/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.audit.AdvancedAuditService;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.base.introspector.AuditFacade;
import com.intellij.database.remote.jdba.RemoteCursor;
import com.intellij.database.remote.jdba.RemoteFacade;
import com.intellij.database.remote.jdba.RemoteSeance;
import com.intellij.database.remote.jdba.RemoteSession;
import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.remote.jdba.core.ParameterDef;
import com.intellij.database.remote.jdba.core.ResultLayout;
import com.intellij.database.remote.jdba.intermediate.PrimeIntermediateCursor;
import com.intellij.database.remote.jdba.intermediate.PrimeIntermediateFacade;
import com.intellij.database.remote.jdba.intermediate.PrimeIntermediateSeance;
import com.intellij.database.remote.jdba.intermediate.PrimeIntermediateSession;
import com.intellij.database.remote.jdba.util.Objects;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.util.ThrowableRunnable;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 !2\u00020\u0001:\u0005!\"#$%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013H\u0016J+\u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade;", "Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateFacade;", "delegate", "Lcom/intellij/database/remote/jdba/RemoteFacade;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "(Lcom/intellij/database/remote/jdba/RemoteFacade;Lcom/intellij/database/dataSource/DatabaseConnection;)V", "getConnection", "()Lcom/intellij/database/dataSource/DatabaseConnection;", "openedSessions", "Ljava/util/ArrayList;", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;", "Lkotlin/collections/ArrayList;", "closeOpenedSessions", "", "connect", "detachFromDB", "disconnect", "getConnectionInfo", "Lcom/intellij/database/remote/jdba/core/ConnectionInfo;", "kotlin.jvm.PlatformType", "getSpecificService", "I", "serviceClass", "Ljava/lang/Class;", "serviceName", "", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "isConnected", "", "openSession", "Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateSession;", "reconnect", "Companion", "Cursor", "OneTimeInvocation", "Seance", "Session", "intellij.database.dialects.base"})
public final class AuditFacade
implements PrimeIntermediateFacade {
    private final ArrayList<Session> openedSessions;
    private final RemoteFacade delegate;
    @NotNull
    private final DatabaseConnection connection;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PrimeIntermediateSession openSession() {
        RemoteSession remoteSession = this.delegate.openSession();
        Intrinsics.checkNotNullExpressionValue((Object)remoteSession, (String)"delegate.openSession()");
        Session opened2 = new Session(remoteSession, this.connection, (Function1<? super Session, Unit>)((Function1)new Function1<Session, Unit>(this){
            final /* synthetic */ AuditFacade this$0;

            public final void invoke(@NotNull Session it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Collection collection = AuditFacade.access$getOpenedSessions$p(this.this$0);
                boolean bl = false;
                collection.remove(it);
            }
            {
                this.this$0 = auditFacade;
                super(1);
            }
        }));
        Collection collection = this.openedSessions;
        boolean bl = false;
        collection.add(opened2);
        return opened2;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.delegate.getConnectionInfo();
    }

    public void reconnect() {
        this.delegate.reconnect();
    }

    public void detachFromDB() {
        this.closeOpenedSessions();
        this.delegate.detachFromDB();
    }

    public void disconnect() {
        this.closeOpenedSessions();
        this.delegate.disconnect();
    }

    private final void closeOpenedSessions() {
        for (Session openedSession : this.openedSessions) {
            openedSession.disconnect();
        }
        this.openedSessions.clear();
    }

    public void connect() {
        this.delegate.connect();
    }

    public boolean isConnected() {
        return this.delegate.isConnected();
    }

    @Nullable
    public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) {
        Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        String string = "not implemented yet";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public final DatabaseConnection getConnection() {
        return this.connection;
    }

    public AuditFacade(@NotNull RemoteFacade delegate, @NotNull DatabaseConnection connection) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.delegate = delegate;
        this.connection = connection;
        this.openedSessions = new ArrayList();
    }

    public static final /* synthetic */ ArrayList access$getOpenedSessions$p(AuditFacade $this) {
        return $this.openedSessions;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\bH\u0016J\u0006\u0010\u0011\u001a\u00020\bJ+\u0010\u0012\u001a\u0004\u0018\u0001H\u0013\"\u0004\b\u0000\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J)\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00172\u0012\u0010\u001e\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010 \u0018\u00010\u001fH\u0016\u00a2\u0006\u0002\u0010!R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;", "Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateSession;", "delegate", "Lcom/intellij/database/remote/jdba/RemoteSession;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "disposalCallback", "Lkotlin/Function1;", "", "(Lcom/intellij/database/remote/jdba/RemoteSession;Lcom/intellij/database/dataSource/DatabaseConnection;Lkotlin/jvm/functions/Function1;)V", "getConnection", "()Lcom/intellij/database/dataSource/DatabaseConnection;", "openedSeances", "Ljava/util/ArrayList;", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Seance;", "Lkotlin/collections/ArrayList;", "close", "disconnect", "getSpecificService", "I", "serviceClass", "Ljava/lang/Class;", "serviceName", "", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "isClosed", "", "openSeance", "Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateSeance;", "statementText", "outParameters", "", "Lcom/intellij/database/remote/jdba/core/ParameterDef;", "(Ljava/lang/String;[Lcom/intellij/database/remote/jdba/core/ParameterDef;)Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateSeance;", "intellij.database.dialects.base"})
    private static final class Session
    implements PrimeIntermediateSession {
        private final ArrayList<Seance> openedSeances;
        private final RemoteSession delegate;
        @NotNull
        private final DatabaseConnection connection;
        private final Function1<Session, Unit> disposalCallback;

        @NotNull
        public PrimeIntermediateSeance openSeance(@NotNull String statementText, @Nullable ParameterDef[] outParameters) {
            Intrinsics.checkNotNullParameter((Object)statementText, (String)"statementText");
            RemoteSeance remoteSeance = this.delegate.openSeance(statementText, outParameters);
            Intrinsics.checkNotNullExpressionValue((Object)remoteSeance, (String)"delegate.openSeance(statementText, outParameters)");
            Seance seance2 = new Seance(remoteSeance, this, statementText, (Function1<? super Seance, Unit>)((Function1)new Function1<Seance, Unit>(this){
                final /* synthetic */ Session this$0;

                public final void invoke(@NotNull Seance it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Collection collection = Session.access$getOpenedSeances$p(this.this$0);
                    boolean bl = false;
                    collection.remove(it);
                }
                {
                    this.this$0 = session;
                    super(1);
                }
            }));
            Collection collection = this.openedSeances;
            boolean bl = false;
            collection.add(seance2);
            return seance2;
        }

        public boolean isClosed() {
            return this.delegate.isClosed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                this.disposalCallback.invoke((Object)this);
                this.disconnect();
            }
            finally {
                this.delegate.close();
            }
        }

        public final void disconnect() {
            for (Seance openedSeance : this.openedSeances) {
                openedSeance.disconnect();
            }
            this.openedSeances.clear();
        }

        @Nullable
        public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) {
            Object object;
            Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
            Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
            switch (serviceName) {
                case "jdbc-connection": {
                    object = Objects.castTo(serviceClass, (Object)this.connection);
                    break;
                }
                case "jdbc-metadata": {
                    object = Objects.castTo(serviceClass, (Object)this.connection.getRemoteMetaData());
                    break;
                }
                default: {
                    object = null;
                }
            }
            return (I)object;
        }

        @NotNull
        public final DatabaseConnection getConnection() {
            return this.connection;
        }

        public Session(@NotNull RemoteSession delegate, @NotNull DatabaseConnection connection, @NotNull Function1<? super Session, Unit> disposalCallback) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNullParameter(disposalCallback, (String)"disposalCallback");
            this.delegate = delegate;
            this.connection = connection;
            this.disposalCallback = disposalCallback;
            this.openedSeances = new ArrayList();
        }

        public static final /* synthetic */ ArrayList access$getOpenedSeances$p(Session $this) {
            return $this.openedSeances;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u007f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\r\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001e\u001a\u00020\nH\u0002J\b\u0010\u001f\u001a\u00020\nH\u0002J\b\u0010 \u001a\u00020\nH\u0016J\u0006\u0010!\u001a\u00020\nJ\b\u0010\"\u001a\u00020\nH\u0016J\b\u0010#\u001a\u00020$H\u0016J+\u0010%\u001a\u0004\u0018\u0001H&\"\u0004\b\u0000\u0010&2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H&0(2\u0006\u0010)\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010*J*\u0010+\u001a\b\u0012\u0004\u0012\u0002H-0,\"\u0004\b\u0000\u0010-2\u0006\u0010.\u001a\u00020$2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H-00H\u0016J\u001d\u00101\u001a\u00020\n2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0016\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020$H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0012\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0018\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade$Seance;", "Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateSeance;", "delegate", "Lcom/intellij/database/remote/jdba/RemoteSeance;", "session", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;", "sql", "", "disposalCallback", "Lkotlin/Function1;", "", "(Lcom/intellij/database/remote/jdba/RemoteSeance;Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "mark", "com/intellij/database/dialects/base/introspector/AuditFacade$Seance$mark$1", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Seance$mark$1;", "myResultSetInvocation", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$OneTimeInvocation;", "myStatementInvocation", "openedCursors", "Ljava/util/ArrayList;", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Cursor;", "Lkotlin/collections/ArrayList;", "parameters", "", "", "[Ljava/lang/Object;", "resultSet", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "statement", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "before", "beforePrepared", "close", "disconnect", "execute", "getAffectedRowsCount", "", "getSpecificService", "I", "serviceClass", "Ljava/lang/Class;", "serviceName", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "openCursor", "Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateCursor;", "R", "parameterPosition", "layout", "Lcom/intellij/database/remote/jdba/core/ResultLayout;", "setInParameters", "([Ljava/lang/Object;)V", "setPackLimit", "packLimit", "intellij.database.dialects.base"})
    private static final class Seance
    implements PrimeIntermediateSeance {
        private Object[] parameters;
        private RemoteResultSet resultSet;
        private RemoteStatement statement;
        private OneTimeInvocation myResultSetInvocation;
        private OneTimeInvocation myStatementInvocation;
        private final mark.1 mark;
        private final ArrayList<Cursor<?>> openedCursors;
        private final RemoteSeance delegate;
        private final Session session;
        private final String sql;
        private final Function1<Seance, Unit> disposalCallback;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public <R> PrimeIntermediateCursor<R> openCursor(int parameterPosition, @NotNull ResultLayout<R> layout) {
            Intrinsics.checkNotNullParameter(layout, (String)"layout");
            try {
                RemoteCursor remoteCursor = this.delegate.openCursor(parameterPosition, layout);
                Intrinsics.checkNotNullExpressionValue((Object)remoteCursor, (String)"delegate.openCursor(parameterPosition, layout)");
                Cursor cursor2 = new Cursor(remoteCursor, this.myResultSetInvocation, this.session, (SmartStatementMark)this.mark, (Function1)new Function1<Cursor<R>, Unit>(this){
                    final /* synthetic */ Seance this$0;

                    public final void invoke(@NotNull Cursor<R> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        Collection collection = Seance.access$getOpenedCursors$p(this.this$0);
                        boolean bl = false;
                        collection.remove(it);
                    }
                    {
                        this.this$0 = seance2;
                        super(1);
                    }
                });
                Collection collection = this.openedCursors;
                boolean bl = false;
                collection.add(cursor2);
                collection = cursor2;
                return collection;
            }
            finally {
                if (this.resultSet != null) {
                    AdvancedAuditService advancedAuditService = this.session.getConnection().getAuditService();
                    RemoteResultSet remoteResultSet = this.resultSet;
                    Intrinsics.checkNotNull((Object)remoteResultSet);
                    advancedAuditService.resultsOpened(remoteResultSet, (SmartStatementMark)this.mark);
                }
            }
        }

        public int getAffectedRowsCount() {
            return this.delegate.getAffectedRowsCount();
        }

        public void setInParameters(@NotNull Object[] parameters2) {
            Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
            this.delegate.setInParameters(parameters2);
            this.parameters = parameters2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                this.disposalCallback.invoke((Object)this);
                this.disconnect();
            }
            finally {
                this.delegate.close();
            }
        }

        public void setPackLimit(int packLimit) {
            this.delegate.setPackLimit(packLimit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            try {
                Companion.runReporting(this.session.getConnection(), (SmartStatementMark)this.mark, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ Seance this$0;

                    @Nullable
                    public final Unit invoke() {
                        Unit unit;
                        Seance.access$before(this.this$0);
                        Seance.access$getMark$p(this.this$0).run((Function0)new Function0<Unit>(this){
                            final /* synthetic */ execute.1 this$0;

                            public final void invoke() {
                                Seance.access$getDelegate$p(this.this$0.this$0).execute();
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                        int count = this.this$0.getAffectedRowsCount();
                        if (count > 0) {
                            Seance.access$getSession$p(this.this$0).getConnection().getAuditService().updateCount(count, (SmartStatementMark)Seance.access$getMark$p(this.this$0));
                        }
                        Seance.access$setResultSet$p(this.this$0, Seance.access$getDelegate$p(this.this$0).getDefaultResultSet());
                        RemoteResultSet remoteResultSet = Seance.access$getResultSet$p(this.this$0);
                        if (remoteResultSet != null) {
                            RemoteResultSet remoteResultSet2 = remoteResultSet;
                            boolean bl = false;
                            boolean bl2 = false;
                            RemoteResultSet it = remoteResultSet2;
                            boolean bl3 = false;
                            Seance.access$setMyResultSetInvocation$p(this.this$0, new OneTimeInvocation((Function0<Unit>)((Function0)new Function0<Unit>(it, this){
                                final /* synthetic */ RemoteResultSet $it;
                                final /* synthetic */ execute.1 this$0;
                                {
                                    this.$it = remoteResultSet;
                                    this.this$0 = var2_2;
                                    super(0);
                                }

                                public final void invoke() {
                                    Seance.access$getSession$p(this.this$0.this$0).getConnection().getAuditService().resultsProcessed((SmartStatementMark)Seance.access$getMark$p(this.this$0.this$0));
                                    Seance.access$getSession$p(this.this$0.this$0).getConnection().getAuditService().beforeResultsClosing(this.$it, (SmartStatementMark)Seance.access$getMark$p(this.this$0.this$0));
                                }
                            })));
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        return unit;
                    }
                    {
                        this.this$0 = seance2;
                        super(0);
                    }
                });
            }
            finally {
                this.session.getConnection().getAuditService().afterStatement((SmartStatementMark)this.mark);
            }
        }

        public final void disconnect() {
            block3: {
                for (Cursor<?> openedCursor : this.openedCursors) {
                    openedCursor.disconnect();
                }
                this.openedCursors.clear();
                if (this.session.isClosed()) {
                    return;
                }
                OneTimeInvocation oneTimeInvocation = this.myResultSetInvocation;
                if (oneTimeInvocation != null) {
                    oneTimeInvocation.run();
                }
                OneTimeInvocation oneTimeInvocation2 = this.myStatementInvocation;
                if (oneTimeInvocation2 == null) break block3;
                oneTimeInvocation2.run();
            }
        }

        private final void before() {
            if (this.parameters != null) {
                this.beforePrepared();
                return;
            }
            this.session.getConnection().getAuditService().beforeSimpleStatement(this.sql, (SmartStatementMark)this.mark);
        }

        private final void beforePrepared() {
            StatementParameters builder = new StatementParameters();
            Intrinsics.checkNotNull((Object)this.parameters);
            for (Object value : this.parameters) {
                builder.obj(value);
            }
            this.session.getConnection().getAuditService().beforeParameterizedStatement(builder.asData(this.sql), (SmartStatementMark)this.mark);
        }

        @Nullable
        public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) {
            Object object;
            Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
            Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
            switch (serviceName) {
                case "jdbc-result-set": {
                    object = Objects.castTo(serviceClass, (Object)this.resultSet);
                    break;
                }
                case "jdbc-statement": {
                    object = Objects.castTo(serviceClass, (Object)this.statement);
                    break;
                }
                case "jdbc-connection": {
                    object = this.session.getSpecificService(serviceClass, serviceName);
                    break;
                }
                default: {
                    object = null;
                }
            }
            return (I)object;
        }

        public Seance(@NotNull RemoteSeance delegate, @NotNull Session session, @NotNull String sql, @NotNull Function1<? super Seance, Unit> disposalCallback) {
            RemoteStatement x;
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            Intrinsics.checkNotNullParameter(disposalCallback, (String)"disposalCallback");
            this.delegate = delegate;
            this.session = session;
            this.sql = sql;
            this.disposalCallback = disposalCallback;
            this.mark = new SmartStatementMark.RunnableMark(this){
                final /* synthetic */ Seance this$0;

                @NotNull
                public DatabaseDepartment getDepartment() {
                    return (DatabaseDepartment)DGDepartment.INTROSPECTION;
                }

                @NotNull
                public SmartStatements.Source getSource() {
                    return SmartStatements.Source.SYSTEM;
                }

                public void cancel() {
                    if (Seance.access$getStatement$p(this.this$0) != null) {
                        JdbcNativeUtil.performSafe((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<Exception>(this){
                            final /* synthetic */ mark.1 this$0;

                            public final void run() {
                                RemoteStatement remoteStatement = Seance.access$getStatement$p(this.this$0.this$0);
                                Intrinsics.checkNotNull((Object)remoteStatement);
                                remoteStatement.cancel();
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }));
                    }
                }
                {
                    this.this$0 = this$0;
                }
            };
            this.openedCursors = new ArrayList();
            RemoteStatement remoteStatement = this.statement = (x = this.delegate.getStatement());
            if (remoteStatement != null) {
                RemoteStatement remoteStatement2 = remoteStatement;
                boolean bl = false;
                boolean bl2 = false;
                RemoteStatement it = remoteStatement2;
                boolean bl3 = false;
                this.myStatementInvocation = new OneTimeInvocation((Function0<Unit>)((Function0)new Function0<Unit>(it, this){
                    final /* synthetic */ RemoteStatement $it;
                    final /* synthetic */ Seance this$0;
                    {
                        this.$it = remoteStatement;
                        this.this$0 = seance2;
                        super(0);
                    }

                    public final void invoke() {
                        Seance.access$getSession$p(this.this$0).getConnection().getAuditService().beforeStatementClosing(this.$it, (SmartStatementMark)Seance.access$getMark$p(this.this$0));
                    }
                }));
            }
            if (this.statement != null) {
                AdvancedAuditService advancedAuditService = this.session.getConnection().getAuditService();
                RemoteStatement remoteStatement3 = this.statement;
                Intrinsics.checkNotNull((Object)remoteStatement3);
                advancedAuditService.statementOpened(remoteStatement3, (SmartStatementMark)this.mark);
            }
        }

        public static final /* synthetic */ ArrayList access$getOpenedCursors$p(Seance $this) {
            return $this.openedCursors;
        }

        public static final /* synthetic */ void access$before(Seance $this) {
            $this.before();
        }

        public static final /* synthetic */ mark.1 access$getMark$p(Seance $this) {
            return $this.mark;
        }

        public static final /* synthetic */ RemoteSeance access$getDelegate$p(Seance $this) {
            return $this.delegate;
        }

        public static final /* synthetic */ Session access$getSession$p(Seance $this) {
            return $this.session;
        }

        public static final /* synthetic */ RemoteResultSet access$getResultSet$p(Seance $this) {
            return $this.resultSet;
        }

        public static final /* synthetic */ void access$setResultSet$p(Seance $this, RemoteResultSet remoteResultSet) {
            $this.resultSet = remoteResultSet;
        }

        public static final /* synthetic */ OneTimeInvocation access$getMyResultSetInvocation$p(Seance $this) {
            return $this.myResultSetInvocation;
        }

        public static final /* synthetic */ void access$setMyResultSetInvocation$p(Seance $this, OneTimeInvocation oneTimeInvocation) {
            $this.myResultSetInvocation = oneTimeInvocation;
        }

        public static final /* synthetic */ RemoteStatement access$getStatement$p(Seance $this) {
            return $this.statement;
        }

        public static final /* synthetic */ void access$setStatement$p(Seance $this, RemoteStatement remoteStatement) {
            $this.statement = remoteStatement;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002BG\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0018\u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\rH\u0016J\u0006\u0010\u0010\u001a\u00020\rJ\r\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade$Cursor;", "T", "Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateCursor;", "delegate", "Lcom/intellij/database/remote/jdba/RemoteCursor;", "resultsClosingInvocation", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$OneTimeInvocation;", "session", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "disposalCallback", "Lkotlin/Function1;", "", "(Lcom/intellij/database/remote/jdba/RemoteCursor;Lcom/intellij/database/dialects/base/introspector/AuditFacade$OneTimeInvocation;Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;Lkotlin/jvm/functions/Function1;)V", "close", "disconnect", "fetch", "()Ljava/lang/Object;", "getColumnNames", "", "", "()[Ljava/lang/String;", "hasRows", "", "setCollectLimit", "limit", "", "intellij.database.dialects.base"})
    private static final class Cursor<T>
    implements PrimeIntermediateCursor<T> {
        private final RemoteCursor<T> delegate;
        private final OneTimeInvocation resultsClosingInvocation;
        private final Session session;
        private final SmartStatementMark mark;
        private final Function1<Cursor<T>, Unit> disposalCallback;

        public T fetch() {
            return (T)Companion.runReporting(this.session.getConnection(), this.mark, new Function0<T>(this){
                final /* synthetic */ Cursor this$0;

                public final T invoke() {
                    return (T)Cursor.access$getDelegate$p(this.this$0).fetch();
                }
                {
                    this.this$0 = cursor2;
                    super(0);
                }
            });
        }

        public boolean hasRows() {
            return this.delegate.hasRows();
        }

        @NotNull
        public String[] getColumnNames() {
            String[] stringArray = this.delegate.getColumnNames();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"delegate.columnNames");
            return stringArray;
        }

        public void setCollectLimit(int limit) {
            this.delegate.setCollectLimit(limit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                this.disposalCallback.invoke((Object)this);
                this.disconnect();
            }
            finally {
                this.delegate.close();
            }
        }

        public final void disconnect() {
            block1: {
                if (this.session.isClosed()) break block1;
                OneTimeInvocation oneTimeInvocation = this.resultsClosingInvocation;
                if (oneTimeInvocation != null) {
                    oneTimeInvocation.run();
                }
            }
        }

        public Cursor(@NotNull RemoteCursor<T> delegate, @Nullable OneTimeInvocation resultsClosingInvocation, @NotNull Session session, @NotNull SmartStatementMark mark2, @NotNull Function1<? super Cursor<T>, Unit> disposalCallback) {
            Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            Intrinsics.checkNotNullParameter(disposalCallback, (String)"disposalCallback");
            this.delegate = delegate;
            this.resultsClosingInvocation = resultsClosingInvocation;
            this.session = session;
            this.mark = mark2;
            this.disposalCallback = disposalCallback;
        }

        public static final /* synthetic */ RemoteCursor access$getDelegate$p(Cursor $this) {
            return $this.delegate;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\b\u001a\u00020\u0004R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade$OneTimeInvocation;", "", "invoker", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "invoked", "", "run", "intellij.database.dialects.base"})
    private static final class OneTimeInvocation {
        private boolean invoked;
        private final Function0<Unit> invoker;

        public final void run() {
            if (this.invoked) {
                return;
            }
            this.invoked = true;
            this.invoker.invoke();
        }

        public OneTimeInvocation(@NotNull Function0<Unit> invoker) {
            Intrinsics.checkNotNullParameter(invoker, (String)"invoker");
            this.invoker = invoker;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00040\nH\u0002\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade$Companion;", "", "()V", "runReporting", "T", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "runnable", "Lkotlin/Function0;", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.database.dialects.base"})
    public static final class Companion {
        private final <T> T runReporting(DatabaseConnection connection, SmartStatementMark mark2, Function0<? extends T> runnable) {
            try {
                return (T)runnable.invoke();
            }
            catch (Throwable t) {
                DatabaseConnectionPoint databaseConnectionPoint = connection.getConnectionPoint();
                Intrinsics.checkNotNullExpressionValue((Object)databaseConnectionPoint, (String)"connection.connectionPoint");
                LocalDataSource localDataSource = databaseConnectionPoint.getDataSource();
                Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"connection.connectionPoint.dataSource");
                LocalDataSource dataSource = localDataSource;
                String string = JdbcEngine.getErrorMessage((Throwable)t, (LocalDataSource)dataSource);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JdbcEngine.getErrorMessage(t, dataSource)");
                String message2 = string;
                connection.getAuditService().error(message2, mark2);
                throw t;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

