/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator.dml;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.base.generator.dml.DmlGenerator;
import com.intellij.database.dialects.base.generator.dml.UtilKt;
import com.intellij.database.script.generator.dml.CountAll;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.OrderBy;
import com.intellij.database.script.generator.dml.QueryColumns;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.script.generator.dml.WrapInSelectResult;
import com.intellij.database.script.generator.dml.WrapInSelectTask;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectOption;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TIntArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J'\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\rH\u0002J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0016J \u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/dialects/base/generator/dml/BaseWrapInSelectGenerator;", "Lcom/intellij/database/dialects/base/generator/dml/DmlGenerator;", "Lcom/intellij/database/script/generator/dml/WrapInSelectResult;", "Lcom/intellij/database/script/generator/dml/WrapInSelectTask;", "task", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/script/generator/dml/WrapInSelectTask;Lcom/intellij/database/Dbms;)V", "appendWrappedQueryTail", "", "head", "Lcom/intellij/database/util/DdlBuilder;", "e", "Lcom/intellij/sql/psi/SqlResultSetExpression;", "query", "", "alias", "buildOptimizedCountQuery", "builder", "Lcom/intellij/sql/psi/SqlQueryExpression;", "queryText", "(Lcom/intellij/database/util/DdlBuilder;Lcom/intellij/sql/psi/SqlQueryExpression;Ljava/lang/String;)Ljava/lang/Integer;", "findQuery", "generate", "removeOrderByClause", "project", "Lcom/intellij/openapi/project/Project;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "intellij.database.dialects.base"})
public final class BaseWrapInSelectGenerator
extends DmlGenerator<WrapInSelectResult, WrapInSelectTask> {
    private final Dbms dbms;

    @Override
    @Nullable
    public WrapInSelectResult generate() {
        WhereClause it;
        boolean bl;
        boolean bl2;
        WhereClause whereClause;
        Integer offset;
        SqlQueryExpression queryExpression;
        DdlBuilder builder = ((WrapInSelectTask)this.getTask()).getBuilder();
        String string = StringUtil.trimEnd((String)((WrapInSelectTask)this.getTask()).getQuery(), (String)";");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.trimEnd(task.query, \";\")");
        String queryText = string;
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect((Dbms)this.dbms);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"DbSqlUtil.getSqlDialect(dbms)");
        SqlLanguageDialect dialect = sqlLanguageDialect;
        if (((WrapInSelectTask)this.getTask()).getColumns() instanceof CountAll) {
            queryText = this.removeOrderByClause(((WrapInSelectTask)this.getTask()).getProject(), queryText, dialect);
        }
        SqlResultSetExpression sqlResultSetExpression = DbSqlUtil.parseSqlQuery((Project)((WrapInSelectTask)this.getTask()).getProject(), (SqlLanguageDialect)dialect, (String)queryText, null);
        if (sqlResultSetExpression == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlResultSetExpression, (String)"DbSqlUtil.parseSqlQuery(\u2026ext, null) ?: return null");
        SqlResultSetExpression e2 = sqlResultSetExpression;
        if (Intrinsics.areEqual((Object)((WrapInSelectTask)this.getTask()).getColumns(), (Object)CountAll.INSTANCE) && (queryExpression = this.findQuery(e2)) != null && (offset = this.buildOptimizedCountQuery(builder, queryExpression, queryText)) != null) {
            String string2 = builder.getStatement();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"builder.statement");
            return new WrapInSelectResult(string2, offset);
        }
        builder.keyword("SELECT").space();
        DmlUtilKt.dmlGenerator((Dbms)this.dbms).generate((DmlTask)DmlTaskKt.queryColumns((QueryColumns)((WrapInSelectTask)this.getTask()).getColumns()).table(((WrapInSelectTask)this.getTask()).getTable()).alias(DmlTaskKt.getTableAlias(this.getTask())).build(builder));
        builder.space().keyword("FROM").space().symbol("(");
        int currentHeadLength = builder.length();
        String string3 = DmlTaskKt.getTableAlias(this.getTask());
        if (string3 == null) {
            string3 = "t";
        }
        int offset2 = currentHeadLength + this.appendWrappedQueryTail(builder, e2, queryText, string3);
        WhereClause whereClause2 = ((WrapInSelectTask)this.getTask()).getWhereClause();
        if (whereClause2 != null) {
            whereClause = whereClause2;
            bl2 = false;
            bl = false;
            it = whereClause;
            boolean bl3 = false;
            DmlUtilKt.space((DdlBuilder)builder, (boolean)DmlTaskKt.insertNewLines(this.getTask()));
            UtilKt.generateWhere(this.dbms, it, builder, this.getTask(), true);
        }
        OrderBy orderBy = ((WrapInSelectTask)this.getTask()).getOrderBy();
        if (orderBy != null) {
            whereClause = orderBy;
            bl2 = false;
            bl = false;
            it = whereClause;
            boolean bl4 = false;
            DmlUtilKt.space((DdlBuilder)builder, (boolean)DmlTaskKt.insertNewLines(this.getTask()));
            UtilKt.generateOrderBy((OrderBy)it, builder, true);
        }
        String string4 = builder.getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"builder.statement");
        return new WrapInSelectResult(string4, Integer.valueOf(offset2));
    }

    private final String removeOrderByClause(Project project, String query, SqlLanguageDialect dialect) {
        SqlResultSetExpression sqlResultSetExpression = DbSqlUtil.parseSqlQuery((Project)project, (SqlLanguageDialect)dialect, (String)query, null);
        if (sqlResultSetExpression == null) {
            return query;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlResultSetExpression, (String)"DbSqlUtil.parseSqlQuery(\u2026ry, null) ?: return query");
        SqlResultSetExpression e2 = sqlResultSetExpression;
        SqlQueryExpression queryExpression = this.findQuery(e2);
        SqlOrderByClause sqlOrderByClause = (SqlOrderByClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)queryExpression), SqlOrderByClause.class);
        if (sqlOrderByClause == null) {
            return query;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlOrderByClause, (String)"PsiTreeUtil.getChildOfTy\u2026ass.java) ?: return query");
        SqlOrderByClause clause = sqlOrderByClause;
        StringBuilder stringBuilder = new StringBuilder();
        String string = query;
        int n = 0;
        TextRange textRange = clause.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"clause.textRange");
        int n2 = textRange.getStartOffset();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        StringBuilder stringBuilder2 = stringBuilder.append(string3);
        string = query;
        TextRange textRange2 = clause.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"clause.textRange");
        n = textRange2.getEndOffset();
        n2 = 0;
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        String queryText = stringBuilder2.append(string5).toString();
        String string6 = StringUtil.trimEnd((String)queryText, (String)" ");
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"StringUtil.trimEnd(queryText, \" \")");
        return string6;
    }

    private final SqlQueryExpression findQuery(SqlResultSetExpression e2) {
        SqlQueryExpression sqlQueryExpression;
        SqlResultSetExpression sqlResultSetExpression = e2;
        if (sqlResultSetExpression instanceof SqlWithQueryExpression) {
            SqlExpression sqlExpression = ((SqlWithQueryExpression)e2).getExpression();
            if (!(sqlExpression instanceof SqlQueryExpression)) {
                sqlExpression = null;
            }
            sqlQueryExpression = (SqlQueryExpression)sqlExpression;
        } else {
            sqlQueryExpression = sqlResultSetExpression instanceof SqlQueryExpression ? (SqlQueryExpression)e2 : null;
        }
        return sqlQueryExpression;
    }

    private final int appendWrappedQueryTail(DdlBuilder head, SqlResultSetExpression e2, String query, String alias) {
        DatabaseDialectEx databaseDialectEx = head.getDialect();
        Intrinsics.checkNotNullExpressionValue((Object)databaseDialectEx, (String)"head.dialect");
        Dbms dbms = databaseDialectEx.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"head.dialect.dbms");
        boolean needSelectTargetAliases = dbms.isMicrosoft();
        int placeholdersOffset = 0;
        if (needSelectTargetAliases) {
            TIntArrayList endOffsets = new TIntArrayList();
            Iterator iterator = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)e2)).filter(SqlSelectClause.class).iterator();
            while (iterator.hasNext()) {
                SqlSelectClause selectClause;
                SqlSelectClause sqlSelectClause = selectClause = (SqlSelectClause)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)sqlSelectClause, (String)"selectClause");
                for (SqlExpression expression : sqlSelectClause.getExpressions()) {
                    if (expression instanceof SqlAsExpression || expression instanceof SqlReferenceExpression) continue;
                    SqlExpression sqlExpression = expression;
                    Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"expression");
                    TextRange textRange = sqlExpression.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"expression.textRange");
                    endOffsets.add(textRange.getEndOffset());
                }
            }
            endOffsets.sort();
            int prevIdx = 0;
            int count = 0;
            int len = endOffsets.size();
            for (int i2 = 0; i2 < len; ++i2) {
                int offset = endOffsets.get(i2);
                String string = query;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(prevIdx, offset);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                head.plain(string3);
                String name2 = "_" + ++count;
                placeholdersOffset += name2.length();
                head.space().columnRef(name2);
                prevIdx = offset;
            }
            String string = e2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.text");
            String string4 = string;
            boolean bl = false;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(prevIdx);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            head.plain(string6);
        } else {
            head.plain(query);
        }
        head.symbol(")").space().alias(alias);
        return placeholdersOffset;
    }

    private final Integer buildOptimizedCountQuery(DdlBuilder builder, SqlQueryExpression query, String queryText) {
        SqlSelectClause sqlSelectClause = query.getSelectClause();
        if (sqlSelectClause == null) {
            return null;
        }
        SqlSelectClause selectClause = sqlSelectClause;
        Iterator iterator = selectClause.getOptions().iterator();
        while (iterator.hasNext()) {
            SqlSelectOption option;
            SqlSelectOption sqlSelectOption = option = (SqlSelectOption)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)sqlSelectOption, (String)"option");
            if (!StringUtil.startsWithIgnoreCase((String)sqlSelectOption.getOptionName(), (String)"DISTINCT") && option.getClause() == null) continue;
            return null;
        }
        SqlTableExpression tableExp = query.getTableExpression();
        if (tableExp == null || tableExp.getHavingClause() != null || tableExp.getGroupByClause() != null) {
            return null;
        }
        List list = selectClause.getExpressions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"selectClause.expressions");
        List expressions = list;
        for (SqlExpression e2 : expressions) {
            JBIterable jBIterable = ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)e2)).preOrderDfsTraversal().filter(SqlFunctionCallExpression.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"SyntaxTraverser.psiTrave\u2026llExpression::class.java)");
            if (jBIterable.isEmpty()) continue;
            return null;
        }
        SqlExpression firstExpression = (SqlExpression)ContainerUtil.getFirstItem((List)expressions);
        SqlExpression lastExpression = (SqlExpression)ContainerUtil.getLastItem((List)expressions);
        if (firstExpression == null || lastExpression == null) {
            return null;
        }
        TextRange textRange = firstExpression.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"firstExpression.textRange");
        int expressionsStartOffset = textRange.getStartOffset();
        TextRange textRange2 = lastExpression.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"lastExpression.textRange");
        int expressionsEndOffset = textRange2.getEndOffset();
        DdlBuilder ddlBuilder = builder.clear();
        String string = queryText;
        int n = 0;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, expressionsStartOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        DdlBuilder ddlBuilder2 = ddlBuilder.plain(string3).keyword("COUNT").symbol("(").symbol("*").symbol(")");
        string = queryText;
        n = 0;
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(expressionsEndOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        ddlBuilder2.plain(string5);
        return builder.length() - queryText.length();
    }

    public BaseWrapInSelectGenerator(@NotNull WrapInSelectTask task, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super((DmlTask)task);
        this.dbms = dbms;
    }
}

