/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator.dml;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.base.BaseDmlHelper;
import com.intellij.database.dialects.base.LimitPlace;
import com.intellij.database.dialects.base.generator.dml.DmlGenerator;
import com.intellij.database.dialects.base.generator.dml.UtilKt;
import com.intellij.database.model.DasTable;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.OrderBy;
import com.intellij.database.script.generator.dml.QueryColumns;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000e\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/base/generator/dml/BaseSelectGenerator;", "Lcom/intellij/database/dialects/base/generator/dml/DmlGenerator;", "Lcom/intellij/database/util/DdlBuilder;", "Lcom/intellij/database/script/generator/dml/SelectTask;", "task", "dbms", "Lcom/intellij/database/Dbms;", "helper", "Lcom/intellij/database/dialects/base/BaseDmlHelper;", "(Lcom/intellij/database/script/generator/dml/SelectTask;Lcom/intellij/database/Dbms;Lcom/intellij/database/dialects/base/BaseDmlHelper;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "getHelper", "()Lcom/intellij/database/dialects/base/BaseDmlHelper;", "generate", "intellij.database.dialects.base"})
public class BaseSelectGenerator
extends DmlGenerator<DdlBuilder, SelectTask> {
    @NotNull
    private final Dbms dbms;
    @NotNull
    private final BaseDmlHelper helper;

    @Override
    @NotNull
    public DdlBuilder generate() {
        WhereClause it;
        boolean bl;
        boolean bl2;
        WhereClause whereClause;
        String string;
        DdlBuilder builder = ((SelectTask)this.getTask()).getOutput();
        DasTable dasTable = ((SelectTask)this.getTask()).getTable();
        if (dasTable == null) {
            return builder;
        }
        DasTable table = dasTable;
        DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect((Dbms)this.dbms);
        Intrinsics.checkNotNullExpressionValue((Object)databaseDialectEx, (String)"DbImplUtil.getDatabaseDialect(dbms)");
        DatabaseDialectEx dialect = databaseDialectEx;
        boolean limited = !DbImplUtil.isPageSizeUnlimited((int)((SelectTask)this.getTask()).getLimit()) || ((SelectTask)this.getTask()).getOffset() > 0;
        LimitPlace limitPlace = this.helper.getPlaceForLimit();
        if (limited) {
            LimitPlace.BOTH.appendLimit(builder, this.helper, dialect, limitPlace, ((SelectTask)this.getTask()).getLimit(), ((SelectTask)this.getTask()).getOffset(), true);
        }
        builder.keyword("SELECT").space();
        if (limited) {
            LimitPlace.BEGIN.appendLimit(builder, this.helper, dialect, limitPlace, ((SelectTask)this.getTask()).getLimit(), ((SelectTask)this.getTask()).getOffset(), true);
        }
        if ((string = ((SelectTask)this.getTask()).getAlias()) == null) {
            string = "t";
        }
        String alias = string;
        this.helper.generate((DmlTask)DmlTaskKt.queryColumns((QueryColumns)((SelectTask)this.getTask()).getColumns()).table(table).alias(alias).build(builder));
        if (dialect.hasRowId(((SelectTask)this.getTask()).getVersion()) && ((SelectTask)this.getTask()).getAppendRowId()) {
            this.helper.appendRowId(builder, alias);
        }
        DmlUtilKt.space((DdlBuilder)builder, (boolean)((SelectTask)this.getTask()).getInsertNewLines());
        this.helper.appendFromTable(builder, table, alias);
        WhereClause whereClause2 = ((SelectTask)this.getTask()).getWhereClause();
        if (whereClause2 != null) {
            whereClause = whereClause2;
            bl2 = false;
            bl = false;
            it = whereClause;
            boolean bl3 = false;
            DmlUtilKt.space((DdlBuilder)builder, (boolean)((SelectTask)this.getTask()).getInsertNewLines());
            UtilKt.generateWhere(this.dbms, it, builder, this.getTask(), true);
        }
        OrderBy orderBy = ((SelectTask)this.getTask()).getOrderBy();
        if (orderBy != null) {
            whereClause = orderBy;
            bl2 = false;
            bl = false;
            it = whereClause;
            boolean bl4 = false;
            DmlUtilKt.space((DdlBuilder)builder, (boolean)((SelectTask)this.getTask()).getInsertNewLines());
            UtilKt.generateOrderBy((OrderBy)it, builder, true);
        }
        if (limited) {
            LimitPlace.BOTH.appendLimit(builder, this.helper, dialect, limitPlace, ((SelectTask)this.getTask()).getLimit(), ((SelectTask)this.getTask()).getOffset(), false);
            LimitPlace.END.appendLimit(builder, this.helper, dialect, limitPlace, ((SelectTask)this.getTask()).getLimit(), ((SelectTask)this.getTask()).getOffset(), false);
        }
        return builder;
    }

    @NotNull
    protected final Dbms getDbms() {
        return this.dbms;
    }

    @NotNull
    protected final BaseDmlHelper getHelper() {
        return this.helper;
    }

    public BaseSelectGenerator(@NotNull SelectTask task, @NotNull Dbms dbms, @NotNull BaseDmlHelper helper) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        super((DmlTask)task);
        this.dbms = dbms;
        this.helper = helper;
    }
}

