/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator.dml;

import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.database.datagrid.mutating.RowQueryData;
import com.intellij.database.datagrid.mutating.RowUpdateData;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.BaseDmlHelperKt;
import com.intellij.database.dialects.base.generator.dml.BaseInsertRowsGeneratorKt;
import com.intellij.database.dialects.base.generator.dml.DmlGenerator;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.InsertRowsTask;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J:\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b\"\u000e\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J:\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000b2\u0012\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/dialects/base/generator/dml/BaseInsertRowsGenerator;", "Lcom/intellij/database/dialects/base/generator/dml/DmlGenerator;", "", "Lcom/intellij/database/datagrid/mutating/RowUpdateData;", "Lcom/intellij/database/script/generator/dml/InsertRowsTask;", "task", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/script/generator/dml/InsertRowsTask;Lcom/intellij/database/Dbms;)V", "generate", "getPlaceholdersOrInlineValues", "", "Lcom/intellij/util/Consumer;", "Lcom/intellij/database/util/DdlBuilder;", "T", "Lcom/intellij/database/datagrid/AutoValueDescriptor$DelegateDescriptor;", "Lcom/intellij/database/datagrid/mutating/ColumnQueryData;", "descriptors", "", "hasPlaceholder", "", "d", "sqlInsertInto", "builder", "table", "Lcom/intellij/database/model/DasTable;", "columns", "", "values", "intellij.database.dialects.base"})
public class BaseInsertRowsGenerator
extends DmlGenerator<List<RowUpdateData>, InsertRowsTask> {
    private final Dbms dbms;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<RowUpdateData> generate() {
        DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect((Dbms)this.dbms);
        Intrinsics.checkNotNullExpressionValue((Object)databaseDialectEx, (String)"DbImplUtil.getDatabaseDialect(dbms)");
        DatabaseDialectEx dialect = databaseDialectEx;
        JdbcEngine.OffsetSavingBuilder builder = new JdbcEngine.OffsetSavingBuilder(DbImplUtil.createBuilderForUIExec((DatabaseDialectEx)dialect));
        boolean bl = false;
        List data = new ArrayList();
        for (RowMutation mutation : ((InsertRowsTask)this.getTask()).getMutations()) {
            String sql;
            void $this$mapTo$iv$iv;
            void $this$filterTo$iv$iv;
            List delegateDescriptors = BaseInsertRowsGeneratorKt.access$createDescriptors(mutation);
            List<Consumer<DdlBuilder>> placeholders = this.getPlaceholdersOrInlineValues(delegateDescriptors, this.dbms);
            List<String> colNames = BaseDmlHelperKt.getColumnNamesForInsert(delegateDescriptors, this.dbms);
            this.sqlInsertInto((DdlBuilder)builder, ((InsertRowsTask)this.getTask()).getTable(), colNames, placeholders);
            Intrinsics.checkNotNullExpressionValue((Object)builder.getStatement(), (String)"builder.statement");
            Iterable $this$filter$iv = delegateDescriptors;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                AutoValueDescriptor.DelegateDescriptor it = (AutoValueDescriptor.DelegateDescriptor)element$iv$iv;
                boolean bl2 = false;
                if (!this.hasPlaceholder((AutoValueDescriptor.DelegateDescriptor<ColumnQueryData>)it, this.dbms)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List withPlaceholders = (List)destination$iv$iv;
            Iterable $this$map$iv = withPlaceholders;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AutoValueDescriptor.DelegateDescriptor bl2 = (AutoValueDescriptor.DelegateDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                ColumnQueryData columnQueryData = (ColumnQueryData)it.getDelegate();
                collection.add(columnQueryData);
            }
            List delegates = (List)destination$iv$iv2;
            RowQueryData qData = new RowQueryData(delegates, builder.getOffsets(), sql, delegates.size());
            data.add(new RowUpdateData(qData, 1));
            builder.clear();
        }
        return data;
    }

    private final <T extends AutoValueDescriptor.DelegateDescriptor<ColumnQueryData>> List<Consumer<DdlBuilder>> getPlaceholdersOrInlineValues(Collection<? extends T> descriptors, Dbms dbms) {
        List list = BaseDmlHelperKt.shouldParticipateInInsert(descriptors, dbms).map(new Function<T, Consumer<DdlBuilder>>(dbms){
            final /* synthetic */ Dbms $dbms;

            public final Consumer<DdlBuilder> fun(@NotNull T d) {
                Intrinsics.checkNotNullParameter(d, (String)"d");
                return JdbcEngine.shouldValueBeInlined((Object)((ColumnQueryData)d.getDelegate()).getObject(), (String)d.getTypeName(), (Dbms)this.$dbms) ? (Consumer)new Consumer<DdlBuilder>((AutoValueDescriptor.DelegateDescriptor)d){
                    final /* synthetic */ AutoValueDescriptor.DelegateDescriptor $d;

                    public final void consume(@NotNull DdlBuilder builder) {
                        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                        builder.plain(String.valueOf(((ColumnQueryData)this.$d.getDelegate()).getObject()));
                    }
                    {
                        this.$d = delegateDescriptor;
                    }
                } : JdbcEngine.defaultOrPlaceholder((AutoValueDescriptor)((AutoValueDescriptor)d));
            }
            {
                this.$dbms = dbms;
            }
        }).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"shouldParticipateInInser\u2026older(d)\n      }.toList()");
        return list;
    }

    private final boolean hasPlaceholder(AutoValueDescriptor.DelegateDescriptor<ColumnQueryData> d, Dbms dbms) {
        return !d.isComputed() && !d.isAutogenerated() && !d.hasDefault() && !JdbcEngine.shouldValueBeInlined((Object)((ColumnQueryData)d.getDelegate()).getObject(), (String)d.getTypeName(), (Dbms)dbms);
    }

    private final DdlBuilder sqlInsertInto(DdlBuilder builder, DasTable table, List<String> columns, List<? extends Consumer<DdlBuilder>> values) {
        builder.keyword("INSERT").space().keyword("INTO").space().qualifiedRef((DasObject)table);
        Collection collection = columns;
        boolean bl = false;
        if (!collection.isEmpty()) {
            builder.space().symbol("(");
            DialectUtils.appendStringList((DdlBuilder)builder, (Iterable)columns);
            builder.symbol(")");
        }
        if (values.isEmpty() && DmlUtilKt.dmlGenerator((Dbms)this.dbms).getSupportsInsertDefaultValues()) {
            builder.space().keyword("DEFAULT").space().keyword("VALUES");
        } else {
            builder.space().keyword("VALUES").space().symbol("(");
            DialectUtils.appendCommaSeparated((DdlBuilder)builder, (Iterable)values);
            builder.symbol(")");
        }
        return builder;
    }

    public BaseInsertRowsGenerator(@NotNull InsertRowsTask task, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super((DmlTask)task);
        this.dbms = dbms;
    }
}

