/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.util.Casing;
import com.intellij.sql.dialects.SqlLanguageDialect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0012H\u0016J\u0018\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u00122\b\u0010)\u001a\u0004\u0018\u00010*J \u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u00122\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010#\u001a\u00020$J*\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u00122\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010#\u001a\u00020$2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0012J\"\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u00122\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0012J\u0018\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u00122\b\u0010)\u001a\u0004\u0018\u00010*J$\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u00122\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0012H\u0016J \u0010+\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u000eH\u0014J\b\u0010/\u001a\u00020\u0007H\u0016J\u0010\u00100\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0012H\u0016J\u0018\u00100\u001a\u00020$2\u0006\u0010&\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u00101\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0012H\u0016J\u0010\u00102\u001a\u00020$2\u0006\u0010,\u001a\u00020\u0012H\u0016J\u0018\u00103\u001a\u00020$2\u0006\u0010&\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u00104\u001a\u00020$2\u0006\u0010&\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$H\u0002J\b\u00105\u001a\u00020\u0012H\u0016J\u0010\u00106\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u0012H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010R\u0014\u0010\u001b\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0014R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018R\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u00067"}, d2={"Lcom/intellij/database/dialects/base/generator/AbstractNamingService;", "Lcom/intellij/database/script/generator/NamingService;", "dbms", "Lcom/intellij/database/Dbms;", "namePattern", "Ljava/util/regex/Pattern;", "casing", "Lcom/intellij/database/util/Casing;", "(Lcom/intellij/database/Dbms;Ljava/util/regex/Pattern;Lcom/intellij/database/util/Casing;)V", "plainNamePattern", "(Lcom/intellij/database/Dbms;Ljava/util/regex/Pattern;Ljava/util/regex/Pattern;Lcom/intellij/database/util/Casing;)V", "getCasing", "()Lcom/intellij/database/util/Casing;", "closingQuote", "", "getClosingQuote", "()C", "closingQuotes", "", "getClosingQuotes", "()Ljava/lang/String;", "getDbms", "()Lcom/intellij/database/Dbms;", "getNamePattern", "()Ljava/util/regex/Pattern;", "openingQuote", "getOpeningQuote", "openingQuotes", "getOpeningQuotes", "getPlainNamePattern", "reservedWords", "", "getReservedWords", "()Ljava/util/Set;", "aptPattern", "plain", "", "canScript", "name", "catToScript", "catName", "kind", "Lcom/intellij/database/model/ObjectKind;", "enquote", "scrName", "op", "cl", "getDefaultCasing", "isPlain", "isPure", "isQuoted", "isValidPlain", "skipQuoting", "toString", "unquoteIdentifier", "intellij.database.dialects.base"})
public abstract class AbstractNamingService
implements NamingService {
    @NotNull
    private final Dbms dbms;
    @NotNull
    private final Pattern namePattern;
    @NotNull
    private final Pattern plainNamePattern;
    @NotNull
    private final Casing casing;

    private final Set<String> getReservedWords() {
        Set set;
        if (Intrinsics.areEqual((Object)this.dbms, (Object)Dbms.UNKNOWN)) {
            set = SetsKt.emptySet();
        } else {
            Object object = SqlLanguageDialect.EP.forDbms(this.dbms);
            Intrinsics.checkNotNull((Object)object);
            Set set2 = ((SqlLanguageDialect)object).getReservedKeywords();
            set = set2;
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"SqlLanguageDialect.EP.fo\u2026(dbms)!!.reservedKeywords");
        }
        return set;
    }

    public char getOpeningQuote() {
        return this.getOpeningQuotes().charAt(0);
    }

    public char getClosingQuote() {
        return this.getClosingQuotes().charAt(0);
    }

    @NotNull
    public String getOpeningQuotes() {
        return "\"";
    }

    @NotNull
    public String getClosingQuotes() {
        return "\"";
    }

    @NotNull
    public Casing getDefaultCasing() {
        return this.casing;
    }

    @NotNull
    public final String catToScript(@NotNull String catName, @Nullable ObjectKind kind) {
        Intrinsics.checkNotNullParameter((Object)catName, (String)"catName");
        return this.catToScript(catName, kind, null);
    }

    @NotNull
    public final String catToScript(@NotNull String catName, @Nullable ObjectKind kind, @Nullable String openingQuotes) {
        Intrinsics.checkNotNullParameter((Object)catName, (String)"catName");
        return this.isPure(catName) && !this.getReservedWords().contains(catName) ? catName : this.enquote(catName, kind, openingQuotes);
    }

    @NotNull
    public final String catToScript(@NotNull String catName, @Nullable ObjectKind kind, boolean plain) {
        Intrinsics.checkNotNullParameter((Object)catName, (String)"catName");
        return this.catToScript(catName, kind, plain, null);
    }

    @NotNull
    public final String catToScript(@NotNull String catName, @Nullable ObjectKind kind, boolean plain, @Nullable String openingQuotes) {
        Intrinsics.checkNotNullParameter((Object)catName, (String)"catName");
        return this.skipQuoting(catName, plain) ? catName : this.enquote(catName, kind, openingQuotes);
    }

    public boolean isQuoted(@NotNull String scrName) {
        Intrinsics.checkNotNullParameter((Object)scrName, (String)"scrName");
        if (scrName.length() < 2) {
            return false;
        }
        int opIdx = StringsKt.indexOf$default((CharSequence)this.getOpeningQuotes(), (char)StringsKt.first((CharSequence)scrName), (int)0, (boolean)false, (int)6, null);
        if (opIdx == -1) {
            return false;
        }
        return StringsKt.last((CharSequence)scrName) == this.getClosingQuotes().charAt(opIdx);
    }

    @NotNull
    public String unquoteIdentifier(@NotNull String scrName) {
        Intrinsics.checkNotNullParameter((Object)scrName, (String)"scrName");
        if (!this.isQuoted(scrName)) {
            return scrName;
        }
        char quote = StringsKt.last((CharSequence)scrName);
        String string = scrName;
        int n = 1;
        int n2 = scrName.length() - 1;
        boolean bl = false;
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return StringsKt.replace$default((String)string2, (String)("" + quote + quote), (String)String.valueOf(quote), (boolean)false, (int)4, null);
    }

    @NotNull
    public final String enquote(@NotNull String scrName, @Nullable ObjectKind kind) {
        Intrinsics.checkNotNullParameter((Object)scrName, (String)"scrName");
        return this.enquote(scrName, kind, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String enquote(@NotNull String scrName, @Nullable ObjectKind kind, @Nullable String openingQuotes) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)scrName, (String)"scrName");
        String oq = this.getOpeningQuotes();
        String cq = this.getClosingQuotes();
        int any = -1;
        String string = openingQuotes;
        if (string != null) {
            void $this$mapTo$iv$iv;
            CharSequence $this$map$iv = string;
            boolean $i$f$map = false;
            CharSequence charSequence = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length());
            boolean $i$f$mapTo = false;
            void var12_13 = $this$mapTo$iv$iv;
            for (int j = 0; j < var12_13.length(); ++j) {
                void it;
                char item$iv$iv;
                char c = item$iv$iv = var12_13.charAt(j);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Integer n = StringsKt.indexOf$default((CharSequence)oq, (char)it, (int)0, (boolean)false, (int)6, null);
                collection.add(n);
            }
            iterable = (List)destination$iv$iv;
        } else {
            int $this$map$iv = 0;
            iterable = (Iterable)new IntRange($this$map$iv, StringsKt.getLastIndex((CharSequence)oq));
        }
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int i2 = ((Number)element$iv).intValue();
            boolean bl = false;
            if (i2 == -1) continue;
            if (any == -1) {
                any = i2;
            }
            if (StringsKt.contains$default((CharSequence)scrName, (char)cq.charAt(i2), (boolean)false, (int)2, null)) continue;
            return this.enquote(scrName, oq.charAt(i2), cq.charAt(i2));
        }
        if (any == -1) {
            any = 0;
        }
        return this.enquote(scrName, oq.charAt(any), cq.charAt(any));
    }

    @NotNull
    protected String enquote(@NotNull String name2, char op, char cl) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        char c = op;
        String string = StringsKt.replace$default((String)name2, (String)String.valueOf(cl), (String)("" + cl + cl), (boolean)false, (int)4, null);
        boolean bl = false;
        return String.valueOf(c) + string + cl;
    }

    private final boolean skipQuoting(String name2, boolean plain) {
        return this.isValidPlain(name2, plain || this.casing.plain == this.casing.quoted);
    }

    public boolean isPlain(@NotNull String name2, boolean plain) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        CharSequence charSequence = name2;
        Pattern pattern = this.aptPattern(plain);
        boolean bl = false;
        pattern = new Regex(pattern);
        bl = false;
        return pattern.matches(charSequence);
    }

    public boolean isPlain(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        CharSequence charSequence = name2;
        Pattern pattern = this.plainNamePattern;
        boolean bl = false;
        pattern = new Regex(pattern);
        bl = false;
        return pattern.matches(charSequence);
    }

    public boolean isPure(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        CharSequence charSequence = name2;
        Pattern pattern = this.namePattern;
        boolean bl = false;
        pattern = new Regex(pattern);
        bl = false;
        return pattern.matches(charSequence);
    }

    public boolean canScript(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.isPlain(name2) && !this.getReservedWords().contains(name2);
    }

    private final boolean isValidPlain(String name2, boolean plain) {
        return this.isPlain(name2, plain) && !this.getReservedWords().contains(name2);
    }

    private final Pattern aptPattern(boolean plain) {
        return plain ? this.plainNamePattern : this.namePattern;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + ":\n\tdbms: " + this.dbms + "\n\tcasing: " + this.casing + "\n\tpure pattern: " + this.namePattern + " \n\tplain pattern: " + this.plainNamePattern + '\n';
    }

    @NotNull
    public final Dbms getDbms() {
        return this.dbms;
    }

    @NotNull
    public final Pattern getNamePattern() {
        return this.namePattern;
    }

    @NotNull
    public final Pattern getPlainNamePattern() {
        return this.plainNamePattern;
    }

    @NotNull
    public final Casing getCasing() {
        return this.casing;
    }

    public AbstractNamingService(@NotNull Dbms dbms, @NotNull Pattern namePattern, @NotNull Pattern plainNamePattern, @NotNull Casing casing) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)namePattern, (String)"namePattern");
        Intrinsics.checkNotNullParameter((Object)plainNamePattern, (String)"plainNamePattern");
        Intrinsics.checkNotNullParameter((Object)casing, (String)"casing");
        this.dbms = dbms;
        this.namePattern = namePattern;
        this.plainNamePattern = plainNamePattern;
        this.casing = casing;
    }

    public AbstractNamingService(@NotNull Dbms dbms, @NotNull Pattern namePattern, @NotNull Casing casing) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)namePattern, (String)"namePattern");
        Intrinsics.checkNotNullParameter((Object)casing, (String)"casing");
        this(dbms, namePattern, namePattern, casing);
    }

    @Nullable
    public Character closingQuoteFor(char openingQuote) {
        return NamingService.DefaultImpls.closingQuoteFor((NamingService)this, (char)openingQuote);
    }
}

