/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelUtil;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicColumniation;
import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicHierarchicalObject;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMixinColumniation;
import com.intellij.database.model.basic.BasicModColumniation;
import com.intellij.database.model.basic.BasicModConstraint;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModTableColumn;
import com.intellij.database.model.basic.BasicModTableOrView;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.basic.BasicModToggleable;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicModTypedElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicOverloadable;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.basic.BasicToggleable;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.basic.BasicTypedElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.IdentifyingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.SourceError;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratedModelUtil {
    @Nullable
    public static <T extends BasicIdentifiedElement> T findInRoot(@Nullable BasicElement e2, long objectId, BasicMetaObject<?> meta, Class<T> clazz) {
        if (objectId == Long.MIN_VALUE || e2 == null) {
            return null;
        }
        return (T)((BasicIdentifiedElement)GeneratedModelUtil.findInParent((BasicElement)DasUtil.getParentOfClass((DasObject)e2, BasicRoot.class, (boolean)false), objectId, meta, clazz));
    }

    @Nullable
    public static <T extends BasicIdentifiedElement> T findInDatabase(@Nullable BasicElement e2, long objectId, BasicMetaObject<?> meta, Class<T> clazz) {
        assert (meta.getParentKind(1) != ObjectKind.ROOT);
        if (objectId == Long.MIN_VALUE || e2 == null) {
            return null;
        }
        BasicDatabase database = e2.getDatabase();
        return (T)(database == null ? null : (BasicIdentifiedElement)ObjectUtils.tryCast((Object)database.findIdentifiedElement(objectId), clazz));
    }

    @Nullable
    public static <T extends BasicElement> T findInRoot(@Nullable BasicElement e2, @Nullable String name2, BasicMetaObject<?> meta, Class<T> clazz) {
        assert (meta.getParentKind(1) == ObjectKind.ROOT);
        if (StringUtil.isEmpty((String)name2) || e2 == null) {
            return null;
        }
        return GeneratedModelUtil.findInParent((BasicElement)DasUtil.getParentOfClass((DasObject)e2, BasicRoot.class, (boolean)false), name2, meta, clazz);
    }

    @Nullable
    public static <T extends BasicElement> T findInDatabase(@Nullable BasicElement e2, @Nullable String name2, BasicMetaObject<?> meta, Class<T> clazz) {
        assert (meta.getParentKind(1) == ObjectKind.DATABASE);
        if (StringUtil.isEmpty((String)name2) || e2 == null) {
            return null;
        }
        return GeneratedModelUtil.findInParent((BasicElement)e2.getDatabase(), name2, meta, clazz);
    }

    @Nullable
    public static <T extends BasicElement> T findInDatabase(@Nullable BasicElement e2, @Nullable String schemaName, @Nullable String name2, BasicMetaObject<?> meta, Class<T> clazz) {
        BasicSchema schema;
        assert (meta.getParentKind(1) == ObjectKind.SCHEMA);
        BasicSchema basicSchema = e2 == null ? null : (schema = schemaName == null ? e2.getSchema() : GeneratedModelUtil.findInDatabase(e2, schemaName, Objects.requireNonNull(meta.getParent()), BasicSchema.class));
        if (schema == null) {
            return null;
        }
        return GeneratedModelUtil.findInSchema((BasicElement)schema, name2, meta, clazz);
    }

    @Nullable
    public static <T extends BasicElement> T findInSchema(@Nullable BasicElement e2, @Nullable String name2, BasicMetaObject<?> meta, Class<T> clazz) {
        assert (meta.getParentKind(1) == ObjectKind.SCHEMA);
        if (StringUtil.isEmpty((String)name2) || e2 == null) {
            return null;
        }
        return GeneratedModelUtil.findInParent((BasicElement)e2.getSchema(), name2, meta, clazz);
    }

    @Nullable
    private static <T extends BasicElement> T findInParent(BasicElement parent2, @NotNull String name2, BasicMetaObject<?> meta, Class<T> clazz) {
        if (name2 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(0);
        }
        NamingFamily family = parent2 == null ? null : (NamingFamily)ObjectUtils.tryCast((Object)parent2.familyOf(meta.kind), NamingFamily.class);
        return (T)(family == null ? null : (BasicElement)ObjectUtils.tryCast((Object)family.get(name2), clazz));
    }

    @Nullable
    private static <T extends BasicElement> T findInParent(BasicElement parent2, long objectId, BasicMetaObject<?> meta, Class<T> clazz) {
        IdentifyingFamily family = parent2 == null ? null : (IdentifyingFamily)ObjectUtils.tryCast((Object)parent2.familyOf(meta.kind), IdentifyingFamily.class);
        return (T)(family == null ? null : (BasicElement)ObjectUtils.tryCast((Object)family.getByObjectId(objectId), clazz));
    }

    @Nullable
    public static <T extends BasicElement> T findInAllSchemas(@Nullable BasicElement e2, @Nullable String name2, BasicMetaObject<?> meta, Class<T> clazz) {
        assert (meta.getParentKind(1) == ObjectKind.SCHEMA);
        if (StringUtil.isEmpty((String)name2) || e2 == null) {
            return null;
        }
        BasicDatabase database = e2.getDatabase();
        if (database == null) {
            return null;
        }
        for (BasicSchema schema : database.getSchemas()) {
            T res2 = GeneratedModelUtil.findInParent((BasicElement)schema, name2, meta, clazz);
            if (res2 == null) continue;
            return res2;
        }
        return null;
    }

    @NotNull
    public static JBIterable<BasicElement> getPredecessors(@NotNull BasicElement element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(1);
        }
        JBIterable jBIterable = JBIterable.of((Object[])element.getMetaObject().references).filterMap(r -> r == BasicModKey.UNDERLYING_INDEX_REF ? null : r.resolve(element));
        if (jBIterable == null) {
            GeneratedModelUtil.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    @NotNull
    public static Iterable<? extends BasicElement> getPredecessors(@NotNull BasicColumniation element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(3);
        }
        JBIterable jBIterable = GeneratedModelUtil.getPredecessors((BasicElement)element).append((Iterable)element.getCols());
        if (jBIterable == null) {
            GeneratedModelUtil.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @NotNull
    public static Iterable<? extends BasicElement> getPredecessors(@NotNull BasicForeignKey element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(5);
        }
        JBIterable jBIterable = JBIterable.of((Object[])new BasicElement[]{element.getRefTable(), element.getRefKey()}).append(GeneratedModelUtil.getPredecessors((BasicColumniation)element)).append((Iterable)element.getRefCols());
        if (jBIterable == null) {
            GeneratedModelUtil.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    @NotNull
    public static Iterable<? extends BasicElement> getPredecessors(@NotNull BasicSynonym element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(7);
        }
        JBIterable jBIterable = JBIterable.of((Object)element.getTargetObject());
        if (jBIterable == null) {
            GeneratedModelUtil.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    public static void handleRename(@NotNull BasicModElement e2, @NotNull String oldName) {
        if (e2 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(9);
        }
        if (oldName == null) {
            GeneratedModelUtil.$$$reportNull$$$0(10);
        }
        BasicHierarchicalObject base = (BasicHierarchicalObject)e2;
        base.handleRename(oldName);
    }

    public static List<String> getRefColNamesByKey(BasicForeignKey fk) {
        BasicKey key2 = fk.getRefKey();
        return key2 == null ? Collections.emptyList() : key2.getColNames();
    }

    public static boolean isComputed(BasicTableOrViewColumn column2) {
        return false;
    }

    public static void setComputed(BasicModTableOrViewColumn column2, boolean computed) {
    }

    public static CascadeRule getOnUpdate(BasicForeignKey key2) {
        return CascadeRule.no_action;
    }

    public static CascadeRule getOnDelete(BasicForeignKey key2) {
        return CascadeRule.no_action;
    }

    public static void setOnUpdate(BasicModForeignKey key2, CascadeRule update) {
    }

    public static void setOnDelete(BasicModForeignKey key2, CascadeRule delete) {
    }

    public static boolean isUnique(BasicModIndex index2) {
        return false;
    }

    public static void setUnique(BasicModIndex index2, boolean unique) {
    }

    public static DasRoutine.Kind getRoutineKind(BasicRoutine aggregate) {
        return DasRoutine.Kind.NONE;
    }

    public static void setRoutineKind(BasicModRoutine aggregate, DasRoutine.Kind kind) {
    }

    public static String getUnderlyingIndexName(BasicKey key2) {
        return null;
    }

    public static void setUnderlyingIndexName(BasicModKey key2, String name2) {
    }

    public static boolean isDeterministic(BasicRoutine function) {
        return false;
    }

    public static void setDeterministic(BasicModRoutine function, boolean deterministic) {
    }

    public static boolean isDeferrable(BasicConstraint c) {
        return false;
    }

    public static void setDeferrable(BasicModConstraint c, boolean deferrable) {
    }

    public static boolean isAutoInc(BasicTableColumn column2) {
        return column2.getSequenceIdentity() != null;
    }

    public static void setAutoInc(BasicModTableColumn column2, boolean inc) {
        column2.setSequenceIdentity((SequenceIdentity)(inc ? SequenceIdentity.UNKNOWN : null));
    }

    public static Set<String> getReverseColNames(BasicIndex index2) {
        return Collections.emptySet();
    }

    public static void setReverseColNames(BasicIndex index2, Set<String> names2) {
    }

    public static SequenceIdentity getSequenceIdentity(BasicModTableColumn column2) {
        return null;
    }

    public static void setSequenceIdentity(BasicModTableColumn column2, SequenceIdentity identity) {
    }

    public static boolean isInitiallyDeferred(BasicModConstraint c) {
        return false;
    }

    public static void setInitiallyDeferred(BasicModConstraint c, boolean deferred) {
    }

    public static boolean isInvalid(BasicSourceAware sa) {
        return false;
    }

    public static void setInvalid(BasicModSourceAware sa, boolean invalid) {
    }

    public static boolean isObfuscated(BasicSourceAware sa) {
        return false;
    }

    public static void setObfuscated(BasicModSourceAware sa, boolean obfuscated) {
    }

    public static List<SourceError> getErrors(BasicSourceAware sa) {
        return Collections.emptyList();
    }

    public static void setErrors(BasicModSourceAware sa, List<SourceError> errors) {
    }

    public static boolean isWithDebugInfo(BasicSourceAware sa) {
        return false;
    }

    public static void setWithDebugInfo(BasicModSourceAware sa, boolean withDebugInfo) {
    }

    @Nullable
    public static String getComment(@NotNull BasicModNamedElement e2) {
        if (e2 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(11);
        }
        return null;
    }

    public static void setComment(@NotNull BasicModNamedElement e2, @Nullable String comment) {
        if (e2 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(12);
        }
    }

    @NotNull
    public static List<String> getColNames(BasicColumniation columniation) {
        List<String> list = Collections.emptyList();
        if (list == null) {
            GeneratedModelUtil.$$$reportNull$$$0(13);
        }
        return list;
    }

    public static void setColNames(BasicModColumniation columniation, @NotNull List<String> names2) {
        if (names2 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(14);
        }
    }

    public static boolean isDisabled(BasicToggleable toggleable) {
        return false;
    }

    public static void setDisabled(BasicModToggleable toggleable, boolean disabled) {
    }

    public static boolean isNotNull(BasicTypedElement typed) {
        return false;
    }

    public static void setNotNull(BasicModTypedElement typed, boolean notNull) {
    }

    @Nullable
    public static String getCondition(BasicIndex index2) {
        return null;
    }

    public static void setCondition(BasicModIndex index2, @Nullable String condition) {
    }

    @Nullable
    public static String getCondition(BasicTrigger index2) {
        return null;
    }

    public static void setCondition(BasicModTrigger index2, @Nullable String condition) {
    }

    @Nullable
    public static String getDefaultExpression(BasicTypedElement typed) {
        return null;
    }

    public static void setDefaultExpression(BasicModTypedElement typed, @Nullable String def) {
    }

    public static boolean isClustering(BasicIndex index2) {
        return false;
    }

    public static void setClustering(BasicModIndex index2, boolean clustering) {
    }

    public static boolean isTemporary(BasicTableOrView table) {
        return false;
    }

    public static void setTemporary(BasicModTableOrView table, boolean temp) {
    }

    public static boolean isSystem(BasicTableOrView table) {
        return false;
    }

    public static void setSystem(BasicModTableOrView table, boolean sys) {
    }

    public static boolean isFunctionBased(BasicIndex index2) {
        return false;
    }

    public static void setFunctionBased(BasicModIndex index2, boolean functionBased) {
    }

    public static void setSubstituted(@NotNull BasicModNamespace nsp) {
        if (nsp == null) {
            GeneratedModelUtil.$$$reportNull$$$0(15);
        }
    }

    public static void setSubstituted(@NotNull BasicModSchema nsp) {
        if (nsp == null) {
            GeneratedModelUtil.$$$reportNull$$$0(16);
        }
        nsp.getModel().setSchemaSourcesVersion((BasicSchema)nsp, null);
    }

    public static boolean isElementSurrogate(@NotNull BasicElement element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(17);
        }
        return false;
    }

    @NotNull
    public static String calculateDisplayOrder(@NotNull BasicElement element) {
        String name2;
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(18);
        }
        return (name2 = element.getName()).length() > 0 ? name2 : "\uffff";
    }

    @NotNull
    public static String calculateDisplayOrder(@NotNull BaseModel element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(19);
        }
        return "ROOT";
    }

    @NotNull
    public static String calculateDisplayOrder(@NotNull BasicArrangedElement element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(20);
        }
        String s = Short.toString(element.getPosition());
        String string = "00000".substring(s.length()) + s;
        if (string == null) {
            GeneratedModelUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public static String calculateDisplayOrder(@NotNull BasicCheck element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(22);
        }
        String p = element.getPredicate();
        String o2 = GeneratedModelUtil.calculateDisplayOrder((BasicColumniation)element);
        Object object = p == null ? o2 : p + "!" + o2;
        if (object == null) {
            GeneratedModelUtil.$$$reportNull$$$0(23);
        }
        return object;
    }

    @NotNull
    public static String calculateDisplayOrder(@NotNull BasicIndex element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(24);
        }
        char c1 = element.isUnique() ? (char)'I' : 'U';
        String string = c1 + GeneratedModelUtil.calculateDisplayOrder((BasicColumniation)element);
        if (string == null) {
            GeneratedModelUtil.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    public static String calculateDisplayOrder(@NotNull BasicKey element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(26);
        }
        char c1 = element.isPrimary() ? (char)'P' : 'U';
        String string = c1 + GeneratedModelUtil.calculateDisplayOrder((BasicColumniation)element);
        if (string == null) {
            GeneratedModelUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public static String calculateDisplayOrder(@NotNull BasicColumniation element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(28);
        }
        String string = BasicMixinColumniation.calculateDisplayOrderByColumns((BasicColumniation)element);
        if (string == null) {
            GeneratedModelUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public static String calculateDisplayOrder(@NotNull BasicOverloadable element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(30);
        }
        String string = element.identity();
        if (string == null) {
            GeneratedModelUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    public static String calculateDisplayOrder(@NotNull BasicTrigger element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(32);
        }
        StringBuilder b = new StringBuilder(40);
        Set events = element.getEvents();
        if (events.contains(TrigEvent.SELECT)) {
            b.append('0');
        }
        if (events.contains(TrigEvent.INSERT)) {
            b.append('1');
        }
        if (events.contains(TrigEvent.UPDATE)) {
            b.append('2');
        }
        if (events.contains(TrigEvent.DELETE)) {
            b.append('3');
        }
        b.append('\u0001');
        TrigTurn turn = element.getTurn();
        int turnOrd = turn != null ? turn.ordinal() + 1 : 9;
        b.append(turnOrd);
        String name2 = element.getRealName();
        if (name2 != null) {
            b.append('\u0002').append(name2);
        }
        String string = b.toString();
        if (string == null) {
            GeneratedModelUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    public static String identity(@NotNull BasicElement element, boolean includingSurrogate) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(34);
        }
        if (element instanceof BasicNamedElement) {
            String name2;
            BasicNamedElement e2 = (BasicNamedElement)element;
            String string = name2 = includingSurrogate ? e2.getRealName() : e2.getNaturalName();
            if (name2 != null) {
                String string2 = name2;
                if (string2 == null) {
                    GeneratedModelUtil.$$$reportNull$$$0(35);
                }
                return string2;
            }
        }
        String string = "#" + Integer.toString(GeneratedModelUtil.getPositionInFamily(element));
        if (string == null) {
            GeneratedModelUtil.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    public static String identity(@NotNull BasicOverloadable element, boolean includingSurrogate) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(37);
        }
        String string = ModelUtil.calculateOverloadableIdentity((BasicOverloadable)element, (boolean)includingSurrogate);
        if (string == null) {
            GeneratedModelUtil.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    public static String identity(@NotNull BasicRoot element, boolean includingSurrogate) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(39);
        }
        return "#ROOT";
    }

    @NotNull
    public static String getDisplayName(@NotNull BasicElement element) {
        String name2;
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(40);
        }
        Object object = (name2 = element.getName()) == ModelConsts.NO_NAME ? element.getKind().code() + " " + element.identity() : name2;
        if (object == null) {
            GeneratedModelUtil.$$$reportNull$$$0(41);
        }
        return object;
    }

    @NotNull
    public static String getDisplayName(@NotNull BasicNode node) {
        if (node == null) {
            GeneratedModelUtil.$$$reportNull$$$0(42);
        }
        String string = node.getClass().getSimpleName();
        if (string == null) {
            GeneratedModelUtil.$$$reportNull$$$0(43);
        }
        return string;
    }

    public static JBIterable<@NotNull ? extends BasicModElement> getDasChildren(@NotNull BasicModElement element, @Nullable ObjectKind kind) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(44);
        }
        return kind == null || kind == ObjectKind.NONE ? element.getChildren() : JBIterable.from((Iterable)element.familyOf(kind));
    }

    @NotNull
    public static @NotNull JBIterable<@NotNull ? extends BasicModElement> getDasChildren(@NotNull BasicModNamespace element, @Nullable ObjectKind kind) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(45);
        }
        JBIterable<? extends BasicModElement> jBIterable = GeneratedModelUtil.getDasChildren((BasicModElement)element, kind);
        if (jBIterable == null) {
            GeneratedModelUtil.$$$reportNull$$$0(46);
        }
        return jBIterable;
    }

    @Nullable
    public static String getRealName(@NotNull BasicElement element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(47);
        }
        return null;
    }

    @Nullable
    public static String getRealName(@NotNull BasicNamedElement element) {
        String name2;
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(48);
        }
        return (name2 = element.getName()) == ModelConsts.NO_NAME ? null : name2;
    }

    @Nullable
    public static String getNaturalName(@NotNull BasicElement element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(49);
        }
        return null;
    }

    @Nullable
    public static String getNaturalName(@NotNull BasicNamedElement element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(50);
        }
        return element.isNameSurrogate() ? null : element.getRealName();
    }

    public static boolean getAutoCreated(@NotNull BasicElement element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(51);
        }
        return element.isElementSurrogate();
    }

    private static int getPositionInFamily(@NotNull BasicElement element) {
        Family f;
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(52);
        }
        if ((f = element.getParentFamily()) != null) {
            int index2 = f.indexOf(element);
            return index2 >= 0 ? index2 + 1 : Integer.MAX_VALUE;
        }
        return 0;
    }

    @Nullable
    public static BasicIndex getUnderlyingIndex(@NotNull BasicKey key2) {
        BasicLikeTable table;
        if (key2 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(53);
        }
        if ((table = key2.getLikeTable()) == null) {
            return null;
        }
        String indexName = key2.getUnderlyingIndexName();
        if (indexName != null) {
            return (BasicIndex)ModelFun.findNamedChild((BasicElement)table, BasicIndex.class, (ObjectKind)ObjectKind.INDEX, (String)indexName);
        }
        Family indices = table.familyOf(ObjectKind.INDEX);
        if (indices == null) {
            return null;
        }
        List names2 = key2.getColNames();
        return (BasicIndex)indices.jbi().filter(BasicIndex.class).find(i2 -> (i2.isUnique() || ModelFun.isNameSurrogate((BasicElement)i2)) && i2.getColNames().equals(names2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 37: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/GeneratedModelUtil";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nsp";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/GeneratedModelUtil";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredecessors";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getColNames";
                break;
            }
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateDisplayOrder";
                break;
            }
            case 35: 
            case 36: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "identity";
                break;
            }
            case 41: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findInParent";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPredecessors";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 46: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleRename";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getComment";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setComment";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setColNames";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setSubstituted";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isElementSurrogate";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "calculateDisplayOrder";
                break;
            }
            case 34: 
            case 37: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "identity";
                break;
            }
            case 40: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getDasChildren";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getRealName";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getNaturalName";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getAutoCreated";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getPositionInFamily";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getUnderlyingIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

