/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.widget;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.icons.AllIcons;
import com.intellij.json.JsonBundle;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.FileDownloadingAdapter;
import com.intellij.openapi.vfs.impl.http.FileDownloadingListener;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonSchemaCatalogProjectConfiguration;
import com.jetbrains.jsonSchema.extension.JsonSchemaEnabler;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.extension.JsonWidgetSuppressor;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaServiceImpl;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import com.jetbrains.jsonSchema.widget.JsonSchemaStatusPopup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JsonSchemaStatusWidget
extends EditorBasedStatusBarPopup {
    public static final String ID = "JSONSchemaSelector";
    private final SynchronizedClearableLazy<JsonSchemaService> myServiceLazy;
    private static final AtomicBoolean myIsNotified = new AtomicBoolean(false);
    private final AtomicReference<Pair<VirtualFile, Boolean>> mySuppressInfoRef;
    private VirtualFile myLastUpdatedFile;
    private EditorBasedStatusBarPopup.WidgetState mySchemaWidgetState;
    private ProgressIndicator myCurrentProgress;
    private final Runnable myUpdateCallback;

    JsonSchemaStatusWidget(@NotNull Project project) {
        if (project == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(0);
        }
        super(project, false);
        this.mySuppressInfoRef = new AtomicReference();
        this.myUpdateCallback = () -> {
            this.update();
            myIsNotified.set(false);
        };
        this.myServiceLazy = new SynchronizedClearableLazy(() -> {
            if (!project.isDisposed()) {
                JsonSchemaService myService = JsonSchemaService.Impl.get(project);
                myService.registerRemoteUpdateCallback(this.myUpdateCallback);
                myService.registerResetAction(this.myUpdateCallback);
                return myService;
            }
            return null;
        });
        JsonWidgetSuppressor.EXTENSION_POINT_NAME.addChangeListener(() -> ((JsonSchemaStatusWidget)this).update(), (Disposable)this);
    }

    @Nullable
    private JsonSchemaService getService() {
        return (JsonSchemaService)this.myServiceLazy.getValue();
    }

    @Contract(value="_, null -> false")
    public static boolean isAvailableOnFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(1);
        }
        if (file == null) {
            return false;
        }
        List enablers = JsonSchemaEnabler.EXTENSION_POINT_NAME.getExtensionList();
        return ContainerUtil.exists((Iterable)enablers, e -> e.isEnabledForFile(file, project) && e.shouldShowSwitcherWidget(file));
    }

    public void update(@Nullable Runnable finishUpdate) {
        this.mySuppressInfoRef.set(null);
        super.update(finishUpdate);
    }

    private static WidgetStatus getWidgetStatus(@NotNull Project project, @NotNull VirtualFile file) {
        List enablers;
        if (project == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(2);
        }
        if (file == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(3);
        }
        if (!ContainerUtil.exists((Iterable)(enablers = JsonSchemaEnabler.EXTENSION_POINT_NAME.getExtensionList()), e -> e.isEnabledForFile(file, project) && e.shouldShowSwitcherWidget(file))) {
            return WidgetStatus.DISABLED;
        }
        if (DumbService.getInstance((Project)project).isDumb()) {
            return WidgetStatus.ENABLED;
        }
        if (JsonWidgetSuppressor.EXTENSION_POINT_NAME.extensions().anyMatch(s -> s.isCandidateForSuppress(file, project))) {
            return WidgetStatus.MAYBE_SUPPRESSED;
        }
        return WidgetStatus.ENABLED;
    }

    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file) {
        EditorBasedStatusBarPopup.WidgetState state;
        Pair suppressInfo = this.mySuppressInfoRef.getAndSet(null);
        EditorBasedStatusBarPopup.WidgetState schemaWidgetState = this.mySchemaWidgetState;
        this.mySchemaWidgetState = null;
        VirtualFile lastUpdatedFile = this.myLastUpdatedFile;
        this.myLastUpdatedFile = file;
        if (this.myCurrentProgress != null && !this.myCurrentProgress.isCanceled()) {
            this.myCurrentProgress.cancel();
        }
        if (file == null) {
            EditorBasedStatusBarPopup.WidgetState widgetState = EditorBasedStatusBarPopup.WidgetState.HIDDEN;
            if (widgetState == null) {
                JsonSchemaStatusWidget.$$$reportNull$$$0(4);
            }
            return widgetState;
        }
        WidgetStatus status = JsonSchemaStatusWidget.getWidgetStatus(this.myProject, file);
        if (status == WidgetStatus.DISABLED) {
            EditorBasedStatusBarPopup.WidgetState widgetState = EditorBasedStatusBarPopup.WidgetState.HIDDEN;
            if (widgetState == null) {
                JsonSchemaStatusWidget.$$$reportNull$$$0(5);
            }
            return widgetState;
        }
        FileType fileType = file.getFileType();
        Language language = fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
        boolean isJsonFile = language instanceof JsonLanguage;
        if (DumbService.getInstance((Project)this.myProject).isDumb()) {
            EditorBasedStatusBarPopup.WidgetState widgetState = JsonSchemaStatusWidget.getDumbModeState(isJsonFile);
            if (widgetState == null) {
                JsonSchemaStatusWidget.$$$reportNull$$$0(6);
            }
            return widgetState;
        }
        if (status == WidgetStatus.MAYBE_SUPPRESSED) {
            if (suppressInfo == null || !Comparing.equal((Object)((VirtualFile)suppressInfo.first), (Object)file)) {
                this.myCurrentProgress = new EmptyProgressIndicator();
                this.scheduleSuppressCheck(file, this.myCurrentProgress);
                if (!Comparing.equal((Object)lastUpdatedFile, (Object)file) && schemaWidgetState != null && schemaWidgetState != EditorBasedStatusBarPopup.WidgetState.HIDDEN) {
                    return new EditorBasedStatusBarPopup.WidgetState(JsonBundle.message("schema.widget.checking.state.tooltip", new Object[0]), JsonBundle.message("schema.widget.checking.state.text", isJsonFile ? JsonBundle.message("schema.widget.prefix.json.files", new Object[0]) : JsonBundle.message("schema.widget.prefix.other.files", new Object[0])), false);
                }
                EditorBasedStatusBarPopup.WidgetState widgetState = EditorBasedStatusBarPopup.WidgetState.NO_CHANGE;
                if (widgetState == null) {
                    JsonSchemaStatusWidget.$$$reportNull$$$0(7);
                }
                return widgetState;
            }
            if (Boolean.TRUE == suppressInfo.second) {
                EditorBasedStatusBarPopup.WidgetState widgetState = EditorBasedStatusBarPopup.WidgetState.HIDDEN;
                if (widgetState == null) {
                    JsonSchemaStatusWidget.$$$reportNull$$$0(8);
                }
                return widgetState;
            }
        }
        this.mySchemaWidgetState = state = this.doGetWidgetState(file, isJsonFile);
        EditorBasedStatusBarPopup.WidgetState widgetState = state;
        if (widgetState == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(9);
        }
        return widgetState;
    }

    private EditorBasedStatusBarPopup.WidgetState doGetWidgetState(@NotNull VirtualFile file, boolean isJsonFile) {
        String bar;
        JsonSchemaService service;
        if (file == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(10);
        }
        if ((service = this.getService()) == null) {
            return JsonSchemaStatusWidget.getNoSchemaState();
        }
        Collection<VirtualFile> schemaFiles = service.getSchemaFilesForFile(file);
        if (schemaFiles.size() == 0) {
            return JsonSchemaStatusWidget.getNoSchemaState();
        }
        if (schemaFiles.size() != 1) {
            ArrayList<VirtualFile> userSchemas = new ArrayList<VirtualFile>();
            if (JsonSchemaStatusWidget.hasConflicts(userSchemas, service, file)) {
                MyWidgetState state = new MyWidgetState(JsonSchemaStatusWidget.createMessage(schemaFiles, service, "<br/>", JsonBundle.message("schema.widget.conflict.message.prefix", new Object[0]), ""), schemaFiles.size() + " " + JsonBundle.message("schema.widget.conflict.message.postfix", new Object[0]), true);
                state.setWarning(true);
                state.setConflict();
                return state;
            }
            schemaFiles = userSchemas;
            if (schemaFiles.size() == 0) {
                return JsonSchemaStatusWidget.getNoSchemaState();
            }
        }
        VirtualFile schemaFile = schemaFiles.iterator().next();
        schemaFile = ((JsonSchemaServiceImpl)service).replaceHttpFileWithBuiltinIfNeeded(schemaFile);
        String tooltip = isJsonFile ? JsonBundle.message("schema.widget.tooltip.json.files", new Object[0]) : JsonBundle.message("schema.widget.tooltip.other.files", new Object[0]);
        String string = bar = isJsonFile ? JsonBundle.message("schema.widget.prefix.json.files", new Object[0]) : JsonBundle.message("schema.widget.prefix.other.files", new Object[0]);
        if (schemaFile instanceof HttpVirtualFile) {
            RemoteFileInfo info = ((HttpVirtualFile)schemaFile).getFileInfo();
            if (info == null) {
                return JsonSchemaStatusWidget.getDownloadErrorState(null);
            }
            switch (info.getState()) {
                case DOWNLOADING_NOT_STARTED: {
                    this.addDownloadingUpdateListener(info);
                    return new MyWidgetState(tooltip + JsonSchemaStatusWidget.getSchemaFileDesc(schemaFile), bar + JsonSchemaStatusWidget.getPresentableNameForFile(schemaFile), true);
                }
                case DOWNLOADING_IN_PROGRESS: {
                    this.addDownloadingUpdateListener(info);
                    return new MyWidgetState(JsonBundle.message("schema.widget.download.in.progress.tooltip", new Object[0]), JsonBundle.message("schema.widget.download.in.progress.label", new Object[0]), false);
                }
                case ERROR_OCCURRED: {
                    return JsonSchemaStatusWidget.getDownloadErrorState(info.getErrorMessage());
                }
            }
        }
        if (!this.isValidSchemaFile(schemaFile)) {
            MyWidgetState state = new MyWidgetState(JsonBundle.message("schema.widget.error.not.a.schema", new Object[0]), JsonBundle.message("schema.widget.error.label", new Object[0]), true);
            state.setWarning(true);
            return state;
        }
        JsonSchemaFileProvider provider = service.getSchemaProvider(schemaFile);
        if (provider != null) {
            boolean preferRemoteSchemas = JsonSchemaCatalogProjectConfiguration.getInstance(this.myProject).isPreferRemoteSchemas();
            String remoteSource = provider.getRemoteSource();
            boolean useRemoteSource = preferRemoteSchemas && remoteSource != null && !JsonFileResolver.isSchemaUrl(remoteSource) && !remoteSource.endsWith("!");
            String providerName = useRemoteSource ? remoteSource : provider.getPresentableName();
            String shortName = StringUtil.trimEnd((String)StringUtil.trimEnd((String)providerName, (String)".json"), (String)"-schema");
            String name = useRemoteSource ? provider.getPresentableName() : (shortName.contains(JsonBundle.message("schema.of.version", "")) ? shortName : bar + shortName);
            String kind = !useRemoteSource && (provider.getSchemaType() == SchemaType.embeddedSchema || provider.getSchemaType() == SchemaType.schema) ? JsonBundle.message("schema.widget.bundled.postfix", new Object[0]) : "";
            return new MyWidgetState(tooltip + providerName + kind, name, true);
        }
        return new MyWidgetState(tooltip + JsonSchemaStatusWidget.getSchemaFileDesc(schemaFile), bar + JsonSchemaStatusWidget.getPresentableNameForFile(schemaFile), true);
    }

    private void scheduleSuppressCheck(@NotNull VirtualFile file, @NotNull ProgressIndicator globalProgress) {
        if (file == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(11);
        }
        if (globalProgress == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(12);
        }
        Runnable update = () -> {
            if (DumbService.getInstance((Project)this.myProject).isDumb()) {
                this.mySuppressInfoRef.set(null);
            } else {
                boolean suppress = JsonWidgetSuppressor.EXTENSION_POINT_NAME.extensions().anyMatch(s -> s.suppressSwitcherWidget(file, this.myProject));
                this.mySuppressInfoRef.set((Pair<VirtualFile, Boolean>)Pair.create((Object)file, (Object)suppress));
            }
            super.update(null);
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().invokeLater(update);
        } else {
            ReadAction.nonBlocking((Runnable)update).expireWith((Disposable)this).expireWith((Disposable)this.myProject).wrapProgress(globalProgress).coalesceBy(new Object[]{this}).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }
    }

    private static EditorBasedStatusBarPopup.WidgetState getDumbModeState(boolean isJsonFile) {
        return EditorBasedStatusBarPopup.WidgetState.getDumbModeState((String)JsonBundle.message("schema.widget.service", new Object[0]), (String)(isJsonFile ? JsonBundle.message("schema.widget.prefix.json.files", new Object[0]) : JsonBundle.message("schema.widget.prefix.other.files", new Object[0])));
    }

    private void addDownloadingUpdateListener(@NotNull RemoteFileInfo info) {
        if (info == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(13);
        }
        info.addDownloadingListener((FileDownloadingListener)new FileDownloadingAdapter(){

            public void fileDownloaded(@NotNull VirtualFile localFile) {
                if (localFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                JsonSchemaStatusWidget.this.update();
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(1);
                }
                JsonSchemaStatusWidget.this.update();
            }

            public void downloadingCancelled() {
                JsonSchemaStatusWidget.this.update();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "localFile";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/jsonSchema/widget/JsonSchemaStatusWidget$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDownloaded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private boolean isValidSchemaFile(@Nullable VirtualFile schemaFile) {
        if (schemaFile == null) {
            return false;
        }
        JsonSchemaService service = this.getService();
        return service != null && service.isSchemaFile(schemaFile) && service.isApplicableToFile(schemaFile);
    }

    @Nullable
    @NlsSafe
    private static String extractNpmPackageName(@Nullable String path) {
        int trimIndex;
        if (path == null) {
            return null;
        }
        int idx = path.indexOf("node_modules");
        if (idx != -1 && (trimIndex = idx + "node_modules".length() + 1) < path.length()) {
            idx = StringUtil.indexOfAny((String)(path = path.substring(trimIndex)), (String)"\\/");
            if (idx != -1 && path.startsWith("@")) {
                idx = StringUtil.indexOfAny((String)path, (String)"\\/", (int)(idx + 1), (int)path.length());
            }
            if (idx != -1) {
                return path.substring(0, idx);
            }
        }
        return null;
    }

    @NotNull
    @Nls
    private static String getPresentableNameForFile(@NotNull VirtualFile schemaFile) {
        if (schemaFile == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(14);
        }
        if (schemaFile instanceof HttpVirtualFile) {
            String string = new JsonSchemaInfo(schemaFile.getUrl()).getDescription();
            if (string == null) {
                JsonSchemaStatusWidget.$$$reportNull$$$0(15);
            }
            return string;
        }
        String nameWithoutExtension = schemaFile.getNameWithoutExtension();
        if (!JsonSchemaInfo.isVeryDumbName(nameWithoutExtension)) {
            String string = nameWithoutExtension;
            if (string == null) {
                JsonSchemaStatusWidget.$$$reportNull$$$0(16);
            }
            return string;
        }
        String path = schemaFile.getPath();
        String npmPackageName = JsonSchemaStatusWidget.extractNpmPackageName(path);
        String string = npmPackageName != null ? npmPackageName : schemaFile.getName();
        if (string == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private static EditorBasedStatusBarPopup.WidgetState getDownloadErrorState(@Nullable @Nls String message) {
        String s = message == null ? "" : ": " + HtmlChunk.br() + message;
        MyWidgetState state = new MyWidgetState(JsonBundle.message("schema.widget.error.cant.download", new Object[0]) + s, JsonBundle.message("schema.widget.error.label", new Object[0]), true);
        state.setWarning(true);
        MyWidgetState myWidgetState = state;
        if (myWidgetState == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(18);
        }
        return myWidgetState;
    }

    @NotNull
    private static EditorBasedStatusBarPopup.WidgetState getNoSchemaState() {
        return new MyWidgetState(JsonBundle.message("schema.widget.no.schema.tooltip", new Object[0]), JsonBundle.message("schema.widget.no.schema.label", new Object[0]), true);
    }

    @NotNull
    @Nls
    private static String getSchemaFileDesc(@NotNull VirtualFile schemaFile) {
        if (schemaFile == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(19);
        }
        if (schemaFile instanceof HttpVirtualFile) {
            String string = schemaFile.getPresentableUrl();
            if (string == null) {
                JsonSchemaStatusWidget.$$$reportNull$$$0(20);
            }
            return string;
        }
        String npmPackageName = JsonSchemaStatusWidget.extractNpmPackageName(schemaFile.getPath());
        String string = schemaFile.getName() + (String)(npmPackageName == null ? "" : " " + JsonBundle.message("schema.widget.package.postfix", npmPackageName));
        if (string == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Nullable
    protected ListPopup createPopup(DataContext context) {
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
        if (virtualFile == null) {
            return null;
        }
        Project project = this.getProject();
        EditorBasedStatusBarPopup.WidgetState popupState = this.mySchemaWidgetState;
        if (!(popupState instanceof MyWidgetState) || !virtualFile.equals(this.myLastUpdatedFile)) {
            return null;
        }
        JsonSchemaService service = this.getService();
        if (service == null) {
            return null;
        }
        return JsonSchemaStatusPopup.createPopup(service, project, virtualFile, ((MyWidgetState)popupState).isWarning());
    }

    protected void registerCustomListeners() {
        class Listener
        implements DumbService.DumbModeListener {
            volatile boolean isDumbMode;

            Listener() {
            }

            public void enteredDumbMode() {
                this.isDumbMode = true;
                JsonSchemaStatusWidget.this.update();
            }

            public void exitDumbMode() {
                this.isDumbMode = false;
                JsonSchemaStatusWidget.this.update();
            }
        }
        Listener listener = new Listener();
        this.myConnection.subscribe(DumbService.DUMB_MODE, (Object)listener);
    }

    protected void handleFileChange(VirtualFile file) {
        myIsNotified.set(false);
    }

    @NotNull
    protected StatusBarWidget createInstance(@NotNull Project project) {
        if (project == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(22);
        }
        return new JsonSchemaStatusWidget(project);
    }

    @NotNull
    public String ID() {
        return ID;
    }

    public void dispose() {
        JsonSchemaService service;
        JsonSchemaService jsonSchemaService = service = this.myServiceLazy.isInitialized() ? (JsonSchemaService)this.myServiceLazy.getValue() : null;
        if (service != null) {
            service.unregisterRemoteUpdateCallback(this.myUpdateCallback);
            service.unregisterResetAction(this.myUpdateCallback);
        }
        super.dispose();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NlsContexts.Tooltip
    private static String createMessage(@NotNull Collection<? extends VirtualFile> schemaFiles, @NotNull JsonSchemaService jsonSchemaService, @NotNull String separator, @NotNull @Nls String prefix, @NotNull @Nls String suffix) {
        if (schemaFiles == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(23);
        }
        if (jsonSchemaService == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(24);
        }
        if (separator == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(25);
        }
        if (prefix == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(26);
        }
        if (suffix == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(27);
        }
        List<@Nls T> pairList = schemaFiles.stream().map(file -> jsonSchemaService.getSchemaProvider((VirtualFile)file)).filter(Objects::nonNull).map(provider -> Pair.create((Object)SchemaType.userSchema.equals((Object)provider.getSchemaType()), (Object)provider.getName())).collect(Collectors.toList());
        long numOfSystemSchemas = pairList.stream().filter(pair -> (Boolean)pair.getFirst() == false).count();
        if (pairList.size() == 2 && numOfSystemSchemas == 1L) {
            return null;
        }
        boolean withTypes = numOfSystemSchemas > 0L;
        return pairList.stream().map(pair -> JsonSchemaStatusWidget.formatName(withTypes, (Pair<Boolean, String>)pair)).collect(Collectors.joining(separator, prefix, suffix));
    }

    @Nls
    private static String formatName(boolean withTypes, Pair<Boolean, String> pair) {
        return "&nbsp;&nbsp;- " + (withTypes ? String.format("%s schema '%s'", Boolean.TRUE.equals(pair.getFirst()) ? "user" : "system", pair.getSecond()) : (String)pair.getSecond());
    }

    private static boolean hasConflicts(@NotNull Collection<VirtualFile> files, @NotNull JsonSchemaService service, @NotNull VirtualFile file) {
        if (files == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(28);
        }
        if (service == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(29);
        }
        if (file == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(30);
        }
        List<JsonSchemaFileProvider> providers = ((JsonSchemaServiceImpl)service).getProvidersForFile(file);
        for (JsonSchemaFileProvider provider : providers) {
            VirtualFile schemaFile;
            if (provider.getSchemaType() != SchemaType.userSchema || (schemaFile = provider.getSchemaFile()) == null) continue;
            files.add(schemaFile);
        }
        return files.size() > 1;
    }

    protected void afterVisibleUpdate(@NotNull EditorBasedStatusBarPopup.WidgetState state) {
        if (state == null) {
            JsonSchemaStatusWidget.$$$reportNull$$$0(31);
        }
        if (!(state instanceof MyWidgetState) || !((MyWidgetState)state).conflict) {
            myIsNotified.set(false);
            return;
        }
        if (myIsNotified.get()) {
            return;
        }
        myIsNotified.set(true);
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        alarm.addRequest(() -> {
            String message = new HtmlBuilder().append((HtmlChunk)HtmlChunk.tag((String)"b").addText(JsonBundle.message("schema.widget.conflict.popup.title", new Object[0]))).append((HtmlChunk)HtmlChunk.br()).append((HtmlChunk)HtmlChunk.br()).appendRaw(((MyWidgetState)state).getTooltip()).toString();
            JComponent label = HintUtil.createErrorLabel((String)message);
            BalloonBuilder builder = JBPopupFactory.getInstance().createBalloonBuilder(label);
            JComponent statusBarComponent = this.getComponent();
            Balloon balloon = builder.setCalloutShift(statusBarComponent.getHeight() / 2).setDisposable((Disposable)this).setFillColor(HintUtil.getErrorColor()).setHideOnClickOutside(true).createBalloon();
            balloon.showInCenterOf(statusBarComponent);
        }, 500, ModalityState.NON_MODAL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/widget/JsonSchemaStatusWidget";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalProgress";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFile";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFiles";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonSchemaService";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/widget/JsonSchemaStatusWidget";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidgetState";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableNameForFile";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownloadErrorState";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaFileDesc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getWidgetStatus";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doGetWidgetState";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "scheduleSuppressCheck";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addDownloadingUpdateListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableNameForFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaFileDesc";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createMessage";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "hasConflicts";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "afterVisibleUpdate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum WidgetStatus {
        ENABLED,
        DISABLED,
        MAYBE_SUPPRESSED;

    }

    private static class MyWidgetState
    extends EditorBasedStatusBarPopup.WidgetState {
        boolean warning = false;
        boolean conflict = false;

        MyWidgetState(@NlsContexts.Tooltip String toolTip, @NlsContexts.StatusBarText String text, boolean actionEnabled) {
            super(toolTip, text, actionEnabled);
        }

        public boolean isWarning() {
            return this.warning;
        }

        public void setWarning(boolean warning) {
            this.warning = warning;
            this.setIcon(warning ? AllIcons.General.Warning : null);
        }

        private void setConflict() {
            this.conflict = true;
        }

        @NlsContexts.Tooltip
        private String getTooltip() {
            return this.toolTip;
        }
    }
}

