/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.jsonSchema.JsonPointerUtil;
import com.jetbrains.jsonSchema.JsonSchemaCatalogEntry;
import com.jetbrains.jsonSchema.JsonSchemaCatalogProjectConfiguration;
import com.jetbrains.jsonSchema.JsonSchemaVfsListener;
import com.jetbrains.jsonSchema.extension.JsonSchemaEnabler;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonCachedValues;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import com.jetbrains.jsonSchema.remote.JsonSchemaCatalogExclusion;
import com.jetbrains.jsonSchema.remote.JsonSchemaCatalogManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaServiceImpl
implements JsonSchemaService,
ModificationTracker,
Disposable {
    private static final Logger LOG = Logger.getInstance(JsonSchemaServiceImpl.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MyState myState;
    @NotNull
    private final ClearableLazyValue<Set<String>> myBuiltInSchemaIds;
    @NotNull
    private final Set<String> myRefs;
    private final AtomicLong myAnyChangeCount;
    @NotNull
    private final JsonSchemaCatalogManager myCatalogManager;
    private final List<Runnable> myResetActions;

    public JsonSchemaServiceImpl(@NotNull Project project) {
        if (project == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(0);
        }
        this.myRefs = ContainerUtil.newConcurrentSet();
        this.myAnyChangeCount = new AtomicLong(0L);
        this.myResetActions = ContainerUtil.createConcurrentList();
        this.myProject = project;
        this.myState = new MyState((Factory<List<JsonSchemaFileProvider>>)((Factory)() -> this.getProvidersFromFactories()), this.myProject);
        this.myBuiltInSchemaIds = new ClearableLazyValue<Set<String>>(){

            @NotNull
            protected Set<String> compute() {
                Set set = ContainerUtil.map2SetNotNull(JsonSchemaServiceImpl.this.myState.getFiles(), f -> JsonCachedValues.getSchemaId(f, JsonSchemaServiceImpl.this.myProject));
                if (set == null) {
                    1.$$$reportNull$$$0(0);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$1", "compute"));
            }
        };
        JsonSchemaProviderFactory.EP_NAME.addChangeListener(this::reset, (Disposable)this);
        JsonSchemaEnabler.EXTENSION_POINT_NAME.addChangeListener(this::reset, (Disposable)this);
        JsonSchemaCatalogExclusion.EP_NAME.addChangeListener(this::reset, (Disposable)this);
        this.myCatalogManager = new JsonSchemaCatalogManager(this.myProject);
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(JsonSchemaVfsListener.JSON_SCHEMA_CHANGED, this.myAnyChangeCount::incrementAndGet);
        connection.subscribe(JsonSchemaVfsListener.JSON_DEPS_CHANGED, () -> {
            this.myRefs.clear();
            this.myAnyChangeCount.incrementAndGet();
        });
        JsonSchemaVfsListener.startListening(project, this, connection);
        this.myCatalogManager.startUpdates();
    }

    public long getModificationCount() {
        return this.myAnyChangeCount.get();
    }

    public void dispose() {
    }

    @NotNull
    private List<JsonSchemaFileProvider> getProvidersFromFactories() {
        ArrayList<JsonSchemaFileProvider> providers = new ArrayList<JsonSchemaFileProvider>();
        for (JsonSchemaProviderFactory factory : this.getProviderFactories()) {
            try {
                providers.addAll(factory.getProviders(this.myProject));
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                PluginException.logPluginError((Logger)Logger.getInstance(JsonSchemaService.class), (String)e.toString(), (Throwable)e, factory.getClass());
            }
        }
        ArrayList<JsonSchemaFileProvider> arrayList = providers;
        if (arrayList == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    protected List<JsonSchemaProviderFactory> getProviderFactories() {
        List list = JsonSchemaProviderFactory.EP_NAME.getExtensionList();
        if (list == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @Nullable
    public JsonSchemaFileProvider getSchemaProvider(@NotNull VirtualFile schemaFile) {
        if (schemaFile == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(3);
        }
        return this.myState.getProvider(schemaFile);
    }

    @Override
    @Nullable
    public JsonSchemaFileProvider getSchemaProvider(@NotNull JsonSchemaObject schemaObject) {
        VirtualFile file;
        if (schemaObject == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(4);
        }
        return (file = this.resolveSchemaFile(schemaObject)) == null ? null : this.getSchemaProvider(file);
    }

    @Override
    public void reset() {
        this.myState.reset();
        this.myBuiltInSchemaIds.drop();
        this.myAnyChangeCount.incrementAndGet();
        for (Runnable action : this.myResetActions) {
            action.run();
        }
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(5);
        }
        return project;
    }

    @Override
    @Nullable
    public VirtualFile findSchemaFileByReference(@NotNull String reference, @Nullable VirtualFile referent) {
        VirtualFile file;
        if (reference == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(6);
        }
        if ((file = this.findBuiltInSchemaByReference(reference)) != null) {
            return file;
        }
        if (reference.startsWith("#")) {
            return referent;
        }
        return JsonFileResolver.resolveSchemaByReference(referent, JsonPointerUtil.normalizeId(reference));
    }

    @Nullable
    private VirtualFile findBuiltInSchemaByReference(@NotNull String reference) {
        if (reference == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(7);
        }
        String id = JsonPointerUtil.normalizeId(reference);
        if (!((Set)this.myBuiltInSchemaIds.getValue()).contains(id)) {
            return null;
        }
        for (VirtualFile file : this.myState.getFiles()) {
            if (!id.equals(JsonCachedValues.getSchemaId(file, this.myProject))) continue;
            return file;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getSchemaFilesForFile(@NotNull VirtualFile file) {
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(8);
        }
        Collection<VirtualFile> collection = this.getSchemasForFile(file, false, false);
        if (collection == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @NotNull
    public Collection<VirtualFile> getSchemasForFile(@NotNull VirtualFile file, boolean single, boolean onlyUserSchemas) {
        VirtualFile virtualFile;
        VirtualFile virtualFile2;
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(10);
        }
        String schemaUrl = null;
        if (!onlyUserSchemas && JsonFileResolver.isSchemaUrl(schemaUrl = JsonCachedValues.getSchemaUrlFromSchemaProperty(file, this.myProject)) && (virtualFile2 = this.resolveFromSchemaProperty(schemaUrl, file)) != null) {
            List<VirtualFile> list = Collections.singletonList(virtualFile2);
            if (list == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(11);
            }
            return list;
        }
        List<JsonSchemaFileProvider> providers = this.getProvidersForFile(file);
        boolean checkSchemaProperty = true;
        if (!onlyUserSchemas && providers.stream().noneMatch(p -> p.getSchemaType() == SchemaType.userSchema)) {
            if (schemaUrl == null) {
                schemaUrl = JsonCachedValues.getSchemaUrlFromSchemaProperty(file, this.myProject);
            }
            if ((virtualFile = this.resolveFromSchemaProperty(schemaUrl, file)) != null) {
                List<VirtualFile> list = Collections.singletonList(virtualFile);
                if (list == null) {
                    JsonSchemaServiceImpl.$$$reportNull$$$0(12);
                }
                return list;
            }
            checkSchemaProperty = false;
        }
        if (!single) {
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
            for (JsonSchemaFileProvider provider2 : providers) {
                VirtualFile schemaFile = JsonSchemaServiceImpl.getSchemaForProvider(this.myProject, provider2);
                if (schemaFile == null) continue;
                files.add(schemaFile);
            }
            if (!files.isEmpty()) {
                ArrayList<VirtualFile> arrayList = files;
                if (arrayList == null) {
                    JsonSchemaServiceImpl.$$$reportNull$$$0(13);
                }
                return arrayList;
            }
        } else if (!providers.isEmpty()) {
            JsonSchemaFileProvider selected;
            if (providers.size() > 2) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    JsonSchemaServiceImpl.$$$reportNull$$$0(14);
                }
                return list;
            }
            if (providers.size() > 1) {
                Optional<JsonSchemaFileProvider> userSchema = providers.stream().filter(provider -> SchemaType.userSchema.equals((Object)provider.getSchemaType())).findFirst();
                if (userSchema.isEmpty()) {
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        JsonSchemaServiceImpl.$$$reportNull$$$0(15);
                    }
                    return list;
                }
                selected = userSchema.get();
            } else {
                selected = providers.get(0);
            }
            VirtualFile schemaFile = JsonSchemaServiceImpl.getSchemaForProvider(this.myProject, selected);
            List list = ContainerUtil.createMaybeSingletonList((Object)schemaFile);
            if (list == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(16);
            }
            return list;
        }
        if (onlyUserSchemas) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(17);
            }
            return list;
        }
        if (checkSchemaProperty) {
            if (schemaUrl == null) {
                schemaUrl = JsonCachedValues.getSchemaUrlFromSchemaProperty(file, this.myProject);
            }
            if ((virtualFile = this.resolveFromSchemaProperty(schemaUrl, file)) != null) {
                List<VirtualFile> list = Collections.singletonList(virtualFile);
                if (list == null) {
                    JsonSchemaServiceImpl.$$$reportNull$$$0(18);
                }
                return list;
            }
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)this.resolveSchemaFromOtherSources(file));
        if (list == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    public List<JsonSchemaFileProvider> getProvidersForFile(@NotNull VirtualFile file) {
        Map map;
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(20);
        }
        if ((map = (Map)this.myState.myData.getValue()).isEmpty()) {
            List<JsonSchemaFileProvider> list = Collections.emptyList();
            if (list == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(21);
            }
            return list;
        }
        List result = null;
        for (List providers : map.values()) {
            for (JsonSchemaFileProvider provider : providers) {
                if (!JsonSchemaServiceImpl.isProviderAvailable(file, provider)) continue;
                if (result == null) {
                    result = new SmartList();
                }
                result.add(provider);
            }
        }
        List<JsonSchemaFileProvider> list = result == null ? Collections.emptyList() : result;
        if (list == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(22);
        }
        return list;
    }

    @Nullable
    private VirtualFile resolveFromSchemaProperty(@Nullable String schemaUrl, @NotNull VirtualFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(23);
        }
        if (schemaUrl != null && (virtualFile = this.findSchemaFileByReference(schemaUrl, file)) != null) {
            return virtualFile;
        }
        return null;
    }

    @Override
    public List<JsonSchemaInfo> getAllUserVisibleSchemas() {
        List<JsonSchemaCatalogEntry> schemas = this.myCatalogManager.getAllCatalogEntries();
        Map map = (Map)this.myState.myData.getValue();
        ArrayList<JsonSchemaInfo> results = new ArrayList<JsonSchemaInfo>(schemas.size() + map.size());
        HashMap processedRemotes = new HashMap();
        this.myState.processProviders(provider -> {
            if (provider.isUserVisible()) {
                String remoteSource = provider.getRemoteSource();
                if (remoteSource != null) {
                    if (!processedRemotes.containsKey(remoteSource)) {
                        JsonSchemaInfo info = new JsonSchemaInfo((JsonSchemaFileProvider)provider);
                        processedRemotes.put(remoteSource, info);
                        results.add(info);
                    }
                } else {
                    results.add(new JsonSchemaInfo((JsonSchemaFileProvider)provider));
                }
            }
        });
        for (JsonSchemaCatalogEntry schema : schemas) {
            JsonSchemaInfo info;
            String url = schema.getUrl();
            if (!processedRemotes.containsKey(url)) {
                info = new JsonSchemaInfo(url);
                if (schema.getDescription() != null) {
                    info.setDocumentation(schema.getDescription());
                }
                if (schema.getName() != null) {
                    info.setName(schema.getName());
                }
                results.add(info);
                continue;
            }
            info = (JsonSchemaInfo)processedRemotes.get(url);
            if (info.getDocumentation() == null) {
                info.setDocumentation(schema.getDescription());
            }
            if (info.getName() != null) continue;
            info.setName(schema.getName());
        }
        return results;
    }

    @Override
    @Nullable
    public JsonSchemaObject getSchemaObject(@NotNull VirtualFile file) {
        Collection<VirtualFile> schemas;
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(24);
        }
        if ((schemas = this.getSchemasForFile(file, true, false)).size() == 0) {
            return null;
        }
        assert (schemas.size() == 1);
        VirtualFile schemaFile = schemas.iterator().next();
        return JsonCachedValues.getSchemaObject(this.replaceHttpFileWithBuiltinIfNeeded(schemaFile), this.myProject);
    }

    @Override
    @Nullable
    public JsonSchemaObject getSchemaObject(@NotNull PsiFile file) {
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(25);
        }
        return JsonCachedValues.computeSchemaForFile(file, this);
    }

    public VirtualFile replaceHttpFileWithBuiltinIfNeeded(VirtualFile schemaFile) {
        if (schemaFile instanceof HttpVirtualFile && (!JsonSchemaCatalogProjectConfiguration.getInstance(this.myProject).isPreferRemoteSchemas() || JsonFileResolver.isSchemaUrl(schemaFile.getUrl()))) {
            String url = schemaFile.getUrl();
            VirtualFile first1 = this.getLocalSchemaByUrl(url);
            return first1 != null ? first1 : schemaFile;
        }
        return schemaFile;
    }

    @Nullable
    public VirtualFile getLocalSchemaByUrl(String url) {
        return this.myState.getFiles().stream().filter(f -> {
            JsonSchemaFileProvider prov = this.getSchemaProvider((VirtualFile)f);
            return prov != null && !(prov.getSchemaFile() instanceof HttpVirtualFile) && (url.equals(prov.getRemoteSource()) || JsonFileResolver.replaceUnsafeSchemaStoreUrls(url).equals(prov.getRemoteSource()) || url.equals(JsonFileResolver.replaceUnsafeSchemaStoreUrls(prov.getRemoteSource())));
        }).findFirst().orElse(null);
    }

    @Override
    @Nullable
    public JsonSchemaObject getSchemaObjectForSchemaFile(@NotNull VirtualFile schemaFile) {
        if (schemaFile == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(26);
        }
        return JsonCachedValues.getSchemaObject(schemaFile, this.myProject);
    }

    @Override
    public boolean isSchemaFile(@NotNull VirtualFile file) {
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(27);
        }
        return this.isMappedSchema(file) || this.isSchemaByProvider(file) || this.hasSchemaSchema(file);
    }

    @Override
    public boolean isSchemaFile(@NotNull JsonSchemaObject schemaObject) {
        VirtualFile file;
        if (schemaObject == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(28);
        }
        return (file = this.resolveSchemaFile(schemaObject)) != null && this.isSchemaFile(file);
    }

    private boolean isMappedSchema(@NotNull VirtualFile file) {
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(29);
        }
        return this.isMappedSchema(file, true);
    }

    public boolean isMappedSchema(@NotNull VirtualFile file, boolean canRecompute) {
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(30);
        }
        return (canRecompute || this.myState.isComputed()) && this.myState.getFiles().contains(file);
    }

    private boolean isSchemaByProvider(@NotNull VirtualFile file) {
        JsonSchemaFileProvider provider;
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(31);
        }
        if ((provider = this.myState.getProvider(file)) != null) {
            return JsonSchemaServiceImpl.isSchemaProvider(provider);
        }
        Map map = (Map)this.myState.myData.getValue();
        for (List providers : map.values()) {
            for (JsonSchemaFileProvider p : providers) {
                if (!JsonSchemaServiceImpl.isSchemaProvider(p) || !p.isAvailable(file)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSchemaProvider(JsonSchemaFileProvider provider) {
        return JsonFileResolver.isSchemaUrl(provider.getRemoteSource());
    }

    @Override
    public JsonSchemaVersion getSchemaVersion(@NotNull VirtualFile file) {
        JsonSchemaFileProvider provider;
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(32);
        }
        if (this.isMappedSchema(file) && (provider = this.myState.getProvider(file)) != null) {
            return provider.getSchemaVersion();
        }
        return this.getSchemaVersionFromSchemaUrl(file);
    }

    @Nullable
    private JsonSchemaVersion getSchemaVersionFromSchemaUrl(@NotNull VirtualFile file) {
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(33);
        }
        Ref res = Ref.create(null);
        ApplicationManager.getApplication().runReadAction(() -> res.set((Object)JsonCachedValues.getSchemaUrlFromSchemaProperty(file, this.myProject)));
        if (res.isNull()) {
            return null;
        }
        return JsonSchemaVersion.byId((String)res.get());
    }

    private boolean hasSchemaSchema(VirtualFile file) {
        return this.getSchemaVersionFromSchemaUrl(file) != null;
    }

    private static boolean isProviderAvailable(@NotNull VirtualFile file, @NotNull JsonSchemaFileProvider provider) {
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(34);
        }
        if (provider == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(35);
        }
        return provider.isAvailable(file);
    }

    @Nullable
    private VirtualFile resolveSchemaFromOtherSources(@NotNull VirtualFile file) {
        if (file == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(36);
        }
        return this.myCatalogManager.getSchemaFileForFile(file);
    }

    @Override
    public void registerRemoteUpdateCallback(Runnable callback) {
        this.myCatalogManager.registerCatalogUpdateCallback(callback);
    }

    @Override
    public void unregisterRemoteUpdateCallback(Runnable callback) {
        this.myCatalogManager.unregisterCatalogUpdateCallback(callback);
    }

    @Override
    public void registerResetAction(Runnable action) {
        this.myResetActions.add(action);
    }

    @Override
    public void unregisterResetAction(Runnable action) {
        this.myResetActions.remove(action);
    }

    @Override
    public void registerReference(String ref) {
        int index = StringUtil.lastIndexOfAny((CharSequence)ref, (String)"\\/");
        if (index >= 0) {
            ref = ref.substring(index + 1);
        }
        this.myRefs.add(ref);
    }

    @Override
    public boolean possiblyHasReference(String ref) {
        return this.myRefs.contains(ref);
    }

    @Override
    public void triggerUpdateRemote() {
        this.myCatalogManager.triggerUpdateCatalog(this.myProject);
    }

    @Override
    public boolean isApplicableToFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        for (JsonSchemaEnabler e : JsonSchemaEnabler.EXTENSION_POINT_NAME.getExtensionList()) {
            if (!e.isEnabledForFile(file, this.myProject)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public JsonSchemaCatalogManager getCatalogManager() {
        JsonSchemaCatalogManager jsonSchemaCatalogManager = this.myCatalogManager;
        if (jsonSchemaCatalogManager == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(37);
        }
        return jsonSchemaCatalogManager;
    }

    @Nullable
    private static VirtualFile getSchemaForProvider(@NotNull Project project, @NotNull JsonSchemaFileProvider provider) {
        String source;
        if (project == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(38);
        }
        if (provider == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(39);
        }
        if (JsonSchemaCatalogProjectConfiguration.getInstance(project).isPreferRemoteSchemas() && (source = provider.getRemoteSource()) != null && !source.endsWith("!") && !JsonFileResolver.isSchemaUrl(source)) {
            return VirtualFileManager.getInstance().findFileByUrl(source);
        }
        return provider.getSchemaFile();
    }

    @Override
    @Nullable
    public VirtualFile resolveSchemaFile(@NotNull JsonSchemaObject schemaObject) {
        VirtualFile rawFile;
        if (schemaObject == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(40);
        }
        if ((rawFile = schemaObject.getRawFile()) != null) {
            return rawFile;
        }
        String fileUrl = schemaObject.getFileUrl();
        if (fileUrl == null) {
            return null;
        }
        return VirtualFileManager.getInstance().findFileByUrl(fileUrl);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl";
                break;
            }
            case 3: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFile";
                break;
            }
            case 4: 
            case 28: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaObject";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 8: 
            case 10: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvidersFromFactories";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderFactories";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaFilesForFile";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemasForFile";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvidersForFile";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getCatalogManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 37: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaProvider";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findSchemaFileByReference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findBuiltInSchemaByReference";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaFilesForFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSchemasForFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getProvidersForFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolveFromSchemaProperty";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaObject";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaObjectForSchemaFile";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isSchemaFile";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isMappedSchema";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isSchemaByProvider";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaVersion";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaVersionFromSchemaUrl";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isProviderAvailable";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "resolveSchemaFromOtherSources";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaForProvider";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "resolveSchemaFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyState {
        @NotNull
        private final Factory<List<JsonSchemaFileProvider>> myFactory;
        @NotNull
        private final Project myProject;
        @NotNull
        private final ClearableLazyValue<Map<VirtualFile, List<JsonSchemaFileProvider>>> myData;
        private final AtomicBoolean myIsComputed;

        private MyState(@NotNull Factory<List<JsonSchemaFileProvider>> factory, @NotNull Project project) {
            if (factory == null) {
                MyState.$$$reportNull$$$0(0);
            }
            if (project == null) {
                MyState.$$$reportNull$$$0(1);
            }
            this.myIsComputed = new AtomicBoolean(false);
            this.myFactory = factory;
            this.myProject = project;
            this.myData = new ClearableLazyValue<Map<VirtualFile, List<JsonSchemaFileProvider>>>(){

                @NotNull
                public Map<VirtualFile, List<JsonSchemaFileProvider>> compute() {
                    Map<VirtualFile, List<JsonSchemaFileProvider>> map = MyState.createFileProviderMap((List)myFactory.create(), myProject);
                    myIsComputed.set(true);
                    Map<VirtualFile, List<JsonSchemaFileProvider>> map2 = map;
                    if (map2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return map2;
                }

                @NotNull
                public final synchronized Map<VirtualFile, List<JsonSchemaFileProvider>> getValue() {
                    Map map = (Map)super.getValue();
                    if (map == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return map;
                }

                public final synchronized void drop() {
                    myIsComputed.set(false);
                    super.drop();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$MyState$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "compute";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getValue";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }

        public void reset() {
            this.myData.drop();
        }

        public void processProviders(@NotNull Consumer<JsonSchemaFileProvider> consumer) {
            Map map;
            if (consumer == null) {
                MyState.$$$reportNull$$$0(2);
            }
            if ((map = (Map)this.myData.getValue()).isEmpty()) {
                return;
            }
            for (List providers : map.values()) {
                providers.forEach(consumer);
            }
        }

        @NotNull
        public Set<VirtualFile> getFiles() {
            Set<VirtualFile> set = ((Map)this.myData.getValue()).keySet();
            if (set == null) {
                MyState.$$$reportNull$$$0(3);
            }
            return set;
        }

        @Nullable
        public JsonSchemaFileProvider getProvider(@NotNull VirtualFile file) {
            List providers;
            if (file == null) {
                MyState.$$$reportNull$$$0(4);
            }
            if ((providers = (List)((Map)this.myData.getValue()).get(file)) == null || providers.isEmpty()) {
                return null;
            }
            for (JsonSchemaFileProvider p : providers) {
                if (p.getSchemaType() != SchemaType.userSchema) continue;
                return p;
            }
            return (JsonSchemaFileProvider)providers.get(0);
        }

        public boolean isComputed() {
            return this.myIsComputed.get();
        }

        @NotNull
        private static Map<VirtualFile, List<JsonSchemaFileProvider>> createFileProviderMap(@NotNull List<JsonSchemaFileProvider> list, @NotNull Project project) {
            if (list == null) {
                MyState.$$$reportNull$$$0(5);
            }
            if (project == null) {
                MyState.$$$reportNull$$$0(6);
            }
            HashMap<VirtualFile, List<JsonSchemaFileProvider>> map = new HashMap<VirtualFile, List<JsonSchemaFileProvider>>();
            for (JsonSchemaFileProvider provider : list) {
                VirtualFile schemaFile;
                try {
                    schemaFile = JsonSchemaServiceImpl.getSchemaForProvider(project, provider);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    continue;
                }
                if (schemaFile == null) continue;
                map.computeIfAbsent(schemaFile, __ -> new SmartList()).add(provider);
            }
            HashMap<VirtualFile, List<JsonSchemaFileProvider>> hashMap = map;
            if (hashMap == null) {
                MyState.$$$reportNull$$$0(7);
            }
            return hashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$MyState";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$MyState";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFileProviderMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "processProviders";
                    break;
                }
                case 3: 
                case 7: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getProvider";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createFileProviderMap";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

