/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsonpath.ui;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.find.FindBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.json.JsonBundle;
import com.intellij.json.json5.Json5FileType;
import com.intellij.json.psi.JsonFile;
import com.intellij.jsonpath.JsonPathFileType;
import com.intellij.jsonpath.ui.JsonPathEvaluateManager;
import com.intellij.jsonpath.ui.JsonPathEvaluateView$sam$java_util_function_Supplier$0;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.serialization.ClassUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.PopupState;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b \u0018\u00002\u00020\u00012\u00020\u0002:\u0004EFGHB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020$H\u0016J\b\u0010(\u001a\u00020$H\u0002J\u0010\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020+H\u0002J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020&0-H\u0002J\n\u0010.\u001a\u0004\u0018\u00010/H$J \u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020&2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0004J\b\u00106\u001a\u00020$H\u0004J\b\u00107\u001a\u00020$H\u0004J\u0010\u00108\u001a\u00020$2\u0006\u00109\u001a\u00020&H\u0002J\u000e\u0010:\u001a\u00020$2\u0006\u0010;\u001a\u00020&J\u0016\u0010<\u001a\u00020$2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020&0>H\u0002J\u0010\u0010?\u001a\u00020$2\u0006\u0010@\u001a\u00020&H\u0002J\u001a\u0010A\u001a\u00020&2\u0006\u0010B\u001a\u00020C2\b\u0010@\u001a\u0004\u0018\u00010DH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006I"}, d2={"Lcom/intellij/jsonpath/ui/JsonPathEvaluateView;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "errorOutputArea", "Lcom/intellij/ui/components/JBTextArea;", "errorOutputContainer", "Ljavax/swing/JScrollPane;", "evalOptions", "", "Lcom/jayway/jsonpath/Option;", "getProject", "()Lcom/intellij/openapi/project/Project;", "resultEditor", "Lcom/intellij/openapi/editor/Editor;", "resultLabel", "Lcom/intellij/ui/components/JBLabel;", "resultWrapper", "Lcom/intellij/ui/components/JBPanelWithEmptyText;", "getResultWrapper", "()Lcom/intellij/ui/components/JBPanelWithEmptyText;", "searchComponent", "Ljavax/swing/JComponent;", "getSearchComponent", "()Ljavax/swing/JComponent;", "searchTextField", "Lcom/intellij/ui/EditorTextField;", "getSearchTextField", "()Lcom/intellij/ui/EditorTextField;", "searchWrapper", "Ljavax/swing/JPanel;", "getSearchWrapper", "()Ljavax/swing/JPanel;", "addJSONPathToHistory", "", "path", "", "dispose", "evaluate", "fillToolbarOptions", "group", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "getExpressionHistory", "", "getJsonFile", "Lcom/intellij/json/psi/JsonFile;", "initJsonEditor", "fileName", "isViewer", "", "kind", "Lcom/intellij/openapi/editor/EditorKind;", "initToolbar", "resetExpressionHighlighting", "setError", "error", "setExpression", "jsonPathExpr", "setExpressionHistory", "history", "", "setResult", "result", "toResultString", "config", "Lcom/jayway/jsonpath/Configuration;", "", "OptionToggleAction", "OutputOptionAction", "SearchHistoryButton", "ShowHistoryAction", "intellij.json"})
public abstract class JsonPathEvaluateView
extends SimpleToolWindowPanel
implements Disposable {
    @NotNull
    private final EditorTextField searchTextField;
    @NotNull
    private final JPanel searchWrapper;
    @NotNull
    private final JBPanelWithEmptyText resultWrapper;
    private final JBLabel resultLabel;
    private final Editor resultEditor;
    private final JBTextArea errorOutputArea;
    private final JScrollPane errorOutputContainer;
    private final Set<Option> evalOptions;
    @NotNull
    private final Project project;

    @NotNull
    protected final EditorTextField getSearchTextField() {
        return this.searchTextField;
    }

    @NotNull
    protected final JPanel getSearchWrapper() {
        return this.searchWrapper;
    }

    @NotNull
    public final JComponent getSearchComponent() {
        return (JComponent)this.searchTextField;
    }

    @NotNull
    protected final JBPanelWithEmptyText getResultWrapper() {
        return this.resultWrapper;
    }

    protected final void initToolbar() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        this.fillToolbarOptions(actionGroup);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("JsonPathEvaluateToolbar", (ActionGroup)actionGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"ActionManager.getInstanc\u2026lbar\", actionGroup, true)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setTargetComponent((JComponent)((Object)this));
        this.setToolbar(toolbar.getComponent());
    }

    @Nullable
    protected abstract JsonFile getJsonFile();

    protected final void resetExpressionHighlighting() {
        PsiFile jsonPathFile = PsiDocumentManager.getInstance((Project)this.project).getPsiFile(this.searchTextField.getDocument());
        if (jsonPathFile != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.project).restart(jsonPathFile);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void fillToolbarOptions(DefaultActionGroup group) {
        void $this$apply;
        ComboBoxAction outputComboBox2 = new ComboBoxAction(this){
            final /* synthetic */ JsonPathEvaluateView this$0;

            @NotNull
            protected DefaultActionGroup createPopupActionGroup(@Nullable JComponent button) {
                DefaultActionGroup outputItems = new DefaultActionGroup();
                String string = JsonBundle.message("jsonpath.evaluate.output.values", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JsonBundle.message(\"json\u2026.evaluate.output.values\")");
                outputItems.add((AnAction)this.this$0.new OutputOptionAction(false, string));
                String string2 = JsonBundle.message("jsonpath.evaluate.output.paths", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JsonBundle.message(\"json\u2026h.evaluate.output.paths\")");
                outputItems.add((AnAction)this.this$0.new OutputOptionAction(true, string2));
                return outputItems;
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Presentation presentation = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
                Presentation presentation2 = presentation;
                if (e.getProject() == null) {
                    return;
                }
                presentation2.setText(JsonPathEvaluateView.access$getEvalOptions$p(this.this$0).contains(Option.AS_PATH_LIST) ? JsonBundle.message("jsonpath.evaluate.output.paths", new Object[0]) : JsonBundle.message("jsonpath.evaluate.output.values", new Object[0]));
            }

            @NotNull
            public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
                Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
                Intrinsics.checkNotNullParameter((Object)place, (String)"place");
                JPanel panel = new JPanel(new GridBagLayout());
                panel.add((Component)new JLabel(JsonBundle.message("jsonpath.evaluate.output.option", new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, (Insets)JBUI.insetsLeft((int)5), 0, 0));
                panel.add((Component)super.createCustomComponent(presentation, place), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, (Insets)JBUI.emptyInsets(), 0, 0));
                return panel;
            }
            {
                this.this$0 = this$0;
            }
        };
        group.add((AnAction)outputComboBox2);
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(JsonBundle.message("jsonpath.evaluate.options", new Object[0]), true);
        boolean bl = false;
        boolean bl2 = false;
        DefaultActionGroup defaultActionGroup2 = defaultActionGroup;
        DefaultActionGroup defaultActionGroup3 = group;
        boolean bl3 = false;
        Presentation presentation = $this$apply.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"templatePresentation");
        presentation.setIcon(AllIcons.General.Settings);
        String string = JsonBundle.message("jsonpath.evaluate.suppress.exceptions", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JsonBundle.message(\"json\u2026ate.suppress.exceptions\")");
        $this$apply.add((AnAction)new OptionToggleAction(Option.SUPPRESS_EXCEPTIONS, string));
        String string2 = JsonBundle.message("jsonpath.evaluate.return.list", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JsonBundle.message(\"json\u2026th.evaluate.return.list\")");
        $this$apply.add((AnAction)new OptionToggleAction(Option.ALWAYS_RETURN_LIST, string2));
        String string3 = JsonBundle.message("jsonpath.evaluate.nullize.missing.leaf", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"JsonBundle.message(\"json\u2026te.nullize.missing.leaf\")");
        $this$apply.add((AnAction)new OptionToggleAction(Option.DEFAULT_PATH_LEAF_TO_NULL, string3));
        String string4 = JsonBundle.message("jsonpath.evaluate.require.all.properties", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"JsonBundle.message(\"json\u2026.require.all.properties\")");
        $this$apply.add((AnAction)new OptionToggleAction(Option.REQUIRE_PROPERTIES, string4));
        Unit unit = Unit.INSTANCE;
        defaultActionGroup3.add((AnAction)defaultActionGroup);
    }

    @NotNull
    protected final Editor initJsonEditor(@NotNull String fileName, boolean isViewer, @NotNull EditorKind kind) {
        Editor editor;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        LightVirtualFile sourceVirtualFile = new LightVirtualFile(fileName, (FileType)Json5FileType.INSTANCE, (CharSequence)"");
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile((VirtualFile)sourceVirtualFile);
        Intrinsics.checkNotNull((Object)psiFile);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiManager.getInstance(p\u2026File(sourceVirtualFile)!!");
        PsiFile sourceFile = psiFile;
        Document document = PsiDocumentManager.getInstance((Project)this.project).getDocument(sourceFile);
        Intrinsics.checkNotNull((Object)document);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"PsiDocumentManager.getIn\u2026getDocument(sourceFile)!!");
        Document document2 = document;
        Editor editor2 = editor = EditorFactory.getInstance().createEditor(document2, this.project, (VirtualFile)sourceVirtualFile, isViewer, kind);
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"editor");
        EditorSettings editorSettings = editor2.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"editor.settings");
        editorSettings.setLineNumbersShown(false);
        return editor;
    }

    public final void setExpression(@NotNull String jsonPathExpr) {
        Intrinsics.checkNotNullParameter((Object)jsonPathExpr, (String)"jsonPathExpr");
        this.searchTextField.setText(jsonPathExpr);
    }

    private final void setResult(String result) {
        WriteAction.run((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<Throwable>(this, result){
            final /* synthetic */ JsonPathEvaluateView this$0;
            final /* synthetic */ String $result;

            public final void run() {
                JsonPathEvaluateView.access$getResultEditor$p(this.this$0).getDocument().setText((CharSequence)this.$result);
                PsiDocumentManager.getInstance((Project)this.this$0.getProject()).commitDocument(JsonPathEvaluateView.access$getResultEditor$p(this.this$0).getDocument());
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.this$0.getProject()).getPsiFile(JsonPathEvaluateView.access$getResultEditor$p(this.this$0).getDocument());
                Intrinsics.checkNotNull((Object)psiFile);
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiDocumentManager.getIn\u2026(resultEditor.document)!!");
                PsiFile psiFile2 = psiFile;
                new ReformatCodeProcessor(psiFile2, false).run();
            }
            {
                this.this$0 = jsonPathEvaluateView;
                this.$result = string;
            }
        }));
        Object[] objectArray = this.resultWrapper.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"resultWrapper.components");
        if (!ArraysKt.contains((Object[])objectArray, (Object)this.resultEditor.getComponent())) {
            this.resultWrapper.removeAll();
            this.resultWrapper.add((Component)this.resultLabel, (Object)"North");
            this.resultWrapper.add((Component)this.resultEditor.getComponent(), (Object)"Center");
            this.resultWrapper.revalidate();
            this.resultWrapper.repaint();
        }
        this.resultEditor.getCaretModel().moveToOffset(0);
    }

    private final void setError(String error) {
        this.errorOutputArea.setText(error);
        Object[] objectArray = this.resultWrapper.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"resultWrapper.components");
        if (!ArraysKt.contains((Object[])objectArray, (Object)this.errorOutputArea)) {
            this.resultWrapper.removeAll();
            this.resultWrapper.add((Component)this.resultLabel, (Object)"North");
            this.resultWrapper.add((Component)this.errorOutputContainer, (Object)"Center");
            this.resultWrapper.revalidate();
            this.resultWrapper.repaint();
        }
    }

    private final void evaluate() {
        Object object;
        DocumentContext documentContext;
        String json;
        JsonPath jsonPath;
        String string = this.searchTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"searchTextField.text");
        String expression = string;
        try {
            if (StringsKt.isBlank((CharSequence)expression)) {
                return;
            }
            JsonPath jsonPath2 = JsonPath.compile((String)expression, (Predicate[])new Predicate[0]);
            Intrinsics.checkNotNullExpressionValue((Object)jsonPath2, (String)"JsonPath.compile(expression)");
            jsonPath = jsonPath2;
        }
        catch (InvalidPathException ip) {
            String string2 = ip.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ip.localizedMessage");
            this.setError(string2);
            return;
        }
        JsonPath jsonPath3 = jsonPath;
        this.addJSONPathToHistory(expression);
        Configuration config = new Configuration.ConfigurationBuilder().options(this.evalOptions).build();
        JsonFile jsonFile = this.getJsonFile();
        String string3 = json = jsonFile != null ? jsonFile.getText() : null;
        if (json == null) {
            String string4 = JsonBundle.message("jsonpath.evaluate.file.not.found", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"JsonBundle.message(\"json\u2026evaluate.file.not.found\")");
            this.setError(string4);
            return;
        }
        try {
            DocumentContext documentContext2 = JsonPath.parse((String)json, (Configuration)config);
            Intrinsics.checkNotNullExpressionValue((Object)documentContext2, (String)"JsonPath.parse(json, config)");
            documentContext = documentContext2;
        }
        catch (IllegalArgumentException e) {
            String string5 = e.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"e.localizedMessage");
            this.setError(string5);
            return;
        }
        catch (InvalidJsonException ej) {
            String string6 = ej.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"ej.localizedMessage");
            this.setError(string6);
            return;
        }
        DocumentContext jsonDocument = documentContext;
        try {
            object = jsonDocument.read(jsonPath3);
        }
        catch (PathNotFoundException pe) {
            String string7 = pe.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"pe.localizedMessage");
            this.setError(string7);
            return;
        }
        catch (JsonPathException jpe) {
            String string8 = jpe.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"jpe.localizedMessage");
            this.setError(string8);
            return;
        }
        catch (IllegalStateException ise) {
            String string9 = ise.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"ise.localizedMessage");
            this.setError(string9);
            return;
        }
        Object result = object;
        Configuration configuration = config;
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"config");
        this.setResult(this.toResultString(configuration, result));
    }

    private final String toResultString(Configuration config, Object result) {
        if (result == null) {
            return "null";
        }
        if (result instanceof String) {
            return "\"" + StringUtil.escapeStringCharacters((String)((String)result)) + "\"";
        }
        if (ClassUtil.isPrimitive(result.getClass())) {
            return result.toString();
        }
        if (result instanceof Collection) {
            return "[" + CollectionsKt.joinToString$default((Iterable)((Iterable)result), (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<Object, CharSequence>(this, config){
                final /* synthetic */ JsonPathEvaluateView this$0;
                final /* synthetic */ Configuration $config;

                @NotNull
                public final CharSequence invoke(@Nullable Object it) {
                    return JsonPathEvaluateView.access$toResultString(this.this$0, this.$config, it);
                }
                {
                    this.this$0 = jsonPathEvaluateView;
                    this.$config = configuration;
                    super(1);
                }
            }), (int)30, null) + "]";
        }
        String string = config.jsonProvider().toJson(result);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor(this.resultEditor);
    }

    private final List<String> getExpressionHistory() {
        Object object = PropertiesComponent.getInstance().getValue("JSONPathEvaluateHistory");
        if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final void setExpressionHistory(Collection<String> history) {
        PropertiesComponent.getInstance().setValue("JSONPathEvaluateHistory", CollectionsKt.joinToString$default((Iterable)history, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
    }

    private final void addJSONPathToHistory(String path) {
        if (StringsKt.isBlank((CharSequence)path)) {
            return;
        }
        ArrayDeque history = new ArrayDeque((Collection)this.getExpressionHistory());
        if (!history.contains((Object)path)) {
            history.addFirst((Object)path);
            if (history.size() > 10) {
                history.removeLast();
            }
            this.setExpressionHistory((Collection)history);
        } else {
            if (Intrinsics.areEqual((Object)((String)history.firstOrNull()), (Object)path)) {
                return;
            }
            history.remove((Object)path);
            history.addFirst((Object)path);
            this.setExpressionHistory((Collection)history);
        }
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    public JsonPathEvaluateView(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(true, true);
        this.project = project;
        this.searchTextField = new EditorTextField(this, this.project, (FileType)JsonPathFileType.INSTANCE){
            final /* synthetic */ JsonPathEvaluateView this$0;

            protected boolean processKeyBinding(@Nullable KeyStroke ks, @Nullable KeyEvent e, int condition, boolean pressed) {
                KeyEvent keyEvent = e;
                if (keyEvent != null) {
                    if (keyEvent.getKeyCode() == 10) {
                        if (pressed) {
                            JsonPathEvaluateView.access$evaluate(this.this$0);
                            return true;
                        }
                    }
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }

            @NotNull
            protected EditorEx createEditor() {
                EditorEx editorEx = super.createEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"super.createEditor()");
                EditorEx editor = editorEx;
                editor.setBorder((Border)JBUI.Borders.empty());
                JComponent jComponent = editor.getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editor.component");
                jComponent.setBorder((Border)JBUI.Borders.empty((int)4, (int)0, (int)3, (int)6));
                JComponent jComponent2 = editor.getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"editor.component");
                jComponent2.setOpaque(false);
                editor.setBackgroundColor(UIUtil.getTextFieldBackground());
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile((Document)editor.getDocument());
                if (psiFile != null) {
                    psiFile.putUserData(JsonPathEvaluateManager.JSON_PATH_EVALUATE_EXPRESSION_KEY, (Object)true);
                    Function0 function0 = (Function0)new Function0<JsonFile>(this.this$0){

                        @Nullable
                        public final JsonFile invoke() {
                            return ((JsonPathEvaluateView)((Object)this.receiver)).getJsonFile();
                        }
                    };
                    psiFile.putUserData(JsonPathEvaluateManager.JSON_PATH_EVALUATE_SOURCE_KEY, (Object)new JsonPathEvaluateView$sam$java_util_function_Supplier$0(function0));
                }
                return editor;
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2);
            }
        };
        this.searchWrapper = (JPanel)new NonOpaquePanel(new BorderLayout()){

            public void updateUI() {
                super.updateUI();
                this.setBackground(UIUtil.getTextFieldBackground());
            }
        };
        this.resultWrapper = new JBPanelWithEmptyText((LayoutManager)new BorderLayout());
        this.resultLabel = new JBLabel(JsonBundle.message("jsonpath.evaluate.result", new Object[0]));
        this.resultEditor = this.initJsonEditor("result.json", true, EditorKind.PREVIEW);
        this.errorOutputArea = new JBTextArea();
        this.errorOutputContainer = (JScrollPane)new JBScrollPane((Component)this.errorOutputArea);
        boolean bl = false;
        this.evalOptions = new LinkedHashSet();
        this.resultEditor.putUserData(JsonPathEvaluateManager.JSON_PATH_EVALUATE_RESULT_KEY, (Object)true);
        this.resultEditor.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)0, (int)0));
        this.resultLabel.setBorder((Border)JBUI.Borders.empty((int)3, (int)6));
        StatusText statusText = this.resultWrapper.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"resultWrapper.emptyText");
        statusText.setText(JsonBundle.message("jsonpath.evaluate.no.result", new Object[0]));
        this.errorOutputContainer.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)0, (int)0));
        SearchHistoryButton historyButton = new SearchHistoryButton((AnAction)new ShowHistoryAction(), false);
        NonOpaquePanel historyButtonWrapper = new NonOpaquePanel((LayoutManager)new BorderLayout());
        historyButtonWrapper.setBorder((Border)JBUI.Borders.empty((int)3, (int)6, (int)3, (int)6));
        historyButtonWrapper.add((Component)((Object)historyButton), (Object)"North");
        this.searchTextField.setFontInheritedFromLAF(false);
        this.searchWrapper.add((Component)historyButtonWrapper, "West");
        this.searchWrapper.add((Component)this.searchTextField, "Center");
        this.searchWrapper.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0));
        this.searchWrapper.setOpaque(true);
        this.errorOutputArea.setEditable(false);
        this.errorOutputArea.setWrapStyleWord(true);
        this.errorOutputArea.setLineWrap(true);
        this.errorOutputArea.setBorder(JBUI.Borders.empty((int)10));
        this.setExpression("$..*");
    }

    public static final /* synthetic */ Editor access$getResultEditor$p(JsonPathEvaluateView $this) {
        return $this.resultEditor;
    }

    public static final /* synthetic */ String access$toResultString(JsonPathEvaluateView $this, Configuration config, Object result) {
        return $this.toResultString(config, result);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jsonpath/ui/JsonPathEvaluateView$OutputOptionAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "enablePaths", "", "message", "", "(Lcom/intellij/jsonpath/ui/JsonPathEvaluateView;ZLjava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.json"})
    private final class OutputOptionAction
    extends DumbAwareAction {
        private final boolean enablePaths;

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.enablePaths) {
                JsonPathEvaluateView.this.evalOptions.add(Option.AS_PATH_LIST);
            } else {
                JsonPathEvaluateView.this.evalOptions.remove(Option.AS_PATH_LIST);
            }
            JsonPathEvaluateView.this.evaluate();
        }

        public OutputOptionAction(@NlsActions.ActionText @NotNull boolean enablePaths, String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
            this.enablePaths = enablePaths;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jsonpath/ui/JsonPathEvaluateView$OptionToggleAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "option", "Lcom/jayway/jsonpath/Option;", "message", "", "(Lcom/intellij/jsonpath/ui/JsonPathEvaluateView;Lcom/jayway/jsonpath/Option;Ljava/lang/String;)V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.json"})
    private final class OptionToggleAction
    extends ToggleAction {
        private final Option option;

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return JsonPathEvaluateView.this.evalOptions.contains(this.option);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (state) {
                JsonPathEvaluateView.this.evalOptions.add(this.option);
            } else {
                JsonPathEvaluateView.this.evalOptions.remove(this.option);
            }
            JsonPathEvaluateView.this.evaluate();
        }

        public OptionToggleAction(@NlsActions.ActionText @NotNull Option option, String message) {
            Intrinsics.checkNotNullParameter((Object)option, (String)"option");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
            this.option = option;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/jsonpath/ui/JsonPathEvaluateView$SearchHistoryButton;", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "focusable", "", "(Lcom/intellij/openapi/actionSystem/AnAction;Z)V", "getDataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getIcon", "Ljavax/swing/Icon;", "getPopState", "", "intellij.json"})
    private static final class SearchHistoryButton
    extends ActionButton {
        @NotNull
        protected DataContext getDataContext() {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"DataManager.getInstance().getDataContext(this)");
            return dataContext;
        }

        public int getPopState() {
            return this.isSelected() ? 2 : super.getPopState();
        }

        @NotNull
        public Icon getIcon() {
            if (this.isEnabled() && this.isSelected()) {
                Presentation presentation = this.myPresentation;
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"myPresentation");
                Icon selectedIcon = presentation.getSelectedIcon();
                if (selectedIcon != null) {
                    return selectedIcon;
                }
            }
            Icon icon = super.getIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"super.getIcon()");
            return icon;
        }

        public SearchHistoryButton(@NotNull AnAction action, boolean focusable) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            super(action, action.getTemplatePresentation().clone(), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            this.setLook(ActionButtonLook.INPLACE_LOOK);
            this.setFocusable(focusable);
            this.updateIcon();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J8\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004H\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jsonpath/ui/JsonPathEvaluateView$ShowHistoryAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/intellij/jsonpath/ui/JsonPathEvaluateView;)V", "popupState", "Lcom/intellij/ui/popup/PopupState;", "Lcom/intellij/openapi/ui/popup/JBPopup;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "showCompletionPopup", "toolbarComponent", "Ljavax/swing/JComponent;", "list", "Ljavax/swing/JList;", "", "textField", "Lcom/intellij/ui/EditorTextField;", "intellij.json"})
    private final class ShowHistoryAction
    extends DumbAwareAction {
        private final PopupState<JBPopup> popupState;

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.popupState.isRecentlyHidden()) {
                return;
            }
            JBList historyList = new JBList((Collection)JsonPathEvaluateView.this.getExpressionHistory());
            this.showCompletionPopup(JsonPathEvaluateView.this.getSearchWrapper(), (JList)historyList, JsonPathEvaluateView.this.getSearchTextField(), this.popupState);
        }

        private final void showCompletionPopup(JComponent toolbarComponent, JList<String> list, EditorTextField textField, PopupState<JBPopup> popupState) {
            PopupChooserBuilder popupChooserBuilder = JBPopupFactory.getInstance().createListPopupBuilder(list);
            Intrinsics.checkNotNullExpressionValue((Object)popupChooserBuilder, (String)"JBPopupFactory.getInstan\u2026ateListPopupBuilder(list)");
            PopupChooserBuilder builder = popupChooserBuilder;
            JBPopup jBPopup = builder.setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(new Runnable(list, textField){
                final /* synthetic */ JList $list;
                final /* synthetic */ EditorTextField $textField;

                public final void run() {
                    String selectedValue = (String)this.$list.getSelectedValue();
                    if (selectedValue != null) {
                        this.$textField.setText(selectedValue);
                        IdeFocusManager.getGlobalInstance().requestFocus((Component)this.$textField, false);
                    }
                }
                {
                    this.$list = jList;
                    this.$textField = editorTextField;
                }
            }).createPopup();
            Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"builder\n        .setMova\u2026})\n        .createPopup()");
            JBPopup popup2 = jBPopup;
            popupState.prepareToShow((Object)popup2);
            if (toolbarComponent != null) {
                popup2.showUnderneathOf((Component)toolbarComponent);
            } else {
                popup2.showUnderneathOf((Component)textField);
            }
        }

        public ShowHistoryAction() {
            super(FindBundle.message((String)"find.search.history", (Object[])new Object[0]), null, AllIcons.Actions.SearchWithHistory);
            PopupState popupState = PopupState.forPopup();
            Intrinsics.checkNotNullExpressionValue((Object)popupState, (String)"PopupState.forPopup()");
            this.popupState = popupState;
            this.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"ShowSearchHistory"), (JComponent)JsonPathEvaluateView.this.getSearchTextField());
        }
    }
}

