/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsonpath;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.impl.JsonRecursiveElementVisitor;
import com.intellij.jsonpath.JsonPathConstants;
import com.intellij.jsonpath.psi.JsonPathBinaryConditionalOperator;
import com.intellij.jsonpath.psi.JsonPathFile;
import com.intellij.jsonpath.psi.JsonPathId;
import com.intellij.jsonpath.psi.JsonPathIdSegment;
import com.intellij.jsonpath.psi.JsonPathObjectValue;
import com.intellij.jsonpath.psi.JsonPathQuotedSegment;
import com.intellij.jsonpath.psi.JsonPathRecursiveElementVisitor;
import com.intellij.jsonpath.psi.JsonPathStringLiteral;
import com.intellij.jsonpath.psi.JsonPathTokenSets;
import com.intellij.jsonpath.psi.JsonPathTypes;
import com.intellij.jsonpath.ui.JsonPathEvaluateManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.util.ProcessingContext;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class JsonPathCompletionContributor
extends CompletionContributor {
    public JsonPathCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(JsonPathStringLiteral.class)).inside((ElementPattern)PlatformPatterns.psiElement().withElementType(JsonPathTypes.QUOTED_PATHS_LIST)), new JsonKeysCompletionProvider(false));
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withElementType(JsonPathTokenSets.JSONPATH_DOT_NAVIGATION_SET)), new JsonKeysCompletionProvider(true));
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withElementType(JsonPathTokenSets.JSONPATH_DOT_NAVIGATION_SET)), new FunctionNamesCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(JsonPathBinaryConditionalOperator.class), new OperatorCompletionProvider());
        KeywordsCompletionProvider keywordsCompletionProvider = new KeywordsCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(JsonPathObjectValue.class)).afterLeaf((ElementPattern)PlatformPatterns.psiElement().withElementType(JsonPathTypes.COLON)), keywordsCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withElementType(JsonPathTokenSets.JSONPATH_EQUALITY_OPERATOR_SET))).andNot((ElementPattern)PlatformPatterns.psiElement().withParent(JsonPathStringLiteral.class)), keywordsCompletionProvider);
    }

    private static class JsonKeysCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private final boolean validIdentifiersOnly;
        private static final Pattern VALID_IDENTIFIER_PATTERN = Pattern.compile("[\\w_][\\w_0-9]*", 256);

        private JsonKeysCompletionProvider(boolean validIdentifiersOnly) {
            this.validIdentifiersOnly = validIdentifiersOnly;
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, final @NotNull CompletionResultSet result) {
            Supplier targetFileGetter;
            PsiFile hostFile;
            PsiFile file;
            InjectedLanguageManager injectedLanguageManager;
            PsiLanguageInjectionHost injectionHost;
            if (parameters == null) {
                JsonKeysCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                JsonKeysCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                JsonKeysCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((injectionHost = (injectedLanguageManager = InjectedLanguageManager.getInstance((Project)(file = parameters.getOriginalFile()).getProject())).getInjectionHost((PsiElement)file)) != null && (hostFile = injectionHost.getContainingFile()) != null) {
                this.visitJsonPathLiteralsInFile(injectedLanguageManager, hostFile, propertyName -> this.addCompletionElement(result, (String)propertyName));
            }
            if ((targetFileGetter = (Supplier)file.getUserData(JsonPathEvaluateManager.JSON_PATH_EVALUATE_SOURCE_KEY)) != null) {
                JsonFile targetFile = (JsonFile)targetFileGetter.get();
                targetFile.accept(new JsonRecursiveElementVisitor(){

                    @Override
                    public void visitProperty(@NotNull JsonProperty o) {
                        if (o == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        super.visitProperty(o);
                        String propertyName = o.getName();
                        if (!propertyName.isBlank()) {
                            this.addCompletionElement(result, propertyName);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jsonpath/JsonPathCompletionContributor$JsonKeysCompletionProvider$1", "visitProperty"));
                    }
                });
            }
        }

        private void addCompletionElement(@NotNull CompletionResultSet result, String propertyName) {
            if (result == null) {
                JsonKeysCompletionProvider.$$$reportNull$$$0(3);
            }
            if (!this.validIdentifiersOnly || VALID_IDENTIFIER_PATTERN.matcher(propertyName).matches()) {
                result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)propertyName).withIcon(AllIcons.Nodes.Field).withTypeText(JsonBundle.message("jsonpath.completion.key", new Object[0])), (double)100.0));
            }
        }

        private void visitJsonPathLiteralsInFile(final InjectedLanguageManager injectedLanguageManager, PsiFile hostFile, final Consumer<String> pathNameConsumer) {
            hostFile.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    super.visitElement(element);
                    if (element instanceof PsiLanguageInjectionHost) {
                        List files = injectedLanguageManager.getInjectedPsiFiles(element);
                        if (files == null) {
                            return;
                        }
                        for (Pair rangePair : files) {
                            if (!(rangePair.getFirst() instanceof JsonPathFile)) continue;
                            JsonPathFile jsonPathFile = (JsonPathFile)((Object)rangePair.getFirst());
                            LiteralTextEscaper escaper = ((PsiLanguageInjectionHost)element).createLiteralTextEscaper();
                            this.visitJsonPathLiterals(jsonPathFile, (TextRange)rangePair.getSecond(), (LiteralTextEscaper<? extends PsiLanguageInjectionHost>)escaper);
                        }
                    }
                }

                private void visitJsonPathLiterals(JsonPathFile jsonPathFile, final TextRange fileRange, final LiteralTextEscaper<? extends PsiLanguageInjectionHost> escaper) {
                    jsonPathFile.accept(new JsonPathRecursiveElementVisitor(){

                        @Override
                        public void visitIdSegment(@NotNull JsonPathIdSegment o) {
                            if (o == null) {
                                JsonKeysCompletionProvider.1.$$$reportNull$$$0(0);
                            }
                            super.visitIdSegment(o);
                            JsonPathId id = o.getId();
                            if (!id.getTextRange().isEmpty()) {
                                StringBuilder decodeBuilder = new StringBuilder();
                                TextRange idTextRange = id.getTextRange().shiftRight(fileRange.getStartOffset());
                                if (escaper.decode(idTextRange, decodeBuilder)) {
                                    pathNameConsumer.accept(decodeBuilder.toString());
                                }
                            }
                        }

                        @Override
                        public void visitQuotedSegment(@NotNull JsonPathQuotedSegment o) {
                            if (o == null) {
                                JsonKeysCompletionProvider.1.$$$reportNull$$$0(1);
                            }
                            super.visitQuotedSegment(o);
                            for (JsonPathStringLiteral stringLiteral : o.getQuotedPathsList().getStringLiteralList()) {
                                TextRange literalTextRange = stringLiteral.getTextRange().shiftRight(fileRange.getStartOffset());
                                StringBuilder decodeBuilder = new StringBuilder();
                                for (Pair<TextRange, String> fragment : stringLiteral.getTextFragments()) {
                                    if (((TextRange)fragment.getFirst()).isEmpty()) continue;
                                    escaper.decode(((TextRange)fragment.getFirst()).shiftRight(literalTextRange.getStartOffset()), decodeBuilder);
                                }
                                if (decodeBuilder.length() <= 0) continue;
                                pathNameConsumer.accept(decodeBuilder.toString());
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            objectArray2[0] = "o";
                            objectArray2[1] = "com/intellij/jsonpath/JsonPathCompletionContributor$JsonKeysCompletionProvider$2$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "visitIdSegment";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "visitQuotedSegment";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsonpath/JsonPathCompletionContributor$JsonKeysCompletionProvider$2", "visitElement"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/jsonpath/JsonPathCompletionContributor$JsonKeysCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletionElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class OperatorCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private OperatorCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                OperatorCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                OperatorCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                OperatorCompletionProvider.$$$reportNull$$$0(2);
            }
            for (String keyword : JsonPathConstants.STANDARD_NAMED_OPERATORS) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)keyword).bold());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jsonpath/JsonPathCompletionContributor$OperatorCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class KeywordsCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private static final String[] KEYWORDS = new String[]{"null", "true", "false"};

        private KeywordsCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                KeywordsCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                KeywordsCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                KeywordsCompletionProvider.$$$reportNull$$$0(2);
            }
            for (String keyword : KEYWORDS) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)keyword).bold());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jsonpath/JsonPathCompletionContributor$KeywordsCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FunctionNamesCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private FunctionNamesCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                FunctionNamesCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                FunctionNamesCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                FunctionNamesCompletionProvider.$$$reportNull$$$0(2);
            }
            result.addElement((LookupElement)LookupElementBuilder.create((String)"*").bold());
            for (Map.Entry<String, String> function : JsonPathConstants.STANDARD_FUNCTIONS.entrySet()) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)(function.getKey() + "()")).withPresentableText(function.getKey()).withIcon(AllIcons.Nodes.Method).withTailText("()").withTypeText(function.getValue()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jsonpath/JsonPathCompletionContributor$FunctionNamesCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

