/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.workshop.generation;

import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.lang.javascript.boilerplate.GithubDownloadUtil;
import com.intellij.lang.javascript.boilerplate.GithubProjectGeneratorPeer;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.platform.templates.github.GeneratorException;
import com.intellij.platform.templates.github.ZipUtil;
import com.jetbrains.php.workshop.PhpStormWorkshopBundle;
import com.jetbrains.php.workshop.generation.PhpStormWorkshopPeer;
import com.jetbrains.php.workshop.generation.PhpStormWorkshopService;
import com.jetbrains.php.workshop.generation.PhpStormWorkshopType;
import icons.PhpWorkshopIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpStormWorkshopGenerator
extends WebProjectTemplate<PhpStormWorkshopType> {
    private static final Logger LOG = Logger.getInstance(PhpStormWorkshopGenerator.class);

    @Nls
    @NotNull
    public String getName() {
        String string = PhpStormWorkshopBundle.message("workshop.project.generator", new Object[0]);
        if (string == null) {
            PhpStormWorkshopGenerator.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String getDescription() {
        return PhpStormWorkshopBundle.message("phpstorm.examples", new Object[0]);
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull PhpStormWorkshopType settings, @NotNull Module module) {
        if (project == null) {
            PhpStormWorkshopGenerator.$$$reportNull$$$0(1);
        }
        if (baseDir == null) {
            PhpStormWorkshopGenerator.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            PhpStormWorkshopGenerator.$$$reportNull$$$0(3);
        }
        if (module == null) {
            PhpStormWorkshopGenerator.$$$reportNull$$$0(4);
        }
        File zipArchiveFile = null;
        try {
            String ghBranch = settings.getBranch();
            String githubUserName = this.getGithubUserName();
            String githubRepositoryName = this.getGithubRepositoryName();
            zipArchiveFile = GithubDownloadUtil.findCacheFile((String)githubUserName, (String)githubRepositoryName, (String)("workshop-" + ghBranch + githubRepositoryName + ".zip"));
            String url = GithubProjectGeneratorPeer.getGithubZipballUrl((String)githubUserName, (String)githubRepositoryName, (String)ghBranch);
            GithubDownloadUtil.downloadContentToFileWithProgressSynchronously((Project)project, (String)GithubProjectGeneratorPeer.getGithubZipballUrl((String)githubUserName, (String)githubRepositoryName, (String)ghBranch), (String)this.getName(), (File)zipArchiveFile, (String)githubUserName, (String)githubRepositoryName, (boolean)false);
            LOG.info("Content of " + url + " has been successfully downloaded to " + zipArchiveFile.getAbsolutePath() + ", size " + zipArchiveFile.length() + " bytes");
            File virtualToIoFile = VfsUtilCore.virtualToIoFile((VirtualFile)baseDir);
            File tempDirectory = FileUtil.createTempDirectory((String)("workshop" + ghBranch), (String)"tmp");
            ZipUtil.unzipWithProgressSynchronously((Project)project, (String)this.getName(), (File)zipArchiveFile, (File)tempDirectory, null, (boolean)true);
            PhpStormWorkshopGenerator.removeFiles(tempDirectory);
            File[] children = tempDirectory.listFiles();
            if (children == null || children.length < 1) {
                throw new GeneratorException(PhpStormWorkshopBundle.message("dialog.message.boilerplates.are.downloaded", new Object[0]));
            }
            for (File it : children) {
                FileUtil.copyFileOrDir((File)it, (File)new File(virtualToIoFile, it.getName()));
            }
            FileUtil.delete((File)tempDirectory);
            ApplicationManager.getApplication().runWriteAction(() -> baseDir.refresh(true, true));
            PhpStormWorkshopService.getInstance(project).setEnabled(true);
        }
        catch (Exception e) {
            Messages.showErrorDialog((Project)project, (String)PhpStormWorkshopBundle.message("workshop.error.creating.workshop.project.0", e.getMessage()), (String)PhpStormWorkshopBundle.message("workshop.create.workshop.project", new Object[0]));
            if (zipArchiveFile != null) {
                FileUtil.delete((File)zipArchiveFile);
            }
            LOG.warn((Throwable)e);
            PhpStormWorkshopGenerator.showErrorMessage(e.getMessage());
        }
    }

    private static void removeFiles(File directory) {
        File[] listFiles = directory.listFiles();
        if (listFiles != null) {
            for (File it : listFiles) {
                if (!it.getName().equals(".gitattributes") && !it.getName().equals(".gitignore")) continue;
                FileUtil.delete((File)it);
            }
        }
    }

    private static void showErrorMessage(@NotNull String message) {
        if (message == null) {
            PhpStormWorkshopGenerator.$$$reportNull$$$0(5);
        }
        String fullMessage = PhpStormWorkshopBundle.message("notification.content.error.creating.phpstorm.workshop.project", message);
        Notifications.Bus.notify((Notification)new Notification(NotificationGroup.createIdWithTitle((String)"PhpStorm Workshop Project", (String)PhpStormWorkshopBundle.message("workshop.project.generator", new Object[0])), PhpStormWorkshopBundle.message("workshop.project.generator", new Object[0]), fullMessage, NotificationType.ERROR));
    }

    @NotNull
    public ProjectGeneratorPeer<PhpStormWorkshopType> createPeer() {
        return new PhpStormWorkshopPeer();
    }

    @NotNull
    public String getGithubRepositoryName() {
        return "phpstorm-workshop";
    }

    @NotNull
    public String getGithubUserName() {
        return "JetBrains";
    }

    public Icon getIcon() {
        return PhpWorkshopIcons.PhpStromWorkshopProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/workshop/generation/PhpStormWorkshopGenerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/workshop/generation/PhpStormWorkshopGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showErrorMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

