/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.mergetags;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.sixrr.xrp.intention.PsiElementPredicate;
import com.sixrr.xrp.utils.XMLRefactoringUtil;

class MergeTagsPredicate
implements PsiElementPredicate {
    MergeTagsPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof XmlTag) || element.getContainingFile().getViewProvider() instanceof TemplateLanguageFileViewProvider) {
            return false;
        }
        XmlTag tag = (XmlTag)element;
        PsiElement nextTag = PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class, XmlText.class});
        if (!(nextTag instanceof XmlTag)) {
            return false;
        }
        return MergeTagsPredicate.tagsCanBeMerged(tag, (XmlTag)nextTag);
    }

    private static boolean tagsCanBeMerged(XmlTag tag, XmlTag nextTag) {
        XmlAttribute[] nextAttributes;
        String nextTagPrefix;
        String nextTagName;
        String tagName = tag.getName();
        if (!MergeTagsPredicate.safeEquals(tagName, nextTagName = nextTag.getName())) {
            return false;
        }
        String tagPrefix = tag.getNamespacePrefix();
        if (!MergeTagsPredicate.safeEquals(tagPrefix, nextTagPrefix = nextTag.getNamespacePrefix())) {
            return false;
        }
        XmlAttribute[] attributes = tag.getAttributes();
        if (attributes.length != (nextAttributes = nextTag.getAttributes()).length) {
            return false;
        }
        for (XmlAttribute xmlAttribute : attributes) {
            String nextAttributeValue;
            String attributeName = xmlAttribute.getName();
            String attributeNameSpace = xmlAttribute.getNamespace();
            String attributeValue = xmlAttribute.getValue();
            if (MergeTagsPredicate.safeEquals(attributeValue, nextAttributeValue = nextTag.getAttributeValue(attributeName, attributeNameSpace))) continue;
            return false;
        }
        return !XMLRefactoringUtil.containsOuterElements((PsiElement)tag) && !XMLRefactoringUtil.containsOuterElements((PsiElement)nextTag);
    }

    private static boolean safeEquals(String tagName, String nextTagName) {
        if (tagName == null) {
            return nextTagName == null;
        }
        return tagName.equals(nextTagName);
    }
}

