/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.base;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ArrayUtil;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.ui.ScopePanel;
import com.sixrr.xrp.ui.ScopePanelListener;
import com.sixrr.xrp.ui.XSLTDialog;
import com.sixrr.xrp.utils.RefactorXBundle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public abstract class BaseRefactoringDialog
extends DialogWrapper
implements ScopePanelListener {
    private final Action refactorAction = new RefactorAction();
    private final Action previewAction = new PreviewAction();
    private final Action showXLTAction = new ShowXSLTAction();
    private boolean previewResults = false;
    protected ScopePanel scopePanel;
    protected final ValidationDocListener docListener = new ValidationDocListener();
    private final Project project;

    public BaseRefactoringDialog(Project project, boolean b) {
        super(project, b);
        this.project = project;
        this.setModal(true);
    }

    public boolean isPreviewUsages() {
        return this.previewResults;
    }

    protected void doOKAction() {
        this.validateButtons();
        if (!this.isOKActionEnabled()) {
            return;
        }
        this.close(0);
    }

    protected void validateButtons() {
        boolean isValid = this.isValid();
        this.previewAction.setEnabled(isValid);
        this.refactorAction.setEnabled(isValid);
        this.showXLTAction.setEnabled(isValid);
    }

    protected Action @NotNull [] createActions() {
        Object[] actions = new Action[]{this.refactorAction, this.previewAction, this.showXLTAction, this.getCancelAction(), this.getHelpAction()};
        if (SystemInfo.isMac) {
            actions = (Action[])ArrayUtil.reverseArray((Object[])actions);
        }
        if (actions == null) {
            BaseRefactoringDialog.$$$reportNull$$$0(0);
        }
        return actions;
    }

    @Override
    public void scopeSelectionHasChanged() {
        this.validateButtons();
    }

    public Context getContext() {
        return this.scopePanel.getContext();
    }

    protected JComponent createCenterPanel() {
        return this.scopePanel;
    }

    protected abstract boolean isValid();

    protected abstract String getDimensionServiceKey();

    @NotNull
    protected abstract String getHelpId();

    public abstract JComponent getPreferredFocusedComponent();

    protected abstract String calculateXSLT();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/base/BaseRefactoringDialog", "createActions"));
    }

    protected class ValidationDocListener
    implements DocumentListener {
        protected ValidationDocListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            BaseRefactoringDialog.this.validateButtons();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            BaseRefactoringDialog.this.validateButtons();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            BaseRefactoringDialog.this.validateButtons();
        }
    }

    private class ShowXSLTAction
    extends AbstractAction {
        ShowXSLTAction() {
            this.putValue("Name", RefactorXBundle.message("show.xslt", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BaseRefactoringDialog.this.validateButtons();
            if (!BaseRefactoringDialog.this.isOKActionEnabled()) {
                return;
            }
            @NlsSafe String xslt = BaseRefactoringDialog.this.calculateXSLT();
            XSLTDialog dialog = new XSLTDialog(BaseRefactoringDialog.this.project, xslt);
            dialog.show();
        }
    }

    private class PreviewAction
    extends AbstractAction {
        PreviewAction() {
            this.putValue("Name", RefactorXBundle.message("preview", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BaseRefactoringDialog.this.validateButtons();
            if (!BaseRefactoringDialog.this.isOKActionEnabled()) {
                return;
            }
            BaseRefactoringDialog.this.previewResults = true;
            BaseRefactoringDialog.this.close(0);
        }
    }

    protected class RefactorAction
    extends AbstractAction {
        RefactorAction() {
            this.putValue("Name", RefactorXBundle.message("refactor", new Object[0]));
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BaseRefactoringDialog.this.validateButtons();
            if (!BaseRefactoringDialog.this.isOKActionEnabled()) {
                return;
            }
            BaseRefactoringDialog.this.previewResults = false;
            BaseRefactoringDialog.this.close(0);
        }
    }
}

