/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.settings;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.frameworks.PhpFrameworkConfigurable;
import com.jetbrains.php.wordpress.WPBundle;
import com.jetbrains.php.wordpress.settings.WPDataService;
import com.jetbrains.php.wordpress.settings.WPSettingsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WPConfigurable
implements PhpFrameworkConfigurable {
    protected JBCheckBox myEnabledCheckBox;
    private JPanel myWPSettingsPlaceholder;
    private JPanel myMainPanel;
    private final WPDataService myService;
    protected final WPSettingsPanel mySettingsForm;

    public WPConfigurable(Project project) {
        this.$$$setupUI$$$();
        this.myService = WPDataService.getInstance(project);
        this.mySettingsForm = new WPSettingsPanel(project, true);
        this.myWPSettingsPlaceholder.add((Component)this.mySettingsForm.createMainPanel(), "Center");
        this.myEnabledCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WPConfigurable.this.updateSettingsPanelEnabled();
            }
        });
        this.updateSettingsPanelEnabled();
    }

    protected void updateSettingsPanelEnabled() {
        boolean selected = this.myEnabledCheckBox.isSelected();
        UIUtil.setEnabled((Component)this.mySettingsForm.createMainPanel(), (boolean)selected, (boolean)true);
        this.mySettingsForm.setEnabled(selected);
    }

    @Nls
    public String getDisplayName() {
        return WPBundle.message("wp.title", new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settings.php.wordpress";
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        if (this.myService.isEnabled() != this.myEnabledCheckBox.isSelected()) {
            return true;
        }
        return this.mySettingsForm.isModified(this.myService);
    }

    public void apply() throws ConfigurationException {
        WPDataService.State state = new WPDataService.State();
        state.setEnabled(this.myEnabledCheckBox.isSelected());
        this.mySettingsForm.apply(state);
        this.myService.setState(state);
    }

    public void reset() {
        this.myEnabledCheckBox.setSelected(this.myService.isEnabled());
        this.mySettingsForm.reset(this.myService);
        this.updateSettingsPanelEnabled();
    }

    @NotNull
    public String getId() {
        return "php.wordpress.base.configurable";
    }

    public boolean isBeingUsed() {
        return this.myEnabledCheckBox.isSelected();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myEnabledCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/WordPressBundle", WPConfigurable.class).getString("wp.configurable.enable.w.p.integration"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myWPSettingsPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 1));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

