/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.hooks;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.wordpress.hooks.WPHook;
import com.jetbrains.php.wordpress.hooks.WPHookName;
import com.jetbrains.php.wordpress.hooks.WPHookNamePart;
import com.jetbrains.php.wordpress.hooks.WPHookType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WPHookUtils {
    private static final Logger LOG = Logger.getInstance(WPHookUtils.class);

    private WPHookUtils() {
    }

    public static PsiElementPattern.Capture<PsiElement> getHookMethodParameterListCapture(String[] methodNames) {
        PsiElementPattern.Capture functionCallCapture = (PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)PhpElementTypes.FUNCTION_CALL).with((PatternCondition)new PsiNamePatternCondition<PsiElement>("withFunctionCallName", (ElementPattern)StandardPatterns.string().oneOf(methodNames)){

            public String getPropertyValue(@NotNull Object o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                return o instanceof FunctionReference ? ((FunctionReference)o).getName() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/php/wordpress/hooks/WPHookUtils$1", "getPropertyValue"));
            }
        });
        return (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(PhpElementTypes.PARAMETER_LIST)).withParent((ElementPattern)functionCallCapture);
    }

    @Nullable
    public static WPHook getPotentialHookFromRegistration(PsiElement psiElement, boolean stringLiteralOnly) {
        if (!(psiElement instanceof FunctionReference)) {
            return null;
        }
        if (psiElement instanceof MethodReference) {
            return null;
        }
        FunctionReference reference = (FunctionReference)psiElement;
        String functionName = reference.getName();
        WPHookType type = WPHookType.findByRegistrationMethod(functionName);
        if (type == null) {
            return null;
        }
        WPHookName hookName = WPHookUtils.getHookNameFromRegistration(reference, stringLiteralOnly);
        if (hookName == null) {
            return null;
        }
        return new WPHook(hookName, type);
    }

    @Nullable
    public static WPHook getPotentialHookFromInvocation(PsiElement psiElement, boolean stringLiteralOnly) {
        if (!(psiElement instanceof FunctionReference)) {
            return null;
        }
        if (psiElement instanceof MethodReference) {
            return null;
        }
        FunctionReference reference = (FunctionReference)psiElement;
        String functionName = reference.getName();
        WPHookType type = WPHookType.findByInvocationMethod(functionName);
        if (type == null) {
            return null;
        }
        WPHookName hookName = WPHookUtils.getHookNameFromInvocation(reference, stringLiteralOnly);
        if (hookName == null) {
            return null;
        }
        return new WPHook(hookName, type);
    }

    @Nullable
    private static WPHookName getHookNameFromRegistration(FunctionReference reference, boolean stringLiteralOnly) {
        return WPHookUtils.getHookNameFromFirstParameter(reference, stringLiteralOnly);
    }

    @Nullable
    public static WPHookName getHookNameFromInvocation(FunctionReference reference, boolean stringLiteralOnly) {
        return WPHookUtils.getHookNameFromFirstParameter(reference, stringLiteralOnly);
    }

    @Nullable
    private static WPHookName getHookNameFromFirstParameter(FunctionReference reference, boolean stringLiteralOnly) {
        PsiElement parameter = reference.getParameter(0);
        if (parameter == null) {
            return null;
        }
        List<WPHookNamePart> s = WPHookUtils.parseHookElement(parameter, 0, stringLiteralOnly);
        if (s == null) {
            if (!stringLiteralOnly) {
                LOG.debug("Found no hook description in " + parameter.getText());
            }
            return null;
        }
        WPHookName name = new WPHookName(s);
        if (stringLiteralOnly && !name.isPureString()) {
            return null;
        }
        return name;
    }

    @Nullable
    private static List<WPHookNamePart> parseHookElement(@Nullable PsiElement element, int level, boolean stringLiteralOnly) {
        if (element == null) {
            return null;
        }
        if (element instanceof StringLiteralExpression) {
            if (element.getChildren().length == 0) {
                String text = ((StringLiteralExpression)element).getContents();
                if (text.contains("\n")) {
                    return null;
                }
                return Collections.singletonList(new WPHookNamePart(text, true));
            }
            if (!stringLiteralOnly) {
                ASTNode node = element.getNode();
                ASTNode[] nodes = node.getChildren(null);
                ArrayList<WPHookNamePart> result = new ArrayList<WPHookNamePart>(nodes.length);
                List<IElementType> ignoredTypes = Arrays.asList(PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE, PhpTokenTypes.DOLLAR_LBRACE, PhpTokenTypes.chLDOUBLE_QUOTE, PhpTokenTypes.chRDOUBLE_QUOTE);
                for (ASTNode astNode : nodes) {
                    WPHookNamePart part;
                    IElementType type = astNode.getElementType();
                    if (astNode instanceof CompositeElement) {
                        part = new WPHookNamePart(astNode.getText(), false);
                    } else if (type == PhpTokenTypes.STRING_LITERAL) {
                        part = new WPHookNamePart(astNode.getText(), true);
                    } else {
                        if (ignoredTypes.contains(type)) continue;
                        throw new IllegalStateException("Unexpected type " + type);
                    }
                    result.add(part);
                }
                return result;
            }
        }
        if (element instanceof BinaryExpression && element.getNode().getElementType() == PhpElementTypes.CONCATENATION_EXPRESSION) {
            IElementType operation = ((BinaryExpression)element).getOperationType();
            if (operation != PhpTokenTypes.opCONCAT) {
                return null;
            }
            List<WPHookNamePart> left = WPHookUtils.parseHookElement(((BinaryExpression)element).getLeftOperand(), level + 1, stringLiteralOnly);
            if (left == null) {
                return null;
            }
            List<WPHookNamePart> right = WPHookUtils.parseHookElement(((BinaryExpression)element).getRightOperand(), level + 1, stringLiteralOnly);
            if (right != null) {
                ArrayList<WPHookNamePart> result = new ArrayList<WPHookNamePart>(left.size() + right.size());
                result.addAll(left);
                result.addAll(right);
                return result;
            }
        }
        if (level > 0 && !stringLiteralOnly && element.getNode() instanceof CompositeElement) {
            return Collections.singletonList(new WPHookNamePart(element.getText(), false));
        }
        return null;
    }

    @NotNull
    static String createStarredPresentation(WPHookName name) {
        String pureStringText = name.getPureStringText();
        if (pureStringText != null) {
            String string = pureStringText;
            if (string == null) {
                WPHookUtils.$$$reportNull$$$0(0);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder();
        for (WPHookNamePart part : name.getParts()) {
            if (part.isStringValue()) {
                sb.append(part.getText());
                continue;
            }
            sb.append("***");
        }
        String string = sb.toString();
        if (string == null) {
            WPHookUtils.$$$reportNull$$$0(1);
        }
        return string;
    }

    static String createDescriptivePresentation(WPHookName name) {
        String pureStringText = name.getPureStringText();
        if (pureStringText != null) {
            return pureStringText;
        }
        StringBuilder sb = new StringBuilder();
        for (WPHookNamePart part : name.getParts()) {
            if (part.isStringValue()) {
                sb.append(part.getText());
                continue;
            }
            sb.append('{').append(part.getText()).append('}');
        }
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/wordpress/hooks/WPHookUtils", "createStarredPresentation"));
    }
}

