/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.hooks;

import com.intellij.codeInsight.daemon.DefaultGutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.wordpress.WPBundle;
import com.jetbrains.php.wordpress.hooks.WPHook;
import com.jetbrains.php.wordpress.hooks.WPHookName;
import com.jetbrains.php.wordpress.hooks.WPHookType;
import com.jetbrains.php.wordpress.hooks.WPHookUtils;
import com.jetbrains.php.wordpress.hooks.WPHooksIndex;
import com.jetbrains.php.wordpress.settings.WPDataService;
import icons.WordPressIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WPHookRegistrationLineMarkerProvider
implements LineMarkerProvider {
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            WPHookRegistrationLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            WPHookRegistrationLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            WPHookRegistrationLineMarkerProvider.$$$reportNull$$$0(2);
        }
        for (PsiElement psiElement : elements) {
            WPHookRegistrationLineMarkerProvider.handlePotentialHook(psiElement, result);
        }
    }

    private static void handlePotentialHook(PsiElement element, Collection<? super LineMarkerInfo<?>> result) {
        PsiElement nameElement;
        WPHook hook = WPHookUtils.getPotentialHookFromRegistration(element, true);
        if (hook == null) {
            return;
        }
        WPDataService dataService = WPDataService.getInstance(element.getProject());
        if (!dataService.isEnabled()) {
            return;
        }
        Collection filesWithKeys = FileBasedIndex.getInstance().getContainingFiles(WPHooksIndex.KEY, (Object)hook, GlobalSearchScope.allScope((Project)element.getProject()));
        if (filesWithKeys.isEmpty()) {
            return;
        }
        MyHooksInvocationCollector visitor = new MyHooksInvocationCollector(hook);
        for (VirtualFile vFile : filesWithKeys) {
            PsiFile file = element.getManager().findFile(vFile);
            if (file == null) continue;
            file.accept((PsiElementVisitor)visitor);
        }
        if (visitor.myInvocations.isEmpty()) {
            return;
        }
        String title = WPBundle.message("wp.choose.invocation.of.hook.0", hook);
        FunctionReference reference = (FunctionReference)element;
        ASTNode nameNode = reference.getNameNode();
        PsiElement psiElement = nameElement = nameNode == null ? null : nameNode.getPsi();
        if (nameElement != null) {
            result.add(new LineMarkerInfo(nameElement, new TextRange(element.getTextOffset(), element.getTextOffset()), WordPressIcons.ImplementingHook, (Function)new OverriddenHookTooltipGenerator(visitor.myInvocations), (GutterIconNavigationHandler)new DefaultGutterIconNavigationHandler(visitor.myInvocations, title), GutterIconRenderer.Alignment.LEFT));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/wordpress/hooks/WPHookRegistrationLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class OverriddenHookTooltipGenerator
    implements Function<PsiElement, String> {
        private final List<? extends FunctionReference> myInvocations;

        private OverriddenHookTooltipGenerator(List<? extends FunctionReference> invocations) {
            this.myInvocations = invocations;
        }

        public String fun(PsiElement __) {
            if (this.myInvocations.size() > 6) {
                return WPBundle.message("wp.has.invocations", new Object[0]);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(WPBundle.message("wp.is.invoked.in", new Object[0])).append("<br/>");
            HashSet<String> fileNames = new HashSet<String>();
            boolean hasRealInvocations = false;
            for (FunctionReference functionReference : this.myInvocations) {
                PsiFile file = functionReference.getContainingFile();
                if (file == null) continue;
                String fileName = file.getName();
                if (!fileNames.contains(fileName)) {
                    sb.append(" '").append(fileName).append("'").append("<br/>");
                    fileNames.add(fileName);
                }
                hasRealInvocations = true;
            }
            return hasRealInvocations ? sb.toString() : WPBundle.message("wp.has.invocations", new Object[0]);
        }
    }

    private static final class MyHooksInvocationCollector
    extends PhpRecursiveElementVisitor {
        private final List<FunctionReference> myInvocations = new ArrayList<FunctionReference>();
        private final WPHook myHookName;

        private MyHooksInvocationCollector(WPHook hookName) {
            this.myHookName = hookName;
        }

        public void visitPhpFunctionCall(FunctionReference reference) {
            super.visitPhpFunctionCall(reference);
            String name = reference.getName();
            WPHookType type = WPHookType.findByInvocationMethod(name);
            if (type == null) {
                return;
            }
            WPHookName currentParameter = WPHookUtils.getHookNameFromInvocation(reference, false);
            if (this.myHookName.equals(currentParameter, type)) {
                this.myInvocations.add(reference);
            }
        }
    }
}

