/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.hooks;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpCallbackFunctionUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.wordpress.hooks.WPHookFunctionReference;
import com.jetbrains.php.wordpress.hooks.WPHookType;
import com.jetbrains.php.wordpress.hooks.WPHookUtils;
import com.jetbrains.php.wordpress.settings.WPDataService;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WPHookCallbackReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            WPHookCallbackReferenceContributor.$$$reportNull$$$0(0);
        }
        PsiElementPattern.Capture<PsiElement> parameterListCapture = WPHookUtils.getHookMethodParameterListCapture(WPHookType.getRegistrationMethodNames());
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement().withParent(parameterListCapture), (PsiReferenceProvider)new SimpleHookReferenceProvider());
        PsiElementPattern.Capture arrayCreationCapture = (PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)PhpElementTypes.ARRAY_CREATION_EXPRESSION).withParent(parameterListCapture);
        PsiElementPattern.Capture arrayValueCapture = (PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)PhpElementTypes.STRING).withParent((ElementPattern)PlatformPatterns.psiElement((IElementType)PhpElementTypes.ARRAY_VALUE).withParent((ElementPattern)arrayCreationCapture));
        registrar.registerReferenceProvider((ElementPattern)arrayValueCapture, (PsiReferenceProvider)new CompositeHookReferenceProvider());
    }

    private static boolean isSecondParameter(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            WPHookCallbackReferenceContributor.$$$reportNull$$$0(1);
        }
        if (!((parent = element.getParent()) instanceof ParameterList)) {
            return false;
        }
        return element.equals(((ParameterList)parent).getParameter(1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/wordpress/hooks/WPHookCallbackReferenceContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSecondParameter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CompositeHookReferenceProvider
    extends PsiReferenceProvider {
        private CompositeHookReferenceProvider() {
        }

        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            PsiElement elementOfArray;
            WPDataService service;
            if (element == null) {
                CompositeHookReferenceProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                CompositeHookReferenceProvider.$$$reportNull$$$0(1);
            }
            if (!(service = WPDataService.getInstance(element.getProject())).isEnabled()) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    CompositeHookReferenceProvider.$$$reportNull$$$0(2);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            if (!(element instanceof StringLiteralExpression)) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    CompositeHookReferenceProvider.$$$reportNull$$$0(3);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            StringLiteralExpression literal = (StringLiteralExpression)element;
            PsiElement arrayCreationElement = element.getParent().getParent();
            if (!(arrayCreationElement instanceof ArrayCreationExpression) || !WPHookCallbackReferenceContributor.isSecondParameter(arrayCreationElement)) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    CompositeHookReferenceProvider.$$$reportNull$$$0(4);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            ArrayCreationExpression arrayCreation = (ArrayCreationExpression)arrayCreationElement;
            PsiElement firstArrayElement = null;
            PsiElement secondArrayElement = null;
            for (PsiElement child : arrayCreation.getChildren()) {
                IElementType childType = child.getNode().getElementType();
                if (PhpElementTypes.ARRAY_VALUE != childType) continue;
                if (firstArrayElement == null) {
                    firstArrayElement = child;
                    continue;
                }
                secondArrayElement = child;
                break;
            }
            if ((elementOfArray = element.getParent()).equals(firstArrayElement)) {
                return CompositeHookReferenceProvider.resolveClasses(literal);
            }
            if (elementOfArray.equals(secondArrayElement)) {
                String methodName = literal.getContents();
                PsiElement[] firstElementChildren = firstArrayElement.getChildren();
                if (firstElementChildren.length != 1) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        CompositeHookReferenceProvider.$$$reportNull$$$0(5);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiElement classOrInstance = firstElementChildren[0];
                PsiReference[] resolveStaticMethod = CompositeHookReferenceProvider.resolveStaticMethod(classOrInstance, methodName, literal);
                if (resolveStaticMethod != null) {
                    if (resolveStaticMethod == null) {
                        CompositeHookReferenceProvider.$$$reportNull$$$0(6);
                    }
                    return resolveStaticMethod;
                }
                PsiReference[] resolveInstanceMethod = CompositeHookReferenceProvider.resolveInstanceMethod(classOrInstance, methodName, literal);
                if (resolveInstanceMethod != null) {
                    if (resolveInstanceMethod == null) {
                        CompositeHookReferenceProvider.$$$reportNull$$$0(7);
                    }
                    return resolveInstanceMethod;
                }
            }
            if (PsiReference.EMPTY_ARRAY == null) {
                CompositeHookReferenceProvider.$$$reportNull$$$0(8);
            }
            return PsiReference.EMPTY_ARRAY;
        }

        private static PsiReference @NotNull [] resolveClasses(StringLiteralExpression element) {
            String className = PhpCallbackFunctionUtil.getCallbackString((PsiElement)element);
            if (className == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    CompositeHookReferenceProvider.$$$reportNull$$$0(9);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            String fqn = PhpLangUtil.toFQN((String)className);
            Collection classesByName = PhpIndex.getInstance((Project)element.getProject()).getClassesByFQN(fqn);
            WPHookFunctionReference[] wPHookFunctionReferenceArray = WPHookFunctionReference.getClassReferences(classesByName, element);
            if (wPHookFunctionReferenceArray == null) {
                CompositeHookReferenceProvider.$$$reportNull$$$0(10);
            }
            return wPHookFunctionReferenceArray;
        }

        private static PsiReference @Nullable [] resolveInstanceMethod(PsiElement classOrInstance, String methodName, StringLiteralExpression element) {
            if (!(classOrInstance instanceof PhpTypedElement)) {
                return null;
            }
            PhpType phpType = ((PhpTypedElement)classOrInstance).getType();
            phpType = phpType.globalLocationAware(classOrInstance);
            Set set = phpType.getTypes();
            Project project = classOrInstance.getProject();
            for (String fqn : set) {
                PhpIndex index = PhpIndex.getInstance((Project)project);
                Collection classes = index.getClassesByFQN(fqn);
                SmartList references = new SmartList();
                for (PhpClass phpClass : classes) {
                    for (Method method : phpClass.getMethods()) {
                        if (!methodName.equals(method.getName())) continue;
                        references.add(WPHookFunctionReference.createReference(element, method, phpClass, false));
                    }
                }
                if (!references.isEmpty()) {
                    return references.toArray(PsiReference.EMPTY_ARRAY);
                }
                if (classes.size() != 1) continue;
                return new PsiReference[]{WPHookFunctionReference.createReference(element, null, (PhpClass)classes.iterator().next(), false)};
            }
            return PsiReference.EMPTY_ARRAY;
        }

        private static PsiReference @Nullable [] resolveStaticMethod(PsiElement classOrInstance, String methodName, StringLiteralExpression element) {
            if (!(classOrInstance instanceof StringLiteralExpression)) {
                return null;
            }
            StringLiteralExpression classNameLiteral = (StringLiteralExpression)classOrInstance;
            String className = PhpCallbackFunctionUtil.getCallbackString((PsiElement)classNameLiteral);
            if (className == null) {
                return PsiReference.EMPTY_ARRAY;
            }
            String fqn = PhpLangUtil.toFQN((String)className);
            Collection classesByName = PhpIndex.getInstance((Project)element.getProject()).getClassesByFQN(fqn);
            if (classesByName.size() == 1) {
                PhpClass phpClass = (PhpClass)classesByName.iterator().next();
                for (Method method : phpClass.getMethods()) {
                    if (!methodName.equals(method.getName()) || !method.isStatic()) continue;
                    return new PsiReference[]{WPHookFunctionReference.createReference(element, method, phpClass, true)};
                }
                return new PsiReference[]{WPHookFunctionReference.createReference(element, null, phpClass, true)};
            }
            return PsiReference.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/wordpress/hooks/WPHookCallbackReferenceContributor$CompositeHookReferenceProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/wordpress/hooks/WPHookCallbackReferenceContributor$CompositeHookReferenceProvider";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByElement";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveClasses";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByElement";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SimpleHookReferenceProvider
    extends PsiReferenceProvider {
        private SimpleHookReferenceProvider() {
        }

        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            WPDataService service;
            if (element == null) {
                SimpleHookReferenceProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                SimpleHookReferenceProvider.$$$reportNull$$$0(1);
            }
            if (!(service = WPDataService.getInstance(element.getProject())).isEnabled()) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    SimpleHookReferenceProvider.$$$reportNull$$$0(2);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            if (!(element instanceof StringLiteralExpression)) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    SimpleHookReferenceProvider.$$$reportNull$$$0(3);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            StringLiteralExpression literal = (StringLiteralExpression)element;
            if (!WPHookCallbackReferenceContributor.isSecondParameter((PsiElement)literal)) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    SimpleHookReferenceProvider.$$$reportNull$$$0(4);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            String functionFQN = PhpCallbackFunctionUtil.getCallbackString((PsiElement)literal);
            if (!StringUtil.isNotEmpty((String)functionFQN)) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    SimpleHookReferenceProvider.$$$reportNull$$$0(5);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            int i = functionFQN.lastIndexOf(92);
            String name = i > -1 ? functionFQN.substring(i + 1) : functionFQN;
            String namespace = i > -1 ? functionFQN.substring(0, i + 1) : "\\";
            PhpIndex index = PhpIndex.getInstance((Project)element.getProject());
            Collection functions = index.getFunctionsByName(name);
            Collection filteredFunctions = index.filterByNamespace(functions, PhpLangUtil.toFQN((String)namespace), true);
            WPHookFunctionReference[] wPHookFunctionReferenceArray = WPHookFunctionReference.getFunctionReferences(filteredFunctions, literal);
            if (wPHookFunctionReferenceArray == null) {
                SimpleHookReferenceProvider.$$$reportNull$$$0(6);
            }
            return wPHookFunctionReferenceArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/wordpress/hooks/WPHookCallbackReferenceContributor$SimpleHookReferenceProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/wordpress/hooks/WPHookCallbackReferenceContributor$SimpleHookReferenceProvider";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByElement";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

