/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.generation;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformUtils;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.wordpress.WPBundle;
import com.jetbrains.php.wordpress.generation.WPProjectGeneratorSettings;
import com.jetbrains.php.wordpress.generation.WPProjectPeer;
import com.jetbrains.php.wordpress.settings.WPDataService;
import icons.WordPressIcons;
import java.io.File;
import java.util.Properties;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WPProjectGenerator
extends WebProjectTemplate<WPProjectGeneratorSettings> {
    private static final String INTERNAL_TEMPLATE_WORD_PRESS_MAIN_PLUGIN_FILE = "WordPress Main Plugin File";
    private static final String PLUGIN_NAME_PROPERTY = "PLUGIN_NAME";

    @Nls
    @NotNull
    public String getName() {
        String string = WPBundle.message("wp.wordpress.plugin", new Object[0]);
        if (string == null) {
            WPProjectGenerator.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String getDescription() {
        return WPBundle.message("wp.wordpress.plugin", new Object[0]);
    }

    public Icon getIcon() {
        return WordPressIcons.WordPress;
    }

    @NotNull
    public ProjectGeneratorPeer<WPProjectGeneratorSettings> createPeer() {
        return new WPProjectPeer();
    }

    public boolean isPrimaryGenerator() {
        return PlatformUtils.isPhpStorm();
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull WPProjectGeneratorSettings settings, @NotNull Module module) {
        if (project == null) {
            WPProjectGenerator.$$$reportNull$$$0(1);
        }
        if (baseDir == null) {
            WPProjectGenerator.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            WPProjectGenerator.$$$reportNull$$$0(3);
        }
        if (module == null) {
            WPProjectGenerator.$$$reportNull$$$0(4);
        }
        WPDataService dataService = WPDataService.getInstance(project);
        dataService.setState(settings.getWPState());
        String directoryName = baseDir.getName();
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            Ref mainFileName = new Ref();
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    String fileName = WPProjectGenerator.generateMainFile(directoryName, baseDir, project);
                    mainFileName.set((Object)fileName);
                }
                catch (Exception e) {
                    Messages.showErrorDialog((Project)project, (String)WPBundle.message("wp.error.creating.wordpress.plugin.0", e.getMessage()), (String)WPBundle.message("wp.create.wordpress.plugin", new Object[0]));
                }
                baseDir.refresh(false, true);
            });
            if (mainFileName.isNull()) {
                baseDir.getFileSystem().refresh(false);
                WPProjectGenerator.openFilesInEditor(project, baseDir, (String)mainFileName.get());
            }
        });
    }

    private static void openFilesInEditor(Project project, VirtualFile baseDir, String ... fileNames) {
        if (baseDir == null) {
            return;
        }
        PsiDirectory psiBaseDir = PsiManager.getInstance((Project)project).findDirectory(baseDir);
        if (psiBaseDir != null) {
            for (String fileName : fileNames) {
                PsiFile psiFile = psiBaseDir.findFile(fileName);
                if (psiFile == null) continue;
                psiFile.navigate(fileName == fileNames[fileNames.length - 1]);
            }
        }
    }

    @Nullable
    private static String generateMainFile(String directoryName, VirtualFile contentRoot, Project project) throws Exception {
        PsiDirectory psiDirectory = PsiManager.getInstance((Project)project).findDirectory(contentRoot);
        if (psiDirectory == null) {
            return null;
        }
        String fileName = WPProjectGenerator.getMainFileName(directoryName);
        File targetFile = new File(contentRoot.getPath(), fileName);
        if (targetFile.exists()) {
            return targetFile.getName();
        }
        FileTemplateManager manager = FileTemplateManager.getInstance((Project)project);
        FileTemplate template = manager.getInternalTemplate(INTERNAL_TEMPLATE_WORD_PRESS_MAIN_PLUGIN_FILE);
        Properties properties = manager.getDefaultProperties();
        String improvedPluginName = WPProjectGenerator.getPluginTitle(directoryName);
        properties.setProperty(PLUGIN_NAME_PROPERTY, improvedPluginName);
        FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, (Properties)properties, (PsiDirectory)psiDirectory, null);
        return targetFile.getName();
    }

    private static String getMainFileName(String directoryName) {
        if (StringUtil.isEmpty((String)directoryName)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(2 * directoryName.length());
        boolean wasLowercaseLetter = false;
        boolean wasHyphen = false;
        for (char c : directoryName.toCharArray()) {
            if (!Character.isLetterOrDigit(c) && !wasHyphen) {
                sb.append('-');
                wasHyphen = true;
                wasLowercaseLetter = false;
                continue;
            }
            if (Character.isDigit(c)) {
                sb.append(c);
                wasHyphen = false;
                wasLowercaseLetter = true;
                continue;
            }
            if (wasHyphen) {
                c = Character.toLowerCase(c);
            }
            if (!wasHyphen && wasLowercaseLetter && Character.isUpperCase(c)) {
                sb.append('-').append(Character.toLowerCase(c));
                wasHyphen = false;
                wasLowercaseLetter = false;
                continue;
            }
            sb.append(c);
            wasHyphen = false;
            wasLowercaseLetter = Character.isLowerCase(c);
        }
        sb.append('.').append(PhpFileType.INSTANCE.getDefaultExtension());
        return sb.toString();
    }

    private static String getPluginTitle(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(2 * name.length());
        boolean wasLowercaseLetter = false;
        boolean wasSpace = false;
        for (char c : name.toCharArray()) {
            if (!Character.isLetterOrDigit(c) && !wasSpace) {
                sb.append(' ');
                wasSpace = true;
                wasLowercaseLetter = false;
                continue;
            }
            if (Character.isDigit(c)) {
                sb.append(c);
                wasSpace = false;
                wasLowercaseLetter = false;
                continue;
            }
            if (wasSpace) {
                c = Character.toUpperCase(c);
            }
            if (wasLowercaseLetter && Character.isUpperCase(c)) {
                sb.append(' ').append(c);
                wasSpace = false;
                wasLowercaseLetter = false;
                continue;
            }
            sb.append(c);
            wasSpace = false;
            wasLowercaseLetter = Character.isLowerCase(c);
        }
        return StringUtil.wordsToBeginFromUpperCase((String)sb.toString());
    }

    @Nullable
    public String getHelpId() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/wordpress/generation/WPProjectGenerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/wordpress/generation/WPProjectGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

