/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.clt;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkDescription;
import com.jetbrains.php.wordpress.clt.WPCliUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WPCommand {
    @NonNls
    public static final String NAME_ELEMENT = "name";
    @NonNls
    public static final String DESCRIPTION_ELEMENT = "description";
    @NonNls
    public static final String LONG_DESCRIPTION_ELEMENT = "longdesc";
    @NonNls
    protected static final String SYNOPSIS_ELEMENT = "synopsis";
    @NonNls
    public static final String SUBCOMMANDS_ELEMENT = "subcommands";
    private final String name;
    private final String description;
    private final String longdesc;
    private final String synopsis;
    private List<WPCommand> subcommands;
    @Nullable
    private final WPCommand parent;

    private WPCommand(String name, String description, String longdesc, String synopsis, @Nullable WPCommand parent) {
        this.name = name;
        this.description = description;
        this.longdesc = longdesc;
        this.synopsis = synopsis;
        this.parent = parent;
    }

    public void setSubcommands(List<WPCommand> subcommands) {
        this.subcommands = subcommands;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    static WPCommand parseCommand(JsonElement commandElement, @Nullable WPCommand parent) {
        List<WPCommand> subCommands;
        if (!commandElement.isJsonObject()) {
            throw new JsonSyntaxException("Command is not an object: " + commandElement);
        }
        JsonObject command = commandElement.getAsJsonObject();
        String name = WPCliUtils.getPrimitiveString(command, NAME_ELEMENT, true);
        String description = WPCliUtils.getPrimitiveString(command, DESCRIPTION_ELEMENT, false);
        String longdesc = WPCliUtils.getPrimitiveString(command, LONG_DESCRIPTION_ELEMENT, false);
        JsonElement subcommandsObject = command.get(SUBCOMMANDS_ELEMENT);
        String synopsis = WPCliUtils.getPrimitiveString(command, SYNOPSIS_ELEMENT, subcommandsObject == null);
        WPCommand result = new WPCommand(name, description, longdesc, synopsis, parent);
        if (subcommandsObject != null) {
            if (!subcommandsObject.isJsonArray()) {
                throw new JsonSyntaxException("subcommands is not an array in: " + commandElement);
            }
            subCommands = new ArrayList<WPCommand>();
            JsonArray leafCommandsArray = subcommandsObject.getAsJsonArray();
            for (JsonElement element : leafCommandsArray) {
                WPCommand subCommand = WPCommand.parseCommand(element, result);
                subCommands.add(subCommand);
            }
        } else {
            subCommands = Collections.emptyList();
        }
        result.setSubcommands(subCommands);
        return result;
    }

    @NotNull
    public List<FrameworkCommand> transform(FrameworkDescription framework) {
        if (this.subcommands.isEmpty()) {
            List<FrameworkCommand> list = this.transformLeafCommand(framework);
            if (list == null) {
                WPCommand.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<FrameworkCommand> result = new ArrayList<FrameworkCommand>(this.subcommands.size());
        for (WPCommand subcommand : this.subcommands) {
            result.addAll(subcommand.transform(framework));
        }
        ArrayList<FrameworkCommand> arrayList = result;
        if (arrayList == null) {
            WPCommand.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private String getFullName() {
        if (this.parent == null) {
            return this.name;
        }
        return this.parent.getFullName() + " " + this.name;
    }

    @NotNull
    protected List<FrameworkCommand> transformLeafCommand(FrameworkDescription frameworkDescription) {
        String commandName = this.getFullName();
        boolean infiniteParams = false;
        String patchedSynopsis = this.synopsis;
        if (patchedSynopsis.endsWith("...")) {
            patchedSynopsis = patchedSynopsis.substring(0, patchedSynopsis.length() - "...".length());
            infiniteParams = true;
        }
        patchedSynopsis = patchedSynopsis.trim();
        List<FrameworkCommand.Parameter> parameters = WPCommand.parseLeafParameters(patchedSynopsis);
        List<FrameworkCommand> list = Collections.singletonList(new FrameworkCommand(commandName, parameters, infiniteParams, this.createLeafHelp(), Collections.emptyList(), frameworkDescription));
        if (list == null) {
            WPCommand.$$$reportNull$$$0(2);
        }
        return list;
    }

    private String createLeafHelp() {
        @NonNls StringBuilder help = new StringBuilder();
        help.append("<strong>").append(this.getFullName()).append("</strong>").append(" ").append(WPCliUtils.htmlizeText(this.synopsis)).append("<br/><br/>");
        help.append(WPCliUtils.htmlizeText(this.description)).append("<br/>");
        help.append(WPCliUtils.htmlizeText(this.longdesc)).append("<br/>");
        return help.toString();
    }

    @NotNull
    private static List<FrameworkCommand.Parameter> parseLeafParameters(String synopsis) {
        List parts = StringUtil.split((String)synopsis, (String)" ");
        ArrayList<FrameworkCommand.Parameter> params = new ArrayList<FrameworkCommand.Parameter>(parts.size());
        ArrayList<FrameworkCommand.Parameter> optionalParams = new ArrayList<FrameworkCommand.Parameter>(parts.size());
        for (String part : parts) {
            if (part.isEmpty()) continue;
            boolean optional = false;
            if (part.startsWith("[") && part.endsWith("]")) {
                optional = true;
                part = part.substring(1, part.length() - 1);
            }
            if (part.startsWith("<") && part.endsWith(">")) {
                part = part.substring(1, part.length() - 1);
            }
            if (part.startsWith("--")) continue;
            FrameworkCommand.Parameter parameter = new FrameworkCommand.Parameter(part, optional ? "null" : null);
            if (parameter.hasDefaultValue()) {
                optionalParams.add(parameter);
                continue;
            }
            params.add(parameter);
        }
        params.addAll(optionalParams);
        ArrayList<FrameworkCommand.Parameter> arrayList = params;
        if (arrayList == null) {
            WPCommand.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/wordpress/clt/WPCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "transform";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "transformLeafCommand";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseLeafParameters";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

