/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.wordpress.settings.WPDataService;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WPSearchDocsAction
extends AnAction {
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            WPSearchDocsAction.$$$reportNull$$$0(0);
        }
        boolean enabled = WPSearchDocsAction.getSelectedText(event) != null && WPSearchDocsAction.getDataServiceIfEnabled(event) != null;
        event.getPresentation().setEnabledAndVisible(enabled);
    }

    @Nullable
    private static String getSelectedText(AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return null;
        }
        String selectedText = editor.getSelectionModel().getSelectedText();
        return StringUtil.nullize((String)selectedText, (boolean)true);
    }

    private static WPDataService getDataServiceIfEnabled(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDefault()) {
            return null;
        }
        WPDataService dataService = WPDataService.getInstance(project);
        if (!dataService.isEnabled()) {
            return null;
        }
        return dataService;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        String selectedText;
        if (event == null) {
            WPSearchDocsAction.$$$reportNull$$$0(1);
        }
        if ((selectedText = WPSearchDocsAction.getSelectedText(event)) == null) {
            return;
        }
        WPDataService dataService = WPSearchDocsAction.getDataServiceIfEnabled(event);
        if (dataService == null) {
            return;
        }
        BrowserUtil.browse((String)WPSearchDocsAction.getSearchUrl(selectedText));
    }

    @NonNls
    public static String getSearchUrl(@NotNull String textToSearch) {
        if (textToSearch == null) {
            WPSearchDocsAction.$$$reportNull$$$0(2);
        }
        return "https://developer.wordpress.org/?s=" + URLEncoder.encode(textToSearch, StandardCharsets.UTF_8);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToSearch";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/wordpress/WPSearchDocsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSearchUrl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

