/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.qunit;

import com.google.common.collect.Maps;
import com.intellij.javascript.testFramework.AbstractTestStructureElement;
import com.intellij.javascript.testFramework.qunit.DefaultQUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitTestMethodStructure;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractQUnitModuleStructure
extends AbstractTestStructureElement<QUnitModuleStructure> {
    private final QUnitFileStructure myFileStructure;
    private final List<QUnitTestMethodStructure> myTestMethodStructures;
    private final Map<String, QUnitTestMethodStructure> myTestMethodStructureByNameMap;

    public AbstractQUnitModuleStructure(@NotNull QUnitFileStructure fileStructure, @NotNull String name) {
        if (fileStructure == null) {
            AbstractQUnitModuleStructure.$$$reportNull$$$0(0);
        }
        if (name == null) {
            AbstractQUnitModuleStructure.$$$reportNull$$$0(1);
        }
        super(null, name, null);
        this.myTestMethodStructures = new ArrayList<QUnitTestMethodStructure>();
        this.myTestMethodStructureByNameMap = Maps.newHashMap();
        this.myFileStructure = fileStructure;
    }

    @NotNull
    public QUnitFileStructure getFileStructure() {
        QUnitFileStructure qUnitFileStructure = this.myFileStructure;
        if (qUnitFileStructure == null) {
            AbstractQUnitModuleStructure.$$$reportNull$$$0(2);
        }
        return qUnitFileStructure;
    }

    public void addTestMethodStructure(QUnitTestMethodStructure qUnitTestMethodStructure) {
        this.myTestMethodStructures.add(qUnitTestMethodStructure);
        this.myTestMethodStructureByNameMap.put(qUnitTestMethodStructure.getName(), qUnitTestMethodStructure);
    }

    @Nullable
    public QUnitTestMethodStructure getTestMethodStructureByName(String testMethodName) {
        return this.myTestMethodStructureByNameMap.get(testMethodName);
    }

    @NotNull
    public List<QUnitTestMethodStructure> getTestMethodStructures() {
        List<QUnitTestMethodStructure> list = this.myTestMethodStructures;
        if (list == null) {
            AbstractQUnitModuleStructure.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean isDefault() {
        return this instanceof DefaultQUnitModuleStructure;
    }

    public int getTestCount() {
        return this.myTestMethodStructures.size();
    }

    @Nullable
    public QUnitTestMethodStructure findTestMethodStructureContainingOffset(int offset) {
        for (QUnitTestMethodStructure testMethodStructure : this.myTestMethodStructures) {
            TextRange testTextRange = testMethodStructure.getCallExpression().getTextRange();
            if (!JsPsiUtils.containsOffsetStrictly(testTextRange, offset)) continue;
            return testMethodStructure;
        }
        return null;
    }

    public void forEachTest(@NotNull Consumer<QUnitTestMethodStructure> testConsumer) {
        if (testConsumer == null) {
            AbstractQUnitModuleStructure.$$$reportNull$$$0(4);
        }
        this.myTestMethodStructures.forEach(testConsumer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileStructure";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/qunit/AbstractQUnitModuleStructure";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/qunit/AbstractQUnitModuleStructure";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStructure";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestMethodStructures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forEachTest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

