/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.jasmine;

import com.intellij.javascript.testFramework.jasmine.AbstractJasmineElement;
import com.intellij.javascript.testFramework.jasmine.JasmineSpecStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineSuiteStructure;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JasmineSuiteNode {
    private final List<JasmineSuiteStructure> mySuiteChildren = new ArrayList<JasmineSuiteStructure>();
    private final List<JasmineSpecStructure> mySpecChildren = new ArrayList<JasmineSpecStructure>();
    private final Map<String, AbstractJasmineElement> myChildByNameMap = new HashMap<String, AbstractJasmineElement>();
    private final List<AbstractJasmineElement> myChildren = new ArrayList<AbstractJasmineElement>();

    void addChild(@NotNull AbstractJasmineElement child) {
        if (child == null) {
            JasmineSuiteNode.$$$reportNull$$$0(0);
        }
        if (child instanceof JasmineSuiteStructure) {
            this.mySuiteChildren.add((JasmineSuiteStructure)child);
        } else if (child instanceof JasmineSpecStructure) {
            this.mySpecChildren.add((JasmineSpecStructure)child);
        } else {
            throw new IllegalStateException("Unknown type: " + child.getClass());
        }
        this.myChildren.add(child);
    }

    @Nullable
    public JasmineSuiteStructure findChildSuiteByName(@NotNull String childSuiteName) {
        if (childSuiteName == null) {
            JasmineSuiteNode.$$$reportNull$$$0(1);
        }
        return (JasmineSuiteStructure)ObjectUtils.tryCast((Object)this.myChildByNameMap.get(childSuiteName), JasmineSuiteStructure.class);
    }

    public JasmineSpecStructure findChildSpecByName(@NotNull String childSpecName) {
        if (childSpecName == null) {
            JasmineSuiteNode.$$$reportNull$$$0(2);
        }
        return (JasmineSpecStructure)ObjectUtils.tryCast((Object)this.myChildByNameMap.get(childSpecName), JasmineSpecStructure.class);
    }

    @NotNull
    public List<JasmineSpecStructure> getChildSpecs() {
        List<JasmineSpecStructure> list = this.mySpecChildren;
        if (list == null) {
            JasmineSuiteNode.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<JasmineSuiteStructure> getChildSuites() {
        List<JasmineSuiteStructure> list = this.mySuiteChildren;
        if (list == null) {
            JasmineSuiteNode.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<AbstractJasmineElement> getChildren() {
        List<AbstractJasmineElement> list = this.myChildren;
        if (list == null) {
            JasmineSuiteNode.$$$reportNull$$$0(5);
        }
        return list;
    }

    void fillNameMap() {
        for (AbstractJasmineElement jasmineElement : this.myChildren) {
            this.myChildByNameMap.put(jasmineElement.getName(), jasmineElement);
        }
    }

    void postProcess() {
        this.fillNameMap();
        this.iterateChildrenRecursively(structure -> structure.getNode().fillNameMap(), null);
    }

    public void iterateChildrenRecursively(@Nullable Consumer<JasmineSuiteStructure> suiteConsumer, @Nullable Consumer<JasmineSpecStructure> specConsumer) {
        for (JasmineSuiteStructure suite : this.mySuiteChildren) {
            suite.getNode().iterateChildrenRecursively(suiteConsumer, specConsumer);
        }
        if (suiteConsumer != null) {
            this.mySuiteChildren.forEach(suiteConsumer);
        }
        if (specConsumer != null) {
            this.mySpecChildren.forEach(specConsumer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childSuiteName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childSpecName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/jasmine/JasmineSuiteNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/jasmine/JasmineSuiteNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildSpecs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildSuites";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findChildSuiteByName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findChildSpecByName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

