/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.jasmine;

import com.intellij.javascript.testFramework.AbstractTestFileStructureBuilder;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineSpecStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineSuiteStructure;
import com.intellij.javascript.testFramework.jasmine.JestTestNamePatternUtil;
import com.intellij.javascript.testFramework.util.JSTestNamePattern;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JasmineFileStructureBuilder
extends AbstractTestFileStructureBuilder<JasmineFileStructure> {
    private static final JasmineFileStructureBuilder INSTANCE = new JasmineFileStructureBuilder();
    public static final String DESCRIBE_NAME = "describe";
    public static final String CONTEXT_NAME = "context";
    public static final String DDESCRIBE_NAME = "ddescribe";
    public static final String XDESCRIBE_NAME = "xdescribe";
    public static final String FDESCRIBE_NAME = "fdescribe";
    public static final String MOCHA_PARALLEL_SUITE_NAME = "parallel";
    public static final String MOCHA_PARALLEL_PKG_NAME = "mocha.parallel";
    public static final String IT_NAME = "it";
    public static final String TEST_NAME = "test";
    public static final String IIT_NAME = "iit";
    public static final String XIT_NAME = "xit";
    public static final String FIT_NAME = "fit";
    private static final String EACH = "each";
    private static final List<String> SUITE_MODIFIERS = Arrays.asList("skip", "only");

    @Override
    @NotNull
    public JasmineFileStructure buildTestFileStructure(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            JasmineFileStructureBuilder.$$$reportNull$$$0(0);
        }
        JasmineFileStructure jasmineFileStructure = new Builder(jsFile).build();
        if (jasmineFileStructure == null) {
            JasmineFileStructureBuilder.$$$reportNull$$$0(1);
        }
        return jasmineFileStructure;
    }

    public static JasmineFileStructureBuilder getInstance() {
        return INSTANCE;
    }

    @Nullable
    private static JSTestNamePattern createTestNamePattern(@NotNull JSCallExpression callExpression, boolean each, @NotNull String testName) {
        if (callExpression == null) {
            JasmineFileStructureBuilder.$$$reportNull$$$0(2);
        }
        if (testName == null) {
            JasmineFileStructureBuilder.$$$reportNull$$$0(3);
        }
        if (each) {
            if (callExpression.getMethodExpression() instanceof ES6TaggedTemplateExpression) {
                return JestTestNamePatternUtil.parseTemplateEachPattern(testName);
            }
            return JestTestNamePatternUtil.parseTableEachPattern(testName);
        }
        return null;
    }

    @Nullable
    static JSReferenceExpression getMethodReferenceExpression(@NotNull JSCallExpression callExpression) {
        JSExpression methodExpr;
        JSReferenceExpression referenceExpr;
        if (callExpression == null) {
            JasmineFileStructureBuilder.$$$reportNull$$$0(4);
        }
        if ((referenceExpr = (JSReferenceExpression)ObjectUtils.tryCast((Object)(methodExpr = callExpression.getMethodExpression()), JSReferenceExpression.class)) != null) {
            return referenceExpr;
        }
        JSCallExpression innerCallExpr = (JSCallExpression)ObjectUtils.tryCast((Object)methodExpr, JSCallExpression.class);
        if (innerCallExpr != null && (referenceExpr = (JSReferenceExpression)ObjectUtils.tryCast((Object)innerCallExpr.getMethodExpression(), JSReferenceExpression.class)) != null && EACH.equals(referenceExpr.getReferenceName())) {
            return referenceExpr;
        }
        ES6TaggedTemplateExpression templateExpr = (ES6TaggedTemplateExpression)ObjectUtils.tryCast((Object)methodExpr, ES6TaggedTemplateExpression.class);
        if (templateExpr != null) {
            return (JSReferenceExpression)ObjectUtils.tryCast((Object)templateExpr.getTag(), JSReferenceExpression.class);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/jasmine/JasmineFileStructureBuilder";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/jasmine/JasmineFileStructureBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTestFileStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTestFileStructure";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTestNamePattern";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMethodReferenceExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Builder {
        private final JasmineFileStructure myFileStructure;

        Builder(JSFile jsFile) {
            this.myFileStructure = new JasmineFileStructure(jsFile);
        }

        public JasmineFileStructure build() {
            if (this.isJasmineFile()) {
                List<JSStatement> statements = JsPsiUtils.listStatementsInExecutionOrder(this.myFileStructure.getJsFile());
                for (JSStatement statement : statements) {
                    JSCallExpression jsCallExpression = JsPsiUtils.toCallExpressionFromStatement(statement);
                    if (jsCallExpression == null) continue;
                    this.handleCallExpr(null, jsCallExpression);
                }
            }
            this.myFileStructure.postProcess();
            return this.myFileStructure;
        }

        private boolean isJasmineFile() {
            CharSequence contents = this.myFileStructure.getJsFile().getViewProvider().getContents();
            return JsPsiUtils.mightContainGlobalCall(contents, JasmineFileStructureBuilder.DESCRIBE_NAME, true) || JsPsiUtils.mightContainGlobalCall(contents, JasmineFileStructureBuilder.CONTEXT_NAME, true) || JsPsiUtils.mightContainGlobalCall(contents, JasmineFileStructureBuilder.IT_NAME, true) || JsPsiUtils.mightContainGlobalCall(contents, JasmineFileStructureBuilder.TEST_NAME, true);
        }

        private void handleCallExpr(@Nullable JasmineSuiteStructure parentSuiteStructure, @NotNull JSCallExpression callExpression) {
            JSExpression testNameExpression;
            String name;
            boolean each;
            JSReferenceExpression expr;
            if (callExpression == null) {
                Builder.$$$reportNull$$$0(0);
            }
            List<String> components = (expr = JasmineFileStructureBuilder.getMethodReferenceExpression(callExpression = Builder.getProperCallExpr(callExpression))) != null ? Builder.getReferenceComponents(expr, 3) : Collections.emptyList();
            boolean bl = each = components.size() > 1 && JasmineFileStructureBuilder.EACH.equals(ContainerUtil.getLastItem(components));
            if (each) {
                components.remove(components.size() - 1);
            }
            if (components.size() == 0) {
                return;
            }
            JSExpression[] arguments = callExpression.getArguments();
            int argc = arguments.length;
            String methodName = (String)components.get(0);
            if (argc == 2 && Builder.isSuiteMethodName(methodName, (PsiFile)this.myFileStructure.getJsFile())) {
                if (!Builder.isSuiteComponents(components)) {
                    return;
                }
                JSExpression suiteNameExpression = Objects.requireNonNull(arguments[0]);
                String name2 = JsPsiUtils.extractStringValue(suiteNameExpression);
                JSFunctionExpression specDefinitions = JsPsiUtils.extractFunctionExpression(arguments[1]);
                if (name2 != null && (specDefinitions != null || parentSuiteStructure != null)) {
                    JasmineSuiteStructure suiteStructure = new JasmineSuiteStructure(callExpression, specDefinitions, suiteNameExpression, name2, parentSuiteStructure);
                    suiteStructure.setNamePattern(JasmineFileStructureBuilder.createTestNamePattern(callExpression, each, name2));
                    if (parentSuiteStructure != null) {
                        parentSuiteStructure.addChild(suiteStructure);
                    } else {
                        this.myFileStructure.addSuiteStructure(suiteStructure);
                    }
                    if (specDefinitions != null) {
                        this.handleSuite(suiteStructure, specDefinitions);
                    }
                }
                return;
            }
            if ((argc == 2 || argc == 3 || argc == 1 && Builder.hasTodo(components)) && Builder.isSpecMethodName(methodName) && (name = JsPsiUtils.extractStringValue(testNameExpression = Objects.requireNonNull(arguments[0]))) != null) {
                JasmineSpecStructure specStructure = new JasmineSpecStructure(callExpression, testNameExpression, name, parentSuiteStructure);
                specStructure.setNamePattern(JasmineFileStructureBuilder.createTestNamePattern(callExpression, each, name));
                if (parentSuiteStructure != null) {
                    parentSuiteStructure.addChild(specStructure);
                } else {
                    this.myFileStructure.addSpecStructure(specStructure);
                }
            }
        }

        private static boolean isSuiteComponents(@NotNull List<String> components) {
            if (components == null) {
                Builder.$$$reportNull$$$0(1);
            }
            if (components.size() == 1) {
                return true;
            }
            String describePropName = components.get(1);
            if (components.size() == 2) {
                return SUITE_MODIFIERS.contains(describePropName) || "posix".equals(describePropName);
            }
            if (components.size() == 3) {
                return SUITE_MODIFIERS.contains(describePropName);
            }
            return false;
        }

        private static boolean hasTodo(@NotNull List<String> components) {
            if (components == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return components.contains("todo");
        }

        @NotNull
        private static List<String> getReferenceComponents(@NotNull JSReferenceExpression expression, int maxCount) {
            if (expression == null) {
                Builder.$$$reportNull$$$0(3);
            }
            ArrayList<String> result = new ArrayList<String>(maxCount);
            while (expression != null) {
                if (result.size() >= maxCount) {
                    List<String> list = Collections.emptyList();
                    if (list == null) {
                        Builder.$$$reportNull$$$0(4);
                    }
                    return list;
                }
                String name = expression.getReferenceName();
                if (name == null) {
                    List<String> list = Collections.emptyList();
                    if (list == null) {
                        Builder.$$$reportNull$$$0(5);
                    }
                    return list;
                }
                result.add(name);
                JSExpression qualifier = expression.getQualifier();
                if (qualifier != null && !(qualifier instanceof JSReferenceExpression)) {
                    List<String> list = Collections.emptyList();
                    if (list == null) {
                        Builder.$$$reportNull$$$0(6);
                    }
                    return list;
                }
                expression = (JSReferenceExpression)qualifier;
            }
            Collections.reverse(result);
            ArrayList<String> arrayList = result;
            if (arrayList == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return arrayList;
        }

        @NotNull
        private static JSCallExpression getProperCallExpr(@NotNull JSCallExpression callExpression) {
            JSExpression qualifier;
            JSReferenceExpression methodExpr;
            if (callExpression == null) {
                Builder.$$$reportNull$$$0(8);
            }
            if ((methodExpr = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class)) != null && (qualifier = methodExpr.getQualifier()) instanceof JSCallExpression && "timeout".equals(methodExpr.getReferenceName())) {
                JSCallExpression jSCallExpression = (JSCallExpression)qualifier;
                if (jSCallExpression == null) {
                    Builder.$$$reportNull$$$0(9);
                }
                return jSCallExpression;
            }
            JSCallExpression jSCallExpression = callExpression;
            if (jSCallExpression == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return jSCallExpression;
        }

        private static boolean isSuiteMethodName(@NotNull String methodName, @NotNull PsiFile psiFile) {
            if (methodName == null) {
                Builder.$$$reportNull$$$0(11);
            }
            if (psiFile == null) {
                Builder.$$$reportNull$$$0(12);
            }
            if (JasmineFileStructureBuilder.MOCHA_PARALLEL_SUITE_NAME.equals(methodName)) {
                CharSequence contents = psiFile.getViewProvider().getContents();
                return StringUtil.contains((CharSequence)contents, (CharSequence)((CharSequence)StringUtil.QUOTER.fun((Object)JasmineFileStructureBuilder.MOCHA_PARALLEL_PKG_NAME))) || StringUtil.contains((CharSequence)contents, (CharSequence)((CharSequence)StringUtil.SINGLE_QUOTER.fun((Object)JasmineFileStructureBuilder.MOCHA_PARALLEL_PKG_NAME)));
            }
            return JasmineFileStructureBuilder.DESCRIBE_NAME.equals(methodName) || JasmineFileStructureBuilder.CONTEXT_NAME.equals(methodName) || JasmineFileStructureBuilder.DDESCRIBE_NAME.equals(methodName) || JasmineFileStructureBuilder.FDESCRIBE_NAME.equals(methodName) || JasmineFileStructureBuilder.XDESCRIBE_NAME.equals(methodName);
        }

        private static boolean isSpecMethodName(String methodName) {
            return JasmineFileStructureBuilder.IT_NAME.equals(methodName) || JasmineFileStructureBuilder.TEST_NAME.equals(methodName) || JasmineFileStructureBuilder.IIT_NAME.equals(methodName) || JasmineFileStructureBuilder.FIT_NAME.equals(methodName) || JasmineFileStructureBuilder.XIT_NAME.equals(methodName);
        }

        private void handleSuite(@NotNull JasmineSuiteStructure suiteStructure, @NotNull JSFunctionExpression specDefinitions) {
            JSBlockStatement jsBlockStatement;
            if (suiteStructure == null) {
                Builder.$$$reportNull$$$0(13);
            }
            if (specDefinitions == null) {
                Builder.$$$reportNull$$$0(14);
            }
            if ((jsBlockStatement = specDefinitions.getBlock()) != null) {
                for (JSSourceElement statement : jsBlockStatement.getStatementListItems()) {
                    JSCallExpression jsCallExpression = JsPsiUtils.toCallExpressionFromStatement((JSStatement)ObjectUtils.tryCast((Object)statement, JSStatement.class));
                    if (jsCallExpression == null) continue;
                    this.handleCallExpr(suiteStructure, jsCallExpression);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callExpression";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "components";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/testFramework/jasmine/JasmineFileStructureBuilder$Builder";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodName";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suiteStructure";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "specDefinitions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/testFramework/jasmine/JasmineFileStructureBuilder$Builder";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferenceComponents";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProperCallExpr";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "handleCallExpr";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSuiteComponents";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "hasTodo";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferenceComponents";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getProperCallExpr";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "isSuiteMethodName";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "handleSuite";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

