/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.security;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.ListEditForm;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.security.Http2HttpsQuickFix;
import com.intellij.httpClient.http.security.HttpUrlsUsageInspection;
import com.intellij.httpClient.http.security.IgnoreUrlQuickFix;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import com.intellij.util.text.StringTokenizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u00015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0002J \u0010\u0014\u001a\u00020\u00052\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00042\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001b\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)H\u0002J,\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020)2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002000/H\u0002J\u0010\u00101\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u001bH\u0002J2\u00102\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00042\u0006\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020)2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002000/H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/httpClient/http/security/HttpUrlsUsageInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "defaultIgnoredUrls", "", "", "ignoreComments", "", "ignoredUrls", "", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "createCheckboxPanel", "Ljavax/swing/JPanel;", "createOptionsPanel", "Ljavax/swing/JComponent;", "createUrlListPanel", "decodeLiteralValue", "escaper", "Lcom/intellij/psi/LiteralTextEscaper;", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "wholeRange", "Lcom/intellij/openapi/util/TextRange;", "getLiteralFragments", "Lcom/intellij/httpClient/http/security/HttpUrlsUsageInspection$LiteralFragment;", "injectionHost", "xmlAttributeValue", "Lcom/intellij/psi/xml/XmlAttributeValue;", "getQuickFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "literalFragment", "(Lcom/intellij/httpClient/http/security/HttpUrlsUsageInspection$LiteralFragment;)[Lcom/intellij/codeInspection/LocalQuickFix;", "hasLocationHint", "namespaceDeclaration", "Lcom/intellij/psi/xml/XmlAttribute;", "mayContainHttpSchema", "element", "Lcom/intellij/psi/PsiElement;", "nextLinkLiteral", "tokenizer", "Lcom/intellij/util/text/StringTokenizer;", "psiElement", "offsetMap", "Lkotlin/Function1;", "", "shouldReport", "splitLiterals", "literal", "host", "LiteralFragment", "intellij.restClient"})
public final class HttpUrlsUsageInspection
extends LocalInspectionTool {
    private final List<String> defaultIgnoredUrls = CollectionsKt.listOf((Object[])new String[]{"http://localhost", "http://127.0.0.1", "http://www.w3.org/2000/svg", "http://www.w3.org/2000/10/XMLSchema", "http://www.w3.org/2001/XMLSchema", "http://www.w3.org/2001/XMLSchema-instance", "http://www.w3.org/2003/03/wsdl", "http://json-schema.org/draft", "http://java.sun.com/xml/ns/", "http://xmlns.jcp.org/xml/ns/", "http://javafx.com/javafx/", "http://javafx.com/fxml", "http://maven.apache.org/xsd/", "http://maven.apache.org/POM/", "http://www.springframework.org/schema/", "http://www.thymeleaf.org", "http://www.ibm.com/webservices/xsd", "http://schemas.xmlsoap.org/", "http://cxf.apache.org/schemas/"});
    @JvmField
    public boolean ignoreComments = true;
    @JvmField
    @NotNull
    public final List<String> ignoredUrls = new ArrayList(this.defaultIgnoredUrls);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PsiElementVisitor(this, holder){
            final /* synthetic */ HttpUrlsUsageInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitElement(@NotNull PsiElement element) {
                List list;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (this.this$0.ignoreComments && element instanceof PsiComment) {
                    return;
                }
                PsiElement psiElement = element;
                if (psiElement instanceof XmlAttributeValue) {
                    list = HttpUrlsUsageInspection.access$getLiteralFragments(this.this$0, (XmlAttributeValue)element);
                } else if (psiElement instanceof PsiLanguageInjectionHost) {
                    list = HttpUrlsUsageInspection.access$getLiteralFragments(this.this$0, (PsiLanguageInjectionHost)element);
                } else {
                    return;
                }
                List literals2 = list;
                Sequence $this$forEach$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)literals2), (Function1)((Function1)new Function1<LiteralFragment, Boolean>(this){
                    final /* synthetic */ buildVisitor.1 this$0;

                    public final boolean invoke(@NotNull LiteralFragment it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return HttpUrlsUsageInspection.access$shouldReport(this.this$0.this$0, it);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    LiteralFragment it = (LiteralFragment)element$iv;
                    boolean bl = false;
                    LocalQuickFix[] localQuickFixArray = HttpUrlsUsageInspection.access$getQuickFixes(this.this$0, it);
                    this.$holder.registerProblem(it.getElement(), it.getRange(), RestClientBundle.message("inspection.template", new Object[0]), Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                }
            }
            {
                this.this$0 = this$0;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    private final boolean shouldReport(LiteralFragment literalFragment) {
        boolean bl;
        block4: {
            int urlStart = StringsKt.indexOf$default((CharSequence)literalFragment.getValue(), (String)"http://", (int)0, (boolean)false, (int)6, null);
            if (urlStart == -1) {
                return false;
            }
            Iterable $this$none$iv = this.ignoredUrls;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)literalFragment.getValue(), (String)it, (int)urlStart, (boolean)false, (int)4, null)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final LocalQuickFix[] getQuickFixes(LiteralFragment literalFragment) {
        URL uRL;
        try {
            uRL = new URL(literalFragment.getValue());
        }
        catch (MalformedURLException e) {
            uRL = null;
        }
        URL url = uRL;
        if (url == null) {
            return new LocalQuickFix[]{new Http2HttpsQuickFix(literalFragment.getValue())};
        }
        return new LocalQuickFix[]{new Http2HttpsQuickFix(literalFragment.getValue()), new IgnoreUrlQuickFix("http://" + url.getHost())};
    }

    @NotNull
    public JComponent createOptionsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(2, 2));
        boolean bl = false;
        boolean bl2 = false;
        JPanel $this$apply = jPanel;
        boolean bl3 = false;
        $this$apply.add((Component)this.createCheckboxPanel(), "North");
        $this$apply.add((Component)this.createUrlListPanel(), "Center");
        return jPanel;
    }

    private final List<LiteralFragment> splitLiterals(String literal, PsiElement host, Function1<? super Integer, Integer> offsetMap) {
        StringTokenizer tokenizer = new StringTokenizer(literal, " \t\n\r\f'\"");
        SmartList literals2 = new SmartList();
        while (tokenizer.hasMoreTokens()) {
            LiteralFragment linkLiteral = this.nextLinkLiteral(tokenizer, host, offsetMap);
            literals2.add((Object)linkLiteral);
        }
        return (List)literals2;
    }

    private final List<LiteralFragment> getLiteralFragments(PsiLanguageInjectionHost injectionHost) {
        if (!injectionHost.isValidHost()) {
            return CollectionsKt.emptyList();
        }
        if (!this.mayContainHttpSchema((PsiElement)injectionHost)) {
            return CollectionsKt.emptyList();
        }
        LiteralTextEscaper literalTextEscaper = injectionHost.createLiteralTextEscaper();
        Intrinsics.checkNotNullExpressionValue((Object)literalTextEscaper, (String)"injectionHost.createLiteralTextEscaper()");
        LiteralTextEscaper escaper = literalTextEscaper;
        TextRange textRange = escaper.getRelevantTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"escaper.relevantTextRange");
        TextRange wholeRange = textRange;
        String literalValue = this.decodeLiteralValue((LiteralTextEscaper<? extends PsiLanguageInjectionHost>)escaper, wholeRange);
        return this.splitLiterals(literalValue, (PsiElement)injectionHost, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(escaper, wholeRange){
            final /* synthetic */ LiteralTextEscaper $escaper;
            final /* synthetic */ TextRange $wholeRange;

            public final int invoke(int it) {
                return this.$escaper.getOffsetInHost(it, this.$wholeRange);
            }
            {
                this.$escaper = literalTextEscaper;
                this.$wholeRange = textRange;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final List<LiteralFragment> getLiteralFragments(XmlAttributeValue xmlAttributeValue) {
        XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtilKt.parentOfTypes$default((PsiElement)((PsiElement)xmlAttributeValue), (KClass[])new KClass[]{Reflection.getOrCreateKotlinClass(XmlAttribute.class)}, (boolean)false, (int)2, null);
        if (xmlAttribute == null) {
            return CollectionsKt.emptyList();
        }
        XmlAttribute attribute = xmlAttribute;
        if (!this.mayContainHttpSchema((PsiElement)xmlAttributeValue)) {
            return CollectionsKt.emptyList();
        }
        String string = xmlAttributeValue.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"xmlAttributeValue.value");
        String attributeValue = string;
        List<LiteralFragment> literals2 = this.splitLiterals(attributeValue, (PsiElement)xmlAttributeValue, (Function1<? super Integer, Integer>)((Function1)getLiteralFragments.literals.1.INSTANCE));
        if (attribute.isNamespaceDeclaration() && this.hasLocationHint(attribute)) {
            return CollectionsKt.emptyList();
        }
        if (Intrinsics.areEqual((Object)attribute.getLocalName(), (Object)"targetNamespace")) {
            PsiElement $this$parentOfType$iv = (PsiElement)xmlAttributeValue;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, XmlTag.class, (boolean)true);
            if (parentTag != null && Intrinsics.areEqual((Object)parentTag.getLocalName(), (Object)"schema") && parentTag.getParentTag() == null) {
                return CollectionsKt.emptyList();
            }
        }
        if (Intrinsics.areEqual((Object)attribute.getNamespace(), (Object)"http://www.w3.org/2001/XMLSchema-instance")) {
            String string2 = attribute.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"attribute.name");
            if (Intrinsics.areEqual((Object)StringsKt.replace$default((String)string2, (String)(attribute.getNamespacePrefix() + ':'), (String)"", (boolean)false, (int)4, null), (Object)"schemaLocation")) {
                void $this$filterIndexedTo$iv$iv;
                Iterable $this$filterIndexed$iv = literals2;
                boolean $i$f$filterIndexed = false;
                Iterable withSelf$iv = $this$filterIndexed$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIndexedTo = false;
                void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv$iv$iv = 0;
                for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                    void element$iv$iv;
                    int n = index$iv$iv$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object t = item$iv$iv$iv;
                    int index$iv$iv = n;
                    boolean bl2 = false;
                    LiteralFragment literalFragment = (LiteralFragment)element$iv$iv;
                    int index = index$iv$iv;
                    boolean bl3 = false;
                    if (!(index % 2 == 1)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }
        return literals2;
    }

    private final boolean mayContainHttpSchema(PsiElement element) {
        return element.textContains(':');
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasLocationHint(XmlAttribute namespaceDeclaration) {
        boolean bl;
        block6: {
            void $this$any$iv;
            void $this$filterIndexedTo$iv$iv;
            Iterable $this$filterIndexed$iv;
            XmlTag tag = namespaceDeclaration.getParent();
            XmlAttribute schemaAttribute = tag.getAttribute("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
            Object object = schemaAttribute;
            if (object == null || (object = object.getValue()) == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"schemaAttribute?.value ?: return false");
            Object schemaLocationValue = object;
            Iterable iterable = this.splitLiterals((String)schemaLocationValue, (PsiElement)schemaAttribute, (Function1<? super Integer, Integer>)((Function1)hasLocationHint.1.INSTANCE));
            boolean $i$f$filterIndexed = false;
            Iterator iterator = $this$filterIndexed$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIndexedTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                void element$iv$iv;
                int n = index$iv$iv$iv++;
                boolean bl2 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl3 = false;
                LiteralFragment literalFragment = (LiteralFragment)element$iv$iv;
                int index = index$iv$iv;
                boolean bl4 = false;
                if (!(index % 2 == 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIndexed$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LiteralFragment it = (LiteralFragment)element$iv;
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)it.getValue(), (Object)namespaceDeclaration.getValue())) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final LiteralFragment nextLinkLiteral(StringTokenizer tokenizer, PsiElement psiElement, Function1<? super Integer, Integer> offsetMap) {
        String string = tokenizer.nextToken();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tokenizer.nextToken()");
        String value = string;
        int endPosition = tokenizer.getCurrentPosition();
        int startPosition = endPosition - value.length();
        return new LiteralFragment(value, new TextRange(((Number)offsetMap.invoke((Object)startPosition)).intValue(), ((Number)offsetMap.invoke((Object)endPosition)).intValue()), psiElement);
    }

    private final String decodeLiteralValue(LiteralTextEscaper<? extends PsiLanguageInjectionHost> escaper, TextRange wholeRange) {
        StringBuilder stringBuilder = new StringBuilder();
        escaper.decode(wholeRange, stringBuilder);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
        return string;
    }

    private final JComponent createUrlListPanel() {
        JComponent jComponent = new ListEditForm(RestClientBundle.message("column.name.ignored.urls", new Object[0]), this.ignoredUrls).getContentPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"ListEditForm(RestClientB\u2026ignoredUrls).contentPanel");
        return jComponent;
    }

    private final JPanel createCheckboxPanel() {
        return (JPanel)new SingleCheckboxOptionsPanel(RestClientBundle.message("checkbox.ignore.comments", new Object[0]), (InspectionProfileEntry)this, "ignoreComments");
    }

    public static final /* synthetic */ List access$getLiteralFragments(HttpUrlsUsageInspection $this, XmlAttributeValue xmlAttributeValue) {
        return $this.getLiteralFragments(xmlAttributeValue);
    }

    public static final /* synthetic */ List access$getLiteralFragments(HttpUrlsUsageInspection $this, PsiLanguageInjectionHost injectionHost) {
        return $this.getLiteralFragments(injectionHost);
    }

    public static final /* synthetic */ boolean access$shouldReport(HttpUrlsUsageInspection $this, LiteralFragment literalFragment) {
        return $this.shouldReport(literalFragment);
    }

    public static final /* synthetic */ LocalQuickFix[] access$getQuickFixes(HttpUrlsUsageInspection $this, LiteralFragment literalFragment) {
        return $this.getQuickFixes(literalFragment);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/httpClient/http/security/HttpUrlsUsageInspection$LiteralFragment;", "", "value", "", "range", "Lcom/intellij/openapi/util/TextRange;", "element", "Lcom/intellij/psi/PsiElement;", "(Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;Lcom/intellij/psi/PsiElement;)V", "getElement", "()Lcom/intellij/psi/PsiElement;", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "getValue", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.restClient"})
    private static final class LiteralFragment {
        @NotNull
        private final String value;
        @Nullable
        private final TextRange range;
        @NotNull
        private final PsiElement element;

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @Nullable
        public final TextRange getRange() {
            return this.range;
        }

        @NotNull
        public final PsiElement getElement() {
            return this.element;
        }

        public LiteralFragment(@NotNull String value, @Nullable TextRange range, @NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.value = value;
            this.range = range;
            this.element = element;
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        @Nullable
        public final TextRange component2() {
            return this.range;
        }

        @NotNull
        public final PsiElement component3() {
            return this.element;
        }

        @NotNull
        public final LiteralFragment copy(@NotNull String value, @Nullable TextRange range, @NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return new LiteralFragment(value, range, element);
        }

        public static /* synthetic */ LiteralFragment copy$default(LiteralFragment literalFragment, String string, TextRange textRange, PsiElement psiElement, int n, Object object) {
            if ((n & 1) != 0) {
                string = literalFragment.value;
            }
            if ((n & 2) != 0) {
                textRange = literalFragment.range;
            }
            if ((n & 4) != 0) {
                psiElement = literalFragment.element;
            }
            return literalFragment.copy(string, textRange, psiElement);
        }

        @NotNull
        public String toString() {
            return "LiteralFragment(value=" + this.value + ", range=" + this.range + ", element=" + this.element + ")";
        }

        public int hashCode() {
            String string = this.value;
            TextRange textRange = this.range;
            PsiElement psiElement = this.element;
            return ((string != null ? string.hashCode() : 0) * 31 + (textRange != null ? textRange.hashCode() : 0)) * 31 + (psiElement != null ? psiElement.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LiteralFragment)) break block3;
                    LiteralFragment literalFragment = (LiteralFragment)object;
                    if (!Intrinsics.areEqual((Object)this.value, (Object)literalFragment.value) || !Intrinsics.areEqual((Object)this.range, (Object)literalFragment.range) || !Intrinsics.areEqual((Object)this.element, (Object)literalFragment.element)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

