/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.structure;

import com.intellij.httpClient.http.request.HttpRequestFileUtils;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.httpClient.http.request.psi.HttpRequestBody;
import com.intellij.httpClient.http.request.psi.HttpRequestTarget;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import icons.RestClientIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequestStructureViewElement
extends PsiTreeElementBase<PsiElement>
implements ColoredItemPresentation {
    private final String myPresentationText;
    private final String myLocation;
    private final Icon myIcon;
    private final boolean myIsValid;

    private HttpRequestStructureViewElement(@NotNull PsiElement element, @NotNull String text, @Nullable String location, @Nullable Icon icon, boolean isValid) {
        if (element == null) {
            HttpRequestStructureViewElement.$$$reportNull$$$0(0);
        }
        if (text == null) {
            HttpRequestStructureViewElement.$$$reportNull$$$0(1);
        }
        super(element);
        this.myPresentationText = text;
        this.myLocation = location;
        this.myIcon = icon;
        this.myIsValid = isValid;
    }

    @NotNull
    public static StructureViewTreeElement create(@NotNull PsiElement element, @Nullable String text, @Nullable Icon icon) {
        if (element == null) {
            HttpRequestStructureViewElement.$$$reportNull$$$0(2);
        }
        return new HttpRequestStructureViewElement(element, StringUtil.notNullize((String)text, (String)"<not defined>"), null, icon, StringUtil.isNotEmpty((String)text));
    }

    @NotNull
    public static StructureViewTreeElement createRequest(@NotNull PsiElement element, @NotNull String text, @Nullable String location, boolean isValid) {
        if (element == null) {
            HttpRequestStructureViewElement.$$$reportNull$$$0(3);
        }
        if (text == null) {
            HttpRequestStructureViewElement.$$$reportNull$$$0(4);
        }
        return new HttpRequestStructureViewElement(element, text, location, RestClientIcons.Request, isValid);
    }

    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        String mimeType;
        FileType fileType;
        HttpRequestBody body;
        PsiElement element = this.getElement();
        if (element instanceof HttpRequestPsiFile) {
            Object[] blocks = HttpRequestPsiUtils.getRequestBlocks((PsiFile)element);
            if (!ArrayUtil.isEmpty((Object[])blocks)) {
                ArrayList<StructureViewTreeElement> children = new ArrayList<StructureViewTreeElement>(blocks.length);
                PsiFile file2 = element.getContainingFile();
                HttpRequestVariableSubstitutor substitutor = HttpRequestVariableSubstitutor.getDefault(element.getProject(), file2);
                boolean showHosts = HttpRequestStructureViewElement.showHosts((HttpRequestBlock[])blocks, substitutor);
                boolean showMethods = HttpRequestStructureViewElement.showMethods((HttpRequestBlock[])blocks);
                for (Object block : blocks) {
                    HttpRequest request = block.getRequest();
                    String originalHost = request.getHttpHost(substitutor);
                    HttpRequestTarget target = request.getRequestTarget();
                    String path = target != null ? target.getHttpPath(substitutor) : null;
                    boolean isEmpty = StringUtil.isEmpty((String)path);
                    String method = request.getHttpMethod();
                    StringBuilder location = new StringBuilder();
                    if (showMethods && !StringUtil.equals((CharSequence)method, (CharSequence)"GET")) {
                        location.append(method);
                    }
                    if (showHosts && !isEmpty) {
                        if (location.length() > 0) {
                            location.append(" ");
                        }
                        location.append(StringUtil.notNullize((String)originalHost, (String)"<not defined>"));
                    }
                    Object text = isEmpty ? StringUtil.notNullize((String)originalHost, (String)"<not defined>") : "/" + StringUtil.notNullize((String)path);
                    children.add(HttpRequestStructureViewElement.createRequest((PsiElement)request, (String)text, location.length() == 0 ? null : location.toString(), StringUtil.isNotEmpty((String)originalHost)));
                }
                ArrayList<StructureViewTreeElement> arrayList = children;
                if (arrayList == null) {
                    HttpRequestStructureViewElement.$$$reportNull$$$0(5);
                }
                return arrayList;
            }
        } else if (element instanceof HttpRequest && (body = ((HttpRequest)element).getRequestBody()) != null && (fileType = HttpRequestFileUtils.findFileType(mimeType = ((HttpRequest)element).getMimeType())) != null) {
            return new SmartList((Object)HttpRequestStructureViewElement.create((PsiElement)body, mimeType, fileType.getIcon()));
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            HttpRequestStructureViewElement.$$$reportNull$$$0(6);
        }
        return list;
    }

    public String getLocationString() {
        return this.myLocation;
    }

    public boolean isSearchInLocationString() {
        return true;
    }

    private static boolean showHosts(HttpRequestBlock[] blocks, HttpRequestVariableSubstitutor substitutor) {
        if (blocks.length <= 1) {
            return true;
        }
        return Stream.of(blocks).map(request -> request.getRequest().getHttpHost(substitutor)).filter(StringUtil::isNotEmpty).distinct().count() > 1L;
    }

    private static boolean showMethods(HttpRequestBlock[] type) {
        if (type.length <= 1) {
            return true;
        }
        return Stream.of(type).map(request -> request.getRequest().getHttpMethod()).filter(StringUtil::isNotEmpty).distinct().count() > 1L;
    }

    @Nullable
    public TextAttributesKey getTextAttributesKey() {
        if (!this.myIsValid) {
            return CodeInsightColors.ERRORS_ATTRIBUTES;
        }
        return null;
    }

    @Nullable
    public String getPresentableText() {
        return this.myPresentationText;
    }

    public Icon getIcon(boolean open) {
        if (this.myIcon != null) {
            return this.myIcon;
        }
        return super.getIcon(open);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/structure/HttpRequestStructureViewElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/structure/HttpRequestStructureViewElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createRequest";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

