/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.httpClient.http.request.actions.HttpRequestBaseAction;
import com.intellij.httpClient.http.request.debug.HttpRequestDebugExecutorExtension;
import com.intellij.httpClient.http.request.debug.HttpRequestDebugger;
import com.intellij.httpClient.http.request.debug.HttpRequestDebuggerUtils;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironment;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.run.HttpRequestExecutorExtension;
import com.intellij.httpClient.http.request.run.HttpRequestExecutorExtensionFactory;
import com.intellij.httpClient.http.request.run.HttpRequestRunConfigurationExecutor;
import com.intellij.httpClient.http.request.run.config.HttpRequestExecutionConfig;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunConfiguration;
import com.intellij.httpClient.http.request.run.config.HttpRequestRuntimeConfigurationProducer;
import com.intellij.httpClient.http.request.run.config.HttpSingleRequestExecutionConfig;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class RunHttpRequestAction
extends HttpRequestBaseAction {
    private HttpRequestRunConfigurationExecutor myExecutor;
    private final HttpRequestExecutorExtension myExtension;
    protected final HttpRequestExecutionConfig myConfig;

    public RunHttpRequestAction(@NotNull HttpRequestExecutionConfig config, @Nullable String initialEnv, @Nullable HttpRequestExecutorExtension extension) {
        if (config == null) {
            RunHttpRequestAction.$$$reportNull$$$0(0);
        }
        this.myConfig = config;
        this.myExecutor = HttpRequestRunConfigurationExecutor.getInstance();
        this.myExtension = extension != null ? extension : HttpRequestExecutorExtensionFactory.getRunExtension();
        this.getTemplatePresentation().setText(this.getRunWithEnvironmentText(initialEnv), true);
        this.getTemplatePresentation().setIcon(this.myExtension.getIcon());
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunHttpRequestAction.$$$reportNull$$$0(1);
        }
        super.update(e);
        String text = this.getPresentationText(e.getProject());
        if (StringUtil.isNotEmpty((String)text)) {
            e.getPresentation().setText(text, true);
            e.getPresentation().setEnabledAndVisible(true);
        } else {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    @Nullable
    @NlsActions.ActionText
    protected abstract String getPresentationText(Project var1);

    @NotNull
    @NlsActions.ActionText
    protected String getRunWithEnvironmentText(@Nullable String initialEnv) {
        String string = this.myConfig.getActionDescription(this.myExtension.getActionName(), initialEnv);
        if (string == null) {
            RunHttpRequestAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @TestOnly
    protected void setExecutor(@NotNull HttpRequestRunConfigurationExecutor executor) {
        if (executor == null) {
            RunHttpRequestAction.$$$reportNull$$$0(3);
        }
        this.myExecutor = executor;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        RunnerAndConfigurationSettings runner;
        Project project;
        if (event == null) {
            RunHttpRequestAction.$$$reportNull$$$0(4);
        }
        if ((project = event.getProject()) == null) {
            return;
        }
        String environment = this.getSelectedEnvironment(project);
        HttpRequestEnvironment.setDefaultEnvName(project, environment);
        HttpRequestRuntimeConfigurationProducer producer = this.myConfig.getRuntimeConfigurationProducer();
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)event.getDataContext());
        if (context.getLocation() == null) {
            return;
        }
        boolean wasCreated = false;
        String customDebuggerName = RunHttpRequestAction.getNotDefaultDebuggerName(this.myExtension);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = runner = StringUtil.isEmpty((String)customDebuggerName) ? producer.findExistingConfigurationWithDefaultEnv(context) : null;
        if (runner == null) {
            ConfigurationFromContext fromContext = producer.createConfigurationFromContext(context);
            if (fromContext == null) {
                return;
            }
            wasCreated = true;
            runner = fromContext.getConfigurationSettings();
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        if (wasCreated) {
            RunConfiguration configuration = runner.getConfiguration();
            HttpRequestRunConfiguration.Settings settings = ((HttpRequestRunConfiguration)configuration).getSettings();
            if (!settings.isDefaultEnvironment()) {
                RunHttpRequestAction.updateEnvironment(settings, environment);
            }
            RunHttpRequestAction.updateDebugger(settings, this.myExtension);
            runManager.setUniqueNameIfNeeded(configuration);
            runner.setTemporary(true);
            runManager.addConfiguration(runner);
        }
        RunHttpRequestAction.updateSelectedRunConfiguration(runManager, runner);
        this.myExecutor.execute(project, runner, this.myExtension.getExecutor());
    }

    private static void updateEnvironment(@NotNull HttpRequestRunConfiguration.Settings settings, @Nullable String environment) {
        if (settings == null) {
            RunHttpRequestAction.$$$reportNull$$$0(5);
        }
        if (StringUtil.isNotEmpty((String)environment)) {
            settings.setEnvironment(environment);
        } else {
            settings.setNoEnvironment();
        }
    }

    private static void updateDebugger(@NotNull HttpRequestRunConfiguration.Settings settings, @NotNull HttpRequestExecutorExtension debug) {
        if (settings == null) {
            RunHttpRequestAction.$$$reportNull$$$0(6);
        }
        if (debug == null) {
            RunHttpRequestAction.$$$reportNull$$$0(7);
        }
        if (debug instanceof HttpRequestDebugExecutorExtension) {
            settings.setDebugger(((HttpRequestDebugExecutorExtension)debug).getDebuggerName());
        }
    }

    @Nullable
    private static String getNotDefaultDebuggerName(@NotNull HttpRequestExecutorExtension debug) {
        if (debug == null) {
            RunHttpRequestAction.$$$reportNull$$$0(8);
        }
        if (debug instanceof HttpRequestDebugExecutorExtension) {
            boolean isDefaultDebugger;
            String name = ((HttpRequestDebugExecutorExtension)debug).getDebuggerName();
            List<HttpRequestDebugger> allExtensions = HttpRequestDebuggerUtils.getAvailableDebuggerExtension();
            boolean bl = isDefaultDebugger = allExtensions.size() == 1 && name.equals(allExtensions.get(0).getPresentableName());
            if (!isDefaultDebugger) {
                return name;
            }
        }
        return null;
    }

    private static void updateSelectedRunConfiguration(@NotNull RunManager runManager, @NotNull RunnerAndConfigurationSettings runner) {
        RunnerAndConfigurationSettings selectedRunner;
        if (runManager == null) {
            RunHttpRequestAction.$$$reportNull$$$0(9);
        }
        if (runner == null) {
            RunHttpRequestAction.$$$reportNull$$$0(10);
        }
        if (((selectedRunner = runManager.getSelectedConfiguration()) == null || selectedRunner.isTemporary()) && Registry.is((String)"select.run.configuration.from.context")) {
            runManager.setSelectedConfiguration(runner);
        }
    }

    @Nullable
    public abstract String getSelectedEnvironment(@NotNull Project var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/RunHttpRequestAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debug";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/RunHttpRequestAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunWithEnvironmentText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setExecutor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateEnvironment";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateDebugger";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNotDefaultDebuggerName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectedRunConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RunRequestWithoutEnvAction
    extends RunHttpRequestAction {
        private static final String ID = "HTTPClient.RunWithoutEnv";

        public RunRequestWithoutEnvAction(@NotNull HttpRequestExecutionConfig config, @Nullable HttpRequestExecutorExtension extension) {
            if (config == null) {
                RunRequestWithoutEnvAction.$$$reportNull$$$0(0);
            }
            super(config, null, extension);
        }

        public String getId() {
            return ID;
        }

        @Override
        protected String getPresentationText(Project project) {
            return this.getTemplatePresentation().getText();
        }

        @Override
        public String getSelectedEnvironment(@NotNull Project project) {
            if (project == null) {
                RunRequestWithoutEnvAction.$$$reportNull$$$0(1);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/httpClient/http/request/run/RunHttpRequestAction$RunRequestWithoutEnvAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedEnvironment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class RunRequestWithDefaultEnvAction
    extends RunHttpRequestAction {
        private static final String ID = "HTTPClient.RunWithDefaultEnv";

        public RunRequestWithDefaultEnvAction(@NotNull HttpRequest request) {
            if (request == null) {
                RunRequestWithDefaultEnvAction.$$$reportNull$$$0(0);
            }
            super(new HttpSingleRequestExecutionConfig(request), null, null);
        }

        public RunRequestWithDefaultEnvAction(@NotNull HttpRequestExecutionConfig config, @Nullable HttpRequestExecutorExtension extension) {
            if (config == null) {
                RunRequestWithDefaultEnvAction.$$$reportNull$$$0(1);
            }
            super(config, null, extension);
        }

        public String getId() {
            return ID;
        }

        @Override
        protected String getPresentationText(Project project) {
            String defaultEnv = project != null ? HttpRequestEnvironment.getDefaultEnvName(project) : null;
            return StringUtil.isNotEmpty((String)defaultEnv) ? this.getRunWithEnvironmentText(defaultEnv) : null;
        }

        @Override
        public String getSelectedEnvironment(@NotNull Project project) {
            if (project == null) {
                RunRequestWithDefaultEnvAction.$$$reportNull$$$0(2);
            }
            return HttpRequestEnvironment.getDefaultEnvName(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/httpClient/http/request/run/RunHttpRequestAction$RunRequestWithDefaultEnvAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedEnvironment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class RunRequestWithEnvAction
    extends RunHttpRequestAction {
        private static final String ID = "HTTPClient.RunWithSelectedEnv";
        private final String myEnvironment;

        public RunRequestWithEnvAction(@NotNull HttpRequestExecutionConfig config, @Nullable String environment, @Nullable HttpRequestExecutorExtension extension) {
            if (config == null) {
                RunRequestWithEnvAction.$$$reportNull$$$0(0);
            }
            super(config, environment, extension);
            this.myEnvironment = environment;
        }

        @Override
        protected String getPresentationText(Project project) {
            boolean isAvailable = project == null || StringUtil.isEmpty((String)this.myEnvironment) || !StringUtil.equals((CharSequence)this.myEnvironment, (CharSequence)HttpRequestEnvironment.getDefaultEnvName(project));
            return isAvailable ? this.getTemplatePresentation().getText() : null;
        }

        public String getId() {
            return ID;
        }

        @Override
        public String getSelectedEnvironment(@NotNull Project project) {
            if (project == null) {
                RunRequestWithEnvAction.$$$reportNull$$$0(1);
            }
            return this.myEnvironment;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/httpClient/http/request/run/RunHttpRequestAction$RunRequestWithEnvAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedEnvironment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

