/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.psi;

import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.psi.HttpQuery;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestTarget;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.FakePsiElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestWebReference
extends WebReference {
    public HttpRequestWebReference(@NotNull PsiElement element, @Nullable String host) {
        if (element == null) {
            HttpRequestWebReference.$$$reportNull$$$0(0);
        }
        super(element, host);
    }

    public PsiElement resolve() {
        PsiElement parent = this.getElement().getParent();
        if (parent instanceof HttpRequest) {
            PsiFile contextFile = parent.getContainingFile();
            HttpRequestVariableSubstitutor substitutor = HttpRequestVariableSubstitutor.getDefault(parent.getProject(), contextFile);
            String url = ((HttpRequest)parent).getHttpUrl(substitutor);
            if (StringUtil.isNotEmpty((String)url)) {
                HttpRequestTarget target = ((HttpRequest)parent).getRequestTarget();
                return new HttpRequestFakePsiElement(url + (target != null ? HttpRequestWebReference.getQueryString(target.getQuery(), substitutor) : ""));
            }
        }
        return null;
    }

    protected TextRange calculateDefaultRangeInElement() {
        return new TextRange(0, this.getElement().getTextLength());
    }

    @NotNull
    public static String getQueryString(@Nullable HttpQuery query, @NotNull HttpRequestVariableSubstitutor substitutor) {
        List<Object> parameters;
        if (substitutor == null) {
            HttpRequestWebReference.$$$reportNull$$$0(1);
        }
        List<Object> list = parameters = query != null ? query.getQueryParameterList() : Collections.emptyList();
        if (parameters.isEmpty()) {
            return "";
        }
        String string = "?" + StringUtil.join(parameters, parameter -> {
            String key2 = parameter.getKey(substitutor);
            String value = parameter.getValue(substitutor);
            return StringUtil.notNullize((String)key2) + "=" + StringUtil.notNullize((String)value);
        }, (String)"&");
        if (string == null) {
            HttpRequestWebReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/psi/HttpRequestWebReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/psi/HttpRequestWebReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueryString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getQueryString";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class HttpRequestFakePsiElement
    extends FakePsiElement {
        private final String myFullUrl;

        public HttpRequestFakePsiElement(String fullUrl) {
            this.myFullUrl = fullUrl;
        }

        public PsiElement getParent() {
            return HttpRequestWebReference.this.myElement;
        }

        public void navigate(boolean requestFocus) {
            BrowserUtil.browse((String)this.myFullUrl);
        }

        public String getPresentableText() {
            return this.myFullUrl;
        }

        public String getName() {
            return this.myFullUrl;
        }

        public TextRange getTextRange() {
            TextRange rangeInElement = HttpRequestWebReference.this.getRangeInElement();
            TextRange elementRange = HttpRequestWebReference.this.myElement.getTextRange();
            return elementRange != null ? rangeInElement.shiftRight(elementRange.getStartOffset()) : rangeInElement;
        }
    }
}

