/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.notification;

import com.intellij.codeInsight.intention.IntentionActionWithOptions;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpClientDataKeys;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpClientNotificationPanel
extends EditorNotificationPanel
implements DataProvider {
    private final VirtualFile myHttpRequestFile;
    private final HyperlinkLabel myExamplesHyperlinkLabel;
    private final HyperlinkLabel myAddRequestHyperlinkLabel;
    private final HyperlinkLabel myRunAllRequestsHyperlinkLabel;
    private final HyperlinkLabel myCreateEnvFileHyperlinkLabel;
    @NotNull
    private final HyperlinkLabel myConvertFromHyperlinkLabel;

    public HttpClientNotificationPanel(@NotNull VirtualFile httpRequestFile) {
        if (httpRequestFile == null) {
            HttpClientNotificationPanel.$$$reportNull$$$0(0);
        }
        this.myHttpRequestFile = httpRequestFile;
        this.myAddRequestHyperlinkLabel = this.createActionLabel(RestClientBundle.message("action.HTTPClient.AddRequest.notification.label", new Object[0]), "HTTPClient.AddRequest");
        this.myCreateEnvFileHyperlinkLabel = this.createActionLabel(RestClientBundle.message("http.request.create.new.environment.file.action.toolbar", new Object[0]), "HTTPClientNewEnvironmentFile");
        this.myConvertFromHyperlinkLabel = this.createActionLabel(RestClientBundle.message("http.request.convert.from.toolbar", new Object[0]), "HTTPClient.Convert");
        this.createActionLabel(RestClientBundle.message("http.request.show.log.file.action.toolbar", new Object[0]), "RESTClient.ShowHistory").setToolTipText(RestClientBundle.message("action.RESTClient.ShowHistory.text", new Object[0]));
        this.myExamplesHyperlinkLabel = this.createActionLabel(RestClientBundle.message("http.request.open.requests.collection.action.toolbar", new Object[0]), "HTTPClient.OpenCollection");
        this.myExamplesHyperlinkLabel.setToolTipText(RestClientBundle.message("action.HTTPClient.OpenCollection.text", new Object[0]));
        this.myRunAllRequestsHyperlinkLabel = this.createRunAllActionLabel();
    }

    public Color getBackground() {
        return EditorNotificationPanel.getToolbarBackground();
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            HttpClientNotificationPanel.$$$reportNull$$$0(1);
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return this.myHttpRequestFile;
        }
        if (HttpClientDataKeys.EXAMPLES_TOOLBAR_HYPERLINK_LABEL.is(dataId)) {
            return this.myExamplesHyperlinkLabel;
        }
        if (HttpClientDataKeys.ADD_REQUEST_TOOLBAR_HYPERLINK_LABEL.is(dataId)) {
            return this.myAddRequestHyperlinkLabel;
        }
        if (HttpClientDataKeys.RUN_ALL_TOOLBAR_HYPERLINK_LABEL.is(dataId)) {
            return this.myRunAllRequestsHyperlinkLabel;
        }
        if (HttpClientDataKeys.CREATE_ENV_FILE_HYPERLINK_LABEL.is(dataId)) {
            return this.myCreateEnvFileHyperlinkLabel;
        }
        if (HttpClientDataKeys.CONVERT_FROM_HYPERLINK_LABEL.is(dataId)) {
            return this.myConvertFromHyperlinkLabel;
        }
        return null;
    }

    @NotNull
    private HyperlinkLabel createRunAllActionLabel() {
        HyperlinkLabel label = new HyperlinkLabel(RestClientBundle.message("action.HTTPClient.RunAll.text.in.notification", new Object[0]), this.getBackground());
        label.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                HttpClientNotificationPanel.this.executeAction("HTTPClient.RunAll");
            }
        });
        label.setToolTipText(RestClientBundle.message("action.HTTPClient.RunAll.text", new Object[0]));
        label.setIcon(AllIcons.Actions.RunAll);
        this.add("West", (Component)label);
        HyperlinkLabel hyperlinkLabel = label;
        if (hyperlinkLabel == null) {
            HttpClientNotificationPanel.$$$reportNull$$$0(2);
        }
        return hyperlinkLabel;
    }

    @NotNull
    protected String getActionPlace() {
        return "HttpClient.NotificationPanel";
    }

    @Nullable
    public IntentionActionWithOptions getIntentionAction() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "httpRequestFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/notification/HttpClientNotificationPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/notification/HttpClientNotificationPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createRunAllActionLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

