/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.environment.secrets;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.environment.HttpRequestIndex;
import com.intellij.httpClient.http.request.environment.secrets.HttpRequestEnvironmentPasswordSafeSecretsManager$cleanFromWhitespaces$;
import com.intellij.httpClient.http.request.environment.secrets.HttpRequestEnvironmentSecretsManager;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002JA\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\b\b\u0001\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\b0\u0016H\u0082\bJ,\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\b\b\u0001\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\u0019\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0011H\u0002J*\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\b\b\u0001\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\u001c\u001a\u00020\u001d*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/httpClient/http/request/environment/secrets/HttpRequestEnvironmentPasswordSafeSecretsManager;", "Lcom/intellij/httpClient/http/request/environment/secrets/HttpRequestEnvironmentSecretsManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "jsonElementGenerator", "Lcom/intellij/json/psi/JsonElementGenerator;", "cleanFromNonExistentEnvironments", "", "secretsObject", "Lcom/intellij/json/psi/JsonObject;", "isScratch", "", "cleanFromWhitespaces", "credentialAttributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "getOrCreateSecret", "", "envName", "valueName", "presentableName", "actionIfAlreadyHasSecret", "Lkotlin/Function1;", "Lcom/intellij/json/psi/JsonStringLiteral;", "getSecret", "getSecretObject", "secrets", "setSecret", "getValueOrCreateProperty", "Lcom/intellij/json/psi/JsonValue;", "propertyName", "intellij.restClient"})
public final class HttpRequestEnvironmentPasswordSafeSecretsManager
implements HttpRequestEnvironmentSecretsManager {
    private final JsonElementGenerator jsonElementGenerator;
    private final Project project;

    @Override
    @Nullable
    public String getSecret(@NotNull String envName, @NotNull String valueName, @Nls @NotNull String presentableName, boolean isScratch) {
        Intrinsics.checkNotNullParameter((Object)envName, (String)"envName");
        Intrinsics.checkNotNullParameter((Object)valueName, (String)"valueName");
        Intrinsics.checkNotNullParameter((Object)presentableName, (String)"presentableName");
        HttpRequestEnvironmentPasswordSafeSecretsManager this_$iv = this;
        boolean $i$f$getOrCreateSecret = false;
        CredentialAttributes attributes$iv = this_$iv.credentialAttributes(isScratch);
        String secrets$iv = PasswordSafe.Companion.getInstance().getPassword(attributes$iv);
        JsonObject secretsObject$iv = this_$iv.getSecretObject(secrets$iv);
        JsonValue requestedSecret$iv = this_$iv.getValueOrCreateProperty(this_$iv.getValueOrCreateProperty((JsonValue)secretsObject$iv, envName), valueName);
        if (requestedSecret$iv instanceof JsonStringLiteral) {
            JsonStringLiteral it = (JsonStringLiteral)requestedSecret$iv;
            boolean bl = false;
            return ElementManipulators.getValueText((PsiElement)((PsiElement)it));
        }
        String newSecretValue$iv = Messages.showPasswordDialog((String)RestClientBundle.message("http.request.secrets.dialog.message", presentableName), (String)RestClientBundle.message("http.request.secrets.dialog.title", new Object[0]));
        if (newSecretValue$iv != null) {
            requestedSecret$iv.replace((PsiElement)this_$iv.jsonElementGenerator.createStringLiteral(newSecretValue$iv));
            this_$iv.cleanFromNonExistentEnvironments(secretsObject$iv, isScratch);
            this_$iv.cleanFromWhitespaces(secretsObject$iv);
            PasswordSafe.Companion.getInstance().setPassword(attributes$iv, secretsObject$iv.getText());
        }
        return newSecretValue$iv;
    }

    @Override
    public void setSecret(@NotNull String envName, @NotNull String valueName, @Nls @NotNull String presentableName, boolean isScratch) {
        String newSecretValue$iv;
        Intrinsics.checkNotNullParameter((Object)envName, (String)"envName");
        Intrinsics.checkNotNullParameter((Object)valueName, (String)"valueName");
        Intrinsics.checkNotNullParameter((Object)presentableName, (String)"presentableName");
        HttpRequestEnvironmentPasswordSafeSecretsManager this_$iv = this;
        boolean $i$f$getOrCreateSecret = false;
        CredentialAttributes attributes$iv = this_$iv.credentialAttributes(isScratch);
        String secrets$iv = PasswordSafe.Companion.getInstance().getPassword(attributes$iv);
        JsonObject secretsObject$iv = this_$iv.getSecretObject(secrets$iv);
        JsonValue requestedSecret$iv = this_$iv.getValueOrCreateProperty(this_$iv.getValueOrCreateProperty((JsonValue)secretsObject$iv, envName), valueName);
        if (requestedSecret$iv instanceof JsonStringLiteral) {
            JsonStringLiteral it = (JsonStringLiteral)requestedSecret$iv;
            boolean bl = false;
        }
        if ((newSecretValue$iv = Messages.showPasswordDialog((String)RestClientBundle.message("http.request.secrets.dialog.message", presentableName), (String)RestClientBundle.message("http.request.secrets.dialog.title", new Object[0]))) != null) {
            requestedSecret$iv.replace((PsiElement)this_$iv.jsonElementGenerator.createStringLiteral(newSecretValue$iv));
            this_$iv.cleanFromNonExistentEnvironments(secretsObject$iv, isScratch);
            this_$iv.cleanFromWhitespaces(secretsObject$iv);
            PasswordSafe.Companion.getInstance().setPassword(attributes$iv, secretsObject$iv.getText());
        }
    }

    private final String getOrCreateSecret(String envName, String valueName, @Nls String presentableName, boolean isScratch, Function1<? super JsonStringLiteral, Unit> actionIfAlreadyHasSecret) {
        String newSecretValue;
        int $i$f$getOrCreateSecret = 0;
        CredentialAttributes attributes = this.credentialAttributes(isScratch);
        String secrets = PasswordSafe.Companion.getInstance().getPassword(attributes);
        JsonObject secretsObject = this.getSecretObject(secrets);
        JsonValue requestedSecret = this.getValueOrCreateProperty(this.getValueOrCreateProperty((JsonValue)secretsObject, envName), valueName);
        if (requestedSecret instanceof JsonStringLiteral) {
            actionIfAlreadyHasSecret.invoke((Object)requestedSecret);
        }
        if ((newSecretValue = Messages.showPasswordDialog((String)RestClientBundle.message("http.request.secrets.dialog.message", presentableName), (String)RestClientBundle.message("http.request.secrets.dialog.title", new Object[0]))) != null) {
            requestedSecret.replace((PsiElement)this.jsonElementGenerator.createStringLiteral(newSecretValue));
            this.cleanFromNonExistentEnvironments(secretsObject, isScratch);
            this.cleanFromWhitespaces(secretsObject);
            PasswordSafe.Companion.getInstance().setPassword(attributes, secretsObject.getText());
        }
        return newSecretValue;
    }

    private final CredentialAttributes credentialAttributes(boolean isScratch) {
        String string;
        if (!isScratch) {
            string = ProjectUtil.guessProjectDir((Project)this.project);
            if (string == null || (string = string.getPresentableUrl()) == null) {
                string = this.project.getName();
            }
        } else {
            string = "Scratches";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (!isScratch) project.\u2026ect.name else \"Scratches\"");
        String projectId = string;
        String serviceName = CredentialAttributesKt.generateServiceName((String)"HTTP Client", (String)projectId);
        return new CredentialAttributes(serviceName, null, null, false, 14, null);
    }

    private final JsonObject getSecretObject(String secrets) {
        JsonObject jsonObject;
        JsonValue jsonValue;
        String string = secrets;
        if (string == null) {
            string = "{}";
        }
        if (!((jsonValue = this.jsonElementGenerator.createValue(string)) instanceof JsonObject)) {
            jsonValue = null;
        }
        JsonObject jsonObject2 = (JsonObject)jsonValue;
        boolean bl = false;
        boolean bl2 = false;
        JsonObject it = jsonObject2;
        boolean bl3 = false;
        if (it == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(HttpRequestEnvironmentPasswordSafeSecretsManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.warn("Secrets is not a valid JSON");
        }
        if ((jsonObject = jsonObject2) == null) {
            JsonObject jsonObject3 = this.jsonElementGenerator.createObject("");
            jsonObject = jsonObject3;
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject3, (String)"jsonElementGenerator.createObject(\"\")");
        }
        return jsonObject;
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanFromNonExistentEnvironments(JsonObject secretsObject, boolean isScratch) {
        void $this$filterTo$iv$iv;
        GlobalSearchScope globalSearchScope = isScratch ? ScratchesSearchScope.getScratchesScope((Project)this.project) : GlobalSearchScope.projectScope((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"if (isScratch) Scratches\u2026ope.projectScope(project)");
        GlobalSearchScope scope = globalSearchScope;
        Collection<String> collection = HttpRequestIndex.getAllEnvironments(this.project, scope);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"HttpRequestIndex.getAllE\u2026ironments(project, scope)");
        Set existingEnvs = CollectionsKt.toSet((Iterable)collection);
        PsiElement psiElement = this.jsonElementGenerator.createComma();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"jsonElementGenerator.createComma()");
        PsiElement comma = psiElement;
        List list = secretsObject.getPropertyList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"secretsObject.propertyList");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JsonProperty it = (JsonProperty)element$iv$iv;
            boolean bl = false;
            JsonProperty jsonProperty = it;
            Intrinsics.checkNotNullExpressionValue((Object)jsonProperty, (String)"it");
            if (!(!existingEnvs.contains(jsonProperty.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator iterator = ((List)destination$iv$iv).iterator();
        while (iterator.hasNext()) {
            JsonProperty jsonProperty;
            JsonProperty jsonProperty2 = jsonProperty = (JsonProperty)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)jsonProperty2, (String)"jsonProperty");
            PsiElement commaAfter = jsonProperty2.getNextSibling();
            PsiElement commaBefore = jsonProperty.getPrevSibling();
            jsonProperty.delete();
            if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)commaAfter), (Object)PsiTreeUtilKt.getElementType((PsiElement)comma))) {
                commaAfter.delete();
                continue;
            }
            if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)commaBefore), (Object)PsiTreeUtilKt.getElementType((PsiElement)comma))) continue;
            commaBefore.delete();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanFromWhitespaces(JsonObject secretsObject) {
        void $this$descendantsOfType$iv;
        PsiElement psiElement = (PsiElement)secretsObject;
        boolean childrenFirst$iv = true;
        boolean $i$f$descendantsOfType = false;
        Sequence $this$filterIsInstance$iv$iv = PsiTreeUtilKt.descendants$default((PsiElement)$this$descendantsOfType$iv, (boolean)childrenFirst$iv, null, (int)2, null);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)cleanFromWhitespaces$$inlined$descendantsOfType$1.INSTANCE);
        if (sequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        for (PsiWhiteSpace whiteSpace : SequencesKt.toList((Sequence)sequence)) {
            whiteSpace.delete();
        }
    }

    private final JsonValue getValueOrCreateProperty(JsonValue $this$getValueOrCreateProperty, String propertyName) {
        if (!($this$getValueOrCreateProperty instanceof JsonObject)) {
            JsonProperty jsonProperty = this.jsonElementGenerator.createProperty(propertyName, "{}");
            Intrinsics.checkNotNullExpressionValue((Object)jsonProperty, (String)"jsonElementGenerator.cre\u2026perty(propertyName, \"{}\")");
            JsonProperty property = jsonProperty;
            PsiElement psiElement = $this$getValueOrCreateProperty.replace((PsiElement)this.jsonElementGenerator.createObject(property.toString()));
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.json.psi.JsonObject");
            }
            JsonObject newObject = (JsonObject)psiElement;
            JsonProperty jsonProperty2 = newObject.findProperty(propertyName);
            Intrinsics.checkNotNull((Object)jsonProperty2);
            Intrinsics.checkNotNullExpressionValue((Object)jsonProperty2, (String)"newObject.findProperty(propertyName)!!");
            JsonValue jsonValue = jsonProperty2.getValue();
            Intrinsics.checkNotNull((Object)jsonValue);
            return jsonValue;
        }
        JsonProperty property = ((JsonObject)$this$getValueOrCreateProperty).findProperty(propertyName);
        JsonProperty jsonProperty = property;
        if (jsonProperty != null && (jsonProperty = jsonProperty.getValue()) != null) {
            JsonProperty newObject = jsonProperty;
            boolean bl = false;
            boolean bl2 = false;
            JsonProperty it = newObject;
            boolean bl3 = false;
            JsonProperty jsonProperty3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)jsonProperty3, (String)"it");
            return jsonProperty3;
        }
        if (property != null) {
            JsonValue jsonValue = property.getValue();
            if (jsonValue != null && (jsonValue = jsonValue.replace((PsiElement)this.jsonElementGenerator.createObject(""))) != null) {
                JsonValue newObject = jsonValue;
                boolean bl = false;
                boolean bl4 = false;
                JsonValue it = newObject;
                boolean bl5 = false;
                JsonValue jsonValue2 = it;
                if (jsonValue2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.json.psi.JsonValue");
                }
                return jsonValue2;
            }
            PsiElement psiElement = property.replace((PsiElement)this.jsonElementGenerator.createProperty(property.getName(), "{}"));
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.json.psi.JsonProperty");
            }
            JsonProperty replacedProperty = (JsonProperty)psiElement;
            JsonValue jsonValue3 = replacedProperty.getValue();
            if (jsonValue3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.json.psi.JsonValue");
            }
            return jsonValue3;
        }
        PsiElement elementBeforeToNew = PsiTreeUtil.skipWhitespacesBackward((PsiElement)((JsonObject)$this$getValueOrCreateProperty).getLastChild());
        PsiElement psiElement = this.jsonElementGenerator.createComma();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"jsonElementGenerator.createComma()");
        PsiElement comma = psiElement;
        if (elementBeforeToNew != null && Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)elementBeforeToNew), (Object)PsiTreeUtilKt.getElementType((PsiElement)comma)) ^ true && Intrinsics.areEqual((Object)elementBeforeToNew, (Object)((JsonObject)$this$getValueOrCreateProperty).getFirstChild()) ^ true) {
            $this$getValueOrCreateProperty.addBefore(comma, ((JsonObject)$this$getValueOrCreateProperty).getLastChild());
        }
        JsonProperty jsonProperty4 = this.jsonElementGenerator.createProperty(propertyName, "{}");
        Intrinsics.checkNotNullExpressionValue((Object)jsonProperty4, (String)"jsonElementGenerator.cre\u2026perty(propertyName, \"{}\")");
        JsonProperty newProperty = jsonProperty4;
        PsiElement psiElement2 = $this$getValueOrCreateProperty.addBefore((PsiElement)newProperty, ((JsonObject)$this$getValueOrCreateProperty).getLastChild());
        if (psiElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.json.psi.JsonProperty");
        }
        JsonValue jsonValue = ((JsonProperty)psiElement2).getValue();
        if (jsonValue == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.json.psi.JsonValue");
        }
        return jsonValue;
    }

    public HttpRequestEnvironmentPasswordSafeSecretsManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.jsonElementGenerator = new JsonElementGenerator(this.project);
    }
}

