/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.environment;

import com.intellij.httpClient.http.request.environment.HttpRequestEnvironmentIndex;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequestIndex {
    @NotNull
    public static Collection<String> getAllEnvironments(@NotNull Project project, @Nullable PsiFile contextFile) {
        if (project == null) {
            HttpRequestIndex.$$$reportNull$$$0(0);
        }
        return HttpRequestIndex.getAllEnvironments(project, HttpRequestIndex.getSearchScope(project, contextFile));
    }

    @NotNull
    public static Collection<String> getAllEnvironments(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            HttpRequestIndex.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            HttpRequestIndex.$$$reportNull$$$0(2);
        }
        FileBasedIndex index = FileBasedIndex.getInstance();
        Collection collection = index.getAllKeys(HttpRequestEnvironmentIndex.INDEX_ID, project).stream().filter(env -> !index.getContainingFiles(HttpRequestEnvironmentIndex.INDEX_ID, env, scope).isEmpty()).collect(Collectors.toSet());
        if (collection == null) {
            HttpRequestIndex.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public static Collection<VirtualFile> getEnvironmentFiles(@NotNull Project project, @NotNull String env, @Nullable PsiFile contextFile) {
        if (project == null) {
            HttpRequestIndex.$$$reportNull$$$0(4);
        }
        if (env == null) {
            HttpRequestIndex.$$$reportNull$$$0(5);
        }
        GlobalSearchScope scope = HttpRequestIndex.getSearchScope(project, contextFile);
        return FileBasedIndex.getInstance().getContainingFiles(HttpRequestEnvironmentIndex.INDEX_ID, (Object)env, scope);
    }

    @NotNull
    public static Collection<String> getAllVariables(@NotNull Project project, @Nullable PsiFile contextFile) {
        GlobalSearchScope scope;
        Collection<String> environments;
        if (project == null) {
            HttpRequestIndex.$$$reportNull$$$0(6);
        }
        if ((environments = HttpRequestIndex.getAllEnvironments(project, scope = HttpRequestIndex.getSearchScope(project, contextFile))).isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                HttpRequestIndex.$$$reportNull$$$0(7);
            }
            return set;
        }
        HashSet<String> variables = new HashSet<String>();
        for (String env : environments) {
            List varsInEnv = FileBasedIndex.getInstance().getValues(HttpRequestEnvironmentIndex.INDEX_ID, (Object)env, scope);
            for (Set vars : varsInEnv) {
                variables.addAll(vars);
            }
        }
        HashSet<String> hashSet = variables;
        if (hashSet == null) {
            HttpRequestIndex.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @NotNull
    public static Stream<String> getAllVariables(@NotNull Project project, @NotNull String env, @Nullable PsiFile contextFile) {
        if (project == null) {
            HttpRequestIndex.$$$reportNull$$$0(9);
        }
        if (env == null) {
            HttpRequestIndex.$$$reportNull$$$0(10);
        }
        List variables = FileBasedIndex.getInstance().getValues(HttpRequestEnvironmentIndex.INDEX_ID, (Object)env, HttpRequestIndex.getSearchScope(project, contextFile));
        Stream<String> stream = variables.stream().flatMap(Collection::stream).distinct();
        if (stream == null) {
            HttpRequestIndex.$$$reportNull$$$0(11);
        }
        return stream;
    }

    @NotNull
    public static GlobalSearchScope getSearchScope(@NotNull Project project, @Nullable PsiFile contextFile) {
        PsiDirectory parent;
        if (project == null) {
            HttpRequestIndex.$$$reportNull$$$0(12);
        }
        GlobalSearchScope projectScope = ProjectScope.getContentScope((Project)project);
        VirtualFile context = PsiUtilCore.getVirtualFile((PsiElement)contextFile);
        if (contextFile != null && context != null && !ScratchUtil.isScratch((VirtualFile)context) && !projectScope.contains(context) && (parent = contextFile.getParent()) != null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoryScope((PsiDirectory)parent, (boolean)false);
            if (globalSearchScope == null) {
                HttpRequestIndex.$$$reportNull$$$0(13);
            }
            return globalSearchScope;
        }
        if (ScratchUtil.isScratch((VirtualFile)context)) {
            GlobalSearchScope globalSearchScope = projectScope.uniteWith(ScratchesSearchScope.getScratchesScope((Project)project));
            if (globalSearchScope == null) {
                HttpRequestIndex.$$$reportNull$$$0(14);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = projectScope;
        if (globalSearchScope == null) {
            HttpRequestIndex.$$$reportNull$$$0(15);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/environment/HttpRequestIndex";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/environment/HttpRequestIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllEnvironments";
                break;
            }
            case 7: 
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllVariables";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllEnvironments";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironmentFiles";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAllVariables";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSearchScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

