/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.ssl;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.ssl.HttpRequestSslConfigurationException;
import com.intellij.httpClient.execution.ssl.MySSLContextBuilder;
import com.intellij.httpClient.execution.ssl.SslCertStore;
import com.intellij.httpClient.execution.ssl.SslCertificate;
import com.intellij.httpClient.execution.ssl.SslCertificatePrivateKey;
import com.intellij.httpClient.execution.ssl.SslConfigurationContext;
import com.intellij.httpClient.execution.ssl.SslErrorDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import java.security.KeyStore;
import java.security.PrivateKey;
import javax.net.ssl.SSLContext;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H!\u0082\u0001\u0002\u0007\b\u00a8\u0006\t"}, d2={"Lcom/intellij/httpClient/execution/ssl/SslConfiguration;", "", "()V", "toSSLContext", "Ljavax/net/ssl/SSLContext;", "Configured", "Error", "Lcom/intellij/httpClient/execution/ssl/SslConfiguration$Error;", "Lcom/intellij/httpClient/execution/ssl/SslConfiguration$Configured;", "intellij.restClient"})
public abstract class SslConfiguration {
    @JvmName(name="toSSLContext")
    @NotNull
    public abstract SSLContext toSSLContext() throws HttpRequestSslConfigurationException;

    private SslConfiguration() {
    }

    public /* synthetic */ SslConfiguration(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\r\u0010\u000f\u001a\u00020\u0010H\u0010\u00a2\u0006\u0002\b\u0011J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/intellij/httpClient/execution/ssl/SslConfiguration$Error;", "Lcom/intellij/httpClient/execution/ssl/SslConfiguration;", "error", "", "(Ljava/lang/String;)V", "getError", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toSSLContext", "Ljavax/net/ssl/SSLContext;", "toSSLContext$intellij_restClient", "toString", "intellij.restClient"})
    public static final class Error
    extends SslConfiguration {
        @NotNull
        private final String error;

        @NotNull
        public SSLContext toSSLContext$intellij_restClient() throws HttpRequestSslConfigurationException {
            throw (Throwable)new HttpRequestSslConfigurationException(this.error, null, 2, null);
        }

        @NotNull
        public final String getError() {
            return this.error;
        }

        public Error(@Nls @NotNull String error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            super(null);
            this.error = error;
        }

        @NotNull
        public final String component1() {
            return this.error;
        }

        @NotNull
        public final Error copy(@Nls @NotNull String error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            return new Error(error);
        }

        public static /* synthetic */ Error copy$default(Error error, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = error.error;
            }
            return error.copy(string);
        }

        @NotNull
        public String toString() {
            return "Error(error=" + this.error + ")";
        }

        public int hashCode() {
            String string = this.error;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Error)) break block3;
                    Error error = (Error)object;
                    if (!Intrinsics.areEqual((Object)this.error, (Object)error.error)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u000bH\u00c2\u0003JA\u0010\u001a\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\r\u0010 \u001a\u00020!H\u0010\u00a2\u0006\u0002\b\"J\t\u0010#\u001a\u00020\tH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006$"}, d2={"Lcom/intellij/httpClient/execution/ssl/SslConfiguration$Configured;", "Lcom/intellij/httpClient/execution/ssl/SslConfiguration;", "certificate", "Lcom/intellij/httpClient/execution/ssl/SslCertificate;", "key", "Lcom/intellij/httpClient/execution/ssl/SslCertificatePrivateKey;", "insecureSslConnection", "", "passphrase", "", "context", "Lcom/intellij/httpClient/execution/ssl/SslConfigurationContext;", "(Lcom/intellij/httpClient/execution/ssl/SslCertificate;Lcom/intellij/httpClient/execution/ssl/SslCertificatePrivateKey;ZLjava/lang/String;Lcom/intellij/httpClient/execution/ssl/SslConfigurationContext;)V", "getCertificate", "()Lcom/intellij/httpClient/execution/ssl/SslCertificate;", "getInsecureSslConnection", "()Z", "getKey", "()Lcom/intellij/httpClient/execution/ssl/SslCertificatePrivateKey;", "getPassphrase", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "toSSLContext", "Ljavax/net/ssl/SSLContext;", "toSSLContext$intellij_restClient", "toString", "intellij.restClient"})
    public static final class Configured
    extends SslConfiguration {
        @Nullable
        private final SslCertificate certificate;
        @Nullable
        private final SslCertificatePrivateKey key;
        private final boolean insecureSslConnection;
        @Nullable
        private final String passphrase;
        private final SslConfigurationContext context;

        @NotNull
        public SSLContext toSSLContext$intellij_restClient() throws HttpRequestSslConfigurationException {
            Object object;
            KeyStore keyStore;
            SslCertificate sslCertificate = this.certificate;
            if (sslCertificate != null) {
                Object object2;
                SslCertificate sslCertificate2 = sslCertificate;
                boolean bl = false;
                try {
                    object2 = Result.Companion;
                    SslCertificate $this$runCatching = sslCertificate2;
                    boolean $i$a$-runCatching-SslConfiguration$Configured$toSSLContext$keyStore$22 = false;
                    SslCertStore keyStore2 = $this$runCatching.readCertificateToKeyStore$intellij_restClient(this.context, this.passphrase);
                    if (this.key != null && !keyStore2.getHasKeyByDefault()) {
                        PrivateKey privateKey = this.key.convertToJavaPrivateKey$intellij_restClient(this.context, this.passphrase);
                        if (privateKey != null) {
                            PrivateKey privateKey2 = privateKey;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            PrivateKey it = privateKey2;
                            boolean bl4 = false;
                            keyStore2.addPrivateKey(it, this.passphrase);
                        }
                    } else if (this.key != null && keyStore2.getHasKeyByDefault()) {
                        String string = RestClientBundle.message("http.request.ssl.cert.file.already.contains.key.error", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RestClientBundle.message\u2026eady.contains.key.error\")");
                        throw (Throwable)new HttpRequestSslConfigurationException(this.context.getErrorMessage(SslErrorDescriptor.KEY, string), null, 2, null);
                    }
                    KeyStore keyStore3 = keyStore2.getKeyStore();
                    $i$a$-runCatching-SslConfiguration$Configured$toSSLContext$keyStore$22 = false;
                    object2 = Result.constructor-impl((Object)keyStore3);
                }
                catch (Throwable throwable) {
                    Result.Companion $i$a$-runCatching-SslConfiguration$Configured$toSSLContext$keyStore$22 = Result.Companion;
                    boolean keyStore2 = false;
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                Object $this$getOrRethrowSslException$iv = object2;
                boolean $i$f$getOrRethrowSslException = false;
                object2 = $this$getOrRethrowSslException$iv;
                boolean bl5 = false;
                boolean $i$a$-runCatching-SslConfiguration$Configured$toSSLContext$keyStore$22 = false;
                Throwable $i$a$-runCatching-SslConfiguration$Configured$toSSLContext$keyStore$22 = Result.exceptionOrNull-impl((Object)object2);
                if ($i$a$-runCatching-SslConfiguration$Configured$toSSLContext$keyStore$22 != null) {
                    HttpRequestSslConfigurationException httpRequestSslConfigurationException;
                    Throwable it$iv = $i$a$-runCatching-SslConfiguration$Configured$toSSLContext$keyStore$22;
                    boolean bl6 = false;
                    if (it$iv instanceof HttpRequestSslConfigurationException) {
                        httpRequestSslConfigurationException = (HttpRequestSslConfigurationException)it$iv;
                    } else {
                        Throwable it = it$iv;
                        boolean bl7 = false;
                        String string = RestClientBundle.message("http.request.ssl.cannot.add.key.to.key.store.error", it.getLocalizedMessage());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RestClientBundle.message\u2026or\", it.localizedMessage)");
                        String string2 = this.context.getErrorMessage(SslErrorDescriptor.KEY, string);
                        Throwable throwable = it$iv;
                        String string3 = string2;
                        httpRequestSslConfigurationException = new HttpRequestSslConfigurationException(string3, throwable);
                    }
                    HttpRequestSslConfigurationException exception$iv = httpRequestSslConfigurationException;
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(SslConfiguration.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.warn((Throwable)exception$iv);
                    throw (Throwable)exception$iv;
                }
                keyStore = (KeyStore)object2;
            } else {
                keyStore = null;
            }
            KeyStore keyStore4 = keyStore;
            MySSLContextBuilder $i$f$getOrRethrowSslException = new MySSLContextBuilder(this.insecureSslConnection);
            boolean bl = false;
            try {
                object = Result.Companion;
                MySSLContextBuilder $this$runCatching = $i$f$getOrRethrowSslException;
                boolean bl8 = false;
                if (keyStore4 != null && this.certificate != null) {
                    String bl6 = this.passphrase;
                    boolean it = false;
                    String string = bl6;
                    if (string == null) {
                        string = "";
                    }
                    bl6 = string;
                    it = false;
                    String string4 = bl6;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    char[] cArray = string4.toCharArray();
                    Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                    $this$runCatching.loadKeyMaterial(keyStore4, cArray);
                }
                MySSLContextBuilder mySSLContextBuilder = $this$runCatching;
                boolean bl9 = false;
                object = Result.constructor-impl((Object)((Object)mySSLContextBuilder));
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl6 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object $this$getOrRethrowSslException$iv = object;
            boolean $i$f$getOrRethrowSslException2 = false;
            object = $this$getOrRethrowSslException$iv;
            boolean bl10 = false;
            boolean bl11 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                HttpRequestSslConfigurationException httpRequestSslConfigurationException;
                Throwable it$iv = throwable;
                boolean bl12 = false;
                if (it$iv instanceof HttpRequestSslConfigurationException) {
                    httpRequestSslConfigurationException = (HttpRequestSslConfigurationException)it$iv;
                } else {
                    Throwable it = it$iv;
                    boolean bl13 = false;
                    String string = RestClientBundle.message("http.request.ssl.cannot.add.key.store.to.ssl.context.error", it.getLocalizedMessage());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RestClientBundle.message\u2026or\", it.localizedMessage)");
                    String string5 = this.context.getErrorMessage(SslErrorDescriptor.CONFIGURATION, string);
                    Throwable throwable2 = it$iv;
                    String string6 = string5;
                    httpRequestSslConfigurationException = new HttpRequestSslConfigurationException(string6, throwable2);
                }
                HttpRequestSslConfigurationException exception$iv = httpRequestSslConfigurationException;
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(SslConfiguration.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.warn((Throwable)exception$iv);
                throw (Throwable)exception$iv;
            }
            MySSLContextBuilder sslContext = (MySSLContextBuilder)((Object)object);
            return sslContext.build();
        }

        @Nullable
        public final SslCertificate getCertificate() {
            return this.certificate;
        }

        @Nullable
        public final SslCertificatePrivateKey getKey() {
            return this.key;
        }

        public final boolean getInsecureSslConnection() {
            return this.insecureSslConnection;
        }

        @Nullable
        public final String getPassphrase() {
            return this.passphrase;
        }

        public Configured(@Nullable SslCertificate certificate, @Nullable SslCertificatePrivateKey key2, boolean insecureSslConnection, @Nullable String passphrase, @NotNull SslConfigurationContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(null);
            this.certificate = certificate;
            this.key = key2;
            this.insecureSslConnection = insecureSslConnection;
            this.passphrase = passphrase;
            this.context = context;
        }

        public /* synthetic */ Configured(SslCertificate sslCertificate, SslCertificatePrivateKey sslCertificatePrivateKey, boolean bl, String string, SslConfigurationContext sslConfigurationContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                string = null;
            }
            if ((n & 0x10) != 0) {
                sslConfigurationContext = SslConfigurationContext.Default.INSTANCE;
            }
            this(sslCertificate, sslCertificatePrivateKey, bl, string, sslConfigurationContext);
        }

        @Nullable
        public final SslCertificate component1() {
            return this.certificate;
        }

        @Nullable
        public final SslCertificatePrivateKey component2() {
            return this.key;
        }

        public final boolean component3() {
            return this.insecureSslConnection;
        }

        @Nullable
        public final String component4() {
            return this.passphrase;
        }

        private final SslConfigurationContext component5() {
            return this.context;
        }

        @NotNull
        public final Configured copy(@Nullable SslCertificate certificate, @Nullable SslCertificatePrivateKey key2, boolean insecureSslConnection, @Nullable String passphrase, @NotNull SslConfigurationContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new Configured(certificate, key2, insecureSslConnection, passphrase, context);
        }

        public static /* synthetic */ Configured copy$default(Configured configured, SslCertificate sslCertificate, SslCertificatePrivateKey sslCertificatePrivateKey, boolean bl, String string, SslConfigurationContext sslConfigurationContext, int n, Object object) {
            if ((n & 1) != 0) {
                sslCertificate = configured.certificate;
            }
            if ((n & 2) != 0) {
                sslCertificatePrivateKey = configured.key;
            }
            if ((n & 4) != 0) {
                bl = configured.insecureSslConnection;
            }
            if ((n & 8) != 0) {
                string = configured.passphrase;
            }
            if ((n & 0x10) != 0) {
                sslConfigurationContext = configured.context;
            }
            return configured.copy(sslCertificate, sslCertificatePrivateKey, bl, string, sslConfigurationContext);
        }

        @NotNull
        public String toString() {
            return "Configured(certificate=" + this.certificate + ", key=" + this.key + ", insecureSslConnection=" + this.insecureSslConnection + ", passphrase=" + this.passphrase + ", context=" + this.context + ")";
        }

        public int hashCode() {
            SslCertificate sslCertificate = this.certificate;
            SslCertificatePrivateKey sslCertificatePrivateKey = this.key;
            int n = ((sslCertificate != null ? ((Object)sslCertificate).hashCode() : 0) * 31 + (sslCertificatePrivateKey != null ? ((Object)sslCertificatePrivateKey).hashCode() : 0)) * 31;
            int n2 = this.insecureSslConnection ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            String string = this.passphrase;
            SslConfigurationContext sslConfigurationContext = this.context;
            return ((n + n2) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (sslConfigurationContext != null ? sslConfigurationContext.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Configured)) break block3;
                    Configured configured = (Configured)object;
                    if (!Intrinsics.areEqual((Object)this.certificate, (Object)configured.certificate) || !Intrinsics.areEqual((Object)this.key, (Object)configured.key) || this.insecureSslConnection != configured.insecureSslConnection || !Intrinsics.areEqual((Object)this.passphrase, (Object)configured.passphrase) || !Intrinsics.areEqual((Object)this.context, (Object)configured.context)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

