/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.ssl;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/httpClient/execution/ssl/SslCertStore;", "", "hasKeyByDefault", "", "(Z)V", "keyStore", "Ljava/security/KeyStore;", "(Ljava/security/KeyStore;Z)V", "getHasKeyByDefault", "()Z", "getKeyStore", "()Ljava/security/KeyStore;", "addCertificate", "", "certificate", "Ljava/security/cert/Certificate;", "addPrivateKey", "privateKey", "Ljava/security/PrivateKey;", "passphrase", "", "Companion", "intellij.restClient"})
public final class SslCertStore {
    @NotNull
    private final KeyStore keyStore;
    private final boolean hasKeyByDefault;
    private static final String CERTIFICATE_ALIAS = "cert";
    private static final String KEY_ALIAS = "key";
    private static final String JKS_STORE = "JKS";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void addCertificate(@NotNull Certificate certificate) {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        this.keyStore.setCertificateEntry(CERTIFICATE_ALIAS, certificate);
    }

    public final void addPrivateKey(@NotNull PrivateKey privateKey, @Nullable String passphrase) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Certificate certificateInKeyStore = this.keyStore.getCertificate(CERTIFICATE_ALIAS);
        KeyStore.Entry entry = new KeyStore.PrivateKeyEntry(privateKey, new Certificate[]{certificateInKeyStore});
        String string = passphrase;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        string = string2;
        bl = false;
        String string3 = string;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string3.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        this.keyStore.setEntry(KEY_ALIAS, entry, new KeyStore.PasswordProtection(cArray));
    }

    @NotNull
    public final KeyStore getKeyStore() {
        return this.keyStore;
    }

    public final boolean getHasKeyByDefault() {
        return this.hasKeyByDefault;
    }

    public SslCertStore(@NotNull KeyStore keyStore, boolean hasKeyByDefault) {
        Intrinsics.checkNotNullParameter((Object)keyStore, (String)"keyStore");
        this.keyStore = keyStore;
        this.hasKeyByDefault = hasKeyByDefault;
    }

    public SslCertStore(boolean hasKeyByDefault) {
        this(SslCertStore.Companion.createKeyStore(), hasKeyByDefault);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/httpClient/execution/ssl/SslCertStore$Companion;", "", "()V", "CERTIFICATE_ALIAS", "", "JKS_STORE", "KEY_ALIAS", "createKeyStore", "Ljava/security/KeyStore;", "intellij.restClient"})
    public static final class Companion {
        private final KeyStore createKeyStore() {
            KeyStore keyStore = KeyStore.getInstance(SslCertStore.JKS_STORE);
            boolean bl = false;
            boolean bl2 = false;
            KeyStore $this$apply = keyStore;
            boolean bl3 = false;
            $this$apply.load(null, null);
            KeyStore keyStore2 = keyStore;
            Intrinsics.checkNotNullExpressionValue((Object)keyStore2, (String)"KeyStore.getInstance(JKS\u2026   load(null, null)\n    }");
            return keyStore2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

