/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.ssl;

import com.intellij.httpClient.execution.RestClientBundle;
import java.security.Provider;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.bc.BcPEMDecryptorProvider;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0019\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001J\u001a\u0010\u0006\u001a\u00020\u00072\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u000e\u0010\n\u001a\u00020\u000b*\u0004\u0018\u00010\tH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/httpClient/execution/ssl/PemHelper;", "", "()V", "isKey", "", "pemObject", "readKey", "Lorg/bouncycastle/asn1/pkcs/PrivateKeyInfo;", "passphrase", "", "asValid", "", "intellij.restClient"})
public final class PemHelper {
    @NotNull
    public static final PemHelper INSTANCE;

    public final boolean isKey(@Nullable Object pemObject) {
        Object object = pemObject;
        return object instanceof PEMKeyPair || object instanceof PEMEncryptedKeyPair || object instanceof PrivateKeyInfo || object instanceof PKCS8EncryptedPrivateKeyInfo;
    }

    @NotNull
    public final PrivateKeyInfo readKey(@Nullable Object pemObject, @Nullable String passphrase) {
        PrivateKeyInfo privateKeyInfo;
        boolean bl = this.isKey(pemObject);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Object object = pemObject;
        if (object instanceof PrivateKeyInfo) {
            privateKeyInfo = (PrivateKeyInfo)pemObject;
        } else if (object instanceof PEMKeyPair) {
            PrivateKeyInfo privateKeyInfo2 = ((PEMKeyPair)pemObject).getPrivateKeyInfo();
            privateKeyInfo = privateKeyInfo2;
            Intrinsics.checkNotNullExpressionValue((Object)privateKeyInfo2, (String)"pemObject.privateKeyInfo");
        } else if (object instanceof PEMEncryptedKeyPair) {
            PEMKeyPair pEMKeyPair = ((PEMEncryptedKeyPair)pemObject).decryptKeyPair((PEMDecryptorProvider)new BcPEMDecryptorProvider(this.asValid(passphrase)));
            Intrinsics.checkNotNullExpressionValue((Object)pEMKeyPair, (String)"pemObject.decryptKeyPair\u2026er(passphrase.asValid()))");
            PrivateKeyInfo privateKeyInfo3 = pEMKeyPair.getPrivateKeyInfo();
            privateKeyInfo = privateKeyInfo3;
            Intrinsics.checkNotNullExpressionValue((Object)privateKeyInfo3, (String)"pemObject.decryptKeyPair\u2026sValid())).privateKeyInfo");
        } else if (object instanceof PKCS8EncryptedPrivateKeyInfo) {
            InputDecryptorProvider provider = new JcePKCSPBEInputDecryptorProviderBuilder().setProvider((Provider)new BouncyCastleProvider()).build(this.asValid(passphrase));
            PrivateKeyInfo privateKeyInfo4 = ((PKCS8EncryptedPrivateKeyInfo)pemObject).decryptPrivateKeyInfo(provider);
            privateKeyInfo = privateKeyInfo4;
            Intrinsics.checkNotNullExpressionValue((Object)privateKeyInfo4, (String)"pemObject.decryptPrivateKeyInfo(provider)");
        } else {
            throw (Throwable)((Object)new AssertionError((Object)"Cannot be here"));
        }
        return privateKeyInfo;
    }

    private final char[] asValid(String $this$asValid) {
        boolean bl = $this$asValid != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = RestClientBundle.message("http.request.ssl.encrypted.key.without.passphrase.error", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RestClientBundle.message\u2026ithout.passphrase.error\")");
            String string2 = string;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String string = $this$asValid;
        bl2 = false;
        String string3 = string;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string3.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        return cArray;
    }

    private PemHelper() {
    }

    static {
        PemHelper pemHelper;
        INSTANCE = pemHelper = new PemHelper();
    }
}

