/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.ssl;

import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.net.ssl.ConfirmingTrustManager;
import java.security.SecureRandom;
import java.util.Collection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J8\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/intellij/httpClient/execution/ssl/MySSLContextBuilder;", "Lorg/apache/http/ssl/SSLContextBuilder;", "insecureSslConnection", "", "(Z)V", "getInsecureSslConnection", "()Z", "build", "Ljavax/net/ssl/SSLContext;", "initSSLContext", "", "sslContext", "keyManagers", "", "Ljavax/net/ssl/KeyManager;", "trustManagers", "Ljavax/net/ssl/TrustManager;", "secureRandom", "Ljava/security/SecureRandom;", "intellij.restClient"})
final class MySSLContextBuilder
extends SSLContextBuilder {
    private final boolean insecureSslConnection;

    protected void initSSLContext(@Nullable SSLContext sslContext, @NotNull Collection<KeyManager> keyManagers, @NotNull Collection<TrustManager> trustManagers, @Nullable SecureRandom secureRandom) {
        Collection collection;
        Intrinsics.checkNotNullParameter(keyManagers, (String)"keyManagers");
        Intrinsics.checkNotNullParameter(trustManagers, (String)"trustManagers");
        if (this.insecureSslConnection) {
            collection = trustManagers;
        } else {
            CertificateManager certificateManager = CertificateManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)certificateManager, (String)"CertificateManager.getInstance()");
            ConfirmingTrustManager confirmingTrustManager = certificateManager.getTrustManager();
            Intrinsics.checkNotNullExpressionValue((Object)confirmingTrustManager, (String)"CertificateManager.getInstance().trustManager");
            collection = CollectionsKt.plus(trustManagers, (Object)confirmingTrustManager);
        }
        super.initSSLContext(sslContext, keyManagers, collection, secureRandom);
    }

    @NotNull
    public SSLContext build() {
        if (this.insecureSslConnection) {
            this.loadTrustMaterial((TrustStrategy)new TrustAllStrategy());
        }
        SSLContext sSLContext = super.build();
        Intrinsics.checkNotNullExpressionValue((Object)sSLContext, (String)"super.build()");
        return sSLContext;
    }

    public final boolean getInsecureSslConnection() {
        return this.insecureSslConnection;
    }

    public MySSLContextBuilder(boolean insecureSslConnection) {
        this.insecureSslConnection = insecureSslConnection;
    }
}

