/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.ssl;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.ssl.HttpRequestSslConfigurationException;
import com.intellij.httpClient.execution.ssl.PemHelper;
import com.intellij.httpClient.execution.ssl.SslCertStore;
import com.intellij.httpClient.execution.ssl.SslConfiguration;
import com.intellij.httpClient.execution.ssl.SslConfigurationContext;
import com.intellij.httpClient.execution.ssl.SslErrorDescriptor;
import com.intellij.httpClient.execution.ssl.SslFilesFormatGuessStrategy;
import com.intellij.openapi.diagnostic.Logger;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH \u00a2\u0006\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0010"}, d2={"Lcom/intellij/httpClient/execution/ssl/CertificateFormat;", "", "(Ljava/lang/String;I)V", "readToStore", "Lcom/intellij/httpClient/execution/ssl/SslCertStore;", "path", "Ljava/nio/file/Path;", "context", "Lcom/intellij/httpClient/execution/ssl/SslConfigurationContext;", "passphrase", "", "readToStore$intellij_restClient", "PEM", "P12", "DER", "Companion", "intellij.restClient"})
public abstract class CertificateFormat
extends Enum<CertificateFormat> {
    public static final /* enum */ CertificateFormat PEM;
    public static final /* enum */ CertificateFormat P12;
    public static final /* enum */ CertificateFormat DER;
    private static final /* synthetic */ CertificateFormat[] $VALUES;
    @NotNull
    private static final String guessExplanation;
    private static final String CERTIFICATE_TYPE = "X.509";
    private static final String PKCS_12_STORE = "PKCS12";
    @NotNull
    public static final Companion Companion;

    static {
        CertificateFormat[] certificateFormatArray = new CertificateFormat[3];
        CertificateFormat[] certificateFormatArray2 = certificateFormatArray;
        certificateFormatArray[0] = PEM = new PEM("PEM", 0);
        certificateFormatArray[1] = P12 = new P12("P12", 1);
        certificateFormatArray[2] = DER = new DER("DER", 2);
        $VALUES = certificateFormatArray;
        Companion = new Companion(null);
        guessExplanation = ".p12, .pkcs12, .pfx -> P12; .pem, .crt -> PEM; .der, .cer -> DER";
    }

    @NotNull
    public abstract SslCertStore readToStore$intellij_restClient(@NotNull Path var1, @NotNull SslConfigurationContext var2, @Nullable String var3) throws HttpRequestSslConfigurationException;

    private CertificateFormat() {
    }

    public /* synthetic */ CertificateFormat(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static CertificateFormat[] values() {
        return (CertificateFormat[])$VALUES.clone();
    }

    public static CertificateFormat valueOf(String string) {
        return Enum.valueOf(CertificateFormat.class, string);
    }

    @JvmStatic
    @Nullable
    public static CertificateFormat guessFormat(@NotNull Path path) {
        return Companion.guessFormat(path);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J'\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0010\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/httpClient/execution/ssl/CertificateFormat$PEM;", "Lcom/intellij/httpClient/execution/ssl/CertificateFormat;", "readToStore", "Lcom/intellij/httpClient/execution/ssl/SslCertStore;", "path", "Ljava/nio/file/Path;", "context", "Lcom/intellij/httpClient/execution/ssl/SslConfigurationContext;", "passphrase", "", "readToStore$intellij_restClient", "intellij.restClient"})
    static final class PEM
    extends CertificateFormat {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public SslCertStore readToStore$intellij_restClient(@NotNull Path path, @NotNull SslConfigurationContext context, @Nullable String passphrase) throws HttpRequestSslConfigurationException {
            void $this$getOrRethrowSslException$iv;
            Object object;
            boolean bl;
            Object object2;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            boolean bl2 = false;
            try {
                object2 = Result.Companion;
                boolean bl3 = false;
                Closeable closeable = (Closeable)new PEMParser((Reader)new FileReader(path.toFile()));
                bl = false;
                boolean bl4 = false;
                Throwable throwable = null;
                try {
                    Object pemParser = (PEMParser)closeable;
                    boolean bl5 = false;
                    Certificate certificate = null;
                    PrivateKey key2 = null;
                    for (Object currentObject : SequencesKt.generateSequence((Function0)((Function0)new Function0<Object>(pemParser){
                        final /* synthetic */ PEMParser $pemParser;

                        @Nullable
                        public final Object invoke() {
                            return this.$pemParser.readObject();
                        }
                        {
                            this.$pemParser = pEMParser;
                            super(0);
                        }
                    }))) {
                        if (currentObject instanceof X509CertificateHolder) {
                            certificate = Companion.readCertificate(new ByteArrayInputStream(((X509CertificateHolder)currentObject).getEncoded()));
                        }
                        if (!PemHelper.INSTANCE.isKey(currentObject)) continue;
                        key2 = new JcaPEMKeyConverter().getPrivateKey(PemHelper.INSTANCE.readKey(currentObject, passphrase));
                    }
                    SslCertStore certStore = new SslCertStore(key2 != null);
                    if (certificate != null) {
                        certStore.addCertificate(certificate);
                        PrivateKey privateKey = key2;
                        if (privateKey != null) {
                            PrivateKey privateKey2 = privateKey;
                            boolean bl6 = false;
                            boolean bl7 = false;
                            Object it = privateKey2;
                            boolean bl8 = false;
                            certStore.addPrivateKey(key2, passphrase);
                        }
                    } else {
                        String string = RestClientBundle.message("http.request.ssl.no.cert.in.file.error", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RestClientBundle.message\u2026l.no.cert.in.file.error\")");
                        throw (Throwable)new HttpRequestSslConfigurationException(context.getErrorMessage(SslErrorDescriptor.CERTIFICATE, string), null, 2, null);
                    }
                    pemParser = certStore;
                }
                catch (Throwable pemParser) {
                    throwable = pemParser;
                    throw pemParser;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                object = pemParser;
                boolean bl9 = false;
                object2 = Result.constructor-impl((Object)object);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                bl = false;
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object3 = object2;
            boolean $i$f$getOrRethrowSslException = false;
            object = $this$getOrRethrowSslException$iv;
            boolean bl10 = false;
            bl = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                HttpRequestSslConfigurationException httpRequestSslConfigurationException;
                Throwable it$iv = throwable;
                boolean bl11 = false;
                if (it$iv instanceof HttpRequestSslConfigurationException) {
                    httpRequestSslConfigurationException = (HttpRequestSslConfigurationException)it$iv;
                } else {
                    Throwable it = it$iv;
                    boolean bl12 = false;
                    String string = RestClientBundle.message("http.request.ssl.cannot.read.certificate.error", it.getLocalizedMessage());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RestClientBundle.message\u2026or\", it.localizedMessage)");
                    String string2 = context.getErrorMessage(SslErrorDescriptor.CERTIFICATE, string);
                    Throwable throwable2 = it$iv;
                    String string3 = string2;
                    httpRequestSslConfigurationException = new HttpRequestSslConfigurationException(string3, throwable2);
                }
                HttpRequestSslConfigurationException exception$iv = httpRequestSslConfigurationException;
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(SslConfiguration.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.warn((Throwable)exception$iv);
                throw (Throwable)exception$iv;
            }
            return (SslCertStore)object;
        }

        /*
         * WARNING - void declaration
         */
        PEM() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J'\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0010\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/httpClient/execution/ssl/CertificateFormat$P12;", "Lcom/intellij/httpClient/execution/ssl/CertificateFormat;", "readToStore", "Lcom/intellij/httpClient/execution/ssl/SslCertStore;", "path", "Ljava/nio/file/Path;", "context", "Lcom/intellij/httpClient/execution/ssl/SslConfigurationContext;", "passphrase", "", "readToStore$intellij_restClient", "intellij.restClient"})
    static final class P12
    extends CertificateFormat {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public SslCertStore readToStore$intellij_restClient(@NotNull Path path, @NotNull SslConfigurationContext context, @Nullable String passphrase) throws HttpRequestSslConfigurationException {
            void $this$getOrRethrowSslException$iv;
            Object object;
            Object object2;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            boolean bl = false;
            try {
                object2 = Result.Companion;
                boolean bl2 = false;
                KeyStore keyStore = KeyStore.getInstance(CertificateFormat.PKCS_12_STORE);
                Closeable closeable = new FileInputStream(path.toFile());
                boolean bl3 = false;
                boolean bl4 = false;
                Throwable throwable = null;
                try {
                    Object stream = (FileInputStream)closeable;
                    boolean bl5 = false;
                    InputStream inputStream = (InputStream)stream;
                    String string = passphrase;
                    boolean bl6 = false;
                    String string2 = string;
                    if (string2 == null) {
                        string2 = "";
                    }
                    string = string2;
                    bl6 = false;
                    String string3 = string;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    char[] cArray = string3.toCharArray();
                    Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                    keyStore.load(inputStream, cArray);
                    KeyStore keyStore2 = keyStore;
                    Intrinsics.checkNotNullExpressionValue((Object)keyStore2, (String)"keyStore");
                    stream = new SslCertStore(keyStore2, true);
                }
                catch (Throwable stream) {
                    throwable = stream;
                    throw stream;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                object = stream;
                boolean bl7 = false;
                object2 = Result.constructor-impl((Object)object);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl8 = false;
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object3 = object2;
            boolean $i$f$getOrRethrowSslException = false;
            object = $this$getOrRethrowSslException$iv;
            boolean bl9 = false;
            boolean bl10 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                HttpRequestSslConfigurationException httpRequestSslConfigurationException;
                Throwable it$iv = throwable;
                boolean bl11 = false;
                if (it$iv instanceof HttpRequestSslConfigurationException) {
                    httpRequestSslConfigurationException = (HttpRequestSslConfigurationException)it$iv;
                } else {
                    Throwable it = it$iv;
                    boolean bl12 = false;
                    String string = RestClientBundle.message("http.request.ssl.cannot.read.p12.key.store.error", it.getLocalizedMessage());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RestClientBundle.message\u2026or\", it.localizedMessage)");
                    String string4 = context.getErrorMessage(SslErrorDescriptor.CERTIFICATE, string);
                    Throwable throwable2 = it$iv;
                    String string5 = string4;
                    httpRequestSslConfigurationException = new HttpRequestSslConfigurationException(string5, throwable2);
                }
                HttpRequestSslConfigurationException exception$iv = httpRequestSslConfigurationException;
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(SslConfiguration.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.warn((Throwable)exception$iv);
                throw (Throwable)exception$iv;
            }
            return (SslCertStore)object;
        }

        /*
         * WARNING - void declaration
         */
        P12() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J'\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0010\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/httpClient/execution/ssl/CertificateFormat$DER;", "Lcom/intellij/httpClient/execution/ssl/CertificateFormat;", "readToStore", "Lcom/intellij/httpClient/execution/ssl/SslCertStore;", "path", "Ljava/nio/file/Path;", "context", "Lcom/intellij/httpClient/execution/ssl/SslConfigurationContext;", "passphrase", "", "readToStore$intellij_restClient", "intellij.restClient"})
    static final class DER
    extends CertificateFormat {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public SslCertStore readToStore$intellij_restClient(@NotNull Path path, @NotNull SslConfigurationContext context, @Nullable String passphrase) throws HttpRequestSslConfigurationException {
            void $this$getOrRethrowSslException$iv;
            Object object;
            boolean bl;
            Object object2;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            boolean bl2 = false;
            try {
                object2 = Result.Companion;
                boolean bl3 = false;
                Closeable closeable = new FileInputStream(path.toFile());
                bl = false;
                boolean bl4 = false;
                Throwable throwable = null;
                try {
                    Object stream = (FileInputStream)closeable;
                    boolean bl5 = false;
                    Certificate certificate = Companion.readCertificate((InputStream)stream);
                    SslCertStore sslCertStore = new SslCertStore(false);
                    boolean bl6 = false;
                    boolean bl7 = false;
                    SslCertStore it = sslCertStore;
                    boolean bl8 = false;
                    it.addCertificate(certificate);
                    stream = sslCertStore;
                }
                catch (Throwable stream) {
                    throwable = stream;
                    throw stream;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                object = stream;
                boolean bl9 = false;
                object2 = Result.constructor-impl((Object)object);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                bl = false;
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object3 = object2;
            boolean $i$f$getOrRethrowSslException = false;
            object = $this$getOrRethrowSslException$iv;
            boolean bl10 = false;
            bl = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                HttpRequestSslConfigurationException httpRequestSslConfigurationException;
                Throwable it$iv = throwable;
                boolean bl11 = false;
                if (it$iv instanceof HttpRequestSslConfigurationException) {
                    httpRequestSslConfigurationException = (HttpRequestSslConfigurationException)it$iv;
                } else {
                    Throwable it = it$iv;
                    boolean bl12 = false;
                    String string = RestClientBundle.message("http.request.ssl.cannot.read.certificate.error", it.getLocalizedMessage());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RestClientBundle.message\u2026or\", it.localizedMessage)");
                    String string2 = context.getErrorMessage(SslErrorDescriptor.CERTIFICATE, string);
                    Throwable throwable2 = it$iv;
                    String string3 = string2;
                    httpRequestSslConfigurationException = new HttpRequestSslConfigurationException(string3, throwable2);
                }
                HttpRequestSslConfigurationException exception$iv = httpRequestSslConfigurationException;
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(SslConfiguration.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.warn((Throwable)exception$iv);
                throw (Throwable)exception$iv;
            }
            return (SslCertStore)object;
        }

        /*
         * WARNING - void declaration
         */
        DER() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/httpClient/execution/ssl/CertificateFormat$Companion;", "Lcom/intellij/httpClient/execution/ssl/SslFilesFormatGuessStrategy;", "Lcom/intellij/httpClient/execution/ssl/CertificateFormat;", "()V", "CERTIFICATE_TYPE", "", "PKCS_12_STORE", "guessExplanation", "getGuessExplanation", "()Ljava/lang/String;", "guessFormat", "path", "Ljava/nio/file/Path;", "readCertificate", "Ljava/security/cert/Certificate;", "inputStream", "Ljava/io/InputStream;", "intellij.restClient"})
    public static final class Companion
    implements SslFilesFormatGuessStrategy<CertificateFormat> {
        /*
         * Unable to fully structure code
         */
        @Override
        @JvmStatic
        @Nullable
        public CertificateFormat guessFormat(@NotNull Path path) {
            block10: {
                block9: {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    var2_2 = PathsKt.getExtension((Path)path);
                    switch (var2_2.hashCode()) {
                        case 109201: {
                            if (!var2_2.equals("p12")) ** break;
                            ** GOTO lbl24
                        }
                        case 99345: {
                            if (!var2_2.equals("der")) ** break;
                            break block9;
                        }
                        case 98384: {
                            if (!var2_2.equals("cer")) ** break;
                            break block9;
                        }
                        case 110914: {
                            if (!var2_2.equals("pfx")) ** break;
                            ** GOTO lbl24
                        }
                        case 98789: {
                            if (!var2_2.equals("crt")) ** break;
                            break;
                        }
                        case 110872: {
                            if (!var2_2.equals("pem")) ** break;
                            break;
                        }
                        case -986624244: {
                            if (!var2_2.equals("pkcs12")) ** break;
lbl24:
                            // 3 sources

                            v0 = CertificateFormat.P12;
                            break block10;
                        }
                    }
                    v0 = CertificateFormat.PEM;
                    break block10;
                }
                v0 = CertificateFormat.DER;
                break block10;
                v0 = null;
            }
            return v0;
        }

        @Override
        @NotNull
        public String getGuessExplanation() {
            return guessExplanation;
        }

        private final Certificate readCertificate(InputStream inputStream) {
            Certificate certificate = CertificateFactory.getInstance(CertificateFormat.CERTIFICATE_TYPE).generateCertificate(inputStream);
            Intrinsics.checkNotNullExpressionValue((Object)certificate, (String)"CertificateFactory.getIn\u2026eCertificate(inputStream)");
            return certificate;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

