/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.auth;

import com.intellij.httpClient.execution.auth.HttpClientAuthConfigurator;
import com.intellij.httpClient.execution.auth.HttpClientAuthData;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpClientOsAuthConfigurator
implements HttpClientAuthConfigurator {
    private static final String CREDENTIALS_PROPERTY_NAME = "javax.security.auth.useSubjectCredsOnly";
    private static final String INITIAL_PROPERTY_STATE = System.getProperty("javax.security.auth.useSubjectCredsOnly");
    private final AtomicInteger myActiveRequestsWithOsCredentials = new AtomicInteger(0);

    @Override
    public void configure(@Nullable HttpClientAuthData data, @NotNull BasicCredentialsProvider provider, @NotNull HttpRequestBase request) {
        int activeRequestsCount;
        if (provider == null) {
            HttpClientOsAuthConfigurator.$$$reportNull$$$0(0);
        }
        if (request == null) {
            HttpClientOsAuthConfigurator.$$$reportNull$$$0(1);
        }
        if (data == HttpClientAuthData.EMPTY_CREDENTIALS && (activeRequestsCount = this.myActiveRequestsWithOsCredentials.incrementAndGet()) == 1) {
            System.setProperty(CREDENTIALS_PROPERTY_NAME, "false");
        }
    }

    @Override
    public void cleanup(@Nullable HttpClientAuthData data) {
        int activeRequestsCount;
        if (data == HttpClientAuthData.EMPTY_CREDENTIALS && (activeRequestsCount = this.myActiveRequestsWithOsCredentials.decrementAndGet()) == 0) {
            if (INITIAL_PROPERTY_STATE == null) {
                System.clearProperty(CREDENTIALS_PROPERTY_NAME);
            } else {
                System.setProperty(CREDENTIALS_PROPERTY_NAME, INITIAL_PROPERTY_STATE);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "provider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "request";
                break;
            }
        }
        objectArray[1] = "com/intellij/httpClient/execution/auth/HttpClientOsAuthConfigurator";
        objectArray[2] = "configure";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

