/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution;

import com.google.common.base.Charsets;
import com.google.common.io.CountingInputStream;
import com.intellij.httpClient.execution.HttpClientRequestWithBody;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.RestClientController;
import com.intellij.httpClient.execution.RestClientFormBodyPart;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.execution.RestClientRequestProcessor;
import com.intellij.httpClient.execution.RestClientResponse;
import com.intellij.httpClient.execution.RestClientResponseImpl;
import com.intellij.httpClient.execution.RestClientResponseListener;
import com.intellij.httpClient.execution.SocksAwareConnectionManagerFactory;
import com.intellij.httpClient.execution.auth.HttpClientAuthConfigurationManager;
import com.intellij.httpClient.execution.auth.HttpClientAuthData;
import com.intellij.httpClient.execution.ssl.HttpRequestSslConfigurationException;
import com.intellij.httpClient.execution.ssl.SslConfiguration;
import com.intellij.httpClient.http.request.cookies.CookieFullComparator;
import com.intellij.httpClient.http.request.run.HttpClientResponseHandlerExecutorUtil;
import com.intellij.httpClient.http.request.run.HttpRequestHistoryManager;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.IdeHttpClientHelpers;
import com.intellij.util.net.ssl.CertificateManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.protocol.HTTP;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestClientControllerImpl
implements RestClientController {
    private static final Logger LOG = Logger.getInstance(RestClientControllerImpl.class);
    private final Project project;
    private static final String UNICODE_QUOTE = "\\u0022";

    public RestClientControllerImpl(Project project) {
        this.project = project;
    }

    @Override
    public void onGoButtonClick(final RestClientRequest request, boolean withProgress, final RestClientResponseListener responseListener, final RestClientRequestProcessor ... processors) {
        EmptyProgressIndicator progressIndicator;
        for (RestClientRequestProcessor processor : processors) {
            processor.preProcessRequest(request);
        }
        responseListener.onStart();
        Task.Backgroundable task = new Task.Backgroundable(this.project, RestClientBundle.message("accessing.url", request.getURL()), true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                BasicCookieStore store = new BasicCookieStore();
                try {
                    int len;
                    HttpEntity entity;
                    InputStream body;
                    Long length;
                    String url = request.getURL();
                    RestClientControllerImpl.biscuitsToCookies(request, store);
                    HttpRequestBase method = RestClientControllerImpl.createHttpMethod(url, request);
                    CloseableHttpClient client = RestClientControllerImpl.createHttpClient(url, (CookieStore)store, request.authData, method, request.config.isFollowRedirects(), request.sslConfiguration);
                    RestClientControllerImpl.addHeaders(method, request);
                    RestClientControllerImpl.initParameters(method, request);
                    long start = System.currentTimeMillis();
                    CloseableHttpResponse response = client.execute((HttpUriRequest)method);
                    for (RestClientRequestProcessor processor : processors) {
                        processor.postProcessRequest(request, (CookieStore)store);
                    }
                    Header contentLength = response.getFirstHeader("Content-Length");
                    Long l = length = contentLength == null ? null : RestClientControllerImpl.fromString(contentLength.getValue());
                    if (length != null) {
                        indicator.setIndeterminate(false);
                        indicator.setText(RestClientBundle.message("rest.client.accessing.resource.indicator.text", new Object[0]));
                        indicator.setFraction(0.0);
                    }
                    InputStream inputStream = body = (entity = response.getEntity()) == null ? null : entity.getContent();
                    if (body == null) {
                        ApplicationManager.getApplication().invokeLater(() -> this.lambda$run$0(request, (HttpResponse)response, responseListener, start, store));
                        return;
                    }
                    CountingInputStream countingInputStream = new CountingInputStream(body);
                    ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
                    Charset charset = RestClientControllerImpl.getResponseCharset(contentType);
                    InputStreamReader reader = new InputStreamReader((InputStream)countingInputStream, charset);
                    char[] b = new char[4096];
                    StringBuffer buf = new StringBuffer();
                    while ((len = reader.read(b)) != -1 && !indicator.isCanceled()) {
                        String out = new String(b, 0, len);
                        buf.append(RestClientControllerImpl.cleanBody(out, charset, contentType.getMimeType()));
                        if (length == null) continue;
                        indicator.setText(RestClientBundle.message("rest.client.0.of.1.kb.indicator.text", countingInputStream.getCount() / 1000L, length / 1000L));
                        indicator.setFraction((double)countingInputStream.getCount() / (double)length.longValue());
                    }
                    ApplicationManager.getApplication().invokeLater(() -> this.lambda$run$1(request, (HttpResponse)response, buf, responseListener, start, store));
                }
                catch (Exception ex) {
                    LOG.info((Throwable)ex);
                    for (RestClientRequestProcessor processor : processors) {
                        processor.postProcessRequest(request, (CookieStore)store);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> responseListener.onErrorResponse(ex));
                    ApplicationManager.getApplication().invokeLater(() -> RestClientControllerImpl.this.addToHistory(RestClientControllerImpl.this.project, request, null));
                }
                finally {
                    HttpClientAuthConfigurationManager.cleanUp(request);
                }
            }

            private /* synthetic */ void lambda$run$1(RestClientRequest request2, HttpResponse response, StringBuffer buf, RestClientResponseListener responseListener2, long start, BasicCookieStore store) {
                RestClientControllerImpl.this.onResponse(RestClientControllerImpl.this.project, request2, RestClientResponseImpl.createResponse(response, buf), responseListener2, start, (CookieStore)store);
            }

            private /* synthetic */ void lambda$run$0(RestClientRequest request2, HttpResponse response, RestClientResponseListener responseListener2, long start, BasicCookieStore store) {
                RestClientControllerImpl.this.onResponse(RestClientControllerImpl.this.project, request2, RestClientResponseImpl.createEmptyResponse(response), responseListener2, start, (CookieStore)store);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/httpClient/execution/RestClientControllerImpl$1", "run"));
            }
        };
        Object object = progressIndicator = ApplicationManager.getApplication().isHeadlessEnvironment() || !withProgress ? new EmptyProgressIndicator() : new BackgroundableProcessIndicator(task);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)progressIndicator);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> RestClientControllerImpl.lambda$onGoButtonClick$0(task, (ProgressIndicator)progressIndicator), ModalityState.defaultModalityState());
        }
    }

    @NotNull
    private static Charset getResponseCharset(ContentType normalizedContent) {
        ContentType contentType = normalizedContent;
        if (contentType.getCharset() == null) {
            contentType = ContentType.getByMimeType((String)contentType.getMimeType());
        }
        Charset charset = contentType != null ? contentType.getCharset() : null;
        Charset charset2 = charset != null ? charset : HTTP.DEF_CONTENT_CHARSET;
        if (charset2 == null) {
            RestClientControllerImpl.$$$reportNull$$$0(0);
        }
        return charset2;
    }

    @NotNull
    private static String cleanBody(@NotNull String body, @NotNull Charset charset, @NotNull String contentType) {
        if (body == null) {
            RestClientControllerImpl.$$$reportNull$$$0(1);
        }
        if (charset == null) {
            RestClientControllerImpl.$$$reportNull$$$0(2);
        }
        if (contentType == null) {
            RestClientControllerImpl.$$$reportNull$$$0(3);
        }
        if (charset == Charsets.UTF_8) {
            String result = body;
            if (HttpClientResponseHandlerExecutorUtil.isJSON(contentType)) {
                result = body.replace(UNICODE_QUOTE, "\\\"");
            }
            String string = StringUtil.replaceUnicodeEscapeSequences((String)result);
            if (string == null) {
                RestClientControllerImpl.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = body;
        if (string == null) {
            RestClientControllerImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static void biscuitsToCookies(RestClientRequest request, BasicCookieStore store) {
        for (RestClientRequest.Biscuit biscuit : request.biscuits) {
            BasicClientCookie cookie = new BasicClientCookie(biscuit.getName(), biscuit.getValue());
            if (biscuit.getDomain() != null) {
                cookie.setDomain(biscuit.getDomain());
            }
            if (biscuit.getPath() != null) {
                cookie.setPath(biscuit.getPath());
            }
            if (biscuit.getDate() != -1L) {
                cookie.setExpiryDate(new Date(biscuit.getDate()));
            }
            store.addCookie((Cookie)cookie);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void onResponse(@NotNull Project project, @NotNull RestClientRequest request, @NotNull RestClientResponse response, @NotNull RestClientResponseListener responseListener, long start, @NotNull CookieStore cookieStore) {
        if (project == null) {
            RestClientControllerImpl.$$$reportNull$$$0(6);
        }
        if (request == null) {
            RestClientControllerImpl.$$$reportNull$$$0(7);
        }
        if (response == null) {
            RestClientControllerImpl.$$$reportNull$$$0(8);
        }
        if (responseListener == null) {
            RestClientControllerImpl.$$$reportNull$$$0(9);
        }
        if (cookieStore == null) {
            RestClientControllerImpl.$$$reportNull$$$0(10);
        }
        if (project.isDisposed()) {
            return;
        }
        String headers = response.getStatusLine() + "\n" + RestClientControllerImpl.toString(response.getAllHeaders());
        String status = RestClientControllerImpl.getStatusText(response, start) + "; Content length: " + response.getContentLength() + " bytes";
        if (response.getContentLength() == 0) {
            responseListener.onResponse(headers, RestClientBundle.message("rest.client.request.response.body.empty", new Object[0]), "text/plain", status);
        } else {
            responseListener.onResponse(headers, response.getContent(), response.getContentType().getMimeType(), status);
        }
        if (request.config.isSaveCookies()) {
            void cookies;
            responseListener.onSetCookies(RestClientControllerImpl.filterUpdatedCookies(request, (CookieStore)cookies));
        }
        this.addToHistory(project, request, response);
    }

    @NotNull
    private static List<Cookie> filterUpdatedCookies(@NotNull RestClientRequest request, @NotNull CookieStore cookieStore) {
        if (request == null) {
            RestClientControllerImpl.$$$reportNull$$$0(11);
        }
        if (cookieStore == null) {
            RestClientControllerImpl.$$$reportNull$$$0(12);
        }
        BasicCookieStore oldCookieStore = new BasicCookieStore();
        RestClientControllerImpl.biscuitsToCookies(request, oldCookieStore);
        TreeSet<Cookie> oldCookies = new TreeSet<Cookie>(new CookieFullComparator());
        oldCookies.addAll(oldCookieStore.getCookies());
        ArrayList<Cookie> updatedCookies = new ArrayList<Cookie>();
        for (Cookie cookie : cookieStore.getCookies()) {
            if (oldCookies.contains(cookie)) continue;
            updatedCookies.add(cookie);
        }
        ArrayList<Cookie> arrayList = updatedCookies;
        if (arrayList == null) {
            RestClientControllerImpl.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    protected void addToHistory(@NotNull Project project, @NotNull RestClientRequest request, @Nullable RestClientResponse response) {
        if (project == null) {
            RestClientControllerImpl.$$$reportNull$$$0(14);
        }
        if (request == null) {
            RestClientControllerImpl.$$$reportNull$$$0(15);
        }
        if (request.config.isLogResponse()) {
            HttpRequestHistoryManager.getInstance(project).addToHistory(request, response);
        }
    }

    private static String getStatusText(@NotNull RestClientResponse response, long start) {
        if (response == null) {
            RestClientControllerImpl.$$$reportNull$$$0(16);
        }
        String text = "Response code: " + response.getStatusLine().getStatusCode();
        String status = response.getStatusLine().getReasonPhrase();
        if (status != null && status.length() > 0) {
            text = text + " (" + status + ")";
        }
        text = text + "; Time: " + (System.currentTimeMillis() - start) + "ms";
        return text;
    }

    private static void addHeaders(HttpRequestBase method, RestClientRequest request) {
        for (RestClientRequest.KeyValuePair header : request.headers) {
            method.addHeader(header.getKey(), header.getValue());
        }
    }

    private static String toString(Header[] headers) {
        StringBuilder builder = new StringBuilder();
        for (Header header : headers) {
            builder.append(header.toString()).append("\n");
        }
        return builder.toString();
    }

    private static CloseableHttpClient createHttpClient(String url, CookieStore cookieStore, @Nullable HttpClientAuthData authData, @NotNull HttpRequestBase method, boolean followRedirects, @Nullable SslConfiguration sslConfiguration) throws HttpRequestSslConfigurationException {
        Proxy currentProxy;
        if (method == null) {
            RestClientControllerImpl.$$$reportNull$$$0(17);
        }
        HttpClientBuilder client = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout((int)TimeUnit.MINUTES.toMillis(5L)).build());
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        client.setDefaultCredentialsProvider((CredentialsProvider)provider);
        client.addInterceptorFirst((HttpResponseInterceptor)new ResponseContentEncoding());
        client.setDefaultCookieStore(cookieStore);
        URI uri = RestClientControllerImpl.uriFromString(url);
        List proxies = uri != null ? HttpConfigurable.getInstance().getOnlyBySettingsSelector().select(uri) : List.of();
        Proxy proxy = currentProxy = proxies.isEmpty() ? null : (Proxy)proxies.get(0);
        if (uri != null) {
            InetSocketAddress address;
            String userinfo = uri.getUserInfo();
            if (userinfo != null && userinfo.length() > 0) {
                provider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userinfo));
            } else if (authData != null) {
                HttpClientAuthConfigurationManager.configure(authData, provider, method);
            }
            if (currentProxy != null && currentProxy != Proxy.NO_PROXY && currentProxy.type() != Proxy.Type.SOCKS && (address = (InetSocketAddress)currentProxy.address()) != null) {
                client.setProxy(new HttpHost(address.getHostName(), address.getPort()));
                IdeHttpClientHelpers.ApacheHttpClient4.setProxyCredentialsIfEnabled((CredentialsProvider)provider);
            }
        }
        try {
            client.setConnectionManager(SocksAwareConnectionManagerFactory.getConnectionManager(currentProxy, sslConfiguration == null ? CertificateManager.getInstance().getSslContext() : sslConfiguration.toSSLContext()));
        }
        catch (HttpRequestSslConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        if (followRedirects) {
            client.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        } else {
            client.disableRedirectHandling();
        }
        return client.build();
    }

    private static void initParameters(HttpRequestBase httpMethod, RestClientRequest request) {
        if (httpMethod instanceof HttpEntityEnclosingRequestBase) {
            List<File> files;
            HttpEntityEnclosingRequestBase method = (HttpEntityEnclosingRequestBase)httpMethod;
            if (request.haveTextToSend) {
                ContentType contentType = ContentType.parse((String)RestClientControllerImpl.getContentType(request));
                if (contentType.getCharset() == null) {
                    contentType = contentType.withCharset(RestClientControllerImpl.getEncoding(request));
                }
                method.setEntity((HttpEntity)new StringEntity(request.textToSend, contentType));
            } else if (request.isFileUpload) {
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                for (RestClientFormBodyPart part : request.formBodyPart) {
                    builder.addPart(part.toBodyPart());
                }
                if (StringUtil.isNotEmpty((String)request.multipartBoundary)) {
                    builder.setBoundary(request.multipartBoundary);
                }
                method.setEntity(builder.build());
            } else if (request.haveFileToSend && (files = request.getFiles()).size() > 0) {
                method.setEntity((HttpEntity)new FileEntity(files.get(0), ContentType.create((String)RestClientControllerImpl.getContentType(request))));
            }
        }
    }

    private static String getContentType(RestClientRequest request) {
        return request.getHeaderValue("Content-Type", "*/*");
    }

    private static String getEncoding(RestClientRequest request) {
        return request.getHeaderValue("Accept-Charset", "UTF-8");
    }

    @Override
    public boolean isValidURL(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static HttpRequestBase createHttpMethod(String uri, RestClientRequest request) {
        String query;
        if (request.parametersEnabled && StringUtil.isNotEmpty((String)(query = request.createQueryString()))) {
            uri = (String)uri + (((String)uri).contains("?") ? "&" : "?") + query;
        }
        if (!request.haveFileToSend && !request.haveTextToSend) {
            if ("GET".equals(request.httpMethod)) {
                return new HttpGet((String)uri);
            }
            if ("HEAD".equals(request.httpMethod)) {
                return new HttpHead((String)uri);
            }
            if ("DELETE".equals(request.httpMethod)) {
                return new HttpDelete((String)uri);
            }
            if ("OPTIONS".equals(request.httpMethod)) {
                return new HttpOptions((String)uri);
            }
        }
        if ("PUT".equals(request.httpMethod)) {
            return new HttpPut((String)uri);
        }
        if ("PATCH".equals(request.httpMethod)) {
            return new HttpPatch((String)uri);
        }
        if ("TRACE".equals(request.httpMethod)) {
            return new HttpTrace((String)uri);
        }
        if ("POST".equals(request.httpMethod)) {
            return new HttpPost((String)uri);
        }
        return new HttpClientRequestWithBody(request.httpMethod, (String)uri);
    }

    @Override
    public void openResponseInBrowser(String response) {
        try {
            File file2 = FileUtil.createTempFile((String)"tmpRestClientResponse", (String)".html");
            FileWriter fw = new FileWriter(file2);
            fw.write(response);
            fw.close();
            BrowserUtil.browse((URI)file2.toURI());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nullable
    private static Long fromString(String num) {
        try {
            return Long.valueOf(num);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private static URI uriFromString(String url) {
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private static /* synthetic */ void lambda$onGoButtonClick$0(Task.Backgroundable task, ProgressIndicator progressIndicator) {
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, progressIndicator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/execution/RestClientControllerImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responseListener";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cookies";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cookieStore";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponseCharset";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/execution/RestClientControllerImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanBody";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUpdatedCookies";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cleanBody";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onResponse";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "filterUpdatedCookies";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addToHistory";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getStatusText";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createHttpClient";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

