/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions.microservices;

import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.httpClient.actions.generation.HttpRequestGenerationManager;
import com.intellij.httpClient.actions.generation.HttpRequestPresentableError;
import com.intellij.httpClient.actions.generation.HttpRequestUrlsGenerationRequest;
import com.intellij.httpClient.actions.generation.PartialResult;
import com.intellij.httpClient.actions.generation.PartialResultKt;
import com.intellij.httpClient.actions.microservices.HttpRequestMicroservicesUtil;
import com.intellij.httpClient.actions.microservices.OpenInHttpClientIntention;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestLanguage;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.url.references.UrlPathReference;
import com.intellij.microservices.url.references.UrlPathReferenceUnifiedPomTarget;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import icons.RestClientIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0019\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J!\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0096\u0002J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/httpClient/actions/microservices/OpenInHttpClientIntention;", "Lcom/intellij/codeInsight/intention/AbstractIntentionAction;", "Lcom/intellij/openapi/util/Iconable;", "()V", "getIcon", "Ljavax/swing/Icon;", "flags", "", "getText", "", "getUrlPathReference", "Lcom/intellij/microservices/url/references/UrlPathReference;", "Lkotlin/internal/NoInfer;", "elementAtCaret", "Lcom/intellij/psi/PsiElement;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "Companion", "intellij.restClient"})
public final class OpenInHttpClientIntention
extends AbstractIntentionAction
implements Iconable {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        String string = RestClientBundle.message("http.request.open.in.http.client.intention.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RestClientBundle.message\u2026p.client.intention.name\")");
        return string;
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = RestClientIcons.Http_requests_filetype;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RestClientIcons.Http_requests_filetype");
        return icon;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (Intrinsics.areEqual((Object)file2.getLanguage(), (Object)((Object)HttpRequestLanguage.INSTANCE))) {
            return false;
        }
        if (editor == null) {
            return false;
        }
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        PsiElement elementAtCaret = file2.findElementAt(offset);
        return this.getUrlPathReference(elementAtCaret) != null;
    }

    /*
     * WARNING - void declaration
     */
    private final UrlPathReference getUrlPathReference(PsiElement elementAtCaret) {
        UrlPathReference urlPathReference;
        PsiReference[] psiReferenceArray = elementAtCaret;
        if (elementAtCaret != null && (psiReferenceArray = PsiTreeUtilKt.parentOfTypes((PsiElement)psiReferenceArray, (KClass[])new KClass[]{Reflection.getOrCreateKotlinClass(PsiLanguageInjectionHost.class), Reflection.getOrCreateKotlinClass(ContributedReferenceHost.class)}, (boolean)true)) != null && (psiReferenceArray = psiReferenceArray.getReferences()) != null) {
            Object v1;
            block4: {
                void $this$filterIsInstanceTo$iv$iv;
                PsiReference[] $this$filterIsInstance$iv = psiReferenceArray;
                boolean $i$f$filterIsInstance = false;
                Object object = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof UrlPathReference)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable iterable = (List)destination$iv$iv;
                boolean bl = false;
                object = iterable;
                boolean bl2 = false;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    UrlPathReference it = (UrlPathReference)t;
                    boolean bl3 = false;
                    if (!it.isAtEnd()) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            urlPathReference = v1;
        } else {
            urlPathReference = null;
        }
        return urlPathReference;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        UrlPathReference urlPathReference = this.getUrlPathReference(file2.findElementAt(caretModel.getOffset()));
        if (urlPathReference == null) {
            return;
        }
        UrlPathReference urlPathReference2 = urlPathReference;
        UrlPathReferenceUnifiedPomTarget urlPathReferenceUnifiedPomTarget = urlPathReference2.getUnifiedPomTarget();
        if (urlPathReferenceUnifiedPomTarget == null || (urlPathReferenceUnifiedPomTarget = urlPathReferenceUnifiedPomTarget.getContext()) == null) {
            return;
        }
        UrlPathReferenceUnifiedPomTarget context = urlPathReferenceUnifiedPomTarget;
        Companion.generateFromUrlPathContext$intellij_restClient(project, editor, (UrlPathContext)context);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ\u0012\u0010\f\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0003\u00a8\u0006\u0010"}, d2={"Lcom/intellij/httpClient/actions/microservices/OpenInHttpClientIntention$Companion;", "", "()V", "generateFromUrlPathContext", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "context", "Lcom/intellij/microservices/url/references/UrlPathContext;", "generateFromUrlPathContext$intellij_restClient", "concatErrors", "", "", "Lcom/intellij/httpClient/actions/generation/HttpRequestPresentableError;", "intellij.restClient"})
    public static final class Companion {
        public final void generateFromUrlPathContext$intellij_restClient(@NotNull Project project, @NotNull Editor editor, @NotNull UrlPathContext context) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            List<PartialResult<HttpRequestUrlsGenerationRequest, HttpRequestPresentableError>> requestsInfo = HttpRequestMicroservicesUtil.generationRequestsFromUrlPathContext(project, context);
            List<HttpRequestUrlsGenerationRequest> requests = PartialResultKt.unwrapSuccess((Iterable)requestsInfo);
            Collection collection = requests;
            boolean bl = false;
            if (!collection.isEmpty()) {
                new HttpRequestGenerationManager(project).generateRequestsInHttpEditor(requests);
            } else {
                String messageContent = this.concatErrors(PartialResultKt.unwrapErrors((Iterable)requestsInfo));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)messageContent, (String)RestClientBundle.message("http.request.open.in.http.client.intention.error", new Object[0]), null);
            }
        }

        @NlsSafe
        private final String concatErrors(Iterable<? extends HttpRequestPresentableError> $this$concatErrors) {
            return CollectionsKt.joinToString$default($this$concatErrors, (CharSequence)"\n", null, null, (int)0, null, (Function1)concatErrors.1.INSTANCE, (int)30, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

