/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions.microservices;

import com.intellij.httpClient.actions.generation.HttpRequestGenerationManager;
import com.intellij.httpClient.actions.generation.HttpRequestPresentableError;
import com.intellij.httpClient.actions.generation.HttpRequestUrlContextError;
import com.intellij.httpClient.actions.generation.HttpRequestUrlPathInfoError;
import com.intellij.httpClient.actions.generation.HttpRequestUrlsGenerationRequest;
import com.intellij.httpClient.actions.microservices.FromUrlTargetInfosConversionResult;
import com.intellij.httpClient.actions.microservices.HttpGenerateRequestFromEndpointsActionKt;
import com.intellij.httpClient.actions.microservices.HttpRequestMicroservicesUtil;
import com.intellij.httpClient.actions.microservices.UrlTargetInfoEx;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.PsiElementNavigatable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Consumer;
import icons.RestClientIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J$\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/httpClient/actions/microservices/HttpGenerateRequestFromEndpointsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "defaultNotificationGroup", "Lcom/intellij/notification/NotificationGroup;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "showNotification", "project", "Lcom/intellij/openapi/project/Project;", "invalidUrlTargetInfos", "", "Lcom/intellij/httpClient/actions/microservices/UrlTargetInfoEx;", "Lcom/intellij/httpClient/actions/generation/HttpRequestPresentableError;", "update", "MyNotification", "intellij.restClient"})
public final class HttpGenerateRequestFromEndpointsAction
extends AnAction {
    private final NotificationGroup defaultNotificationGroup = new NotificationGroup("http.generation.notifications", NotificationDisplayType.STICKY_BALLOON, true, null, null, 24, null);

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Iterable urlInfos = (Iterable)e.getData(EndpointsProvider.URL_TARGET_INFO);
        if (urlInfos == null) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabled(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void requests;
        void errorContexts;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = AnAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getEventProject(e) ?: return");
        Project project2 = project;
        Iterable iterable = (Iterable)e.getData(EndpointsProvider.URL_TARGET_INFO);
        if (iterable == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"e.getData(EndpointsProvi\u2026RL_TARGET_INFO) ?: return");
        Iterable endpointsData = iterable;
        List urls = CollectionsKt.toList((Iterable)endpointsData);
        if (urls.isEmpty()) {
            return;
        }
        Object object = HttpRequestMicroservicesUtil.getGenerationRequestsFromUrlTargetInfos(project2, urls);
        List<HttpRequestUrlsGenerationRequest> list = ((FromUrlTargetInfosConversionResult)object).component1();
        List<UrlTargetInfoEx<HttpRequestUrlContextError>> list2 = ((FromUrlTargetInfosConversionResult)object).component2();
        List<UrlTargetInfoEx<HttpRequestUrlPathInfoError>> invalidUrls = ((FromUrlTargetInfosConversionResult)object).component3();
        object = (Collection)errorContexts;
        boolean bl = false;
        if (!object.isEmpty()) {
            this.showNotification(project2, (List<? extends UrlTargetInfoEx<? extends HttpRequestPresentableError>>)errorContexts);
        }
        object = invalidUrls;
        bl = false;
        if (!object.isEmpty()) {
            this.showNotification(project2, invalidUrls);
        }
        object = (Collection)requests;
        bl = false;
        if (!object.isEmpty()) {
            new HttpRequestGenerationManager(project2).generateRequestsInHttpEditor((List<HttpRequestUrlsGenerationRequest>)requests);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void showNotification(Project project, List<? extends UrlTargetInfoEx<? extends HttpRequestPresentableError>> invalidUrlTargetInfos) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        NotificationGroup notificationGroup = this.defaultNotificationGroup;
        Iterable iterable = invalidUrlTargetInfos;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SmartPsiElementPointer smartPsiElementPointer;
            void it;
            UrlTargetInfoEx urlTargetInfoEx = (UrlTargetInfoEx)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiElement psiElement = it.getUrl().resolveToPsiElement();
            if (psiElement != null && (psiElement = psiElement.getNavigationElement()) != null) {
                PsiElement psiElement2 = psiElement;
                boolean bl2 = false;
                boolean bl3 = false;
                PsiElement el = psiElement2;
                boolean bl4 = false;
                smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)el);
            } else {
                smartPsiElementPointer = null;
            }
            SmartPsiElementPointer smartPsiElementPointer2 = smartPsiElementPointer;
            collection.add(smartPsiElementPointer2);
        }
        List pointers = (List)destination$iv$iv;
        String string = RestClientBundle.message("http.request.microservices.generate.from.endpoints.view.fail.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RestClientBundle.message\u2026dpoints.view.fail.title\")");
        String string2 = RestClientBundle.message("http.request.microservices.generate.from.endpoints.view.fail.message", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"RestClientBundle.message\u2026oints.view.fail.message\")");
        MyNotification notification = new MyNotification(NotificationGroup.createNotification$default((NotificationGroup)notificationGroup, (String)string, (String)string2, (NotificationType)NotificationType.ERROR, null, (int)8, null));
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)invalidUrlTargetInfos)) {
            String msg;
            Intrinsics.checkNotNullExpressionValue((Object)RestClientBundle.message("http.request.microservices.generate.from.endpoints.view.fail.concrete.message", ((HttpRequestPresentableError)((UrlTargetInfoEx)indexedValue.getValue()).getAdditionalInfo()).getMessage(), ((UrlTargetInfoEx)indexedValue.getValue()).getUrl().getPath().getPresentation()), (String)"RestClientBundle.message\u2026getPresentation()\n      )");
            notification.addAction((AnAction)NotificationAction.create((String)msg, (Consumer)((Consumer)new Consumer<AnActionEvent>(project, invalidUrlTargetInfos, pointers, indexedValue){
                final /* synthetic */ Project $project;
                final /* synthetic */ List $invalidUrlTargetInfos;
                final /* synthetic */ List $pointers;
                final /* synthetic */ IndexedValue $indexedValue;

                public final void consume(AnActionEvent $noName_0) {
                    block0: {
                        HttpGenerateRequestFromEndpointsActionKt.access$countStatistics(this.$project, this.$invalidUrlTargetInfos);
                        SmartPsiElementPointer smartPsiElementPointer = (SmartPsiElementPointer)this.$pointers.get(this.$indexedValue.getIndex());
                        if (smartPsiElementPointer == null || (smartPsiElementPointer = smartPsiElementPointer.getElement()) == null) break block0;
                        SmartPsiElementPointer smartPsiElementPointer2 = smartPsiElementPointer;
                        boolean bl = false;
                        boolean bl2 = false;
                        SmartPsiElementPointer navigationElement = smartPsiElementPointer2;
                        boolean bl3 = false;
                        new PsiElementNavigatable((PsiElement)navigationElement).navigate(true);
                    }
                }
                {
                    this.$project = project;
                    this.$invalidUrlTargetInfos = list;
                    this.$pointers = list2;
                    this.$indexedValue = indexedValue;
                }
            })));
        }
        notification.setCollapseActionsDirection(Notification.CollapseActionsDirection.KEEP_LEFTMOST);
        notification.setDropDownText(RestClientBundle.message("http.request.microservices.generate.from.endpoints.view.fail.dropdown", new Object[0]));
        notification.whenExpired(new Runnable(project){
            final /* synthetic */ Project $project;

            public final void run() {
                NotificationsManager manager = NotificationsManager.getNotificationsManager();
                Notification[] notificationArray = manager.getNotificationsOfType(MyNotification.class, this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)notificationArray, (String)"manager.getNotifications\u2026ion::class.java, project)");
                Notification[] $this$forEach$iv = notificationArray;
                boolean $i$f$forEach = false;
                for (Notification element$iv : $this$forEach$iv) {
                    MyNotification it = (MyNotification)element$iv;
                    boolean bl = false;
                    manager.expire((Notification)it);
                }
            }
            {
                this.$project = project;
            }
        });
        notification.notify(project);
    }

    public HttpGenerateRequestFromEndpointsAction() {
        super(RestClientBundle.messagePointer("http.request.microservices.generate.from.endpoints.view.title", new Object[0]), (Supplier)1.INSTANCE, RestClientIcons.Http_requests_filetype);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/httpClient/actions/microservices/HttpGenerateRequestFromEndpointsAction$MyNotification;", "Lcom/intellij/notification/Notification;", "delegate", "(Lcom/intellij/notification/Notification;)V", "intellij.restClient"})
    private static final class MyNotification
    extends Notification {
        public MyNotification(@NotNull Notification delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            super(delegate.getGroupId(), delegate.getTitle(), delegate.getContent(), delegate.getType());
        }
    }
}

