/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions.generation;

import com.intellij.httpClient.actions.generation.HttpRequestUrlContextError;
import com.intellij.httpClient.actions.generation.PartialResult;
import com.intellij.httpClient.actions.generation.UrlChecker;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B#\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/httpClient/actions/generation/HttpRequestUrlContextInfo;", "", "schemes", "", "", "authorities", "(Ljava/util/List;Ljava/util/List;)V", "getAuthorities", "()Ljava/util/List;", "authoritiesWithScheme", "", "getAuthoritiesWithScheme", "()Ljava/lang/Iterable;", "onlyOneAuthorityWithScheme", "", "getOnlyOneAuthorityWithScheme", "()Z", "getSchemes", "equals", "other", "hashCode", "", "toString", "Companion", "intellij.restClient"})
public final class HttpRequestUrlContextInfo {
    @NotNull
    private final List<String> schemes;
    @NotNull
    private final List<String> authorities;
    private static final List<String> LOCALHOST;
    @NotNull
    private static final HttpRequestUrlContextInfo DEFAULT_CONTEXT;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Iterable<String> getAuthoritiesWithScheme() {
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.schemes), (Function1)((Function1)new Function1<String, Sequence<? extends String>>(this){
            final /* synthetic */ HttpRequestUrlContextInfo this$0;

            @NotNull
            public final Sequence<String> invoke(@NotNull String scheme) {
                Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
                return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.this$0.getAuthorities()), (Function1)((Function1)new Function1<String, String>(scheme){
                    final /* synthetic */ String $scheme;

                    @NotNull
                    public final String invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.$scheme + it;
                    }
                    {
                        this.$scheme = string;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = httpRequestUrlContextInfo;
                super(1);
            }
        })));
    }

    public final boolean getOnlyOneAuthorityWithScheme() {
        return this.schemes.size() == 1 && this.authorities.size() == 1;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.httpClient.actions.generation.HttpRequestUrlContextInfo");
        }
        HttpRequestUrlContextInfo cfr_ignored_0 = (HttpRequestUrlContextInfo)object2;
        if (Intrinsics.areEqual(this.schemes, ((HttpRequestUrlContextInfo)other).schemes) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual(this.authorities, ((HttpRequestUrlContextInfo)other).authorities) ^ true);
    }

    public int hashCode() {
        int result = ((Object)this.schemes).hashCode();
        result = 31 * result + ((Object)this.authorities).hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "HttpGenerationContext(schemes=" + this.schemes + ", authorities=" + this.authorities + ')';
    }

    @NotNull
    public final List<String> getSchemes() {
        return this.schemes;
    }

    @NotNull
    public final List<String> getAuthorities() {
        return this.authorities;
    }

    private HttpRequestUrlContextInfo(List<String> schemes, List<String> authorities) {
        this.schemes = schemes;
        this.authorities = authorities;
    }

    static {
        Companion = new Companion(null);
        LOCALHOST = CollectionsKt.listOf((Object[])new String[]{"localhost", "127.0.0.1", "localhost:8080", "127.0.0.1:8080"});
        DEFAULT_CONTEXT = new HttpRequestUrlContextInfo(UrlConstants.HTTP_SCHEMES, LOCALHOST);
    }

    public /* synthetic */ HttpRequestUrlContextInfo(List schemes, List authorities, DefaultConstructorMarker $constructor_marker) {
        this(schemes, authorities);
    }

    @JvmStatic
    @NotNull
    public static final HttpRequestUrlContextInfo notEmpty(@Nullable HttpRequestUrlContextInfo $this$notEmpty) {
        return Companion.notEmpty($this$notEmpty);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u000e\u0010\u0011\u001a\u00020\u0004*\u0004\u0018\u00010\u0004H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/httpClient/actions/generation/HttpRequestUrlContextInfo$Companion;", "", "()V", "DEFAULT_CONTEXT", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlContextInfo;", "getDEFAULT_CONTEXT", "()Lcom/intellij/httpClient/actions/generation/HttpRequestUrlContextInfo;", "LOCALHOST", "", "", "create", "Lcom/intellij/httpClient/actions/generation/PartialResult;", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlContextError;", "project", "Lcom/intellij/openapi/project/Project;", "schemes", "authorities", "notEmpty", "intellij.restClient"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final PartialResult<HttpRequestUrlContextInfo, HttpRequestUrlContextError> create(@NotNull Project project, @NotNull List<String> schemes, @NotNull List<String> authorities) {
            void validAuthorities;
            void wrongSchemes;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(schemes, (String)"schemes");
            Intrinsics.checkNotNullParameter(authorities, (String)"authorities");
            Iterable $this$partition$iv22 = schemes;
            boolean $i$f$partition22 = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv22) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!UrlConstants.HTTP_SCHEMES.contains(it)) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Object object = new Pair(first$iv, second$iv);
            List list = (List)object.component1();
            List validSchemes = (List)object.component2();
            object = schemes;
            boolean $this$partition$iv22 = false;
            if (!object.isEmpty() && wrongSchemes.size() == schemes.size()) {
                return new PartialResult.Error<HttpRequestUrlContextError>(new HttpRequestUrlContextError((List)wrongSchemes, null, 2, null));
            }
            Iterable $this$partition$iv = authorities;
            boolean $i$f$partition = false;
            ArrayList first$iv2 = new ArrayList();
            ArrayList second$iv2 = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (UrlChecker.isValidRequest$default(UrlChecker.INSTANCE, project, null, it, 2, null)) {
                    first$iv2.add(element$iv);
                    continue;
                }
                second$iv2.add(element$iv);
            }
            Object $i$f$partition22 = new Pair(first$iv2, second$iv2);
            object = (List)$i$f$partition22.component1();
            List wrongAuthorities = (List)$i$f$partition22.component2();
            $i$f$partition22 = authorities;
            boolean bl = false;
            if (!$i$f$partition22.isEmpty() && wrongAuthorities.size() == authorities.size()) {
                return new PartialResult.Error<HttpRequestUrlContextError>(new HttpRequestUrlContextError(null, wrongAuthorities, 1, null));
            }
            HttpRequestUrlContextInfo result = new HttpRequestUrlContextInfo(validSchemes, (List)validAuthorities, null);
            return wrongSchemes.isEmpty() && wrongAuthorities.isEmpty() ? (PartialResult)new PartialResult.Success<HttpRequestUrlContextInfo>(result) : (PartialResult)new PartialResult.PartialSuccess<HttpRequestUrlContextInfo, HttpRequestUrlContextError>(result, new HttpRequestUrlContextError((List<String>)wrongSchemes, wrongAuthorities));
        }

        @JvmStatic
        @NotNull
        public final HttpRequestUrlContextInfo notEmpty(@Nullable HttpRequestUrlContextInfo $this$notEmpty) {
            if ($this$notEmpty == null) {
                return this.getDEFAULT_CONTEXT();
            }
            Collection collection = $this$notEmpty.getSchemes();
            boolean bl = false;
            if (!collection.isEmpty()) {
                collection = $this$notEmpty.getAuthorities();
                bl = false;
                if (!collection.isEmpty()) {
                    return $this$notEmpty;
                }
            }
            collection = $this$notEmpty.getSchemes();
            bl = false;
            if (!collection.isEmpty()) {
                return new HttpRequestUrlContextInfo($this$notEmpty.getSchemes(), LOCALHOST, null);
            }
            collection = $this$notEmpty.getAuthorities();
            bl = false;
            if (!collection.isEmpty()) {
                return new HttpRequestUrlContextInfo(UrlConstants.HTTP_SCHEMES, $this$notEmpty.getAuthorities(), null);
            }
            return this.getDEFAULT_CONTEXT();
        }

        @NotNull
        public final HttpRequestUrlContextInfo getDEFAULT_CONTEXT() {
            return DEFAULT_CONTEXT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

