/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.jcef;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JCEFHtmlPanel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.random.Random;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.plugins.markdown.extensions.MarkdownConfigurableExtension;
import org.intellij.plugins.markdown.extensions.jcef.MarkdownJCEFPreviewExtension;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.PreviewStaticServer;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.intellij.plugins.markdown.ui.preview.jcef.BrowserPipe;
import org.intellij.plugins.markdown.ui.preview.jcef.IncrementalDOM;
import org.intellij.plugins.markdown.ui.preview.jcef.MarkdownJCEFHtmlPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0002\"#B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u001aH\u0016J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel;", "Lcom/intellij/ui/jcef/JCEFHtmlPanel;", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "()V", "browserPipe", "Lorg/intellij/plugins/markdown/ui/preview/jcef/BrowserPipe;", "delayedContent", "", "firstUpdate", "", "indexContent", "getIndexContent", "()Ljava/lang/String;", "previousRenderClousure", "resourceProvider", "Lorg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel$MyResourceProvider;", "scrollListeners", "Ljava/util/ArrayList;", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel$ScrollListener;", "Lkotlin/collections/ArrayList;", "addScrollListener", "", "listener", "dispose", "reloadWithOffset", "offset", "", "removeScrollListener", "scrollToMarkdownSrcOffset", "setHtml", "html", "initialScrollOffset", "updateDom", "renderClosure", "Companion", "MyResourceProvider", "intellij.markdown"})
public final class MarkdownJCEFHtmlPanel
extends JCEFHtmlPanel
implements MarkdownHtmlPanel {
    private final MyResourceProvider resourceProvider = new MyResourceProvider();
    private final BrowserPipe browserPipe = new BrowserPipe((JBCefBrowser)this);
    private final ArrayList<MarkdownHtmlPanel.ScrollListener> scrollListeners = new ArrayList();
    private volatile String delayedContent;
    private boolean firstUpdate = true;
    private String previousRenderClousure = "";
    private static final String SET_SCROLL_EVENT = "setScroll";
    private static final String EVENTS_SCRIPT_FILENAME = "events.js";
    private static final List<String> baseScripts;
    private static final List<String> baseStyles;
    @NotNull
    public static final Companion Companion;

    private final String getIndexContent() {
        return "\n      <!DOCTYPE html>\n      <html>\n        <head>\n          <meta http-equiv=\"Content-Security-Policy\" content=\"" + MarkdownJCEFHtmlPanel.Companion.getContentSecurityPolicy() + "\"/>\n          <meta name=\"markdown-position-attribute-name\" content=\"" + HtmlGenerator.Companion.getSRC_ATTRIBUTE_NAME() + "\"/>\n          " + MarkdownJCEFHtmlPanel.Companion.getScriptingLines() + "\n          " + MarkdownJCEFHtmlPanel.Companion.getStylesLines() + "\n        </head>\n      </html>\n    ";
    }

    private final void updateDom(String renderClosure, int initialScrollOffset) {
        String code;
        this.previousRenderClousure = renderClosure;
        String scrollCode = this.firstUpdate ? "window.scrollController.scrollTo(" + initialScrollOffset + ", true);" : "";
        this.delayedContent = code = "\n        (function() {\n          const action = () => {\n            console.time(\"incremental-dom-patch\");\n            const render = " + this.previousRenderClousure + ";\n            IncrementalDOM.patch(document.body, () => render());\n            " + scrollCode + "\n            if (IncrementalDOM.notifications.afterPatchListeners) {\n              IncrementalDOM.notifications.afterPatchListeners.forEach(listener => listener());\n            }\n            console.timeEnd(\"incremental-dom-patch\");\n          };\n          if (document.readyState === \"loading\" || document.readyState === \"uninitialized\") {\n            document.addEventListener(\"DOMContentLoaded\", () => action(), { once: true });\n          }\n          else {\n            action();\n          }\n        })();\n      ";
        this.getCefBrowser().executeJavaScript(code, null, 0);
    }

    @Override
    public void setHtml(@NotNull String html, int initialScrollOffset) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        this.updateDom(IncrementalDOM.INSTANCE.generateRenderClosure(html), initialScrollOffset);
        this.firstUpdate = false;
    }

    @Override
    public void reloadWithOffset(int offset) {
        this.delayedContent = null;
        this.firstUpdate = true;
        super.setHtml(this.getIndexContent());
        this.updateDom(this.previousRenderClousure, offset);
    }

    @Override
    public void addScrollListener(@NotNull MarkdownHtmlPanel.ScrollListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.scrollListeners.add(listener);
    }

    @Override
    public void removeScrollListener(@Nullable MarkdownHtmlPanel.ScrollListener listener) {
        Collection collection = this.scrollListeners;
        boolean bl = false;
        Collection collection2 = collection;
        if (collection2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
        }
        TypeIntrinsics.asMutableCollection((Object)collection2).remove(listener);
    }

    @Override
    public void scrollToMarkdownSrcOffset(int offset) {
        this.getCefBrowser().executeJavaScript("if (window.scrollController) { window.scrollController.scrollTo(" + offset + "); }", null, 0);
    }

    public void dispose() {
        super.dispose();
    }

    /*
     * WARNING - void declaration
     */
    public MarkdownJCEFHtmlPanel() {
        super(MarkdownJCEFHtmlPanel.Companion.getClassUrl());
        void $this$flatMapTo$iv$iv;
        Disposer.register((Disposable)this, (Disposable)this.browserPipe);
        PreviewStaticServer.Companion.getInstance().setResourceProvider(this.resourceProvider);
        this.browserPipe.addBrowserEvents(SET_SCROLL_EVENT);
        this.browserPipe.subscribe("documentReady", (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String it) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String string = delayedContent;
                    if (string == null) break block0;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it2 = string2;
                    boolean bl3 = false;
                    this.getCefBrowser().executeJavaScript(it2, null, 0);
                    delayedContent = null;
                }
            }
        }));
        this.browserPipe.subscribe(SET_SCROLL_EVENT, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Integer n = StringsKt.toIntOrNull((String)data);
                if (n != null) {
                    Integer n2 = n;
                    boolean bl = false;
                    boolean bl2 = false;
                    int offset = ((Number)n2).intValue();
                    boolean bl3 = false;
                    Iterable $this$forEach$iv = scrollListeners;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        MarkdownHtmlPanel.ScrollListener it = (MarkdownHtmlPanel.ScrollListener)element$iv;
                        boolean bl4 = false;
                        it.onScroll(offset);
                    }
                }
            }
        }));
        Iterable $this$flatMap$iv = MarkdownJCEFHtmlPanel.Companion.getExtensions();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            MarkdownJCEFPreviewExtension it = (MarkdownJCEFPreviewExtension)element$iv$iv;
            boolean bl3 = false;
            Iterable list$iv$iv = it.getEvents().entrySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void event;
            Map.Entry $dstr$event$handler = (Map.Entry)element$iv;
            boolean bl = false;
            Map.Entry entry = $dstr$event$handler;
            boolean bl2 = false;
            String bl3 = (String)entry.getKey();
            entry = $dstr$event$handler;
            bl2 = false;
            Function1 handler = (Function1)entry.getValue();
            this.browserPipe.addBrowserEvents(new String[]{event});
            this.browserPipe.subscribe((String)event, (Function1<? super String, Unit>)handler);
        }
        super.setHtml(this.getIndexContent());
    }

    static {
        Companion = new Companion(null);
        baseScripts = CollectionsKt.listOf((Object[])new String[]{"incremental-dom.min.js", "incremental-dom-additions.js", "BrowserPipe.js", EVENTS_SCRIPT_FILENAME, "ScrollSync.js"});
        baseStyles = CollectionsKt.emptyList();
    }

    public static final /* synthetic */ List access$getBaseStyles$cp() {
        return baseStyles;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\b\u001a\u00020\u0005H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel$MyResourceProvider;", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "(Lorg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel;)V", "internalResources", "", "", "canProvide", "", "resourceName", "loadResource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "intellij.markdown"})
    private final class MyResourceProvider
    implements ResourceProvider {
        private final List<String> internalResources = CollectionsKt.plus((Collection)MarkdownJCEFHtmlPanel.access$getBaseScripts$cp(), (Iterable)MarkdownJCEFHtmlPanel.access$getBaseStyles$cp());

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean canProvide(@NotNull String resourceName) {
            MarkdownJCEFPreviewExtension it;
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            if (this.internalResources.contains(resourceName)) return true;
            Iterable $this$any$iv = Companion.getExtensions();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (MarkdownJCEFPreviewExtension)element$iv;
                boolean bl = false;
            } while (!it.getResourceProvider().canProvide(resourceName));
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public ResourceProvider.Resource loadResource(@NotNull String resourceName) {
            ResourceProvider.Resource resource;
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            String string = resourceName;
            if (Intrinsics.areEqual((Object)string, (Object)MarkdownJCEFHtmlPanel.EVENTS_SCRIPT_FILENAME)) {
                String string2 = MarkdownJCEFHtmlPanel.this.browserPipe.inject();
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string3.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                resource = new ResourceProvider.Resource(byArray, null, 2, null);
            } else if (this.internalResources.contains(string)) {
                ResourceProvider.Companion this_$iv = ResourceProvider.Companion;
                String contentType$iv = null;
                boolean $i$f$loadInternalResource = false;
                resource = this_$iv.loadInternalResource(MarkdownJCEFHtmlPanel.class, resourceName, contentType$iv);
            } else {
                Object v3;
                block7: {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = Companion.getExtensions();
                    boolean $i$f$map = false;
                    Iterable $i$f$loadInternalResource = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        MarkdownJCEFPreviewExtension markdownJCEFPreviewExtension = (MarkdownJCEFPreviewExtension)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        ResourceProvider resourceProvider = it.getResourceProvider();
                        collection.add(resourceProvider);
                    }
                    Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ResourceProvider it = (ResourceProvider)element$iv;
                        boolean bl = false;
                        if (!it.canProvide(resourceName)) continue;
                        v3 = element$iv;
                        break block7;
                    }
                    v3 = null;
                }
                ResourceProvider resourceProvider = v3;
                resource = resourceProvider != null ? resourceProvider.loadResource(resourceName) : null;
            }
            return resource;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000bR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0016\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel$Companion;", "", "()V", "EVENTS_SCRIPT_FILENAME", "", "SET_SCROLL_EVENT", "baseScripts", "", "baseStyles", "contentSecurityPolicy", "getContentSecurityPolicy", "()Ljava/lang/String;", "extensions", "Lorg/intellij/plugins/markdown/extensions/jcef/MarkdownJCEFPreviewExtension;", "getExtensions", "()Ljava/util/List;", "scriptingLines", "getScriptingLines", "scripts", "getScripts", "styles", "getStyles", "stylesLines", "getStylesLines", "getClassUrl", "intellij.markdown"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final List<MarkdownJCEFPreviewExtension> getExtensions() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = MarkdownJCEFPreviewExtension.Companion.getAllSorted();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MarkdownJCEFPreviewExtension it = (MarkdownJCEFPreviewExtension)element$iv$iv;
                boolean bl = false;
                boolean bl2 = it instanceof MarkdownConfigurableExtension ? ((MarkdownConfigurableExtension)((Object)it)).isEnabled() : true;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getScripts() {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Iterable iterable = Companion.getExtensions();
            Collection collection = baseScripts;
            boolean $i$f$flatMap = false;
            void var3_4 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                MarkdownJCEFPreviewExtension it = (MarkdownJCEFPreviewExtension)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getScripts();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List list = (List)destination$iv$iv;
            return CollectionsKt.plus((Collection)collection, (Iterable)list);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getStyles() {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = Companion.getExtensions();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                MarkdownJCEFPreviewExtension it = (MarkdownJCEFPreviewExtension)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getStyles();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final String getScriptingLines() {
            return CollectionsKt.joinToString$default((Iterable)Companion.getScripts(), (CharSequence)"\n", null, null, (int)0, null, (Function1)scriptingLines.1.INSTANCE, (int)30, null);
        }

        private final String getStylesLines() {
            return CollectionsKt.joinToString$default((Iterable)Companion.getStyles(), (CharSequence)"\n", null, null, (int)0, null, (Function1)stylesLines.1.INSTANCE, (int)30, null);
        }

        private final String getContentSecurityPolicy() {
            Object object;
            String it;
            Collection<String> collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = Companion.getScripts();
            PreviewStaticServer.Companion companion = PreviewStaticServer.Companion;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                object = PreviewStaticServer.Companion.getStaticUrl(it);
                collection.add((String)object);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = Companion.getStyles();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                String string = PreviewStaticServer.Companion.getStaticUrl(it);
                object.add(string);
            }
            object = (List)destination$iv$iv;
            return companion.createCSP((List<String>)collection, (List<String>)object);
        }

        private final String getClassUrl() {
            String string;
            try {
                Class<MarkdownJCEFHtmlPanel> cls = MarkdownJCEFHtmlPanel.class;
                String string2 = cls.getResource(cls.getSimpleName() + ".class").toExternalForm();
                if (string2 == null) {
                    String string3 = "Failed to get class URL!";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
                string = string2;
            }
            catch (Exception ignored) {
                string = "about:blank";
            }
            String url = string;
            return url + '@' + Random.Default.nextInt(Integer.MAX_VALUE);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

