/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.jcef;

import com.intellij.openapi.util.text.StringUtil;
import java.net.URLEncoder;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bJ\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bJ\u001c\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0002J\u001c\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00172\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0002J\"\u0010\u0018\u001a\u00060\bj\u0002`\t2\u0006\u0010\u0005\u001a\u00020\u00062\f\b\u0002\u0010\u0019\u001a\u00060\bj\u0002`\tH\u0002\u00a8\u0006\u001a"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/jcef/IncrementalDOM;", "", "()V", "closeTag", "", "node", "Lorg/jsoup/nodes/Node;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "encodeArgument", "", "argument", "ensureCorrectTag", "name", "escapeAttributeContent", "string", "escapeTagContent", "generateDomBuildCalls", "html", "generateRenderClosure", "openTag", "textElement", "Lorg/jsoup/nodes/TextNode;", "traverse", "result", "intellij.markdown"})
public final class IncrementalDOM {
    @NotNull
    public static final IncrementalDOM INSTANCE;

    private final String ensureCorrectTag(String name) {
        return Intrinsics.areEqual((Object)name, (Object)"body") ? "div" : name;
    }

    private final String encodeArgument(String argument) {
        String string = URLEncoder.encode(argument, Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URLEncoder.encode(argument, Charsets.UTF_8)");
        return StringsKt.replace$default((String)string, (String)"+", (String)"%20", (boolean)false, (int)4, null);
    }

    private final void openTag(Node node, StringBuilder builder) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$with = builder;
        boolean bl3 = false;
        $this$with.append("o('");
        String string = node.nodeName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.nodeName()");
        $this$with.append(INSTANCE.ensureCorrectTag(string));
        $this$with.append("'");
        for (Attribute attribute : node.attributes()) {
            $this$with.append(",'");
            $this$with.append(attribute.getKey());
            $this$with.append("','");
            String string2 = attribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"attribute.value");
            $this$with.append(INSTANCE.escapeAttributeContent(string2));
            $this$with.append("'");
        }
        $this$with.append(");");
    }

    private final void closeTag(Node node, StringBuilder builder) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$with = builder;
        boolean bl3 = false;
        $this$with.append("c('");
        String string = node.nodeName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.nodeName()");
        $this$with.append(INSTANCE.ensureCorrectTag(string));
        $this$with.append("');");
    }

    private final void textElement(TextNode node, StringBuilder builder) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$with = builder;
        boolean bl3 = false;
        $this$with.append("t(`");
        String string = node.getWholeText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.wholeText");
        $this$with.append(INSTANCE.encodeArgument(string));
        $this$with.append("`);");
    }

    private final StringBuilder traverse(Node node, StringBuilder result) {
        Node node2 = node;
        if (node2 instanceof TextNode) {
            this.textElement((TextNode)node, result);
        } else if (!(node2 instanceof Comment)) {
            this.openTag(node, result);
            Iterator iterator = node.childNodes().iterator();
            while (iterator.hasNext()) {
                Node child;
                Node node3 = child = (Node)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)node3, (String)"child");
                this.traverse(node3, result);
            }
            this.closeTag(node, result);
        }
        return result;
    }

    static /* synthetic */ StringBuilder traverse$default(IncrementalDOM incrementalDOM, Node node, StringBuilder stringBuilder, int n, Object object) {
        if ((n & 2) != 0) {
            stringBuilder = new StringBuilder();
        }
        return incrementalDOM.traverse(node, stringBuilder);
    }

    @NotNull
    public final String generateRenderClosure(@NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        return "\n      () => {\n        const o = (tag, ...attrs) => IncrementalDOM.elementOpen(tag, null, null, ...attrs);\n        const t = content => IncrementalDOM.text(decodeURIComponent(content));\n        const c = IncrementalDOM.elementClose;\n        " + this.generateDomBuildCalls(html) + "\n      }\n    ";
    }

    @NotNull
    public final String generateDomBuildCalls(@NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        Document document = Jsoup.parse((String)html);
        Element element = document.body();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"document.body()");
        String string = IncrementalDOM.traverse$default(this, (Node)element, null, 2, null).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"traverse(document.body()).toString()");
        return string;
    }

    private final String escapeTagContent(String string) {
        String string2 = StringUtil.escapeChars((String)string, (char[])new char[]{'\\', '`', '$'});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.escapeChars(string, '\\\\', '`', '$')");
        return string2;
    }

    private final String escapeAttributeContent(String string) {
        String string2 = StringUtil.escapeChar((String)string, (char)'\'');
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.escapeChar(string, '\\'')");
        return string2;
    }

    private IncrementalDOM() {
    }

    static {
        IncrementalDOM incrementalDOM;
        INSTANCE = incrementalDOM = new IncrementalDOM();
    }
}

