/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.DynamicBundle;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.settings.MarkdownCssSettings;
import org.intellij.plugins.markdown.settings.MarkdownPreviewSettings;
import org.intellij.plugins.markdown.settings.MarkdownScriptsTable;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelProvider;
import org.intellij.plugins.markdown.ui.split.SplitFileEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownSettingsForm
implements MarkdownCssSettings.Holder,
MarkdownPreviewSettings.Holder,
Disposable {
    private JPanel myMainPanel;
    private JBCheckBox myCustomCssFromPathEnabled;
    private TextFieldWithBrowseButton myCustomCssPath;
    private JBCheckBox myApplyCustomCssText;
    private JPanel myEditorPanel;
    private JPanel myCssTitledSeparator;
    private ComboBox myPreviewProvider;
    private ComboBox myDefaultSplitLayout;
    private JPanel myPreviewTitledSeparator;
    private JBCheckBox myAutoScrollCheckBox;
    private JPanel myMultipleProvidersPreviewPanel;
    private JBRadioButton myVerticalLayout;
    private JBRadioButton myHorizontalLayout;
    private JBLabel myVerticalSplitLabel;
    private JBCheckBox myDisableInjections;
    private JBCheckBox myHideErrorsCheckbox;
    private MarkdownScriptsTable myScriptsTable;
    private JBLabel myExtensionsHelpMessage;
    @Nullable
    private EditorEx myEditor;
    @NotNull
    private final ActionListener myCustomCssPathListener;
    @NotNull
    private final ActionListener myCustomCssTextListener;
    private Object myLastItem;
    private EnumComboBoxModel<SplitFileEditor.SplitEditorLayout> mySplitLayoutModel;
    private CollectionComboBoxModel<MarkdownHtmlPanelProvider.ProviderInfo> myPreviewPanelModel;

    public MarkdownSettingsForm() {
        this.$$$setupUI$$$();
        this.myCustomCssPathListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarkdownSettingsForm.this.myCustomCssPath.setEnabled(MarkdownSettingsForm.this.myCustomCssFromPathEnabled.isSelected());
            }
        };
        this.myCustomCssTextListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarkdownSettingsForm.this.adjustCSSRulesAvailability();
            }
        };
        this.adjustCSSRulesAvailability();
        this.myCustomCssFromPathEnabled.addActionListener(this.myCustomCssPathListener);
        this.myApplyCustomCssText.addActionListener(this.myCustomCssTextListener);
        this.myCustomCssPath.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFileDescriptor((String)"css")){

            @NotNull
            protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    3.$$$reportNull$$$0(0);
                }
                String string = chosenFile.getPath();
                if (string == null) {
                    3.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "chosenFile";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/plugins/markdown/settings/MarkdownSettingsForm$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/plugins/markdown/settings/MarkdownSettingsForm$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "chosenFileToResultingText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "chosenFileToResultingText";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.myMultipleProvidersPreviewPanel.setVisible(MarkdownSettingsForm.isMultipleProviders());
        this.myDefaultSplitLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarkdownSettingsForm.this.adjustAutoScroll();
                MarkdownSettingsForm.this.adjustSplitOption();
            }
        });
        this.adjustAutoScroll();
    }

    private void adjustSplitOption() {
        boolean isSplitted = this.myDefaultSplitLayout.getSelectedItem() == SplitFileEditor.SplitEditorLayout.SPLIT;
        this.myVerticalLayout.setEnabled(isSplitted);
        this.myHorizontalLayout.setEnabled(isSplitted);
        this.myVerticalSplitLabel.setEnabled(isSplitted);
    }

    private void adjustAutoScroll() {
        this.myAutoScrollCheckBox.setEnabled(this.myDefaultSplitLayout.getSelectedItem() == SplitFileEditor.SplitEditorLayout.SPLIT);
    }

    private void adjustCSSRulesAvailability() {
        if (this.myEditor != null) {
            boolean enabled = this.myApplyCustomCssText.isSelected();
            this.myEditor.getDocument().setReadOnly(!enabled);
            this.myEditor.getContentComponent().setEnabled(enabled);
            this.myEditor.setCaretEnabled(enabled);
        }
    }

    public JComponent getComponent() {
        return this.myMainPanel;
    }

    private void createUIComponents() {
        this.myEditorPanel = new JPanel(new BorderLayout());
        this.myEditor = MarkdownSettingsForm.createEditor();
        this.myEditorPanel.add((Component)this.myEditor.getComponent(), "Center");
        this.myCssTitledSeparator = new TitledSeparator(MarkdownBundle.message("markdown.settings.css.title.name", new Object[0]));
        this.myExtensionsHelpMessage = ContextHelpLabel.create((String)MarkdownBundle.message("markdown.settings.download.extension.download.notice", new Object[0]));
        this.myScriptsTable = new MarkdownScriptsTable();
        this.createPreviewUIComponents();
    }

    private static boolean isMultipleProviders() {
        return MarkdownHtmlPanelProvider.getProviders().length > 1;
    }

    public void validate() throws ConfigurationException {
        if (!this.myCustomCssFromPathEnabled.isSelected()) {
            return;
        }
        if (!new File(this.myCustomCssPath.getText()).exists()) {
            throw new ConfigurationException(MarkdownBundle.message("dialog.message.path.error", this.myCustomCssPath.getText()));
        }
    }

    @NotNull
    private static EditorEx createEditor() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document editorDocument = editorFactory.createDocument((CharSequence)"");
        EditorEx editor = (EditorEx)editorFactory.createEditor(editorDocument);
        MarkdownSettingsForm.fillEditorSettings(editor.getSettings());
        MarkdownSettingsForm.setHighlighting(editor);
        EditorEx editorEx = editor;
        if (editorEx == null) {
            MarkdownSettingsForm.$$$reportNull$$$0(0);
        }
        return editorEx;
    }

    private static void setHighlighting(EditorEx editor) {
        FileType cssFileType = FileTypeManager.getInstance().getFileTypeByExtension("css");
        if (cssFileType == UnknownFileType.INSTANCE) {
            return;
        }
        EditorHighlighter editorHighlighter = HighlighterFactory.createHighlighter((FileType)cssFileType, (EditorColorsScheme)EditorColorsManager.getInstance().getGlobalScheme(), null);
        editor.setHighlighter(editorHighlighter);
    }

    private static void fillEditorSettings(EditorSettings editorSettings) {
        editorSettings.setWhitespacesShown(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(true);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setAdditionalColumnsCount(1);
        editorSettings.setAdditionalLinesCount(1);
        editorSettings.setUseSoftWraps(false);
    }

    @Override
    public void setMarkdownCssSettings(@NotNull MarkdownCssSettings settings) {
        if (settings == null) {
            MarkdownSettingsForm.$$$reportNull$$$0(1);
        }
        this.myCustomCssFromPathEnabled.setSelected(settings.isCustomStylesheetEnabled());
        this.myCustomCssPath.setText(settings.getCustomStylesheetPath());
        this.myApplyCustomCssText.setSelected(settings.isTextEnabled());
        this.resetEditor(settings.getCustomStylesheetText());
        this.myCustomCssPathListener.actionPerformed(null);
        this.myCustomCssTextListener.actionPerformed(null);
    }

    void resetEditor(@NotNull String cssText) {
        if (cssText == null) {
            MarkdownSettingsForm.$$$reportNull$$$0(2);
        }
        if (this.myEditor != null && !this.myEditor.isDisposed()) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                boolean writable = this.myEditor.getDocument().isWritable();
                this.myEditor.getDocument().setReadOnly(false);
                this.myEditor.getDocument().setText((CharSequence)cssText);
                this.myEditor.getDocument().setReadOnly(!writable);
            });
        }
    }

    @Override
    @NotNull
    public MarkdownCssSettings getMarkdownCssSettings() {
        String customCssText = this.myEditor != null && !this.myEditor.isDisposed() ? (String)ReadAction.compute(() -> this.myEditor.getDocument().getText()) : "";
        Integer fontSize = MarkdownApplicationSettings.getInstance().getMarkdownCssSettings().getFontSize();
        String fontFamily = MarkdownApplicationSettings.getInstance().getMarkdownCssSettings().getFontFamily();
        return new MarkdownCssSettings(this.myCustomCssFromPathEnabled.isSelected(), this.myCustomCssPath.getText(), this.myApplyCustomCssText.isSelected(), customCssText, fontSize, fontFamily);
    }

    @NotNull
    public Map<String, Boolean> getExtensionsEnabledState() {
        return new HashMap<String, Boolean>(this.myScriptsTable.getState());
    }

    public void setExtensionsEnabledState(@NotNull Map<String, Boolean> state) {
        if (state == null) {
            MarkdownSettingsForm.$$$reportNull$$$0(3);
        }
        this.myScriptsTable.setState(state, (MarkdownHtmlPanelProvider.ProviderInfo)this.myPreviewProvider.getSelectedItem());
    }

    public void dispose() {
        if (this.myEditor != null && !this.myEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
        }
        this.myEditor = null;
    }

    private void createPreviewUIComponents() {
        this.myPreviewTitledSeparator = new TitledSeparator(MarkdownBundle.message("markdown.settings.preview.name", new Object[0]));
        this.mySplitLayoutModel = new EnumComboBoxModel(SplitFileEditor.SplitEditorLayout.class);
        this.myDefaultSplitLayout = new ComboBox(this.mySplitLayoutModel);
        this.myDefaultSplitLayout.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", SplitFileEditor.SplitEditorLayout::getPresentationText));
        this.createMultipleProvidersSettings();
    }

    private void createMultipleProvidersSettings() {
        List providerInfos = ContainerUtil.mapNotNull((Object[])MarkdownHtmlPanelProvider.getProviders(), provider -> {
            if (provider.isAvailable() == MarkdownHtmlPanelProvider.AvailabilityInfo.UNAVAILABLE) {
                return null;
            }
            return provider.getProviderInfo();
        });
        this.myPreviewPanelModel = new CollectionComboBoxModel(providerInfos, (Object)((MarkdownHtmlPanelProvider.ProviderInfo)providerInfos.get(0)));
        this.myPreviewProvider = new ComboBox(this.myPreviewPanelModel);
        this.myLastItem = this.myPreviewProvider.getSelectedItem();
        this.myPreviewProvider.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item = e.getItem();
                if (e.getStateChange() != 1 || !(item instanceof MarkdownHtmlPanelProvider.ProviderInfo)) {
                    return;
                }
                MarkdownHtmlPanelProvider provider = MarkdownHtmlPanelProvider.createFromInfo((MarkdownHtmlPanelProvider.ProviderInfo)item);
                MarkdownHtmlPanelProvider.AvailabilityInfo availability = provider.isAvailable();
                if (!availability.checkAvailability(MarkdownSettingsForm.this.myMainPanel)) {
                    MarkdownSettingsForm.this.myPreviewProvider.setSelectedItem(MarkdownSettingsForm.this.myLastItem);
                } else {
                    MarkdownSettingsForm.this.myLastItem = item;
                    MarkdownSettingsForm.this.myScriptsTable.setState(MarkdownApplicationSettings.getInstance().getExtensionsEnabledState(), provider.getProviderInfo());
                }
            }
        });
        this.myScriptsTable.setState(MarkdownApplicationSettings.getInstance().getExtensionsEnabledState(), (MarkdownHtmlPanelProvider.ProviderInfo)this.myPreviewProvider.getSelectedItem());
    }

    @NotNull
    private static MarkdownHtmlPanelProvider getDefaultProvider() {
        MarkdownHtmlPanelProvider[] providers = MarkdownHtmlPanelProvider.getProviders();
        if (providers.length > 0) {
            MarkdownHtmlPanelProvider markdownHtmlPanelProvider = providers[0];
            if (markdownHtmlPanelProvider == null) {
                MarkdownSettingsForm.$$$reportNull$$$0(4);
            }
            return markdownHtmlPanelProvider;
        }
        throw new RuntimeException("No providers are defined");
    }

    @NotNull
    private MarkdownHtmlPanelProvider.ProviderInfo getSelectedProvider() {
        if (MarkdownSettingsForm.isMultipleProviders()) {
            MarkdownHtmlPanelProvider.ProviderInfo providerInfo = Objects.requireNonNull((MarkdownHtmlPanelProvider.ProviderInfo)this.myPreviewPanelModel.getSelected());
            if (providerInfo == null) {
                MarkdownSettingsForm.$$$reportNull$$$0(5);
            }
            return providerInfo;
        }
        MarkdownHtmlPanelProvider.ProviderInfo providerInfo = MarkdownSettingsForm.getDefaultProvider().getProviderInfo();
        if (providerInfo == null) {
            MarkdownSettingsForm.$$$reportNull$$$0(6);
        }
        return providerInfo;
    }

    @Override
    public void setMarkdownPreviewSettings(@NotNull MarkdownPreviewSettings settings) {
        if (settings == null) {
            MarkdownSettingsForm.$$$reportNull$$$0(7);
        }
        if (MarkdownSettingsForm.isMultipleProviders() && this.myPreviewPanelModel.contains((Object)settings.getHtmlPanelProviderInfo())) {
            this.myPreviewPanelModel.setSelectedItem((Object)settings.getHtmlPanelProviderInfo());
        }
        this.mySplitLayoutModel.setSelectedItem((Enum)settings.getSplitEditorLayout());
        this.myAutoScrollCheckBox.setSelected(settings.isAutoScrollPreview());
        this.myVerticalLayout.setSelected(settings.isVerticalSplit());
        this.myHorizontalLayout.setSelected(!settings.isVerticalSplit());
    }

    @Override
    @NotNull
    public MarkdownPreviewSettings getMarkdownPreviewSettings() {
        MarkdownHtmlPanelProvider.ProviderInfo provider = this.getSelectedProvider();
        Objects.requireNonNull(provider);
        return new MarkdownPreviewSettings((SplitFileEditor.SplitEditorLayout)this.mySplitLayoutModel.getSelectedItem(), provider, this.myAutoScrollCheckBox.isSelected(), this.myVerticalLayout.isSelected());
    }

    public void setDisableInjections(boolean disableInjections) {
        this.myDisableInjections.setSelected(disableInjections);
    }

    public boolean isDisableInjections() {
        return this.myDisableInjections.isSelected();
    }

    public void setHideErrors(boolean hideErrors) {
        this.myHideErrorsCheckbox.setSelected(hideErrors);
    }

    public boolean isHideErrors() {
        return this.myHideErrorsCheckbox.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/settings/MarkdownSettingsForm";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/settings/MarkdownSettingsForm";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setMarkdownCssSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetEditor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setExtensionsEnabledState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setMarkdownPreviewSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBCheckBox jBCheckBox4;
        JBCheckBox jBCheckBox5;
        JBLabel jBLabel;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 7, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myMultipleProvidersPreviewPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/MarkdownBundle", MarkdownSettingsForm.class).getString("markdown.settings.preview.browser.title"));
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboBox comboBox = this.myPreviewProvider;
        jPanel.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/MarkdownBundle", MarkdownSettingsForm.class).getString("markdown.settings.default.layout"));
        jPanel3.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboBox comboBox2 = this.myDefaultSplitLayout;
        jPanel3.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myVerticalLayout = jBRadioButton2 = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, DynamicBundle.getBundle((String)"messages/MarkdownBundle", MarkdownSettingsForm.class).getString("markdown.settings.preview.layout.vertical"));
        jPanel4.add((Component)jBRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        this.myHorizontalLayout = jBRadioButton = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/MarkdownBundle", MarkdownSettingsForm.class).getString("markdown.settings.preview.layout.horizontal"));
        jPanel4.add((Component)jBRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        this.myVerticalSplitLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/MarkdownBundle", MarkdownSettingsForm.class).getString("markdown.settings.preview.layout.label"));
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAutoScrollCheckBox = jBCheckBox5 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox5, DynamicBundle.getBundle((String)"messages/MarkdownBundle", MarkdownSettingsForm.class).getString("markdown.settings.preview.auto.scroll.checkbox"));
        jPanel3.add((Component)jBCheckBox5, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane, new GridConstraints(1, 3, 4, 3, 0, 3, 3, 3, new Dimension(300, -1), new Dimension(400, -1), null));
        MarkdownScriptsTable markdownScriptsTable = this.myScriptsTable;
        jBScrollPane.setViewportView((Component)((Object)markdownScriptsTable));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 6, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/MarkdownBundle", MarkdownSettingsForm.class).getString("markdown.settings.preview.extensions.name"));
        jPanel3.add((Component)jBLabel4, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel5 = this.myExtensionsHelpMessage;
        jPanel3.add((Component)jBLabel5, new GridConstraints(0, 4, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 5, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(7, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = this.myCssTitledSeparator;
        jPanel2.add((Component)jPanel5, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCustomCssFromPathEnabled = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/MarkdownBundle", MarkdownSettingsForm.class).getString("markdown.settings.css.enable.uri"));
        jPanel2.add((Component)jBCheckBox4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCustomCssPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myApplyCustomCssText = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/MarkdownBundle", MarkdownSettingsForm.class).getString("markdown.settings.css.enable.inline"));
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(5, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel6 = this.myEditorPanel;
        ((Component)jPanel6).setBackground(new Color(-1118482));
        ((Component)jPanel6).setEnabled(true);
        jPanel2.add((Component)jPanel6, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, new Dimension(-1, 150), null, 1));
        this.myDisableInjections = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/MarkdownBundle", MarkdownSettingsForm.class).getString("markdown.settings.disable.injections"));
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myHideErrorsCheckbox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/MarkdownBundle", MarkdownSettingsForm.class).getString("markdown.settings.hide.errors"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

