/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.lang.index.MarkdownHeadersIndex;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeaderImpl;
import org.intellij.plugins.markdown.lang.references.MarkdownAnchorReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004B)\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0011\u001a\u00020\u0006H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0006H\u0016J\u0013\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001b\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/intellij/plugins/markdown/lang/references/MarkdownAnchorReferenceImpl;", "Lorg/intellij/plugins/markdown/lang/references/MarkdownAnchorReference;", "Lcom/intellij/psi/PsiPolyVariantReferenceBase;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/daemon/EmptyResolveMessageProvider;", "myAnchor", "", "myFileReference", "Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference;", "myPsiElement", "myOffset", "", "(Ljava/lang/String;Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference;Lcom/intellij/psi/PsiElement;I)V", "file", "Lcom/intellij/psi/PsiFile;", "getFile", "()Lcom/intellij/psi/PsiFile;", "getCanonicalText", "getElement", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "getUnresolvedMessagePattern", "getVariants", "", "", "()[Ljava/lang/Object;", "multiResolve", "Lcom/intellij/psi/ResolveResult;", "incompleteCode", "", "(Z)[Lcom/intellij/psi/ResolveResult;", "intellij.markdown"})
public final class MarkdownAnchorReferenceImpl
extends PsiPolyVariantReferenceBase<PsiElement>
implements MarkdownAnchorReference,
EmptyResolveMessageProvider {
    private final String myAnchor;
    private final FileReference myFileReference;
    private final PsiElement myPsiElement;
    private final int myOffset;

    private final PsiFile getFile() {
        PsiFile psiFile;
        if (this.myFileReference != null) {
            PsiFileSystemItem psiFileSystemItem = this.myFileReference.resolve();
            if (!(psiFileSystemItem instanceof PsiFile)) {
                psiFileSystemItem = null;
            }
            psiFile = (PsiFile)psiFileSystemItem;
        } else {
            PsiFile psiFile2 = this.myPsiElement.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"myPsiElement.containingFile");
            psiFile = psiFile2.getOriginalFile();
        }
        return psiFile;
    }

    @NotNull
    public PsiElement getElement() {
        return this.myPsiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return new TextRange(this.myOffset, this.myOffset + this.myAnchor.length());
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        CharSequence charSequence = this.myAnchor;
        boolean bl = false;
        if (charSequence.length() == 0) {
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{this.myPsiElement});
            Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"PsiElementResolveResult.\u2026eateResults(myPsiElement)");
            return resolveResultArray;
        }
        Project project = this.myPsiElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myPsiElement.project");
        Project project2 = project;
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(MarkdownAnchorReference.Companion.getPsiHeaders(project2, this.getCanonicalText(), this.getFile()));
        Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"PsiElementResolveResult.\u2026ct, canonicalText, file))");
        return resolveResultArray;
    }

    @NotNull
    public String getCanonicalText() {
        return this.myAnchor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Object[] getVariants() {
        Project project = this.myPsiElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myPsiElement.project");
        Project project2 = project;
        ArrayList list = new ArrayList();
        Collection collection = StubIndex.getInstance().getAllKeys(MarkdownHeadersIndex.Companion.getKEY(), project2);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"StubIndex.getInstance().\u2026eadersIndex.KEY, project)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GlobalSearchScope globalSearchScope;
            String key = (String)element$iv;
            boolean bl = false;
            StubIndex stubIndex = StubIndex.getInstance();
            StubIndexKey<String, MarkdownHeaderImpl> stubIndexKey = MarkdownHeadersIndex.Companion.getKEY();
            String string = key;
            Project project3 = project2;
            if (this.getFile() != null) {
                void it;
                PsiFile psiFile;
                boolean bl2 = false;
                boolean bl3 = false;
                PsiFile psiFile2 = psiFile;
                Project project4 = project3;
                String string2 = string;
                StubIndexKey<String, MarkdownHeaderImpl> stubIndexKey2 = stubIndexKey;
                StubIndex stubIndex2 = stubIndex;
                boolean bl4 = false;
                GlobalSearchScope globalSearchScope2 = GlobalSearchScope.fileScope((PsiFile)it);
                stubIndex = stubIndex2;
                stubIndexKey = stubIndexKey2;
                string = string2;
                project3 = project4;
                globalSearchScope = globalSearchScope2;
            } else {
                globalSearchScope = null;
            }
            stubIndex.processElements(stubIndexKey, (Object)string, project3, globalSearchScope, MarkdownHeaderImpl.class, (Processor)new Processor<MarkdownHeaderImpl>(key, this, project2, list){
                final /* synthetic */ String $key;
                final /* synthetic */ MarkdownAnchorReferenceImpl this$0;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ ArrayList $list$inlined;
                {
                    this.$key = string;
                    this.this$0 = markdownAnchorReferenceImpl;
                    this.$project$inlined = project;
                    this.$list$inlined = arrayList;
                }

                public final boolean process(MarkdownHeaderImpl it) {
                    String string = this.$key;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key");
                    return this.$list$inlined.add(MarkdownAnchorReference.Companion.dashed(string));
                }
            });
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string;
        if (this.getFile() == null) {
            String string2 = MarkdownBundle.message("markdown.cannot.resolve.anchor.error.message", this.myAnchor);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MarkdownBundle.message(\"\u2026error.message\", myAnchor)");
        } else {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.myAnchor;
            PsiFile psiFile = this.getFile();
            if (psiFile == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiFile");
            }
            objectArray[1] = psiFile.getName();
            String string3 = MarkdownBundle.message("markdown.cannot.resolve.anchor.in.file.error.message", objectArray);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"MarkdownBundle.message(\"\u2026, (file as PsiFile).name)");
        }
        return string;
    }

    public MarkdownAnchorReferenceImpl(@NotNull String myAnchor, @Nullable FileReference myFileReference, @NotNull PsiElement myPsiElement, int myOffset) {
        Intrinsics.checkNotNullParameter((Object)myAnchor, (String)"myAnchor");
        Intrinsics.checkNotNullParameter((Object)myPsiElement, (String)"myPsiElement");
        super(myPsiElement);
        this.myAnchor = myAnchor;
        this.myFileReference = myFileReference;
        this.myPsiElement = myPsiElement;
        this.myOffset = myOffset;
    }
}

