/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.formatter.settings;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.intellij.lang.annotations.Language;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.lang.formatter.settings.MarkdownCodeStyleConfigurable;
import org.intellij.plugins.markdown.lang.formatter.settings.MarkdownCodeStyleSettingsProvider$WhenMappings;
import org.intellij.plugins.markdown.lang.formatter.settings.MarkdownCustomCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0012\u0010\u0013\u001a\f0\u0012\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001a"}, d2={"Lorg/intellij/plugins/markdown/lang/formatter/settings/MarkdownCodeStyleSettingsProvider;", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider;", "()V", "createConfigurable", "Lcom/intellij/psi/codeStyle/CodeStyleConfigurable;", "baseSettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "modelSettings", "createCustomSettings", "Lcom/intellij/psi/codeStyle/CustomCodeStyleSettings;", "settings", "customizeSettings", "", "consumer", "Lcom/intellij/psi/codeStyle/CodeStyleSettingsCustomizable;", "settingsType", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider$SettingsType;", "getCodeSample", "", "getConfigurableDisplayName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getIndentOptionsEditor", "Lcom/intellij/application/options/IndentOptionsEditor;", "getLanguage", "Lcom/intellij/lang/Language;", "intellij.markdown"})
public final class MarkdownCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public com.intellij.lang.Language getLanguage() {
        MarkdownLanguage markdownLanguage = MarkdownLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)markdownLanguage), (String)"MarkdownLanguage.INSTANCE");
        return markdownLanguage;
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        Intrinsics.checkNotNullParameter((Object)baseSettings, (String)"baseSettings");
        Intrinsics.checkNotNullParameter((Object)modelSettings, (String)"modelSettings");
        return (CodeStyleConfigurable)new MarkdownCodeStyleConfigurable(baseSettings, modelSettings);
    }

    @NotNull
    public String getConfigurableDisplayName() {
        String string = MarkdownBundle.message("markdown.settings.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"markdown.settings.name\")");
        return string;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)settingsType, (String)"settingsType");
        switch (MarkdownCodeStyleSettingsProvider$WhenMappings.$EnumSwitchMapping$0[settingsType.ordinal()]) {
            case 1: {
                consumer.showStandardOptions(new String[]{"RIGHT_MARGIN", "WRAP_ON_TYPING"});
                break;
            }
            case 2: {
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "MAX_LINES_AROUND_HEADER", MarkdownBundle.message("markdown.style.settings.blank.lines.around.header", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES, new Object[0]);
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "MAX_LINES_AROUND_BLOCK_ELEMENTS", MarkdownBundle.message("markdown.style.settings.blank.lines.around.block.elements", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES, new Object[0]);
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "MAX_LINES_BETWEEN_PARAGRAPHS", MarkdownBundle.message("markdown.style.settings.blank.lines.between.paragraphs", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES, new Object[0]);
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "MIN_LINES_AROUND_HEADER", MarkdownBundle.message("markdown.style.settings.blank.lines.around.header", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES_KEEP, new Object[0]);
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "MIN_LINES_AROUND_BLOCK_ELEMENTS", MarkdownBundle.message("markdown.style.settings.blank.lines.around.block.elements", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES_KEEP, new Object[0]);
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "MIN_LINES_BETWEEN_PARAGRAPHS", MarkdownBundle.message("markdown.style.settings.blank.lines.between.paragraphs", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES_KEEP, new Object[0]);
                break;
            }
            case 3: {
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "FORCE_ONE_SPACE_BETWEEN_WORDS", MarkdownBundle.message("markdown.style.settings.spacing.between.words", new Object[0]), MarkdownBundle.message("markdown.style.settings.spacing.force.one.space", new Object[0]), new Object[0]);
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "FORCE_ONE_SPACE_AFTER_HEADER_SYMBOL", MarkdownBundle.message("markdown.style.settings.spacing.after.header.symbol", new Object[0]), MarkdownBundle.message("markdown.style.settings.spacing.force.one.space", new Object[0]), new Object[0]);
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "FORCE_ONE_SPACE_AFTER_LIST_BULLET", MarkdownBundle.message("markdown.style.settings.spacing.after.list.marker", new Object[0]), MarkdownBundle.message("markdown.style.settings.spacing.force.one.space", new Object[0]), new Object[0]);
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "FORCE_ONE_SPACE_AFTER_BLOCKQUOTE_SYMBOL", MarkdownBundle.message("markdown.style.settings.spacing.after.blockquote.marker", new Object[0]), MarkdownBundle.message("markdown.style.settings.spacing.force.one.space", new Object[0]), new Object[0]);
                break;
            }
        }
    }

    @Nullable
    public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new MarkdownCustomCodeStyleSettings(settings);
    }

    @Nullable
    public IndentOptionsEditor getIndentOptionsEditor() {
        return (IndentOptionsEditor)new SmartIndentOptionsEditor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Language(value="Markdown")
    @NotNull
    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)settingsType, (String)"settingsType");
        switch (MarkdownCodeStyleSettingsProvider$WhenMappings.$EnumSwitchMapping$1[settingsType.ordinal()]) {
            case 1: {
                inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("indent_settings.md");
                break;
            }
            case 2: {
                inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("blank_lines_settings.md");
                break;
            }
            case 3: {
                inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("spacing_settings.md");
                break;
            }
            default: {
                inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("default.md");
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"when (settingsType) {\n  \u2026efault.md\")\n      }\n    }");
        Closeable closeable = inputStream;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Object object = closeable;
        int n = 0;
        object = new InputStreamReader((InputStream)object, charset);
        n = 8192;
        boolean bl2 = false;
        closeable = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
        boolean bl3 = false;
        bl = false;
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl4 = false;
            object = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return object;
    }
}

