/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.formatter;

import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.formatter.MarkdownSpacingBuilder;
import org.intellij.plugins.markdown.lang.formatter.settings.MarkdownCustomCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J-\u0010\u0007\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0017\u0010\n\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000b\u00a2\u0006\u0002\b\fH\u0002J \u0010\r\u001a\u00020\u0004*\u00060\u000eR\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/lang/formatter/MarkdownSpacingBuilder;", "", "()V", "get", "Lcom/intellij/formatting/SpacingBuilder;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "applyIf", "condition", "", "body", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "blankLinesRange", "Lcom/intellij/formatting/SpacingBuilder$RuleBuilder;", "from", "", "to", "intellij.markdown"})
public final class MarkdownSpacingBuilder {
    @NotNull
    public static final MarkdownSpacingBuilder INSTANCE;

    @NotNull
    public final SpacingBuilder get(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(MarkdownCustomCodeStyleSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"settings.getCustomSettin\u2026tyleSettings::class.java)");
        MarkdownCustomCodeStyleSettings markdown = (MarkdownCustomCodeStyleSettings)customCodeStyleSettings;
        SpacingBuilder.RuleBuilder ruleBuilder = new SpacingBuilder(settings, (Language)MarkdownLanguage.INSTANCE).aroundInside(MarkdownElementTypes.CODE_FENCE, MarkdownElementTypes.MARKDOWN_FILE);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder, (String)"SpacingBuilder(settings,\u2026ementTypes.MARKDOWN_FILE)");
        SpacingBuilder.RuleBuilder ruleBuilder2 = this.blankLinesRange(ruleBuilder, markdown.MIN_LINES_AROUND_BLOCK_ELEMENTS, markdown.MAX_LINES_AROUND_BLOCK_ELEMENTS).aroundInside(MarkdownElementTypes.CODE_BLOCK, MarkdownElementTypes.MARKDOWN_FILE);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder2, (String)"SpacingBuilder(settings,\u2026ementTypes.MARKDOWN_FILE)");
        SpacingBuilder.RuleBuilder ruleBuilder3 = this.blankLinesRange(ruleBuilder2, markdown.MIN_LINES_AROUND_BLOCK_ELEMENTS, markdown.MAX_LINES_AROUND_BLOCK_ELEMENTS).aroundInside(MarkdownElementTypes.TABLE, MarkdownElementTypes.MARKDOWN_FILE);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder3, (String)"SpacingBuilder(settings,\u2026ementTypes.MARKDOWN_FILE)");
        SpacingBuilder.RuleBuilder ruleBuilder4 = this.blankLinesRange(ruleBuilder3, markdown.MIN_LINES_AROUND_BLOCK_ELEMENTS, markdown.MAX_LINES_AROUND_BLOCK_ELEMENTS).between(MarkdownTokenTypeSets.LISTS, MarkdownTokenTypeSets.LISTS).blankLines(markdown.MIN_LINES_AROUND_BLOCK_ELEMENTS).aroundInside(MarkdownTokenTypeSets.LISTS, MarkdownElementTypes.LIST_ITEM).blankLines(0).aroundInside(MarkdownTokenTypeSets.LISTS, MarkdownElementTypes.MARKDOWN_FILE);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder4, (String)"SpacingBuilder(settings,\u2026ementTypes.MARKDOWN_FILE)");
        SpacingBuilder.RuleBuilder ruleBuilder5 = this.applyIf(this.blankLinesRange(ruleBuilder4, markdown.MIN_LINES_AROUND_BLOCK_ELEMENTS, markdown.MAX_LINES_AROUND_BLOCK_ELEMENTS), markdown.FORCE_ONE_SPACE_AFTER_LIST_BULLET, (Function1<? super SpacingBuilder, ? extends SpacingBuilder>)((Function1)get.1.INSTANCE)).aroundInside(MarkdownTokenTypeSets.ATX_HEADERS, MarkdownElementTypes.MARKDOWN_FILE);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder5, (String)"SpacingBuilder(settings,\u2026ementTypes.MARKDOWN_FILE)");
        SpacingBuilder.RuleBuilder ruleBuilder6 = this.applyIf(this.applyIf(this.blankLinesRange(ruleBuilder5, markdown.MIN_LINES_AROUND_HEADER, markdown.MAX_LINES_AROUND_HEADER), markdown.FORCE_ONE_SPACE_AFTER_HEADER_SYMBOL, (Function1<? super SpacingBuilder, ? extends SpacingBuilder>)((Function1)get.2.INSTANCE)), markdown.FORCE_ONE_SPACE_AFTER_BLOCKQUOTE_SYMBOL, (Function1<? super SpacingBuilder, ? extends SpacingBuilder>)((Function1)get.3.INSTANCE)).before(MarkdownElementTypes.LINK_DEFINITION).blankLines(1).betweenInside(MarkdownElementTypes.PARAGRAPH, MarkdownElementTypes.PARAGRAPH, MarkdownElementTypes.MARKDOWN_FILE);
        Intrinsics.checkNotNullExpressionValue((Object)ruleBuilder6, (String)"SpacingBuilder(settings,\u2026ementTypes.MARKDOWN_FILE)");
        SpacingBuilder spacingBuilder = this.blankLinesRange(ruleBuilder6, markdown.MIN_LINES_BETWEEN_PARAGRAPHS, markdown.MAX_LINES_BETWEEN_PARAGRAPHS);
        boolean bl = false;
        boolean bl2 = false;
        SpacingBuilder $this$apply = spacingBuilder;
        boolean bl3 = false;
        int spaces = markdown.FORCE_ONE_SPACE_BETWEEN_WORDS ? 1 : Integer.MAX_VALUE;
        $this$apply.between(MarkdownTokenTypes.TEXT, MarkdownTokenTypes.TEXT).spacing(1, spaces, 0, false, 0);
        return spacingBuilder;
    }

    private final SpacingBuilder applyIf(SpacingBuilder $this$applyIf, boolean condition, Function1<? super SpacingBuilder, ? extends SpacingBuilder> body) {
        return condition ? (SpacingBuilder)body.invoke((Object)$this$applyIf) : $this$applyIf;
    }

    private final SpacingBuilder blankLinesRange(SpacingBuilder.RuleBuilder $this$blankLinesRange, int from, int to) {
        SpacingBuilder spacingBuilder = $this$blankLinesRange.spacing(0, 0, to + 1, false, from);
        Intrinsics.checkNotNullExpressionValue((Object)spacingBuilder, (String)"spacing(0, 0, to + 1, false, from)");
        return spacingBuilder;
    }

    private MarkdownSpacingBuilder() {
    }

    static {
        MarkdownSpacingBuilder markdownSpacingBuilder;
        INSTANCE = markdownSpacingBuilder = new MarkdownSpacingBuilder();
    }
}

