/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ReadOnlyModificationException;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.images.ide.EditorImagePasteProvider;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/editor/MarkdownImagePasteProvider;", "Lorg/intellij/images/ide/EditorImagePasteProvider;", "()V", "supportedFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getSupportedFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "imageFilePasted", "", "Lcom/intellij/openapi/editor/Editor;", "imageFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.markdown"})
public final class MarkdownImagePasteProvider
extends EditorImagePasteProvider {
    @NotNull
    private final FileType supportedFileType;

    @NotNull
    public FileType getSupportedFileType() {
        return this.supportedFileType;
    }

    public void imageFilePasted(@NotNull Editor $this$imageFilePasted, @NotNull VirtualFile imageFile) {
        Intrinsics.checkNotNullParameter((Object)$this$imageFilePasted, (String)"$this$imageFilePasted");
        Intrinsics.checkNotNullParameter((Object)imageFile, (String)"imageFile");
        String string = imageFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"imageFile.name");
        String pastedFileName = string;
        CaretModel caretModel = $this$imageFilePasted.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"caretModel");
        Caret caret = caretModel.getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"caretModel.currentCaret");
        int n = caret.getOffset();
        boolean bl = false;
        boolean bl2 = false;
        int currentCaretOffset = n;
        boolean bl3 = false;
        String textToInsert = "![" + pastedFileName + "](" + pastedFileName + ')';
        try {
            $this$imageFilePasted.getDocument().insertString(currentCaretOffset, (CharSequence)textToInsert);
            $this$imageFilePasted.getCaretModel().moveToOffset(currentCaretOffset + textToInsert.length());
        }
        catch (ReadOnlyModificationException readOnlyModificationException) {
        }
        catch (ReadOnlyFragmentModificationException readOnlyFragmentModificationException) {
        }
    }

    public MarkdownImagePasteProvider() {
        MarkdownFileType markdownFileType = MarkdownFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)markdownFileType), (String)"MarkdownFileType.INSTANCE");
        this.supportedFileType = (FileType)markdownFileType;
    }
}

