/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.progress;

import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.ResponseItem;
import com.intellij.docker.agent.DockerErrorUtilKt;
import com.intellij.docker.agent.i18n.DockerAgentBundle;
import com.intellij.docker.agent.progress.DockerResponseItemTtyHandler;
import com.intellij.docker.agent.progress.ResponseItemCallbackTemplate;
import com.intellij.docker.agent.progress.TtySink;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0003\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bJ\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0014J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/docker/agent/progress/DockerCallbackWithTtySink;", "RI", "Lcom/github/dockerjava/api/model/ResponseItem;", "Lcom/intellij/docker/agent/progress/ResponseItemCallbackTemplate;", "ttySink", "Lcom/intellij/docker/agent/progress/TtySink;", "(Lcom/intellij/docker/agent/progress/TtySink;)V", "myPrintError", "", "ttyHandler", "Lcom/intellij/docker/agent/progress/DockerResponseItemTtyHandler;", "getTtyHandler", "()Lcom/intellij/docker/agent/progress/DockerResponseItemTtyHandler;", "enableErrorPrinting", "", "enable", "onComplete", "onError", "throwable", "", "throwFirstError", "ttyReportError", "intellij.clouds.docker.agent.impl"})
public abstract class DockerCallbackWithTtySink<RI extends ResponseItem>
extends ResponseItemCallbackTemplate<RI> {
    @NotNull
    private final DockerResponseItemTtyHandler ttyHandler;
    private boolean myPrintError;
    private final TtySink ttySink;

    @NotNull
    protected final DockerResponseItemTtyHandler getTtyHandler() {
        return this.ttyHandler;
    }

    public final void enableErrorPrinting(boolean enable) {
        this.myPrintError = enable;
    }

    public void onError(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (this.myPrintError) {
            this.ttyReportError(throwable);
        }
        super.onError(throwable);
    }

    private final void ttyReportError(Throwable throwable) {
        String message = DockerErrorUtilKt.dockerUserFriendlyMessage((Throwable)throwable);
        if (throwable instanceof DockerException) {
            this.ttySink.coloredTtyPrintln(DockerAgentBundle.Companion.message("DockerCallbackWithTtySink.error.response.from.daemon", new Object[]{message}), TtySink.Colors.RED);
        } else {
            this.ttySink.coloredTtyPrintln(DockerAgentBundle.Companion.message("DockerCallbackWithTtySink.internal.error", new Object[]{message}), TtySink.Colors.RED);
        }
    }

    public void onComplete() {
        super.onComplete();
    }

    protected void throwFirstError() {
        super.throwFirstError();
    }

    public DockerCallbackWithTtySink(@NotNull TtySink ttySink) {
        Intrinsics.checkNotNullParameter((Object)ttySink, (String)"ttySink");
        this.ttySink = ttySink;
        this.ttyHandler = new DockerResponseItemTtyHandler(this.ttySink);
    }
}

