/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.pipe;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.github.dockerjava.api.command.SyncDockerCmd;
import com.github.dockerjava.api.model.Frame;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.pipe.DockerAsyncCmdAbstractPipe;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import com.intellij.docker.agent.util.PipedOutputStream;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J\b\u0010\u0010\u001a\u00020\u0002H\u0014J \u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/docker/agent/pipe/DockerExecPipe;", "Lcom/intellij/docker/agent/pipe/DockerAsyncCmdAbstractPipe;", "Lcom/github/dockerjava/api/command/ExecStartCmd;", "allowSystemPrint", "", "execID", "", "context", "Lcom/intellij/docker/agent/DockerAgentContext;", "(ZLjava/lang/String;Lcom/intellij/docker/agent/DockerAgentContext;)V", "callback", "Lcom/github/dockerjava/api/async/ResultCallback$Adapter;", "Lcom/github/dockerjava/api/model/Frame;", "promise", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe;", "cmd", "resizeCommand", "Lcom/github/dockerjava/api/command/SyncDockerCmd;", "Ljava/lang/Void;", "width", "", "height", "ExecCommandCallback", "intellij.clouds.docker.agent.impl"})
public final class DockerExecPipe
extends DockerAsyncCmdAbstractPipe<ExecStartCmd> {
    private final String execID;

    @Nullable
    protected SyncDockerCmd<Void> resizeCommand(int width, int height) {
        return (SyncDockerCmd)this.getContext().getClient().resizeExecCmd(this.execID).withSize(height, width);
    }

    @Override
    @NotNull
    protected ExecStartCmd cmd() {
        ExecStartCmd execStartCmd = this.getContext().getClient().execStartCmd(this.execID).withDetach(Boolean.valueOf(false)).withStdIn((InputStream)this.getReadFromTerminalStream()).withTty(Boolean.valueOf(true));
        Intrinsics.checkNotNullExpressionValue((Object)execStartCmd, (String)"context.client\n    .exec\u2026tream)\n    .withTty(true)");
        return execStartCmd;
    }

    @Override
    @NotNull
    protected ResultCallback.Adapter<Frame> callback(@NotNull CompletableFuture<DockerTerminalPipe> promise) {
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        return new ExecCommandCallback(promise);
    }

    public DockerExecPipe(boolean allowSystemPrint, @NotNull String execID, @NotNull DockerAgentContext context) {
        Intrinsics.checkNotNullParameter((Object)execID, (String)"execID");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super("DockerTerminalExec.pipe", allowSystemPrint, context);
        this.execID = execID;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f0\u0001R\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/docker/agent/pipe/DockerExecPipe$ExecCommandCallback;", "Lcom/intellij/docker/agent/pipe/DockerAsyncCmdAbstractPipe$MyDockerResultCallback;", "Lcom/intellij/docker/agent/pipe/DockerAsyncCmdAbstractPipe;", "Lcom/github/dockerjava/api/command/ExecStartCmd;", "promise", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe;", "(Lcom/intellij/docker/agent/pipe/DockerExecPipe;Ljava/util/concurrent/CompletableFuture;)V", "beforeComplete", "", "intellij.clouds.docker.agent.impl"})
    private final class ExecCommandCallback
    extends DockerAsyncCmdAbstractPipe.MyDockerResultCallback {
        @Override
        protected void beforeComplete() {
            DockerTerminalPipe.WithTty.println$default((DockerTerminalPipe.WithTty)DockerExecPipe.this, null, (int)1, null);
            super.beforeComplete();
        }

        public ExecCommandCallback(CompletableFuture<DockerTerminalPipe> promise) {
            Intrinsics.checkNotNullParameter(promise, (String)"promise");
            PipedOutputStream pipedOutputStream = DockerExecPipe.this.getWriteToTerminalStream();
            Intrinsics.checkNotNullExpressionValue((Object)pipedOutputStream, (String)"writeToTerminalStream");
            PipedOutputStream pipedOutputStream2 = DockerExecPipe.this.getWriteErrToTerminalStream();
            Intrinsics.checkNotNullExpressionValue((Object)pipedOutputStream2, (String)"writeErrToTerminalStream");
            super(pipedOutputStream, pipedOutputStream2, promise);
        }
    }
}

