/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.OngoingProcessResultCallbackBase;
import com.intellij.docker.agent.ResponseItemAggregator;
import com.intellij.docker.agent.i18n.DockerAgentBundle;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;

public class PullImageResultCallbackImpl
extends OngoingProcessResultCallbackBase<PullResponseItem> {
    private static final Supplier<@Nls String> DOWNLOADING_STATUS = DockerAgentBundle.messagePointer((String)"PullImageResultCallbackImpl.status.downloading", (Object[])new Object[0]);
    private static final Supplier<@Nls String> DOWNLOAD_COMPLETE_STATUS = DockerAgentBundle.messagePointer((String)"PullImageResultCallbackImpl.status.download.complete", (Object[])new Object[0]);
    private static final Supplier<@Nls String> EXTRACTING_STATUS = DockerAgentBundle.messagePointer((String)"PullImageResultCallbackImpl.status.extracting", (Object[])new Object[0]);
    private static final Supplier<@Nls String> PULL_COMPLETE_STATUS = DockerAgentBundle.messagePointer((String)"PullImageResultCallbackImpl.status.pull.complete", (Object[])new Object[0]);
    private static final Supplier<@Nls String> PULL_CANCELLED = DockerAgentBundle.messagePointer((String)"PullImageResultCallbackImpl.status.pull.cancelled", (Object[])new Object[0]);
    private final ResponseItemAggregator myDownloads = new ResponseItemAggregator();
    private final ResponseItemAggregator myExtractions = new ResponseItemAggregator();

    public PullImageResultCallbackImpl(DockerAgentProgressCallback callback, CloudAgentLogger logger2) {
        super(callback, logger2);
    }

    public void onNext(PullResponseItem item) {
        if (item.isPullSuccessIndicated()) {
            this.setSuccessMessage(item.getStatus());
        }
        if (item.isErrorIndicated()) {
            this.setErrorMessage(item.getErrorDetail().getMessage());
        }
        String status = item.getStatus();
        String id = item.getId();
        if (id != null && status != null) {
            if (DOWNLOADING_STATUS.get().equals(status)) {
                this.myDownloads.updateProgress((ResponseItem)item);
            } else if (DOWNLOAD_COMPLETE_STATUS.get().equals(status)) {
                this.myDownloads.completeProgress(id);
            } else if (EXTRACTING_STATUS.get().equals(status)) {
                this.myExtractions.updateProgress((ResponseItem)item);
            } else if (PULL_COMPLETE_STATUS.get().equals(status)) {
                this.myDownloads.completeProgress(id);
                this.myExtractions.completeProgress(id);
            }
        }
        this.updateIndicator(item);
    }

    @Override
    protected void ongoingProcessDelegateCancelled() {
        this.setSuccessMessage(PULL_CANCELLED.get());
    }

    private void updateIndicator(PullResponseItem item) {
        ResponseItem.ProgressDetail progressDetail = item.getProgressDetail();
        if (progressDetail != null) {
            ResponseItemAggregator.ProgressInfo downloadProgress = this.myDownloads.computeAggregatedProgress();
            ResponseItemAggregator.ProgressInfo extractProgress = this.myExtractions.computeAggregatedProgress();
            if (!(downloadProgress == null || downloadProgress.isCompleted() && extractProgress != null)) {
                this.getAgentCallback().step(item.getStatus(), downloadProgress.getCurrent(), downloadProgress.getTotal());
            } else if (extractProgress != null && !extractProgress.isCompleted()) {
                this.getAgentCallback().step(item.getStatus(), extractProgress.getCurrent(), extractProgress.getTotal());
            }
        }
    }
}

